/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.UnitConverter;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSCell;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheet;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheetPrintSetup;
import com.kingdee.cosmic.ctrl.kdf.table.IBlock;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTColumns;
import com.kingdee.cosmic.ctrl.kdf.table.KDTHead;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTPrintManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRange;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.KDTableHelper;
import com.kingdee.cosmic.ctrl.kdf.table.foot.KDTFoot;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePageSetupModel;
import com.kingdee.cosmic.ctrl.print.config.ui.PageSetupModel;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.print.attribute.Attribute;
import javax.print.attribute.standard.OrientationRequested;

public final class Kdt2Kds {
    boolean withHead = true;
    boolean withIndexColumn = false;
    boolean withHiddenCol = false;
    boolean withFoot = true;
    private KDTable table;
    private KDSBook book;
    KDTRange range;
    private boolean isLargeData = false;

    public Kdt2Kds(KDTable table, KDSBook book) {
        this.table = table;
        this.book = book;
    }

    public void setLargeDataOutput(boolean flag) {
        this.isLargeData = flag;
    }

    private static short getValueType(Object value) {
        if (value instanceof Boolean) {
            return 4;
        }
        if (value instanceof Number) {
            return 0;
        }
        if (value instanceof Date || value instanceof Calendar) {
            return 6;
        }
        return 1;
    }

    public KDSSheet transform(String sheetName) {
        IBlock block;
        int colIndex;
        int rowBeginIndex;
        boolean isSelectAllTable = false;
        int rowCount = this.table.getIOManager().getTableRowCount();
        KDTRange range = this.getRange();
        KDSSheetPrintSetup printSetup = this.generatePrintSetup(this.table);
        if (range == null) {
            range = new KDTRange();
            range.add(new KDTBlock(0, 0, 0, 0, 8));
        } else if ((range = range.getSequenceRange()) == null) {
            KDSSheet sheet = new KDSSheet(this.book, sheetName);
            sheet.setPrintSetup(printSetup);
            return sheet;
        }
        int direct = range.getRangeDirect();
        if (range.size() == 1 && ((IBlock)range.get(0)).getMode() == 8) {
            isSelectAllTable = true;
        }
        KDSSheet sheet = new KDSSheet(this.book, sheetName);
        int headRowCount = this.table.getHeadRowCount();
        int colCount = this.table.getIOManager().getTableColumnCount();
        boolean[] colOutputMark = new boolean[colCount];
        int mode = ((IBlock)range.get(0)).getMode();
        if (isSelectAllTable || mode == 2) {
            for (int i = 0; i < colCount; ++i) {
                colOutputMark[i] = this.isWithHiddenCol() ? true : !this.isColumnHidden(i);
            }
        } else {
            boolean withhidden = this.isWithHiddenCol();
            int size = range.size();
            for (int i = 0; i < size; ++i) {
                IBlock aBlock = (IBlock)range.get(i);
                for (int m = aBlock.getLeft(); m <= aBlock.getRight(); ++m) {
                    colOutputMark[m] = !withhidden ? !this.isColumnHidden(m) : true;
                }
            }
        }
        int colBeginIndex = this.isWithIndexColumn() ? 1 : 0;
        int n = rowBeginIndex = this.isWithHead() ? headRowCount : 0;
        if (this.isWithHead()) {
            KDTHead head = this.table.getHead();
            for (int i = 0; i < headRowCount; ++i) {
                KDTRow row = head.getRow(i);
                sheet.getRows().setRowHeight(i, (float)UnitConverter.px2mm((int)row.getHeight()));
                colIndex = colBeginIndex;
                for (int j = 0; j < colCount; ++j) {
                    KDSCell temp;
                    boolean tempB;
                    if (!colOutputMark[j]) continue;
                    KDTCell cell = row.getCell(j);
                    if (cell == null) {
                        ++colIndex;
                        continue;
                    }
                    KDTMergeBlock block2 = cell.getMergeBlock();
                    boolean bl = tempB = block2 != null && (i != block2.getTop() || j != block2.getLeft());
                    if (tempB) {
                        cell = head.getRow(block2.getTop()).getCell(block2.getLeft());
                    }
                    if (cell != null) {
                        ShareStyleAttributes ssa = null;
                        ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), row.getSSA(), this.table.getHeadSSA()});
                        Object value = cell.getValue();
                        KDSCell temp2 = sheet.setCell(i, colIndex, tempB ? null : value, null, ssa);
                        temp2.setType(Kdt2Kds.getValueType(value));
                    }
                    boolean firstVisibleCell = true;
                    if (cell != null) {
                        boolean mergeCell;
                        KDTMergeBlock mergeBlock = cell.getMergeBlock();
                        boolean bl2 = mergeCell = mergeBlock != null && (i != mergeBlock.getTop() || j != mergeBlock.getLeft());
                        if (mergeCell) {
                            cell = head.getRow(mergeBlock.getTop()).getCell(mergeBlock.getLeft());
                            firstVisibleCell = this.isFirstVisibleCell(!mergeCell, mergeBlock, colOutputMark, i, j, isSelectAllTable);
                        }
                    }
                    ShareStyleAttributes ssa = null;
                    Object value = null;
                    if (cell != null) {
                        ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), row.getSSA(), this.table.getHeadSSA()});
                        value = cell.getValue();
                    } else {
                        ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{Styles.getEmptySSA(), row.getSSA(), this.table.getHeadSSA()});
                    }
                    if (!firstVisibleCell) {
                        temp = sheet.setCell(i, colIndex, null, null, ssa, null);
                        temp.setType((short)1);
                    } else {
                        temp = sheet.setCell(i, colIndex, value, null, ssa);
                        temp.setType(Kdt2Kds.getValueType(value));
                    }
                    ++colIndex;
                }
            }
            sheet.setHeadRowCount(this.table.getHeadRowCount());
        }
        KDTColumns cols = this.getTable().getColumns();
        if (this.isWithIndexColumn()) {
            sheet.getColumns().setColumnWidth(0, (float)UnitConverter.px2mm((int)this.table.getIndexColumn().getWidth()));
        }
        colIndex = colBeginIndex;
        for (int i = 0; i < colCount; ++i) {
            if (!colOutputMark[i]) continue;
            sheet.getColumns().setColumnWidth(colIndex, (float)UnitConverter.px2mm((int)cols.getColumnWidth(i)));
            ++colIndex;
        }
        int rowIndex = rowBeginIndex;
        colIndex = colBeginIndex;
        if (this.isLargeData) {
            range = this.getRange();
        }
        Iterator itRange = range.iterator();
        while (itRange.hasNext() && ((mode = (block = (IBlock)itRange.next()).getMode()) == 1 || mode == 8 || mode == 2 || mode == 4)) {
            int top = block.getTop();
            int bottom = block.getBottom();
            if (mode == 4 || isSelectAllTable) {
                top = 0;
                bottom = rowCount - 1;
                rowIndex = rowBeginIndex;
            } else if (direct == 0) {
                rowIndex = rowBeginIndex;
            }
            int left = block.getLeft();
            int right = block.getRight();
            if (mode == 2 || isSelectAllTable) {
                left = 0;
                right = colCount - 1;
                colIndex = colBeginIndex;
            } else if (direct == 1) {
                colIndex = colBeginIndex;
            }
            for (int i = top; i <= bottom; ++i) {
                IRow row;
                if (this.isWithIndexColumn()) {
                    ShareStyleAttributes ssa = this.table.getIndexColumn().getSsa();
                    KDSCell temp = sheet.setCell(rowIndex, 0, (Object)String.valueOf(i + 1), null, ssa);
                    temp.setType((short)1);
                }
                if ((row = this.table.getRow(i)) == null) break;
                sheet.setRowHeight(rowIndex, (float)UnitConverter.px2mm((int)row.getHeight()));
                if (mode == 2) {
                    left = 0;
                    right = colCount - 1;
                }
                int colTemp = colIndex;
                for (int j = left; j <= right; ++j) {
                    KDSCell temp;
                    if (!colOutputMark[j]) continue;
                    ICell cell = row.getCell(j);
                    boolean firstVisibleCell = true;
                    if (cell != null) {
                        boolean mergeCell;
                        KDTMergeBlock mergeBlock = cell.getMergeBlock();
                        boolean bl = mergeCell = mergeBlock != null && (i != mergeBlock.getTop() || j != mergeBlock.getLeft());
                        if (mergeCell) {
                            cell = this.table.getRow(mergeBlock.getTop()).getCell(mergeBlock.getLeft());
                            firstVisibleCell = this.isFirstVisibleCell(!mergeCell, mergeBlock, colOutputMark, i, j, isSelectAllTable);
                        }
                    }
                    ShareStyleAttributes ssa = null;
                    Object value = null;
                    String formula = null;
                    String text = null;
                    if (cell != null) {
                        ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getKDTCell().getSSA(), row.getKDTRow().getSSA(), cols.getColumn(j).getSSA(), this.table.getSSA()});
                        if (firstVisibleCell) {
                            value = this.getCellValue(cell.getKDTCell(), ssa, cell.getRowIndex(), cell.getColumnIndex());
                            formula = cell.getExpressions();
                            text = this.table.getCellDisplayText(cell);
                        }
                    } else {
                        ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{this.table.getBlankCellSSA(), row.getKDTRow().getSSA(), this.table.getColumns().getColumn(j).getSSA(), this.table.getSSA()});
                    }
                    if (formula != null && !(formula = formula.trim()).equals("") && formula.charAt(0) == '=') {
                        formula = formula.substring(1);
                    }
                    if (!firstVisibleCell) {
                        temp = sheet.setCell(rowIndex, colTemp, null, null, ssa, null);
                        temp.setType((short)1);
                    } else {
                        temp = sheet.setCell(rowIndex, colTemp, value, formula, ssa, text);
                        temp.setType(Kdt2Kds.getValueType(value));
                    }
                    ++colTemp;
                }
                ++rowIndex;
            }
            if (direct == 0) {
                colIndex = colIndex + 1 + block.getRight() - block.getLeft();
            }
            if (!this.isLargeData) continue;
            this.table.getIOManager().doMemeryCallBack(this.table.getDataRequestManager(), top, bottom, true);
        }
        int footRowCount = 0;
        if (this.table.isHasFoot() && this.isWithFoot()) {
            KDTFoot foot = this.table.getFootManager().getFoot();
            footRowCount = foot != null ? foot.size() : 0;
            for (int i = 0; i < footRowCount && isSelectAllTable; ++i) {
                if (this.isWithIndexColumn()) {
                    ShareStyleAttributes ssa = this.table.getIndexColumn().getSsa();
                    KDSCell temp = sheet.setCell(rowIndex, 0, (Object)String.valueOf(i + 1), null, ssa);
                    temp.setType((short)1);
                }
                KDTRow row = foot.getRow(i);
                sheet.getRows().setRowHeight(rowIndex, (float)UnitConverter.px2mm((int)foot.getRowHeight(i)));
                colIndex = colBeginIndex;
                for (int j = 0; j < colCount; ++j) {
                    if (!colOutputMark[j]) continue;
                    KDTCell cell = row.getCell(j);
                    boolean firstVisibleCell = true;
                    if (cell != null) {
                        boolean mergeCell;
                        KDTMergeBlock mergeBlock = cell.getMergeBlock();
                        boolean bl = mergeCell = mergeBlock != null && (i != mergeBlock.getTop() || j != mergeBlock.getLeft());
                        if (mergeCell) {
                            cell = foot.getRow(mergeBlock.getTop()).getCell(mergeBlock.getLeft());
                            firstVisibleCell = this.isFirstVisibleCell(!mergeCell, mergeBlock, colOutputMark, rowIndex, j, isSelectAllTable);
                        }
                    }
                    ShareStyleAttributes ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell != null ? cell.getSSA() : Styles.getEmptySSA(), row.getSSA(), cols.getColumn(j).getSSA(), this.table.getSSA()});
                    Object value = cell != null ? cell.getValue() : null;
                    value = firstVisibleCell ? value : null;
                    KDSCell temp = sheet.setCell(rowIndex, colIndex, value, null, ssa, null);
                    temp.setType(Kdt2Kds.getValueType(value));
                    ++colIndex;
                }
                ++rowIndex;
            }
        }
        if (this.isWithHead()) {
            Iterator it = this.table.getHeadMergeManager().getMergeBlockList().iterator();
            while (it.hasNext()) {
                KDTMergeBlock kdtBlock = this.transBlock((KDTMergeBlock)it.next(), colOutputMark, 0);
                if (kdtBlock == null) continue;
                sheet.getMerges().addMerge(kdtBlock.getTop(), kdtBlock.getLeft(), kdtBlock.getBottom(), kdtBlock.getRight());
            }
        }
        if (!isSelectAllTable) {
            if (this.isLargeData) {
                range = range.getSequenceRange();
                sheet.setDoCrossTest(!this.isLargeData);
            }
            sheet = this.transformMergeWhenMutiSelect(this.table, range, sheet, colOutputMark);
        } else {
            Iterator iter = this.table.getMergeManager().getMergeBlockList().iterator();
            while (iter.hasNext()) {
                KDTMergeBlock kdtBlock = this.transBlock((KDTMergeBlock)iter.next(), colOutputMark, headRowCount);
                if (kdtBlock == null) continue;
                if (this.isWithHead()) {
                    sheet.getMerges().addMerge(kdtBlock.getTop(), kdtBlock.getLeft(), kdtBlock.getBottom(), kdtBlock.getRight());
                    continue;
                }
                sheet.getMerges().addMerge(kdtBlock.getTop() - headRowCount, kdtBlock.getLeft(), kdtBlock.getBottom() - headRowCount, kdtBlock.getRight());
            }
        }
        if (isSelectAllTable && this.table.isHasFoot() && this.isWithFoot() && footRowCount > 0) {
            Iterator it = this.table.getFootManager().getMergeManager().getMergeBlockList().iterator();
            while (it.hasNext()) {
                KDTMergeBlock kdtBlock = this.transBlock((KDTMergeBlock)it.next(), colOutputMark, 0);
                if (kdtBlock == null) continue;
                sheet.getMerges().addMerge(rowIndex + kdtBlock.getTop() - footRowCount, kdtBlock.getLeft(), rowIndex + kdtBlock.getBottom() - footRowCount, kdtBlock.getRight());
            }
        }
        sheet.setPrintSetup(printSetup);
        return sheet;
    }

    private KDSSheetPrintSetup generatePrintSetup(KDTable table) {
        HeadFootModel footModel;
        if (!table.isExportPrintSetup2Xls()) {
            return null;
        }
        KDTPrintManager printManager = table.getPrintManager();
        TablePageSetupModel printJobModel = printManager.getNewPrintManager().getPrintJobConfig();
        KDSSheetPrintSetup printInfo = new KDSSheetPrintSetup();
        if (printJobModel != null) {
            printInfo.setNoColor(printJobModel.isSingleColor());
            printInfo.setRowToCol(!printJobModel.getOrder());
            printInfo.setHasNotes(printJobModel.getPostilType() != 0);
        }
        printInfo.setScale((short)printManager.getScale());
        printInfo.setPageSize(this.transformPaperSizefromISOtoPOI(printManager.getPaperSize()));
        PageSetupModel printModel = printManager.getPageSetupModel();
        Attribute att = printModel.getPrintRequestAttributeSet().get(OrientationRequested.class);
        printInfo.setLandScape(att == OrientationRequested.LANDSCAPE);
        HeadFootModel headModel = printManager.getHeaderModel();
        if (headModel != null) {
            this.configHeaderFooter(true, headModel, printInfo);
        }
        if ((footModel = printManager.getFooterModel()) != null) {
            this.configHeaderFooter(false, footModel, printInfo);
        }
        return printInfo;
    }

    private short transformPaperSizefromISOtoPOI(int paperSizeValue) {
        short paperSize = 9;
        switch (paperSizeValue) {
            case 4: {
                paperSize = 9;
                break;
            }
            case 5: {
                paperSize = 11;
                break;
            }
            case 40: {
                paperSize = 1;
                break;
            }
            case 60: {
                paperSize = 20;
                break;
            }
            case 57: {
                paperSize = 37;
                break;
            }
            default: {
                paperSize = 9;
            }
        }
        return paperSize;
    }

    private void configHeaderFooter(boolean isHead, HeadFootModel model, KDSSheetPrintSetup printInfo) {
        ListIterator rowList = model.getRows();
        StringBuilder LeftBuffer = new StringBuilder();
        StringBuilder CenterBuffer = new StringBuilder();
        StringBuilder RightBuffer = new StringBuilder();
        while (rowList.hasNext()) {
            String originRowText = ((HeadFootRow)rowList.next()).toString();
            String[] Text = StringUtil.splitString((String)originRowText, (String)"&|");
            String[] Result = this.spliceHeaderOrFooter(Text, rowList.previousIndex());
            LeftBuffer.append(Result[0]);
            CenterBuffer.append(Result[1]);
            RightBuffer.append(Result[2]);
        }
        if (isHead) {
            if (!StringUtil.isEmptyString((String)LeftBuffer.toString())) {
                printInfo.setHeaderLeft(LeftBuffer.toString());
            }
            if (!StringUtil.isEmptyString((String)CenterBuffer.toString())) {
                printInfo.setHeaderCenter(CenterBuffer.toString());
            }
            if (!StringUtil.isEmptyString((String)RightBuffer.toString())) {
                printInfo.setHeaderRight(RightBuffer.toString());
            }
        } else {
            if (!StringUtil.isEmptyString((String)LeftBuffer.toString())) {
                printInfo.setFooterLeft(LeftBuffer.toString());
            }
            if (!StringUtil.isEmptyString((String)CenterBuffer.toString())) {
                printInfo.setFooterCenter(CenterBuffer.toString());
            }
            if (!StringUtil.isEmptyString((String)RightBuffer.toString())) {
                printInfo.setFooterRight(RightBuffer.toString());
            }
        }
    }

    private String[] spliceHeaderOrFooter(String[] rowText, int rowIndex) {
        String newLine = rowIndex > 0 ? "\n" : "";
        StringBuilder left = new StringBuilder(newLine);
        StringBuilder center = new StringBuilder(newLine);
        StringBuilder right = new StringBuilder(newLine);
        int col = rowText.length;
        if (col != 0) {
            if (col == 1) {
                center.append(rowText[0]);
            } else if (col == 2) {
                left.append(rowText[0]);
                right.append(rowText[1]);
            } else if (col == 3) {
                left.append(rowText[0]);
                center.append(rowText[1]);
                right.append(rowText[2]);
            } else {
                left.append(rowText[0]);
                right.append(rowText[col - 1]);
                for (int i = 1; i <= col - 2; ++i) {
                    center.append(rowText[i]);
                }
            }
        }
        return new String[]{left.toString(), center.toString(), right.toString()};
    }

    private boolean isFirstVisibleCell(boolean firstmerge, KDTMergeBlock mergeBlock, boolean[] colOutputMark, int rowIndex, int colIndex, boolean isSelectAllTable) {
        int left;
        if (mergeBlock == null || firstmerge) {
            return true;
        }
        if (isSelectAllTable && mergeBlock.getTop() != rowIndex) {
            return false;
        }
        for (int i = left = mergeBlock.getLeft(); i < colIndex; ++i) {
            if (!colOutputMark[i]) continue;
            return false;
        }
        return true;
    }

    Object getCellValue(KDTCell thecell, ShareStyleAttributes ssa, int rowIndex, int cellIndex) {
        String nf = ssa.getNumberFormat();
        if (nf != null && nf.startsWith("@") && nf.length() > 1) {
            return this.table.getCellDisplayValue(thecell, rowIndex, cellIndex);
        }
        return KDTableHelper.getCellDisplayValue2(this.table, rowIndex, cellIndex);
    }

    private KDSSheet transformMergeWhenMutiSelect(KDTable table, KDTRange range, KDSSheet sheet, boolean[] colOutputMark) {
        int headRowCount = this.table.getHeadRowCount();
        int colBeginIndex = this.isWithIndexColumn() ? 1 : 0;
        int rowBeginIndex = this.isWithHead() ? headRowCount : 0;
        int rowCount = this.table.getRowCount();
        int colCount = this.table.getColumnCount();
        List blockList = table.getMergeManager().getMergeBlockList();
        Iterator itRange = range.iterator();
        int rTop = -1;
        int rBottom = -1;
        int headHeight = 0;
        if (this.isWithHead()) {
            headHeight = this.table.getHeadRowCount();
        }
        rTop = rowBeginIndex;
        rBottom += headHeight;
        int rLeft = colBeginIndex;
        int direct = range.getRangeDirect();
        int mode = ((IBlock)range.get(0)).getMode();
        while (itRange.hasNext()) {
            IBlock block = (IBlock)itRange.next();
            int top = block.getTop();
            int bottom = block.getBottom();
            if (mode == 4 || mode == 8) {
                top = 0;
                bottom = rowCount - 1;
            }
            int left = block.getLeft();
            int right = block.getRight();
            if (mode == 2 || mode == 8) {
                left = 0;
                right = colCount - 1;
            }
            int height = bottom - top + 1;
            int width = right - left + 1;
            rBottom += height;
            for (IBlock mergeBlock : blockList) {
                int mTop = mergeBlock.getTop();
                int mLeft = mergeBlock.getLeft();
                int mBottom = mergeBlock.getBottom();
                int mRight = mergeBlock.getRight();
                if (mLeft < left && mRight < left || mLeft > right && mRight > right || mTop < top && mBottom < top || mTop > bottom && mBottom > bottom) continue;
                if (mTop >= top && mBottom >= bottom) {
                    mBottom = bottom;
                } else if (mTop <= top && mBottom >= bottom) {
                    mTop = top;
                    mBottom = bottom;
                } else if (mTop <= top && mBottom <= bottom) {
                    mTop = top;
                }
                if (mLeft >= left && mLeft >= right) {
                    mRight = right;
                } else if (mLeft <= left && mLeft >= right) {
                    mLeft = left;
                    mRight = right;
                } else if (mLeft <= left && mLeft <= right) {
                    mLeft = left;
                }
                mTop = mTop + rTop - top;
                mBottom = mBottom + rTop - top;
                mLeft = mLeft + rLeft - left;
                mRight = mRight + rLeft - left;
                if (mBottom - mTop == 0 && mRight - mLeft == 0) continue;
                KDTMergeBlock newBlock = new KDTMergeBlock();
                newBlock.bottom = mBottom;
                newBlock.top = mTop;
                newBlock.left = mLeft;
                newBlock.right = mRight;
                if ((newBlock = this.transBlockWithHiddenColumn(newBlock, colOutputMark)) == null) continue;
                sheet.getMerges().addMerge(newBlock.getTop(), newBlock.getLeft(), newBlock.getBottom(), newBlock.getRight());
            }
            if (mode == 2 || direct == 1) {
                rTop += height;
                continue;
            }
            if (mode != 4 && direct != 0) continue;
            rLeft += width;
        }
        return sheet;
    }

    private KDTMergeBlock transBlock(KDTMergeBlock block, boolean[] colOutputMark, int headRowCount) {
        KDTMergeBlock newBlock = new KDTMergeBlock();
        newBlock.bottom = block.getBottom() + headRowCount;
        newBlock.top = block.getTop() + headRowCount;
        newBlock.left = block.getLeft();
        newBlock.right = block.getRight();
        if ((newBlock = this.transBlockWithHiddenColumn(newBlock, colOutputMark)) == null) {
            return null;
        }
        if (this.isWithIndexColumn()) {
            ++newBlock.left;
            ++newBlock.right;
        }
        return newBlock;
    }

    private KDTMergeBlock transBlockWithHiddenColumn(KDTMergeBlock block, boolean[] colOutputMark) {
        int i;
        int left;
        int length = colOutputMark.length;
        int right = block.getRight();
        if (right > length - 1 || left > length - 1) {
            return null;
        }
        for (left = block.getLeft(); left <= right && !colOutputMark[left]; ++left) {
        }
        while (right >= left && !colOutputMark[right]) {
            --right;
        }
        int left2 = left;
        int right2 = right;
        for (i = 0; i < left; ++i) {
            if (colOutputMark[i]) continue;
            --left2;
            --right2;
        }
        for (i = left; i < right; ++i) {
            if (colOutputMark[i]) continue;
            --right2;
        }
        if (left2 > right2) {
            return null;
        }
        if (left2 == right2 && block.getTop() == block.getBottom()) {
            return null;
        }
        block.setLeft(left2);
        block.setRight(right2);
        return block;
    }

    private boolean isColumnHidden(int colIndex) {
        IColumn col = this.getTable().getColumn(colIndex);
        if (col != null) {
            return col.getStyleAttributes().isHided();
        }
        return true;
    }

    public KDSBook getBook() {
        return this.book;
    }

    public KDTable getTable() {
        return this.table;
    }

    public boolean isWithHead() {
        return this.withHead;
    }

    public void setWithHead(boolean withHead) {
        this.withHead = withHead;
    }

    public boolean isWithFoot() {
        return this.withFoot;
    }

    public void setWithFoot(boolean withFoot) {
        this.withFoot = withFoot;
    }

    public boolean isWithHiddenCol() {
        return this.withHiddenCol;
    }

    public void setWithHiddenCol(boolean withHiddenCol) {
        this.withHiddenCol = withHiddenCol;
    }

    public boolean isWithIndexColumn() {
        return this.withIndexColumn;
    }

    public void setWithIndexColumn(boolean withIndexColumn) {
        this.withIndexColumn = withIndexColumn;
    }

    public KDTRange getRange() {
        return this.range;
    }

    public void setRange(KDTRange range) {
        this.range = range;
    }
}

