/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table.component;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.component.BasicSelectComponentUI;
import com.kingdee.cosmic.ctrl.kdf.table.component.SelectFrame;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.cosmic.ctrl.kdf.util.Tools;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SelectComponent
extends JComponent {
    private static final long serialVersionUID = -1158599576917868816L;
    private String selectFrameTitle;
    private Window oppositeWindow;
    SelectComponent oppositeComp;
    private KDTable table;
    private SelectHandle selectHandle;
    KDTextField editor = new KDTextField();
    JButton button = new JButton();
    int type = 0;
    static final String SPLIT_CHAR = ",";
    static final String FROM_CHAR = ":";
    static final Pattern p1 = Pattern.compile(",");
    static final Pattern p2 = Pattern.compile(":");

    public SelectComponent() {
        this.selectHandle = new SelectHandle();
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI(BasicSelectComponentUI.createUI(this));
    }

    void openOppositeWindow() {
        Window oppoWindow = this.getOppositeWindow();
        if (oppoWindow != null) {
            Window currWindow = this.getCurrentWindow();
            Point pt = null;
            if (currWindow != null) {
                currWindow.setVisible(false);
                pt = currWindow.getLocation();
            }
            if (pt != null) {
                this.oppositeWindow.setLocation(pt);
            }
            this.oppositeWindow.setVisible(true);
        }
    }

    public String getText() {
        return this.editor.getText();
    }

    public void setText(String text) {
        this.editor.setText(text);
    }

    public KDTable getTable() {
        return this.table;
    }

    public void setTable(KDTable table) {
        if (this.table != null) {
            this.table.removeKDTSelectListener(this.selectHandle);
        }
        this.table = table;
        table.addKDTSelectListener(this.selectHandle);
        if (this.oppositeComp != null) {
            this.oppositeComp.setTable(table);
        }
    }

    private Window getCurrentWindow() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private SelectFrame createSelectFrame() {
        Window window = this.getCurrentWindow();
        Window parent = null;
        if (window != null) {
            parent = window.getOwner();
        }
        SelectFrame sFrame = parent instanceof Frame ? new SelectFrame((Frame)parent, this.getSelectFrameTitle()) : (parent instanceof Dialog ? new SelectFrame((Dialog)parent, this.getSelectFrameTitle()) : new SelectFrame((Frame)null, this.getSelectFrameTitle()));
        this.oppositeComp = sFrame.getSelectComponent();
        this.oppositeComp.setOppositeWindow(window);
        this.oppositeComp.setTable(this.getTable());
        this.oppositeComp.setText(this.getText());
        return sFrame;
    }

    public Window getOppositeWindow() {
        if (this.oppositeWindow == null && this.type == 0) {
            this.oppositeWindow = this.createSelectFrame();
        }
        return this.oppositeWindow;
    }

    public void setOppositeWindow(Window oppositeWindow) {
        this.oppositeWindow = oppositeWindow;
    }

    public KDTextField getEditor() {
        return this.editor;
    }

    public ArrayList getSelectBlocks() {
        return SelectComponent.textToBlocks(this.editor.getText());
    }

    private String blocksToText(ArrayList blocks) {
        if (blocks == null || blocks.size() <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = blocks.iterator();
        while (it.hasNext()) {
            int top;
            KDTSelectBlock block = (KDTSelectBlock)it.next();
            int mode = block.getMode();
            if (mode == 8) {
                sb.append(0);
                sb.append(':');
                sb.append(this.table.getRowCount3());
            } else if (mode == 4) {
                int left = block.getLeft();
                int right = block.getRight();
                sb.append(Tools.getCharacterFromIndex((int)left));
                sb.append(':');
                sb.append(Tools.getCharacterFromIndex((int)right));
            } else if (mode == 2) {
                top = block.getTop();
                int bottom = block.getBottom();
                sb.append(String.valueOf(top + 1));
                sb.append(':');
                sb.append(String.valueOf(bottom + 1));
            } else {
                top = block.getTop();
                int left = block.getLeft();
                int right = block.getRight();
                int bottom = block.getBottom();
                if (top == bottom && left == right) {
                    sb.append(Tools.getCharacterFromIndex((int)left));
                    sb.append(String.valueOf(top + 1));
                } else {
                    sb.append(Tools.getCharacterFromIndex((int)left));
                    sb.append(String.valueOf(top + 1));
                    sb.append(':');
                    sb.append(Tools.getCharacterFromIndex((int)right));
                    sb.append(String.valueOf(bottom + 1));
                }
            }
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static ArrayList textToBlocks(String text) {
        if (StringUtil.isEmptyString((String)text)) {
            return null;
        }
        if (!(text = text.trim()).endsWith(SPLIT_CHAR)) {
            text = text + SPLIT_CHAR;
        }
        ArrayList<KDTSelectBlock> blocks = new ArrayList<KDTSelectBlock>();
        Matcher m = p1.matcher(text);
        int index = 0;
        while (index < text.length() && m.find(index)) {
            int start = index;
            int end = m.start();
            index = end + 1;
            blocks.add(SelectComponent.textToBlock(text.substring(start, end)));
        }
        return blocks;
    }

    public static KDTSelectBlock textToBlock(String text) {
        if (StringUtil.isEmptyString((String)text)) {
            return null;
        }
        text = text.trim();
        text = text + FROM_CHAR;
        KDTSelectBlock block = new KDTSelectBlock();
        Matcher m = p2.matcher(text);
        int index = 0;
        while (index < text.length() && m.find(index)) {
            int start = index;
            int end = m.start();
            String cell = text.substring(start, end);
            int i = 0;
            char ch = cell.charAt(i);
            int col = 0;
            int row = 0;
            for (i = 0; i < cell.length(); ++i) {
                ch = cell.charAt(i);
                if (Character.isLetter(ch)) {
                    col = col * 26 + (Character.toUpperCase(ch) - 65 + 1);
                    continue;
                }
                if (!Character.isDigit(ch)) continue;
                row = row * 10 + (Character.toUpperCase(ch) - 48);
            }
            if (--row == -1 && --col == -1) {
                return null;
            }
            if (row == -1) {
                block.setMode(4);
                if (index == 0) {
                    block.setLeft(col);
                    block.setRight(col);
                } else {
                    block.setRight(col);
                }
            } else if (col == -1) {
                block.setMode(2);
                if (index == 0) {
                    block.setTop(row);
                    block.setBottom(row);
                } else {
                    block.setBottom(row);
                }
            } else {
                block.setMode(1);
                if (index == 0) {
                    block.setTop(row);
                    block.setLeft(col);
                    block.setBottom(row);
                    block.setRight(col);
                } else {
                    block.setBottom(row);
                    block.setRight(col);
                }
            }
            index = end + 1;
        }
        return block;
    }

    public JButton getButton() {
        return this.button;
    }

    public void setEnable(boolean enabled) {
        super.setEnabled(enabled);
        this.getEditor().setEnabled(enabled);
        this.getButton().setEnabled(enabled);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getEditor().setEnabled(enabled);
        this.getButton().setEnabled(enabled);
    }

    public String getSelectFrameTitle() {
        return this.selectFrameTitle;
    }

    public void setSelectFrameTitle(String selectFrameTitle) {
        this.selectFrameTitle = selectFrameTitle;
    }

    class SelectHandle
    implements KDTSelectListener {
        SelectHandle() {
        }

        @Override
        public void tableSelectChanged(KDTSelectEvent e) {
            String text = SelectComponent.this.blocksToText(SelectComponent.this.table.getSelectManager().getBlocks());
            SelectComponent.this.editor.setText(text);
        }
    }
}

