/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table.icons;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class ResourceManager {
    private static final Logger logger = LogUtil.getPackageLogger(ResourceManager.class);
    private static Point point = new Point(16, 16);
    private static Hashtable cursors = new Hashtable();
    static Hashtable urls = new Hashtable();

    public static Cursor getCustomCursor(Component comp, String url) {
        if (url == null) {
            return null;
        }
        if (cursors.containsKey(url)) {
            return (Cursor)cursors.get(url);
        }
        Image img = ResourceManager.getBufferedImage(url);
        Cursor cur = comp.getToolkit().createCustomCursor(img, point, url);
        cursors.put(url, cur);
        return cur;
    }

    public static URL getResourceURL(String resName) {
        if (urls.containsKey(resName)) {
            return (URL)urls.get(resName);
        }
        URL url = ResourceManager.class.getResource(resName);
        if (url != null) {
            urls.put(resName, url);
        }
        return url;
    }

    public static Image getBufferedImage(String resName) {
        Image image = null;
        URL url = ResourceManager.getResourceURL(resName);
        try {
            image = new ImageIcon(url).getImage();
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return image;
    }

    public static ImageIcon getImageIcon(String resName) {
        ImageIcon icon = null;
        URL url = ResourceManager.getResourceURL(resName);
        icon = new ImageIcon(url);
        return icon;
    }
}

