/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table.perspective;

import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDTableMessages;
import com.kingdee.cosmic.ctrl.kdf.data.DataSetVisitor;
import com.kingdee.cosmic.ctrl.kdf.data.exception.DataSetWrapperException;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.cosmic.ctrl.kdf.table.IBlock;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import java.util.ArrayList;

public class PerspectiveDataProvider
implements DataSetVisitor {
    private Object[] data = new Object[0];
    private String[] fields = new String[0];
    private int recCount = 0;
    private int currentPos = -1;

    public PerspectiveDataProvider(KDTable table, IBlock selectBlock) {
        this.fill(table, selectBlock);
    }

    private void fill(KDTable table, IBlock selectBlock) {
        selectBlock = this.change(table, selectBlock);
        selectBlock = this.filterBlankColOrRow(table, selectBlock);
        this.fillFields(table, selectBlock);
        this.filldata(table, selectBlock);
    }

    private void filldata(KDTable table, IBlock selectBlock) {
        int height = selectBlock.getBottom() - selectBlock.getTop() + 1;
        this.recCount = height - 1;
        if (height <= 1) {
            return;
        }
        int width = selectBlock.getRight() - selectBlock.getLeft() + 1;
        this.data = new Object[width * height];
        int top = selectBlock.getTop() + 1;
        for (int i = 0; i < height - 1; ++i) {
            int left = selectBlock.getLeft();
            for (int j = 0; j < width; ++j) {
                ICell cell = table.getCell(top, left);
                KDTCell kCell = null;
                if (cell != null) {
                    kCell = cell.getKDTCell();
                }
                Object value = null;
                if (kCell != null) {
                    value = kCell.getValue();
                }
                int index = i * width + j;
                this.data[index] = value;
                ++left;
            }
            ++top;
        }
    }

    private void fillFields(KDTable table, IBlock selectBlock) {
        int width = selectBlock.getRight() - selectBlock.getLeft() + 1;
        this.fields = new String[width];
        int top = selectBlock.getTop();
        int left = selectBlock.getLeft();
        for (int i = 0; i < width; ++i) {
            ICell cell = table.getCell(top, left);
            KDTCell kCell = cell.getKDTCell();
            Object value = kCell.getValue();
            if (value != null) {
                this.fields[i] = value.toString();
            }
            ++left;
        }
    }

    private IBlock change(KDTable table, IBlock selectBlock) {
        if (selectBlock.getMode() == 1) {
            return selectBlock;
        }
        int maxRow = table.getRowCount();
        int maxCol = table.getColumnCount();
        if (selectBlock.getMode() == 4) {
            selectBlock.setBottom(maxRow - 1);
            selectBlock.setRight(selectBlock.getLeft());
        } else if (selectBlock.getMode() == 2) {
            selectBlock.setBottom(selectBlock.getBottom());
            selectBlock.setRight(maxCol - 1);
        } else if (selectBlock.getMode() == 8) {
            selectBlock.setTop(0);
            selectBlock.setLeft(0);
            selectBlock.setBottom(maxRow - 1);
            selectBlock.setRight(maxCol - 1);
        }
        selectBlock.setMode(1);
        return selectBlock;
    }

    private IBlock filterBlankColOrRow(KDTable table, IBlock selectBlock) {
        Object value;
        ICell cell;
        int j;
        boolean isBlankRow;
        int i;
        int top = selectBlock.getTop();
        int bottom = selectBlock.getBottom();
        int left = selectBlock.getLeft();
        int right = selectBlock.getRight();
        for (i = top; i <= bottom; ++i) {
            isBlankRow = true;
            for (j = left; j <= right; ++j) {
                cell = table.getCell(i, j);
                if (cell == null || (value = cell.getValue()) == null || value.toString().equals("")) continue;
                isBlankRow = false;
                break;
            }
            if (!isBlankRow) break;
            selectBlock.setTop(i + 1);
        }
        for (i = bottom; i >= top; --i) {
            isBlankRow = true;
            for (j = left; j <= right; ++j) {
                cell = table.getCell(i, j);
                if (cell == null || (value = cell.getValue()) == null || value.toString().equals("")) continue;
                isBlankRow = false;
                break;
            }
            if (!isBlankRow) break;
            selectBlock.setBottom(i - 1);
        }
        for (i = left; i <= right; ++i) {
            isBlankRow = true;
            for (j = top; j <= bottom; ++j) {
                cell = table.getCell(j, i);
                if (cell == null || (value = cell.getValue()) == null || value.toString().equals("")) continue;
                isBlankRow = false;
                break;
            }
            if (!isBlankRow) break;
            selectBlock.setLeft(i + 1);
        }
        for (i = right; i >= left; --i) {
            isBlankRow = true;
            for (j = top; j <= bottom; ++j) {
                cell = table.getCell(j, i);
                if (cell == null || (value = cell.getValue()) == null || value.toString().equals("")) continue;
                isBlankRow = false;
                break;
            }
            if (!isBlankRow) break;
            selectBlock.setRight(i - 1);
        }
        return selectBlock;
    }

    public boolean execute(String sName, String sQuery) throws DataSetWrapperException {
        throw new DataSetWrapperException(CtrlKDTableMessages.getMLS("methodNotImplemented", "\u8be5\u65b9\u6cd5\u6ca1\u6709\u88ab\u5b9e\u73b0"));
    }

    public boolean next(ArrayList avOut) throws DataSetWrapperException {
        ++this.currentPos;
        avOut.clear();
        if (this.isValidRow()) {
            for (int i = 0; i < this.fields.length; ++i) {
                avOut.add(new Variant(this.data[this.currentPos * this.fields.length + i]));
            }
        } else {
            for (int i = 0; i < this.fields.length; ++i) {
                avOut.add(new Variant());
            }
            return false;
        }
        return true;
    }

    public boolean isValidRow() throws DataSetWrapperException {
        return this.currentPos < this.recCount && this.currentPos >= 0;
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    public String[] getAllFieldName() {
        return this.fields;
    }

    public int getRecordCount() {
        return this.recCount;
    }
}

