/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table.print;

import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class TableUtil2 {
    public static boolean isEmpty(KDTable table) {
        int rowCount = table.getRowCount1();
        if (table.getPrintManager().getNewPrintManager().isExpandedOnly()) {
            rowCount = table.getExpandedRowCount();
        }
        if (table.isHasFoot()) {
            rowCount += table.getFootManager().getFoot().size();
        }
        return rowCount == 0;
    }

    public static int getMaxRowIndex(KDTable table) {
        int rowCount = 0;
        int mode = table.getDataRequestManager().getDataRequestMode();
        if (table.getPrintManager().getNewPrintManager().isExpandedOnly()) {
            rowCount = table.getExpandedRowCount();
        } else if (mode == 0) {
            rowCount = table.getRowCount1();
        } else {
            rowCount = table.getRowCount1();
            if (rowCount == -1 || rowCount == Integer.MAX_VALUE) {
                int i = -1;
                while (table.getRow(++i) != null) {
                }
                rowCount = i;
            }
        }
        if (table.isHasFoot()) {
            rowCount += table.getFootManager().getFoot().size();
        }
        return rowCount - 1;
    }

    public static int getMaxColIndex(KDTable table) {
        if (table.getPrintManager().getNewPrintManager().isExpandedOnly()) {
            int rowCount = table.getExpandedColumnCount();
            return rowCount - 1;
        }
        return table.getColumnCount() - 1;
    }

    public static List getMergerBlocks(KDTable table, int top, int left, int bottom, int right) {
        HashSet<KDTMergeBlock> mergerSet = new HashSet<KDTMergeBlock>();
        for (int row = top; row <= bottom; ++row) {
            for (int col = left; col <= right; ++col) {
                ICell cell = table.getCell(row, col);
                if (cell == null || cell.getMergeBlock() == null) continue;
                mergerSet.add(cell.getMergeBlock());
            }
        }
        ArrayList mergerList = new ArrayList(mergerSet.size());
        Iterator iter = mergerSet.iterator();
        while (iter.hasNext()) {
            mergerList.add(iter.next());
        }
        return mergerList;
    }

    public static int getRowHeight(KDTable table, int i) {
        IRow row = null;
        row = i >= table.getRowCount() && table.isHasFoot() ? table.getFootRow(i - table.getRowCount()) : table.getRow(i);
        if (row == null) {
            return 19;
        }
        if (table.getPrintManager().isAutoConnect() && table.getPrintManager().getNewPrintManager().getPrinterConfig().getPrintContentType() == 0 && table.getPrintManager().getNewPrintManager().getPrintJobConfig().getPrintAreas() != null) {
            ArrayList list = table.getSelectManager().getBlocks();
            if (list == null) {
                return row.getHeight() - 1;
            }
            for (int k = 0; k < list.size(); ++k) {
                KDTSelectBlock block = (KDTSelectBlock)list.get(k);
                if (!block.contains(0, row.getRowIndex())) continue;
                return row.getHeight() - 1;
            }
            return -1;
        }
        return row.getHeight() - 1;
    }

    public static int getColumnWidth(KDTable table, int j) {
        if (table.getPrintHiddenColIndex() != null && table.getPrintHiddenColIndex().contains(j)) {
            return -1;
        }
        IColumn column = table.getColumn(j);
        if (column == null) {
            return 0;
        }
        return column.getWidth() - 1;
    }

    public static Style getCellStyle(KDTable table, int i, int j) {
        ICell cell = TableUtil2.getTableCell(table, i, j);
        if (cell != null) {
            return cell.getStyle();
        }
        return null;
    }

    public static ICell getTableCell(KDTable table, int i, int j) {
        IRow row = null;
        row = i >= table.getRowCount() && table.isHasFoot() ? table.getFootRow(i - table.getRowCount()) : table.getRow(i);
        if (row != null) {
            return row.getCell(j, false);
        }
        return null;
    }
}

