/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.tablepanel;

import com.kingdee.cosmic.ctrl.kdf.tablepanel.PanelCell;
import com.kingdee.cosmic.ctrl.kdf.tablepanel.PanelCells;
import com.kingdee.cosmic.ctrl.kdf.tablepanel.PanelColumn;
import com.kingdee.cosmic.ctrl.kdf.tablepanel.PanelColumns;
import com.kingdee.cosmic.ctrl.kdf.tablepanel.PanelMerger;
import com.kingdee.cosmic.ctrl.kdf.tablepanel.PanelMergers;
import com.kingdee.cosmic.ctrl.kdf.tablepanel.PanelRow;
import com.kingdee.cosmic.ctrl.kdf.tablepanel.PanelRows;
import com.kingdee.cosmic.ctrl.kdf.tablepanel.TablePanelLayout;
import com.kingdee.cosmic.ctrl.kdf.tablepanel.plaf.KingdeeTablePanelUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;

public class KDTablePanel
extends JComponent {
    private PanelRows rows;
    private PanelColumns columns;
    private PanelCells cells;
    private PanelMergers mergers;
    private static final long serialVersionUID = -6409782465705764918L;
    private static final String uiClassID = "TablePanelUI";
    private HashMap<Component, Rectangle> oldComponent = new HashMap();

    public KDTablePanel() {
        this(0, 0);
    }

    public KDTablePanel(int rows, int cols) {
        this.setBorder(new LineBorder(Color.decode("#737373")));
        this.rows = new PanelRows();
        this.columns = new PanelColumns();
        this.cells = new PanelCells(this);
        this.mergers = new PanelMergers();
        this.addRows(rows);
        this.addColumns(cols);
        this.addCells();
        this.updateCells();
        this.updateUI();
    }

    private void addRows(int count) {
        this.rows.addRows(count);
    }

    public PanelRow getRow(int index) {
        return this.rows.getRow(index);
    }

    public int getRowCount() {
        return this.rows.getRowsCount();
    }

    public int getRowIndex(PanelRow row) {
        return this.rows.getRowIndex(row);
    }

    private void addColumns(int count) {
        this.columns.addColumns(count);
    }

    public PanelColumn getColumn(int index) {
        return this.columns.getColumn(index);
    }

    public int getColumnCount() {
        return this.columns.getColumnsCount();
    }

    public int getColumnIndex(PanelColumn column) {
        return this.columns.getColumnIndex(column);
    }

    public PanelCell getCell(int index) {
        return this.cells.getCell(index);
    }

    public PanelCell getCell(int row, int col) {
        return this.cells.getCell(row, col);
    }

    public int getCellsCount() {
        return this.cells.getCellsCount();
    }

    private void addCells() {
        int rowCount = this.getRowCount();
        int colCount = this.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                this.cells.addCell(this.getRow(i), this.getColumn(j));
            }
        }
    }

    private void updateCells() {
        int rowCount = this.getRowCount();
        int colCount = this.getColumnCount();
        Insets ins = this.getInsets();
        int x = ins.left;
        int y = ins.top;
        for (int i = 0; i < rowCount; ++i) {
            y = i == 0 ? ins.top : (y += this.getRow(i - 1).getHeight() + 1);
            for (int j = 0; j < colCount; ++j) {
                x = j == 0 ? ins.left : (x += this.getColumn(j - 1).getWidth() + 1);
                this.getCell(i, j).setTop(x, y);
            }
        }
    }

    public void addMerger(PanelMerger merger) {
        this.mergers.addMerger(merger);
    }

    public PanelMerger getMerger(int index) {
        return this.mergers.getMerger(index);
    }

    public int getMergersCount() {
        return this.mergers.getMergerCount();
    }

    public void clearMergers() {
        for (int i = 0; i < this.getCellsCount(); ++i) {
            this.getCell(i).setMerger(null);
        }
        this.mergers.clearMergers();
    }

    public void merge(PanelCell cell1, PanelCell cell2) {
        if (cell1 != null && cell2 != null && cell1 != cell2) {
            int startRowIndex = this.getRowIndex(cell1.getRow());
            int startColIndex = this.getColumnIndex(cell1.getColumn());
            int endRowIndex = this.getRowIndex(cell2.getRow());
            int endColIndex = this.getColumnIndex(cell2.getColumn());
            if (startRowIndex != -1 && startColIndex != -1 && endRowIndex != -1 && endColIndex != -1) {
                int temp;
                if (startRowIndex > endRowIndex) {
                    temp = startRowIndex;
                    startRowIndex = endRowIndex;
                    endRowIndex = temp;
                }
                if (startColIndex > endColIndex) {
                    temp = startColIndex;
                    startColIndex = endColIndex;
                    endColIndex = temp;
                }
            }
            PanelCell startCell = this.getCell(startRowIndex, startColIndex);
            PanelCell endCell = this.getCell(endRowIndex, endColIndex);
            PanelMerger merger = new PanelMerger(startCell, endCell);
            this.addMerger(merger);
            for (int i = startRowIndex; i <= endRowIndex; ++i) {
                for (int j = startColIndex; j <= endColIndex; ++j) {
                    this.getCell(i, j).setMerger(merger);
                }
            }
        }
    }

    public void resize(int[] rowHeights, int[] colWidths) {
        int rowCount = this.getRowCount();
        int colCount = this.getColumnCount();
        if (rowHeights.length == rowCount && colWidths.length == colCount) {
            int i;
            for (i = 0; i < rowCount; ++i) {
                this.getRow(i).setHeight(rowHeights[i]);
            }
            for (i = 0; i < colCount; ++i) {
                this.getColumn(i).setWidth(colWidths[i]);
            }
        }
        this.updateCells();
        this.revalidate();
    }

    public void rebuild(int rows, int cols, int[] rowHeights, int[] colWidths) {
        this.rows.removeAllRows();
        this.columns.removeAllColumns();
        this.cells.clearCells();
        this.clearMergers();
        this.addRows(rows);
        this.addColumns(cols);
        this.addCells();
        this.updateCells();
        this.updateUI();
        this.resize(rowHeights, colWidths);
    }

    public void resizeComponent() {
        block0: for (int j = 0; j < this.getComponents().length; ++j) {
            Component cpt = this.getComponents()[j];
            for (int i = 0; i < this.oldComponent.size(); ++i) {
                Rectangle rect = this.oldComponent.get(cpt);
                if (rect == null) continue;
                cpt.setBounds(rect);
                continue block0;
            }
        }
    }

    public void updateOldComponentBycompName(String compName, Rectangle bounds) {
        Component cmp = null;
        for (Component key : this.oldComponent.keySet()) {
            if (!key.getName().equals(compName)) continue;
            cmp = key;
            break;
        }
        if (cmp != null) {
            this.oldComponent.put(cmp, bounds);
        }
    }

    public void updateOldComponentBycomp(Component cmp, Rectangle bounds) {
        Component temp = null;
        for (Component key : this.oldComponent.keySet()) {
            if (!cmp.equals(key)) continue;
            temp = key;
            break;
        }
        if (temp != null) {
            this.oldComponent.put(temp, bounds);
        }
    }

    public void doAutoLayout() {
        LayoutManager layout = this.getLayout();
        this.resizeComponent();
        if (layout instanceof TablePanelLayout) {
            ((TablePanelLayout)layout).autoLayoutContainer(this);
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public KingdeeTablePanelUI getUI() {
        return (KingdeeTablePanelUI)this.ui;
    }

    @Override
    public void updateUI() {
        this.setUI((KingdeeTablePanelUI)UIManager.getUI(this));
    }

    public void setUI(KingdeeTablePanelUI ui) {
        super.setUI(ui);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.oldComponent.put(comp, comp.getBounds());
        this.addImpl(comp, constraints, -1);
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
    }

    static {
        UIManager.getDefaults().put(uiClassID, "com.kingdee.cosmic.ctrl.kdf.tablepanel.plaf.KingdeeTablePanelUI");
    }
}

