/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.kdfsax;

import com.kingdee.cosmic.ctrl.kdf.util.kdfsax.BasicElementHandler;
import com.kingdee.cosmic.ctrl.kdf.util.kdfsax.BordersHandler;
import com.kingdee.cosmic.ctrl.kdf.util.kdfsax.NumberFormatHandler;
import com.kingdee.cosmic.ctrl.kdf.util.style.Pattern;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleParser;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StyleHandler
extends BasicElementHandler {
    private String styleid = null;
    private StyleAttributes sa = null;

    public StyleHandler() {
        this.handlerMap = new HashMap();
        this.handlerMap.put("c:NumberFormat", new NumberFormatHandler());
        this.handlerMap.put("c:Borders", new BordersHandler());
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        super.endElement(namespaceURI, sName, qName);
        if ("c:NumberFormat".equals(qName)) {
            this.currentHandler = null;
        } else if ("c:Borders".equals(qName)) {
            this.currentHandler = null;
        } else if ("c:Style".equals(qName)) {
            if (this.styleid != null) {
                ((HashMap)this.parent).put(this.styleid, this.sa);
                this.styleid = null;
                this.sa = null;
            }
            this.currentHandler = null;
        }
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if ("c:Style".equals(qName)) {
            this.styleid = attrs.getValue("id");
            this.sa = Styles.getEmptySA();
            this.current = this.sa;
            return;
        }
        if ("c:Interior".equals(qName)) {
            StyleHandler.parseInterior(this.sa, attrs);
        } else if ("c:Font".equals(qName)) {
            StyleHandler.parseFont(this.sa, attrs);
        } else if ("c:Protection".equals(qName)) {
            StyleHandler.parseProtection(this.sa, attrs);
        } else if ("c:Alignment".equals(qName)) {
            StyleHandler.parseAlignment(this.sa, attrs);
        } else {
            super.startElement(namespaceURI, sName, qName, attrs);
        }
    }

    static void parseNumberFormat(StyleAttributes sa, Attributes attrs) {
    }

    static void parseAlignment(StyleAttributes sa, Attributes attrs) {
        String value = attrs.getValue("rotate");
        if (value != null) {
            sa.setRotation(Integer.parseInt(value));
        }
        if ((value = attrs.getValue("horizontal")) != null) {
            sa.setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)value));
        }
        if ((value = attrs.getValue("vertical")) != null) {
            sa.setVerticalAlign(Styles.VerticalAlignment.getAlignment((String)value));
        }
        if ((value = attrs.getValue("lineSpace")) != null) {
            sa.setLinespacing(Float.parseFloat(value));
        }
        if ((value = attrs.getValue("wrapText")) != null) {
            sa.setWrapText(Boolean.parseBoolean(value));
        }
        if ((value = attrs.getValue("shrink")) != null) {
            sa.setShrinkText(Boolean.parseBoolean(value));
        }
        if ((value = attrs.getValue("clip")) != null) {
            sa.setClip(Boolean.parseBoolean(value));
        }
    }

    static void parseProtection(StyleAttributes sa, Attributes attrs) {
        String value = attrs.getValue("locked");
        if (value != null) {
            sa.setLocked(Boolean.parseBoolean(value));
        }
        if ((value = attrs.getValue("hidden")) != null) {
            sa.setHided(Boolean.parseBoolean(value));
        }
    }

    static void parseFont(StyleAttributes sa, Attributes attrs) {
        String value = attrs.getValue("fontName");
        if (value != null) {
            sa.setFontName(value);
        }
        if ((value = attrs.getValue("size")) != null) {
            sa.setFontSize(Integer.parseInt(value));
        }
        if ((value = attrs.getValue("color")) != null) {
            sa.setFontColor(StyleParser.stringToColor((String)value));
        }
        if ((value = attrs.getValue("bold")) != null) {
            sa.setBold(Boolean.parseBoolean(value));
        }
        if ((value = attrs.getValue("italic")) != null) {
            sa.setItalic(Boolean.parseBoolean(value));
        }
        if ((value = attrs.getValue("strikethrough")) != null) {
            sa.setStrikeThrough(Boolean.parseBoolean(value));
        }
        if ((value = attrs.getValue("underline")) != null) {
            sa.setUnderline(Boolean.parseBoolean(value));
        }
        if ((value = attrs.getValue("weight")) != null) {
            sa.setWeight(Float.parseFloat(value));
        }
    }

    static void parseInterior(StyleAttributes sa, Attributes attrs) {
        String value = attrs.getValue("color");
        if (value != null) {
            sa.setBackground(StyleParser.stringToColor((String)value));
        }
        if ((value = attrs.getValue("pattern")) != null) {
            sa.setPattern(Pattern.getPattern((String)value));
        }
        if ((value = attrs.getValue("patternColor")) != null) {
            sa.setPatternColor(StyleParser.stringToColor((String)value));
        }
    }
}

