/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.plaf.PlafUtilies;
import com.kingdee.cosmic.ctrl.swing.util.SwingLogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class ThemeXMLHandler {
    private static final Logger log = LogUtil.getPackageLogger(ThemeXMLHandler.class);
    private transient String tempFilePath = "";
    private String fileAlias = null;
    private static int aliasIndex = 0;
    private boolean isFirstAlias = true;
    private static transient String AliasName = "alias";
    private Properties currentThemeProperties;
    private static boolean DEBUG = true;

    public ThemeXMLHandler() {
        this(null);
    }

    public ThemeXMLHandler(String filePath) {
        this.loadThemeFile(filePath);
        this.fileAlias = String.valueOf(aliasIndex);
        ++aliasIndex;
    }

    public URL getThemePath() {
        return this.getClass().getResource("resources/kingdeetheme.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadThemeFile(String filePath) {
        if (filePath == null || filePath.length() == 0) {
            return;
        }
        InputStream is = null;
        try {
            this.currentThemeProperties = new Properties();
            File propFile = new File(FilenameUtils.normalize((String)filePath));
            is = propFile.exists() ? new FileInputStream(propFile) : this.getClass().getResourceAsStream(filePath);
            this.currentThemeProperties.load(is);
        }
        catch (Exception e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.info((Object)"error", (Throwable)e);
                }
            }
        }
    }

    public String getElementValue(String elementName) {
        return PlafUtilies.getElementValue(this.currentThemeProperties, elementName);
    }

    public String getThemeFileAlias() {
        if (!this.isFirstAlias && this.fileAlias != null) {
            return this.fileAlias;
        }
        this.fileAlias = this.getElementValue(AliasName);
        if (this.fileAlias == null || this.fileAlias.length() == 0) {
            SwingLogUtil.error("alias element is empty in file " + this.tempFilePath);
        } else {
            this.fileAlias = String.valueOf(aliasIndex);
        }
        this.isFirstAlias = false;
        return this.fileAlias;
    }

    private static void logs(String info) {
        if (DEBUG) {
            SwingLogUtil.info(info);
        }
    }

    private final void test() {
        UIManager.put("aa", LookAndFeel.makeIcon(this.getClass(), "resources/icons/arrow_north.gif"));
        Icon i = UIManager.getIcon("aa");
        if (i != null) {
            SwingLogUtil.info("makeIcon() is ok! the iconHeight is  " + i.getIconHeight());
        }
        String filePath = "resources/kingdeetheme.properties";
        this.loadThemeFile(filePath);
        ThemeXMLHandler.logs("ThemeXMLHandler " + CtrlCommonMessages.getMLS((String)"unitTestClassStart", (String)"\u5355\u5143\u6d4b\u8bd5\u7c7b\u5f00\u59cb\uff1a"));
        ThemeXMLHandler.logs(this.getElementValue("name"));
        ThemeXMLHandler.logs("alias " + this.getElementValue("alias"));
        ThemeXMLHandler.logs(this.getElementValue("description"));
        ThemeXMLHandler.logs(this.getElementValue("version"));
        ThemeXMLHandler.logs(this.getElementValue("options:IsUseSystemColor"));
        ThemeXMLHandler.logs(this.getElementValue("options:SoundEnabled"));
        ThemeXMLHandler.logs(this.getElementValue("name"));
        ThemeXMLHandler.logs(this.getElementValue("ArrowButton:Look:Background"));
        ThemeXMLHandler.logs(this.getElementValue("ArrowButton:Look:Foreground"));
        ThemeXMLHandler.logs(this.getElementValue("ArrowButton:Look:Font:Name"));
        ThemeXMLHandler.logs(this.getElementValue("ArrowButton:Look:Font:Style"));
        ThemeXMLHandler.logs(this.getElementValue("ArrowButton:Look:Font:Size"));
        ThemeXMLHandler.logs("ThemeXMLHandler " + CtrlCommonMessages.getMLS((String)"unitTestClassEnd", (String)"\u5355\u5143\u6d4b\u8bd5\u7c7b\u7ed3\u675f\u3002"));
    }

    public static void main(String[] args) {
        ThemeXMLHandler app = new ThemeXMLHandler();
        app.test();
    }

    public Properties getCurrentThemeProperties() {
        return this.currentThemeProperties;
    }

    public void setCurrentThemeProperties(Properties currentThemeProperties) {
        this.currentThemeProperties = currentThemeProperties;
    }
}

