/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf.lfm;

import com.kingdee.cosmic.ctrl.common.KDToolkit;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.Locale;
import javax.swing.plaf.FontUIResource;

public class KDFontUIResource
extends FontUIResource {
    public static float fontScale = KDFontUIResource.getFontScale();
    private static final long serialVersionUID = 5976691768398302637L;

    private static float getFontScale() {
        float fontScale;
        block7: {
            fontScale = 1.0f;
            String osName = System.getProperty("os.name");
            boolean isWin = osName.toLowerCase(Locale.ENGLISH).startsWith("win");
            boolean isLinux = osName.toLowerCase(Locale.ENGLISH).startsWith("linux");
            try {
                if (isLinux) {
                    fontScale = (float)Toolkit.getDefaultToolkit().getScreenResolution() / 72.0f;
                } else {
                    fontScale = Float.parseFloat(System.getProperty("com.kingdee.cosmic.ctrl.swing.fontscale"));
                    if (isWin) {
                        fontScale = fontScale * 96.0f / 72.0f;
                    }
                }
            }
            catch (Exception e) {
                if (!isWin) break block7;
                try {
                    int currentDPI = KDToolkit.getCurrentDpi();
                    fontScale = (float)currentDPI / 72.0f;
                    System.out.println("dpi: " + currentDPI);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return fontScale;
    }

    public KDFontUIResource(String name, int style, int size) {
        super(name, style, Math.round((float)size * fontScale));
    }

    public KDFontUIResource(Font font) {
        super(font);
    }

    @Override
    public int getSize() {
        return Math.round((float)super.getSize() / fontScale);
    }

    public int getDrawingSize() {
        return super.getSize();
    }
}

