/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.print.ConfigManager;
import com.kingdee.cosmic.ctrl.print.DefaultVariantParser;
import com.kingdee.cosmic.ctrl.print.IConfigChangeListener;
import com.kingdee.cosmic.ctrl.print.IPrintActionListener;
import com.kingdee.cosmic.ctrl.print.IVariantParser;
import com.kingdee.cosmic.ctrl.print.KDPConstant;
import com.kingdee.cosmic.ctrl.print.KDPreview;
import com.kingdee.cosmic.ctrl.print.config.IXmlTranslate;
import com.kingdee.cosmic.ctrl.print.config.ui.KDPrintServiceUI;
import com.kingdee.cosmic.ctrl.print.config.ui.PrintConfigModel;
import com.kingdee.cosmic.ctrl.print.control.ControlPrint;
import com.kingdee.cosmic.ctrl.print.io.IOManager;
import com.kingdee.cosmic.ctrl.print.printjob.IPrintJob;
import com.kingdee.cosmic.ctrl.print.printjob.MultiBufferPrintJobs;
import com.kingdee.cosmic.ctrl.print.resource.Resources;
import com.kingdee.cosmic.ctrl.print.ui.IPaintFilter;
import com.kingdee.cosmic.ctrl.print.util.KDPrintUtil;
import com.kingdee.cosmic.ctrl.print.util.TempFileUtil;
import com.kingdee.cosmic.ctrl.swing.KDOptionPane;
import com.kingdee.cosmic.ctrl.swing.MessageDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.print.PrintService;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public class KDPrinter
implements KDPConstant {
    private static final Logger log = LogUtil.getLogger(KDPrinter.class);
    private IPrintJob printJob;
    private static Map painterXmlTranslateMap;
    public static boolean FIRST_LOAD;
    private Component parentWindow;
    private ControlPrint controlPrint;
    private KDPreview preview;
    private ConfigManager config;
    private IVariantParser defaultVariantParser;
    private IVariantParser variantParser;
    protected EventListenerList listenerList = new EventListenerList();
    private boolean isStopPagination = false;
    private boolean isDividePage = false;
    private IPaintFilter paintFilter;
    private IOManager ioManager;
    private boolean isExportImportButtonVisible = false;
    private boolean isEditButtonVisible = false;
    private boolean isCompositePrint = false;
    public static String[] headFootPreList;

    public KDPrinter() {
        this.controlPrint = new ControlPrint(this);
        this.config = new ConfigManager(this);
        this.printJob = new MultiBufferPrintJobs();
        this.printJob.setPrinter(this);
    }

    public void setPrintConfig(ConfigManager config) {
        this.config = config;
    }

    public ConfigManager getPrintConfig() {
        return this.config;
    }

    public ControlPrint getControlPrint() {
        return this.controlPrint;
    }

    public IPrintJob getPrintJob() {
        return this.printJob;
    }

    public PrintService getPrintService() {
        return this.config.getPrintService();
    }

    public void print() {
        if (this.isPrintDirect()) {
            KDPrintUtil.getInstance();
            String printServiceName = KDPrintUtil.getPrinterName(this.config.getPrintJobName());
            PrintService[] printService = this.config.getModel().getPrintServices();
            boolean isPrinterExits = false;
            if (printService != null && printService.length > 0) {
                for (PrintService service : printService) {
                    if (!service.getName().equals(printServiceName)) continue;
                    isPrinterExits = true;
                    this.config.getModel().setPrintService(service);
                    break;
                }
            }
            if (isPrinterExits) {
                this.printDirect();
            } else {
                KDPrintUtil.getInstance();
                KDPrintUtil.deleteNotExistPrinter(printServiceName);
                this.print2();
            }
        } else {
            this.print2();
        }
    }

    public int print2() {
        int status = this.printDialog(this.parentWindow);
        if (status == 1) {
            if (this.config.getModel().getPrintDirect()) {
                KDPrintUtil.getInstance();
                KDPrintUtil.addConfigToXml(this.config.getPrintJobName(), this.config.getModel().getPrintService().getName());
            }
            this.printDirect();
        } else if (status == 3) {
            this.printPreview(true);
        } else {
            this.config.getModel().reset();
        }
        return status;
    }

    public void setParentWindow(Component parent) {
        this.parentWindow = parent;
    }

    public Component getParentWindow() {
        return this.parentWindow;
    }

    public void printDirect() {
        this.preParePrint();
        this.controlPrint.print(this.getPrintJob());
    }

    public void preParePrint() {
        this.firePrintPaginationListener();
        this.getPrintJob().preparePagination();
    }

    public void printDirectNoPagination() {
        this.controlPrint.print(this.getPrintJob());
    }

    public int printDialog(Component owner) {
        this.config.setChange(false);
        int status = KDPrintServiceUI.printdialog(this.config, owner);
        if (status != 2) {
            this.config.checkChange();
        }
        this.fireConfigOver();
        return status;
    }

    public void printPreview() {
        this.printPreview(this.parentWindow, null);
    }

    public void printPreview(boolean printDirect) {
        this.printPreview(this.parentWindow, null, printDirect);
    }

    public void printPreview(String title) {
        this.printPreview(this.parentWindow, title);
    }

    public void printPreview(Component parent) {
        this.printPreview(parent, null);
    }

    public void printPreview(Component parent, String title) {
        boolean printDirect = this.isPrintDirect();
        this.printPreview(parent, title, printDirect);
    }

    private boolean isPrintDirect() {
        return false;
    }

    public void printPreview(Component parent, String title, boolean printDirect) {
        this.preParePrint();
        this.firePreviewActionListener();
        this.getPrintPreview().setPrintDirect(printDirect);
        this.getPrintPreview().preview(parent, title);
    }

    public KDPreview getPrintPreview() {
        if (this.preview == null) {
            this.preview = new KDPreview(this);
        }
        return this.preview;
    }

    public void closePreview() {
        if (this.preview != null && this.preview.isPreviewing()) {
            this.preview.setPrintDirect(false);
            this.isStopPagination = true;
            this.preview.dispose();
            this.isStopPagination = false;
            this.fireClosePreviewActionListener();
            this.config.getModel().reset();
        }
    }

    public void clear() {
        this.getPrintConfig().clear();
        this.printJob.clear();
        if (FIRST_LOAD) {
            TempFileUtil.deleteTempFile();
            FIRST_LOAD = false;
        }
    }

    public void removeAllPrintActionListeners() {
        this.listenerList = new EventListenerList();
    }

    public void prompt(String string) {
        Component parent = null;
        parent = this.getPrintPreview().isPreviewing() ? this.getPrintPreview().getPreviewComponent() : this.getParentWindow();
        Component p = SwingUtilities.getWindowAncestor(parent);
        if (p == null) {
            p = parent;
        }
        KDOptionPane.showMessageDialog((Component)p, (Object)string);
    }

    public void prompt(String string, Throwable th) {
        Component parent = null;
        parent = this.getPrintPreview().isPreviewing() ? this.getPrintPreview().getPreviewComponent() : this.getParentWindow();
        if (th == null) {
            KDOptionPane.showMessageDialog((Component)parent, (Object)string);
        } else {
            if (parent != null && !(parent instanceof Window)) {
                parent = SwingUtilities.getWindowAncestor(parent);
            }
            StringWriter sw = new StringWriter();
            th.printStackTrace(new PrintWriter(sw));
            String str = sw.toString();
            MessageDialog dialog = null;
            dialog = parent instanceof Dialog ? new MessageDialog((Dialog)parent, string, "print error", -1, 0, true) : (parent instanceof Frame ? new MessageDialog((Frame)parent, string, "print error", -1, 0, true) : new MessageDialog((Frame)null, string, "print error", -1, 0, true));
            dialog.setDetailMessage(str);
            dialog.setLocationRelativeTo(parent);
            dialog.setVisible(true);
        }
    }

    public int confirm(String message, String title) {
        return KDOptionPane.showConfirmDialog((Component)this.parentWindow, (Object)message, (String)title, (int)2);
    }

    public void addPrintJob(IPrintJob job) {
        this.printJob.addPrintJob(job);
    }

    public void setPrintJob(IPrintJob job) {
        this.clear();
        job.setPrinter(this);
        this.printJob = job;
    }

    public int pageDialog(Component parent, int paperIndex, boolean isPreviewing) {
        this.config.setChange(false);
        int status = 0;
        IPrintJob job = this.getPrintJobByPaperIndex(paperIndex);
        this.fireConfigWillChange();
        status = job.pageDialog2(parent, isPreviewing);
        if (status != 2) {
            this.config.checkChange();
        }
        if (!this.getPrintPreview().isPreviewing()) {
            this.config.getModel().reset();
        }
        this.fireConfigOver();
        return status;
    }

    public IPrintJob getPrintJobByPaperIndex(int paperIndex) {
        return this.printJob.getPrintJobByPaperIndex(paperIndex);
    }

    public IVariantParser getVariantParser() {
        return this.variantParser;
    }

    public void setVariantParser(IVariantParser variantParser) {
        this.variantParser = variantParser;
    }

    public IVariantParser getDefaultVariantParser() {
        if (this.defaultVariantParser == null) {
            this.defaultVariantParser = new DefaultVariantParser();
        }
        return this.defaultVariantParser;
    }

    public void setDefaultVariantParser(IVariantParser defaultVariantParser) {
        this.defaultVariantParser = defaultVariantParser;
    }

    public String getID() {
        return null;
    }

    public void registerConfigUI(String name, Class class1, int position) {
        this.config.registerConfigUI(name, class1, position);
    }

    public void unRegisterConfigUI(String name) {
        this.config.unRegisterConfigUI(name);
    }

    public void setPrintPanel(Class panelClass, PrintConfigModel model) {
        this.config.setPrintPanel(panelClass, model);
    }

    public static IXmlTranslate getPainterXmlTranslate(String name) {
        if (painterXmlTranslateMap != null) {
            return (IXmlTranslate)painterXmlTranslateMap.get(name);
        }
        return null;
    }

    public static void registerPainterXmlTranslate(String name, IXmlTranslate trans) {
        if (painterXmlTranslateMap == null) {
            painterXmlTranslateMap = new HashMap(1);
        }
        painterXmlTranslateMap.put(name, trans);
    }

    public void removePrintActionListener(IPrintActionListener l) {
        if (l == null) {
            return;
        }
        this.listenerList.remove(IPrintActionListener.class, l);
    }

    public void addPreviewActionListener(IPrintActionListener lisener) {
        this.addListener(IPrintActionListener.class, lisener);
    }

    public void addPrintActionListener(IPrintActionListener lisener) {
        this.addListener(IPrintActionListener.class, lisener);
    }

    public void addConfigChangeListener(IConfigChangeListener lisener) {
        this.addListener(IConfigChangeListener.class, lisener);
    }

    private void addListener(Class listenerClass, EventListener lisener) {
        if (lisener == null) {
            return;
        }
        this.listenerList.add(listenerClass, lisener);
    }

    public void removeConfigChangeListener(IConfigChangeListener l) {
        if (l == null) {
            return;
        }
        this.listenerList.remove(IConfigChangeListener.class, l);
    }

    public void removePreviewActionListener(IPrintActionListener l) {
        if (l == null) {
            return;
        }
        this.listenerList.remove(IPrintActionListener.class, l);
    }

    protected void firePrintPaginationListener() {
        Object[] listeners = this.listenerList.getListenerList();
        int len = listeners.length;
        for (int i = len - 2; i >= 0; i -= 2) {
            if (listeners[i] != IPrintActionListener.class) continue;
            ((IPrintActionListener)listeners[i + 1]).beforePrintOrPreview();
        }
    }

    public void firePrintListener() {
        Object[] listeners = this.listenerList.getListenerList();
        int len = listeners.length;
        for (int i = len - 2; i >= 0; i -= 2) {
            if (listeners[i] != IPrintActionListener.class) continue;
            ((IPrintActionListener)listeners[i + 1]).beforePrint();
        }
    }

    protected void firePreviewActionListener() {
        Object[] listeners = this.listenerList.getListenerList();
        int len = listeners.length;
        for (int i = len - 2; i >= 0; i -= 2) {
            if (listeners[i] != IPrintActionListener.class) continue;
            ((IPrintActionListener)listeners[i + 1]).beforePreview();
        }
    }

    protected void fireClosePreviewActionListener() {
        Object[] listeners = this.listenerList.getListenerList();
        int len = listeners.length;
        for (int i = len - 2; i >= 0; i -= 2) {
            if (listeners[i] != IPrintActionListener.class) continue;
            ((IPrintActionListener)listeners[i + 1]).closePreview();
        }
    }

    public boolean isStopPagination() {
        return this.isStopPagination;
    }

    public boolean isDynamicPaper() {
        return this.config.getModel().isDynamicPaper();
    }

    public void setDynamicPaper(boolean isDynamicpaper) {
        this.config.getModel().setDynamicPaper(isDynamicpaper);
    }

    public String[] getHeadFootPreList() {
        return headFootPreList;
    }

    public IPaintFilter getPaintFilter() {
        return this.paintFilter;
    }

    public void setPaintFilter(IPaintFilter paintFilter) {
        this.paintFilter = paintFilter;
    }

    public IOManager getIOManager() {
        if (this.ioManager == null) {
            this.ioManager = new IOManager(this);
        }
        return this.ioManager;
    }

    public void firePageCountChange() {
        if (this.getPrintPreview() != null) {
            this.getPrintPreview().setPageCount(this.printJob.getPageCount());
        }
    }

    public boolean isDividePage() {
        return this.isDividePage;
    }

    public void setDividePage(boolean isReFetchPage) {
        if (this.isDividePage != isReFetchPage) {
            this.isDividePage = isReFetchPage;
            ((MultiBufferPrintJobs)this.getPrintJob()).changeReFecthPage(this.isDividePage);
        }
    }

    public void setPreviewWindowType(int type) {
        this.getPrintPreview().setWindowType(type);
    }

    public boolean isExportImportButtonVisible() {
        return this.isExportImportButtonVisible;
    }

    public void setExportImportButtonVisible(boolean isExportImportButtonVisible) {
        this.isExportImportButtonVisible = isExportImportButtonVisible;
    }

    public void setMaxCopies(int max) {
        this.config.getModel().setMaxCopies(max);
    }

    public int getMaxCopies() {
        return this.config.getModel().getMaxCopies();
    }

    public boolean isEditButtonVisible() {
        return this.isEditButtonVisible;
    }

    public void setEditButtonVisible(boolean isEditButtonVisible) {
        this.isEditButtonVisible = isEditButtonVisible;
    }

    public boolean isCompositePrint() {
        return this.isCompositePrint;
    }

    public void setCompositePrint(boolean isCompositePrint) {
        this.isCompositePrint = isCompositePrint;
    }

    public void fireConfigWillChange() {
        Object[] listeners = this.listenerList.getListenerList();
        int len = listeners.length;
        for (int i = len - 2; i >= 0; i -= 2) {
            if (listeners[i] != IConfigChangeListener.class) continue;
            ((IConfigChangeListener)listeners[i + 1]).configWillChange();
        }
    }

    public void fireConfigChange() {
        Object[] listeners = this.listenerList.getListenerList();
        int len = listeners.length;
        for (int i = len - 2; i >= 0; i -= 2) {
            if (listeners[i] != IConfigChangeListener.class) continue;
            ((IConfigChangeListener)listeners[i + 1]).configChanged();
        }
    }

    public void fireConfigOver() {
        Object[] listeners = this.listenerList.getListenerList();
        int len = listeners.length;
        for (int i = len - 2; i >= 0; i -= 2) {
            if (listeners[i] != IConfigChangeListener.class) continue;
            ((IConfigChangeListener)listeners[i + 1]).configOver();
        }
    }

    static {
        FIRST_LOAD = true;
        headFootPreList = null;
        headFootPreList = new String[6];
        KDPrinter.headFootPreList[0] = "";
        KDPrinter.headFootPreList[1] = Resources.getMsg("header.Predefine1");
        KDPrinter.headFootPreList[2] = Resources.getMsg("header.Predefine2");
        KDPrinter.headFootPreList[3] = Resources.getMsg("header.Predefine3");
        KDPrinter.headFootPreList[4] = "&[Date] &[Time]";
        KDPrinter.headFootPreList[5] = Resources.getMsg("header.Predefine4");
    }
}

