/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.config.ui;

import com.kingdee.cosmic.ctrl.common.CtrlUIEnv;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlPrintMessages;
import com.kingdee.cosmic.ctrl.print.config.attribute.HeadFootIntervalInfo;
import com.kingdee.cosmic.ctrl.print.config.attribute.PageIntervalInfo;
import com.kingdee.cosmic.ctrl.print.config.ui.PageSetupModel;
import com.kingdee.cosmic.ctrl.print.util.KDPrinterUtils;
import com.kingdee.cosmic.ctrl.swing.KDFrame;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class ContentHeadFootPreview
extends KDPanel {
    private static final long serialVersionUID = 8185981664299223711L;
    private static final float widthHeightScale = 0.7f;
    private static final Color ActivedColor = Color.RED;
    private static final Color ValidateColor = Color.LIGHT_GRAY;
    private PageIntervalInfo pageContentArea;
    private HeadFootIntervalInfo headFootInfo;
    public static final short DOT_PAGE_TOP = 0;
    public static final short DOT_PAGE_LEFT = 1;
    public static final short DOT_PAGE_BOTTOM = 2;
    public static final short DOT_PAGE_RIGHT = 3;
    public static final short DOT_HEADFOOT_TOP = 4;
    public static final short DOT_HEADFOOT_BOTTOM = 5;
    private int orientation = 1;
    private int centerAling = 0;
    private short dot = (short)-1;
    private float scale = 1.0f;
    private Rectangle rect;

    public ContentHeadFootPreview() {
        this.setOpaque(false);
        this.rect = new Rectangle();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.updateRect();
    }

    private void updateRect() {
        if (this.orientation == 1) {
            int width = this.getPaperWidth() - 1;
            int height = this.getHeight() - 1;
            int x = (this.getWidth() - this.getPaperWidth()) / 2;
            int y = 0;
            this.rect.setBounds(x, y, width, height);
        } else {
            int width = this.getHeight() - 1;
            int height = this.getPaperWidth() - 1;
            int x = 0;
            int y = (this.getWidth() - this.getPaperWidth()) / 2;
            this.rect.setBounds(x, y, width, height);
        }
    }

    private int getPaperWidth() {
        return (int)((float)this.getWidth() * 0.7f);
    }

    public void setActivedDot(short pDot) {
        this.dot = pDot;
        this.repaint();
    }

    public void setPrevewScale(float pScale) {
        this.scale = pScale;
    }

    public void setPageContentInfo(PageIntervalInfo pageArea) {
        if (pageArea != null) {
            this.pageContentArea = pageArea;
            this.repaint();
        }
    }

    public void setHeadFootInfo(HeadFootIntervalInfo hfInfo) {
        if (hfInfo != null) {
            this.headFootInfo = hfInfo;
            this.repaint();
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintBackGround(g);
        this.paintContentLine(g);
        this.paintHeadFootLine(g);
        this.paintRectBorder(g);
    }

    private void paintBackGround(Graphics g) {
        g.setColor(Color.WHITE);
        Graphics2D g2d = (Graphics2D)g;
        g2d.fill(this.rect);
    }

    private void paintRectBorder(Graphics g) {
        Color oldColor = g.getColor();
        g.setColor(Color.BLACK);
        Graphics2D g2d = (Graphics2D)g;
        g2d.draw(this.rect);
        g.setColor(oldColor);
    }

    protected void paintContentLine(Graphics g) {
        Point[] pTop = this.getPageContentLine(0);
        Point[] pLeft = this.getPageContentLine(1);
        Point[] pBottom = this.getPageContentLine(2);
        Point[] pRight = this.getPageContentLine(3);
        boolean bTopActive = false;
        boolean bLeftActive = false;
        boolean bBottomActive = false;
        boolean bRightActive = false;
        switch (this.dot) {
            case 2: {
                bBottomActive = true;
                break;
            }
            case 1: {
                bLeftActive = true;
                break;
            }
            case 3: {
                bRightActive = true;
                break;
            }
            case 0: {
                bTopActive = true;
            }
        }
        this.drawLine(g, pTop, bTopActive);
        this.drawLine(g, pLeft, bLeftActive);
        this.drawLine(g, pBottom, bBottomActive);
        this.drawLine(g, pRight, bRightActive);
        if (pLeft != null && pTop != null && pRight != null && pBottom != null) {
            this.drawVisualContent(g, pLeft[0].x, pTop[0].y, pRight[0].x, pBottom[0].y);
        }
    }

    private void drawVisualContent(Graphics g, int x1, int y1, int x2, int y2) {
        Point[] line;
        int width = (x2 - x1) / 5 * 4;
        int height = (y2 - y1) / 5 * 4;
        if (this.centerAling == PageSetupModel.CENTERALIGN_HORIZONTAL || this.centerAling == PageSetupModel.CENTERALIGN_CENTER) {
            x1 += (x2 - x1 - width) / 2;
        }
        if (this.centerAling == PageSetupModel.CENTERALIGN_VERTICAL || this.centerAling == PageSetupModel.CENTERALIGN_CENTER) {
            y1 += (y2 - y1 - height) / 2;
        }
        x2 = x1 + width;
        y2 = y1 + height;
        int x = x1;
        int y = y1;
        while (true) {
            line = new Point[]{new Point(x1, y), new Point(x2, y)};
            this.drawLine(g, line, false);
            if (y == y2) break;
            if ((y += 4) <= y2) continue;
            y = y2;
        }
        while (true) {
            line = new Point[2];
            if (x >= x2) {
                x = x2;
            }
            line[0] = new Point(x, y1);
            line[1] = new Point(x, y2);
            this.drawLine(g, line, false);
            if (x == x2) break;
            x += 10;
        }
    }

    protected void paintHeadFootLine(Graphics g) {
        Point[] pTop = this.getHeadFootLine(4);
        Point[] pBottom = this.getHeadFootLine(5);
        boolean bTop = false;
        boolean bBottom = false;
        switch (this.dot) {
            case 5: {
                bBottom = true;
                break;
            }
            case 4: {
                bTop = true;
            }
        }
        this.drawLine(g, pTop, bTop);
        this.drawLine(g, pBottom, bBottom);
    }

    private void drawLine(Graphics g, Point[] p, boolean isActived) {
        if (p == null) {
            return;
        }
        if (isActived) {
            g.setColor(ActivedColor);
        } else {
            g.setColor(ValidateColor);
        }
        g.drawLine(p[0].x, p[0].y, p[1].x, p[1].y);
    }

    private Point[] getHeadFootLine(int type) {
        if (this.headFootInfo == null) {
            return null;
        }
        int x0 = 0;
        int y0 = 0;
        int x1 = 0;
        int y1 = 0;
        int left = 0;
        int right = 0;
        if (this.pageContentArea != null) {
            left = this.scaleTo(KDPrinterUtils.inchToPoint(this.pageContentArea.getLeft(25400), 72));
            right = this.scaleTo(KDPrinterUtils.inchToPoint(this.pageContentArea.getRight(25400), 72));
        }
        if (type == 5) {
            int bottom = this.scaleTo(KDPrinterUtils.inchToPoint(this.headFootInfo.getFootBottom(25400), 72));
            x0 = this.rect.x + left;
            y0 = this.rect.y + this.rect.height - bottom;
            x1 = this.rect.x + this.rect.width - right;
            y1 = y0;
        } else if (type == 4) {
            int top = this.scaleTo(KDPrinterUtils.inchToPoint(this.headFootInfo.getHeadTop(25400), 72));
            x0 = this.rect.x + left;
            y0 = this.rect.y + top;
            x1 = this.rect.x + this.rect.width - right;
            y1 = y0;
        }
        return new Point[]{new Point(x0, y0), new Point(x1, y1)};
    }

    private Point[] getPageContentLine(int type) {
        if (this.pageContentArea == null) {
            return null;
        }
        int x0 = 0;
        int y0 = 0;
        int x1 = 0;
        int y1 = 0;
        if (type == 2) {
            int bottom = this.scaleTo(KDPrinterUtils.inchToPoint(this.pageContentArea.getBottom(25400), 72));
            x0 = this.rect.x;
            y0 = this.rect.y + this.rect.height - bottom;
            x1 = this.rect.x + this.rect.width - 1;
            y1 = y0;
        } else if (type == 1) {
            int left = this.scaleTo(KDPrinterUtils.inchToPoint(this.pageContentArea.getLeft(25400), 72));
            x0 = this.rect.x + left;
            y0 = this.rect.y;
            x1 = x0;
            y1 = this.rect.y + this.rect.height;
        } else if (type == 3) {
            int right = this.scaleTo(KDPrinterUtils.inchToPoint(this.pageContentArea.getRight(25400), 72));
            x0 = this.rect.x + this.rect.width - right;
            y0 = this.rect.y;
            x1 = x0;
            y1 = this.rect.y + this.rect.height;
        } else if (type == 0) {
            int top = this.scaleTo(KDPrinterUtils.inchToPoint(this.pageContentArea.getTop(25400), 72));
            x0 = this.rect.x;
            y0 = this.rect.y + top;
            x1 = this.rect.x + this.rect.width;
            y1 = this.rect.y + top;
        }
        return new Point[]{new Point(x0, y0), new Point(x1, y1)};
    }

    private int scaleTo(int val) {
        return (int)((double)((float)val * this.scale) + 0.5);
    }

    public void setOrientation(int orien) {
        if (this.orientation != orien) {
            this.orientation = orien;
            this.updateRect();
            this.repaint();
        }
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        KDFrame mainFrame = new KDFrame(CtrlPrintMessages.getMLS("preview.EditButtons.delete", "\u7ebf\u6761\u6d4b\u8bd5"));
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setSize(new Dimension(400, 300));
        KDPanel conPane = new KDPanel();
        mainFrame.setContentPane((Container)conPane);
        conPane.setLayout(null);
        ContentHeadFootPreview p = new ContentHeadFootPreview();
        p.setActivedDot((short)0);
        p.setBounds(15, 15, 100, 100);
        PageIntervalInfo pageContent = new PageIntervalInfo(8.0f, 4.0f, 8.0f, 4.0f, 1000);
        p.setPageContentInfo(pageContent);
        HeadFootIntervalInfo hfInfo = new HeadFootIntervalInfo(3.0f, 3.0f, 1000);
        p.setHeadFootInfo(hfInfo);
        p.setActivedDot((short)5);
        conPane.add((Component)((Object)p));
        mainFrame.show();
    }

    public int getCenterAling() {
        return this.centerAling;
    }

    public void setcenterAling(int centerAling) {
        this.centerAling = centerAling;
        this.repaint();
    }
}

