/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.config.ui;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlPrintMessages;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.cosmic.ctrl.print.ui.component.HeaderFooter;
import com.kingdee.cosmic.ctrl.print.ui.component.PainterInfo;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDLayout;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.BorderFactory;

public class HeadFootPreviewPane
extends KDPanel {
    private static final long serialVersionUID = -1848351303283532039L;
    private HeadFootModel headModel;
    private HeadFootModel footModel;
    private PainterInfo painterInfo;

    public HeadFootPreviewPane() {
        this.installComponents();
        this.setBackground(new Color(0xD9D9D0));
    }

    private void installComponents() {
        HeaderPane panPreviewHead = new HeaderPane();
        FooterPane panPreviewFoot = new FooterPane();
        KDLabel labHead = new KDLabel(this.getMLS("head", ""));
        KDLabel labFoot = new KDLabel(this.getMLS("foot", ""));
        KDScrollPane scpHead = new KDScrollPane((Component)((Object)panPreviewHead));
        KDScrollPane scpFoot = new KDScrollPane((Component)((Object)panPreviewFoot));
        scpHead.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        scpFoot.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        scpHead.setOpaque(false);
        scpFoot.setOpaque(false);
        scpHead.getViewport().setOpaque(false);
        scpFoot.getViewport().setOpaque(false);
        this.add((Component)labHead);
        this.add((Component)scpHead);
        this.add((Component)labFoot);
        this.add((Component)scpFoot);
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, 620, 220));
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 0, 600, 20);
        cons.anchor = 13;
        labHead.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 20, 600, 90);
        cons.anchor = 77;
        scpHead.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 110, 600, 90);
        cons.anchor = 46;
        scpFoot.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 200, 600, 20);
        cons.anchor = 14;
        labFoot.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
    }

    public void setFootModel(HeadFootModel model) {
        this.footModel = model;
    }

    public void setHeadModel(HeadFootModel model) {
        this.headModel = model;
    }

    private String getMLS(String key, String defaultValue) {
        return CtrlPrintMessages.getMLS(key, defaultValue);
    }

    public PainterInfo getPainterInfo() {
        return this.painterInfo;
    }

    public void setPainterInfo(PainterInfo painterInfo) {
        this.painterInfo = painterInfo;
    }

    private class FooterPane
    extends KDPanel {
        private static final long serialVersionUID = -6042261185423785490L;
        private HeaderFooter footer = new HeaderFooter();

        public FooterPane() {
            this.setBackground(Color.WHITE);
            int height = 200;
            this.setPreferredSize(new Dimension(570, height));
            this.footer.setPainterBounds(0.0f, 0.0f, 570.0f, height);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.footer.setModel(HeadFootPreviewPane.this.footModel);
            this.footer.painting(g, HeadFootPreviewPane.this.getPainterInfo());
        }
    }

    private class HeaderPane
    extends KDPanel {
        private static final long serialVersionUID = -8452990488109761828L;
        private HeaderFooter header = new HeaderFooter();

        public HeaderPane() {
            this.setBackground(Color.WHITE);
            int height = 200;
            this.setPreferredSize(new Dimension(570, height));
            this.header.setPainterBounds(0.0f, 0.0f, 570.0f, height);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.header.setModel(HeadFootPreviewPane.this.headModel);
            this.header.painting(g, HeadFootPreviewPane.this.getPainterInfo());
        }
    }
}

