/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.config.ui;

import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.print.PropertyConfig;
import com.kingdee.cosmic.ctrl.print.config.IConfigModel;
import com.kingdee.cosmic.ctrl.print.config.IXmlTranslate;
import com.kingdee.cosmic.ctrl.print.config.ui.AbstractConfigModel;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class PaperAdjustModel
extends AbstractConfigModel {
    Map adjustContent = new HashMap();
    public static String REPLACER = "!!";

    public PaperAdjustModel() {
        String config = PropertyConfig.getPaper_Adjust();
        this.load(config);
    }

    private void load(String config) {
        this.adjustContent.clear();
        if (config != null && !config.equals("")) {
            StringTokenizer st = new StringTokenizer(config, ":");
            while (st.hasMoreTokens()) {
                String oneConfig = st.nextToken();
                StringTokenizer stOne = new StringTokenizer(oneConfig, ",");
                String key = stOne.nextToken();
                float x = Float.parseFloat(stOne.nextToken());
                float y = Float.parseFloat(stOne.nextToken());
                float z = stOne.hasMoreTokens() ? Float.parseFloat(stOne.nextToken()) : 0.0f;
                key = key.replaceAll(REPLACER, ":");
                this.adjustContent.put(key, new float[]{x, y, z});
            }
        }
    }

    public void save() {
        PropertyConfig.setPaper_Adjust(this.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.adjustContent.entrySet()) {
            String printer = (String)entry.getKey();
            float[] values = (float[])entry.getValue();
            float x = values[0];
            float y = values[1];
            float z = values[2];
            if (ArrayUtil.isEqual((Float)Float.valueOf(y), (Float)Float.valueOf(0.0f)) && ArrayUtil.isEqual((Float)Float.valueOf(z), (Float)Float.valueOf(0.0f))) continue;
            printer = printer.replaceAll(":", REPLACER);
            sb.append(printer).append(',').append(x).append(',').append(y).append(',').append(z);
            sb.append(':');
        }
        return sb.toString();
    }

    @Override
    public Object clone() {
        return "";
    }

    @Override
    public IXmlTranslate createXmlTrans() {
        return null;
    }

    @Override
    public void setDefault() {
    }

    @Override
    public void set(IConfigModel from) {
    }

    public float[] getAdjustValues(String item) {
        Object value = this.adjustContent.get(item);
        if (value == null) {
            value = new float[]{1.0f, 0.0f, 0.0f};
        }
        return (float[])value;
    }

    public boolean isEnableAdjust(String item) {
        float[] values = (float[])this.adjustContent.get(item);
        if (values == null) {
            return false;
        }
        return ArrayUtil.isEqual((Float)Float.valueOf(values[2]), (Float)Float.valueOf(1.0f));
    }

    public Map getAdjustContent() {
        return this.adjustContent;
    }

    public void setAdjustContent(Map content) {
        this.adjustContent = content;
    }
}

