/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.config.ui;

import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.print.ConfigManager;
import com.kingdee.cosmic.ctrl.print.config.IConfigModel;
import com.kingdee.cosmic.ctrl.print.config.PrintJobConfig;
import com.kingdee.cosmic.ctrl.print.config.ui.AbstractConfigUI;
import com.kingdee.cosmic.ctrl.print.config.ui.PaperAdjustModel;
import com.kingdee.cosmic.ctrl.print.config.ui.SunPrintConfigDialog;
import com.kingdee.cosmic.ctrl.print.resource.Resources;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDFormattedTextField;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDSpinner;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.print.PrintService;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PaperAdjustUI
extends AbstractConfigUI {
    private static final Logger logger = LogUtil.getPackageLogger(PaperAdjustUI.class);
    private static final long serialVersionUID = 1164290774146673956L;
    private static final int PAGE_W = 410;
    private static final int GAP = 5;
    PrintServicePanel ps;
    private PrintService[] services;
    private int defaultServiceIndex = 0;
    protected ConfigManager printermanager;
    Map adjustContent;

    @Override
    public void init(PrintJobConfig manager, String uniqueName) {
        this.setManager(manager.getPrinter().getPrintConfig());
        super.init(manager, uniqueName);
        this.initPanel();
    }

    public void setManager(ConfigManager manager) {
        this.printermanager = manager;
        this.defaultServiceIndex = manager.getModel().getPrintServiceIndex();
        this.config = manager.getAdjustor();
    }

    protected void initPanel() {
        this.services = this.printermanager.getModel().getPrintServices();
        this.setLayout(null);
        this.ps = new PrintServicePanel();
        this.add((Component)((Object)this.ps));
        int x = 5;
        int y = 5;
        int h = this.ps.getPreferredSize().height;
        int w = 400;
        this.ps.setBounds(x, y, w, h);
        JTextArea lblRangeTo = new JTextArea(17, 17);
        JScrollPane explainTextPane = new JScrollPane(lblRangeTo);
        lblRangeTo.setEditable(false);
        lblRangeTo.setText(PaperAdjustUI.getMsg("label.paperAdjustExplain"));
        lblRangeTo.setOpaque(false);
        lblRangeTo.setLineWrap(true);
        lblRangeTo.setWrapStyleWord(true);
        lblRangeTo.setBorder(null);
        explainTextPane.setBounds(x + 5, y + h + 10, w, 200);
        explainTextPane.setVerticalScrollBarPolicy(20);
        this.add(explainTextPane);
        this.setPreferredSize(new Dimension(425, 350));
    }

    @Override
    public IConfigModel createConfigModel() {
        return null;
    }

    @Override
    public void updateConfigToUI() {
        PaperAdjustModel model = (PaperAdjustModel)this.config;
        Map ac = model.getAdjustContent();
        this.adjustContent = new HashMap(ac.size());
        for (Map.Entry entry : ac.entrySet()) {
            float[] values = (float[])entry.getValue();
            this.adjustContent.put(entry.getKey(), values);
        }
        this.ps.updateInfo();
    }

    @Override
    public void approve() {
        PaperAdjustModel model = (PaperAdjustModel)this.config;
        model.setAdjustContent(this.adjustContent);
        model.save();
    }

    private static String getMsg(String key) {
        return Resources.getMsg(key);
    }

    static /* synthetic */ PrintService[] access$102(PaperAdjustUI x0, PrintService[] x1) {
        x0.services = x1;
        return x1;
    }

    public class PrintServicePanel
    extends KDPanel
    implements ItemListener,
    FocusListener,
    ChangeListener {
        private static final long serialVersionUID = -6930652844850698265L;
        private KDComboBox cbName;
        KDSpinner perPaper = new KDSpinner((SpinnerModel)new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        KDFormattedTextField scrollMM = new KDFormattedTextField();
        KDCheckBox cbPaper = new KDCheckBox(PaperAdjustUI.access$000("paper.newtext"));

        public PrintServicePanel() {
            this.setOpaque(false);
            this.setLayout(null);
            this.setBorder(BorderFactory.createTitledBorder(PaperAdjustUI.getMsg("tree.stylusPrinterAdujust")));
            PaperAdjustUI.access$102(PaperAdjustUI.this, PaperAdjustUI.this.printermanager.getModel().getPrintServices());
            Object[] psnames = new String[PaperAdjustUI.this.services.length];
            for (int i = 0; i < psnames.length; ++i) {
                psnames[i] = PaperAdjustUI.this.services[i].getName();
            }
            this.cbName = new KDComboBox(psnames);
            if (psnames.length > PaperAdjustUI.this.defaultServiceIndex) {
                this.cbName.setSelectedIndex(PaperAdjustUI.this.defaultServiceIndex);
            }
            this.cbName.addItemListener((ItemListener)this);
            this.perPaper.addChangeListener((ChangeListener)this);
            this.scrollMM.setDataType(4);
            this.scrollMM.setNumberValue((Number)new Float(0.0f));
            this.scrollMM.setPrecision(1);
            this.scrollMM.addFocusListener((FocusListener)this);
            this.cbPaper.addChangeListener((ChangeListener)this);
            String str = PaperAdjustUI.getMsg("label.printer");
            SunPrintConfigDialog.LinedLabel l1 = SunPrintConfigDialog.L(str, (JComponent)this.cbName);
            SunPrintConfigDialog.LinedLabel l2 = SunPrintConfigDialog.L(PaperAdjustUI.getMsg("label.perPaper"), (JComponent)this.perPaper);
            SunPrintConfigDialog.LinedLabel l3 = SunPrintConfigDialog.L(PaperAdjustUI.getMsg("label.scrollLength"), (JComponent)this.scrollMM);
            int height = (int)l1.getPreferredSize().getHeight();
            this.add((Component)((Object)l1));
            this.add((Component)((Object)l2));
            this.add((Component)((Object)l3));
            KDLabel label = new KDLabel("(" + PaperAdjustUI.getMsg("label.unit_mm") + ")");
            this.add((Component)label);
            int y = 25;
            l1.setBounds(10, y, 350, 20);
            y = y + height + 5;
            l2.setBounds(10, y, 150, 20);
            y = y + height + 5;
            l3.setBounds(10, y, 180, 20);
            label.setBounds(200, y, 150, 20);
            this.add((Component)this.cbPaper);
            y = y + height + 5;
            this.cbPaper.setBounds(10, y, 350, 20);
            this.setPreferredSize(new Dimension(225, 135));
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.updateInfo();
        }

        public void updateInfo() {
            String item = (String)this.cbName.getSelectedItem();
            if (item != null) {
                float[] values = (float[])PaperAdjustUI.this.adjustContent.get(item);
                if (values == null) {
                    values = new float[]{1.0f, 0.0f, 0.0f};
                    PaperAdjustUI.this.adjustContent.put(item, values);
                }
                this.perPaper.removeChangeListener((ChangeListener)this);
                this.cbPaper.removeChangeListener((ChangeListener)this);
                this.perPaper.setValue((Object)((int)values[0]));
                this.scrollMM.setValue((Object)Float.valueOf(values[1]));
                this.cbPaper.setSelected(ArrayUtil.isEqual((Float)Float.valueOf(values[2]), (Float)Float.valueOf(1.0f)));
                this.perPaper.addChangeListener((ChangeListener)this);
                this.cbPaper.addChangeListener((ChangeListener)this);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.save();
        }

        public void save() {
            String item = (String)this.cbName.getSelectedItem();
            if (item != null) {
                int pValue = ((Number)this.perPaper.getValue()).intValue();
                try {
                    this.scrollMM.commitEdit();
                }
                catch (ParseException e) {
                    logger.error((Object)"err", (Throwable)e);
                }
                float sValue = this.scrollMM.getNumberValue().floatValue();
                float z = this.cbPaper.isSelected() ? 1.0f : 0.0f;
                float[] values = new float[]{pValue, sValue, z};
                PaperAdjustUI.this.adjustContent.put(item, values);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.save();
        }
    }
}

