/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.config.ui;

import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.StyleDesigner;
import com.kingdee.cosmic.ctrl.print.config.PrintJobConfig;
import com.kingdee.cosmic.ctrl.print.config.attribute.FreeMediaSize;
import com.kingdee.cosmic.ctrl.print.config.attribute.HeadFootIntervalInfo;
import com.kingdee.cosmic.ctrl.print.config.attribute.MediaSizeNameExtend;
import com.kingdee.cosmic.ctrl.print.config.attribute.PageIntervalInfo;
import com.kingdee.cosmic.ctrl.print.config.attribute.ZoomScaleInfo;
import com.kingdee.cosmic.ctrl.print.config.ui.ContentHeadFootPreview;
import com.kingdee.cosmic.ctrl.print.config.ui.PageSetupModel;
import com.kingdee.cosmic.ctrl.print.resource.Resources;
import com.kingdee.cosmic.ctrl.print.resource.Resources2;
import com.kingdee.cosmic.ctrl.print.ui.component.MixVariantLabelCell;
import com.kingdee.cosmic.ctrl.print.util.KDPrinterUtils;
import com.kingdee.cosmic.ctrl.print.util.MediaUtil;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDComboColor;
import com.kingdee.cosmic.ctrl.swing.KDFormattedTextField;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDNumberTextField;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.KDSpinner;
import com.kingdee.cosmic.ctrl.swing.KDTabbedPane;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.event.ComboColorSelectedEvent;
import com.kingdee.cosmic.ctrl.swing.event.ComboColorSelectedListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;
import org.apache.log4j.Logger;
import sun.print.SunAlternateMedia;

public class SunPrintConfigDialog {
    private static final Logger log = LogUtil.getLogger(SunPrintConfigDialog.class);
    public static final int PAGE_W = 405;
    public static final int PAGE_H = 304;
    public static final int TAB_W = 407;
    public static final int GAP = 5;
    public static final int SPACE = 3;
    public static final int CONFIG_COMPONENT_HEIGHT = 350;
    public static final int CONFIG_COMPONENT_WIDTH = 407;
    public static final int WAITING = 0;
    public static final int APPROVE = 1;
    public static final int CANCEL = 2;
    private KDTabbedPane tpTabs;
    private HashPrintRequestAttributeSet asCurrent;
    private PrintService psCurrent;
    private DocFlavor docFlavor;
    private boolean isFrugalPrint = false;
    private boolean mediaSizeChange = false;
    private MixVariantLabelCell waterMark = new MixVariantLabelCell();
    private boolean isWaterMarkOnlyFirstPage = false;
    private Color backGroundColor;
    private Image backGroundImage;
    private String backGroundUrl;
    private byte backGroundImageFillMode = 0;
    private int centerAlign = 0;
    private int footerAlign = 0;
    private int headerAlign = 0;
    private PageSetupPanel pnlPageSetup;
    private PageMarginPanel pnlPageMargin;
    private EffectPanel pnlEffect;
    private PageSetupModel model;
    private static final String[] staticItems = new String[]{SunPrintConfigDialog.getMsg("label.backGroundFillMode_center"), SunPrintConfigDialog.getMsg("label.backGroundFillMode_tile"), SunPrintConfigDialog.getMsg("label.backGroundFillMode_fill")};
    private static final String[] staticAccepts = new String[]{"jpg", "jpeg", "gif", "png"};

    public SunPrintConfigDialog(GraphicsConfiguration gc, int x, int y, PrintService service, DocFlavor flavor, PageSetupModel model, PrintJobConfig config) {
        this.model = model;
        PrintRequestAttributeSet attributes = model.getPrintRequestAttributeSet();
        this.init(gc, x, y, service, flavor, attributes, config);
    }

    private void init(GraphicsConfiguration gc, int x, int y, PrintService service, DocFlavor flavor, PrintRequestAttributeSet attributes, PrintJobConfig config) {
        this.psCurrent = service;
        this.docFlavor = flavor;
        this.asCurrent = new HashPrintRequestAttributeSet(attributes);
        this.tpTabs = new KDTabbedPane();
        this.tpTabs.setPreferredSize(new Dimension(405, 304));
        String mkey = SunPrintConfigDialog.getMsg("tab.pagemargin");
        this.pnlPageMargin = new PageMarginPanel();
        String pkey = SunPrintConfigDialog.getMsg("tab.pagesetup");
        this.pnlPageSetup = new PageSetupPanel();
        this.tpTabs.add(pkey, (Component)((Object)this.pnlPageSetup));
        if (config.isPageMarginPanelVisible()) {
            this.tpTabs.add(mkey, (Component)((Object)this.pnlPageMargin));
        }
        this.pnlEffect = new EffectPanel();
        this.enableAutoFit(false, false);
        this.updatePanels();
    }

    public void revomePageMarginPanel() {
        this.tpTabs.remove((Component)((Object)this.pnlPageMargin));
    }

    public void enableAutoFit(boolean widthFit, boolean heightFit) {
        this.pnlPageSetup.pnlScale.enableAutoFit(widthFit, heightFit);
    }

    public void setAttributes(PrintRequestAttributeSet attributes) {
        this.asCurrent = new HashPrintRequestAttributeSet(attributes);
        this.updatePanels();
    }

    public boolean isFrugalPrint() {
        return this.isFrugalPrint;
    }

    public MixVariantLabelCell getWaterMark() {
        return this.waterMark;
    }

    public boolean isWaterMarkOnlyFirstPage() {
        return this.isWaterMarkOnlyFirstPage;
    }

    public Color getBackGroundColor() {
        return this.backGroundColor;
    }

    public Image getBackGroundImage() {
        return this.backGroundImage;
    }

    public String getBackGroundUrl() {
        return this.backGroundUrl;
    }

    public byte getBackGroundImageFillMode() {
        return this.backGroundImageFillMode;
    }

    public boolean isMediaSizeChange() {
        return this.mediaSizeChange;
    }

    public PrintRequestAttributeSet getAttributes() {
        return this.asCurrent;
    }

    public void updatePanels() {
        this.pnlPageSetup.updateInfo();
        this.pnlPageMargin.updateInfo();
        this.pnlEffect.updateInfo();
    }

    private static String getMsg(String key) {
        return Resources.getMsg(key);
    }

    private static URL getImageResource(String key) {
        URL url = SunPrintConfigDialog.class.getResource("resources/" + key);
        if (url == null) {
            throw new Error("Fatal: Resource for ServiceUI is broken; there is no " + key + " key in resource");
        }
        return url;
    }

    public static KDButton createButton(String key, ActionListener al) {
        KDButton btn = new KDButton(SunPrintConfigDialog.getMsg(key));
        btn.addActionListener(al);
        return btn;
    }

    public static KDCheckBox createCheckBox(String key, ActionListener al) {
        KDCheckBox cb = new KDCheckBox(SunPrintConfigDialog.getMsg(key));
        cb.addActionListener(al);
        return cb;
    }

    public static KDRadioButton createRadioButton(String key, ActionListener al) {
        KDRadioButton rb = new KDRadioButton(SunPrintConfigDialog.getMsg(key));
        rb.addActionListener(al);
        return rb;
    }

    public static void showNoPrintService(GraphicsConfiguration gc) {
        JOptionPane.showMessageDialog(new Frame(gc), SunPrintConfigDialog.getMsg("dialog.noprintermsg"));
    }

    public static void addToGB(Component comp, Container cont, GridBagLayout gridbag, GridBagConstraints constraints) {
        gridbag.setConstraints(comp, constraints);
        cont.add(comp);
    }

    public static void addToBG(AbstractButton button, Container cont, ButtonGroup bg) {
        bg.add(button);
        cont.add(button);
    }

    public KDTabbedPane getTabbedPane() {
        return this.tpTabs;
    }

    public static LinedLabel L(String t, JComponent c) {
        return new LinedLabel(t, c);
    }

    public void setPrintService(PrintService psCurrent2) {
        this.psCurrent = psCurrent2;
        this.pnlPageSetup.updateInfo();
    }

    public int getCenterAlign() {
        return this.centerAlign;
    }

    public int getFooterAlign() {
        return this.footerAlign;
    }

    public int getHeaderAlign() {
        return this.headerAlign;
    }

    public void setCenterAlign(int centerAlign) {
        this.centerAlign = centerAlign;
    }

    public float getPageAdjustX() {
        return this.model.getPageAdjustX();
    }

    public float getPageAdjustY() {
        return this.model.getPageAdjustX();
    }

    public static class FixedPanel
    extends KDPanel {
        private static final long serialVersionUID = -9209541515076756181L;

        public FixedPanel() {
            this.setOpaque(false);
            this.setLayout(new FlowLayout(0, 3, 0));
        }
    }

    public static class LineLayout
    implements LayoutManager {
        private static final int INSET_ADJUST = 4;
        public static final LineLayout LIGHTWEIGHT = new LineLayout();
        public int gap = 5;

        public void setGap(int gap) {
            this.gap = gap;
        }

        @Override
        public void layoutContainer(Container p) {
            JComponent child;
            JComponent parent = (JComponent)p;
            Insets insets = parent.getInsets();
            int temp = 0;
            int count = parent.getComponentCount();
            int w = parent.getWidth() - this.gap * 2 - insets.left - insets.right + 4;
            int h = parent.getHeight() - this.gap * 2 - insets.top - insets.bottom + 4;
            int y = insets.top - 4 + this.gap;
            for (int i = 0; i < count; ++i) {
                child = (JComponent)parent.getComponent(i);
                temp += child.getPreferredSize().height;
            }
            int space = 0;
            if (count <= 0) {
                return;
            }
            if (count == 1) {
                space = h - temp;
                y += space / 2;
            } else {
                space = (h - temp) / (count - 1);
                if (space > 3) {
                    space = (h - temp) / count;
                    y += space / 2;
                }
            }
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    y += space;
                }
                child = (JComponent)parent.getComponent(i);
                temp = child.getPreferredSize().height;
                child.setBounds(5 + insets.left - 2, y, w, temp);
                y += temp;
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int count = parent.getComponentCount();
            Insets insets = parent.getInsets();
            int h = insets.top + insets.bottom - 4;
            int w = 0;
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    h += 3;
                }
                Dimension psize = parent.getComponent(i).getPreferredSize();
                h += psize.height;
                w = w < psize.width ? psize.width : w;
            }
            return new Dimension(w += 10, h += 10);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    public static class LinedLabel
    extends KDLabelContainer {
        private static final long serialVersionUID = 2749262831083606284L;

        private LinedLabel(String labelText, JComponent editor) {
            super(LinedLabel.Normalize(labelText, editor), editor);
            if (!(editor instanceof JLabel)) {
                this.setBoundLabelUnderline(true);
            }
        }

        private static String Normalize(String realtext, JComponent editor) {
            if (!(editor instanceof JLabel)) {
                return realtext.replace('\uff1a', ' ') + "  ";
            }
            return realtext.replace('\uff1a', ':') + "  ";
        }
    }

    private static class IconRadioButton
    extends JPanel {
        private static final long serialVersionUID = 887059568416033077L;
        private KDRadioButton rb;
        private JLabel lbl;

        public IconRadioButton(String key, String img, boolean selected, ButtonGroup bg, ActionListener al) {
            super(new FlowLayout(3));
            this.setOpaque(false);
            ImageIcon icon = new ImageIcon(SunPrintConfigDialog.getImageResource(img));
            this.lbl = new JLabel(icon);
            this.add(this.lbl);
            this.rb = SunPrintConfigDialog.createRadioButton(key, al);
            this.rb.setSelected(selected);
            SunPrintConfigDialog.addToBG((AbstractButton)this.rb, this, bg);
        }

        public void addActionListener(ActionListener al) {
            this.rb.addActionListener(al);
        }

        public boolean isSameAs(Object source) {
            return this.rb == source;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.rb.setEnabled(enabled);
            this.lbl.setEnabled(enabled);
        }

        public boolean isSelected() {
            return this.rb.isSelected();
        }

        public void setSelected(boolean selected) {
            this.rb.setSelected(selected);
        }
    }

    private class EffectPanel
    extends KDPanel
    implements ActionListener,
    ItemListener,
    KeyListener,
    ComboColorSelectedListener {
        private static final long serialVersionUID = -1795630729262788645L;
        KDComboBox cbwarterMark;
        KDCheckBox cbOnlyFirstPage;
        KDWorkButton cbEdit;
        KDComboColor colorChooser;
        KDWorkButton backGround;
        KDComboBox cbFillMode;
        KDWorkButton cbDelete;
        String waterMarktitle = SunPrintConfigDialog.access$200("border.watermark");

        public EffectPanel() {
            this.setLayout(null);
            JPanel pnlWaterMark = this.createWaterMarkPanel();
            JPanel pnlBackGround = this.createBackGroundPanel();
            this.add(pnlWaterMark);
            this.add(pnlBackGround);
            int x = 5;
            int y = 5;
            pnlWaterMark.setBounds(x, y, 200, 100);
            pnlBackGround.setBounds(x, y + 100 + 5, 200, 155);
        }

        public JPanel createWaterMarkPanel() {
            JPanel waterMarkPanel = this.createPanel(this.waterMarktitle);
            this.cbwarterMark = new KDComboBox();
            this.cbwarterMark.setEditable(true);
            this.cbwarterMark.getEditor().getEditorComponent().addKeyListener(this);
            this.cbOnlyFirstPage = SunPrintConfigDialog.createCheckBox("label.onlyFirstPage", this);
            this.cbEdit = new KDWorkButton(SunPrintConfigDialog.getMsg("button.style") + "...");
            this.cbwarterMark.addItemListener((ItemListener)this);
            Object[] items = new String[]{" " + SunPrintConfigDialog.getMsg("label.nothing") + " ", SunPrintConfigDialog.getMsg("comobox.watermark0"), SunPrintConfigDialog.getMsg("comobox.watermark1"), SunPrintConfigDialog.getMsg("comobox.watermark2"), "&[Date]", "&[Time]"};
            this.cbwarterMark.addItems(items);
            this.cbOnlyFirstPage.setEnabled(false);
            KDPanel fixPanel = new KDPanel();
            fixPanel.setOpaque(false);
            fixPanel.setLayout(new FlowLayout(2, 3, 0));
            this.cbEdit.setEnabled(false);
            this.cbEdit.addActionListener((ActionListener)this);
            fixPanel.add((Component)this.cbEdit);
            waterMarkPanel.add((Component)this.cbwarterMark);
            waterMarkPanel.add((Component)this.cbOnlyFirstPage);
            waterMarkPanel.add((Component)fixPanel);
            return waterMarkPanel;
        }

        public JPanel createBackGroundPanel() {
            String title = SunPrintConfigDialog.getMsg("border.background");
            JPanel backGroundPanel = this.createPanel(title);
            this.colorChooser = new KDComboColor();
            this.colorChooser.addSelectedListener((ComboColorSelectedListener)this);
            this.colorChooser.setDefaultColor(KDComboColor.TRANSPARENTCOLOR);
            this.colorChooser.setDefaultColorPrompt(SunPrintConfigDialog.getMsg("color.transparence"));
            LinedLabel ll = SunPrintConfigDialog.L(SunPrintConfigDialog.getMsg("label.backgroundColor"), (JComponent)this.colorChooser);
            backGroundPanel.add((Component)((Object)ll));
            this.backGround = new KDWorkButton(SunPrintConfigDialog.getMsg("label.comefromFile") + "...");
            this.backGround.addActionListener((ActionListener)this);
            LinedLabel ll2 = SunPrintConfigDialog.L(SunPrintConfigDialog.getMsg("label.background"), (JComponent)this.backGround);
            backGroundPanel.add((Component)((Object)ll2));
            this.cbFillMode = new KDComboBox();
            this.cbFillMode.setEnabled(false);
            this.cbFillMode.addItemListener((ItemListener)this);
            Object[] items = staticItems;
            this.cbFillMode.addItems(items);
            LinedLabel ll3 = SunPrintConfigDialog.L(SunPrintConfigDialog.getMsg("label.backgroundfillmode"), (JComponent)this.cbFillMode);
            backGroundPanel.add((Component)((Object)ll3));
            KDPanel fixPanel = new KDPanel();
            fixPanel.setOpaque(false);
            fixPanel.setLayout(new FlowLayout(2, 3, 0));
            this.cbDelete = new KDWorkButton(SunPrintConfigDialog.getMsg("button.clearBackGround"));
            this.cbDelete.setEnabled(false);
            this.cbDelete.addActionListener((ActionListener)this);
            fixPanel.add((Component)this.cbDelete);
            backGroundPanel.add((Component)fixPanel);
            return backGroundPanel;
        }

        public JPanel createPanel(String title) {
            KDPanel panel = new KDPanel();
            panel.setOpaque(false);
            panel.setLayout(LineLayout.LIGHTWEIGHT);
            panel.setBorder(BorderFactory.createTitledBorder(title));
            return panel;
        }

        public void updateInfo() {
            String text = SunPrintConfigDialog.this.model.getWaterMark().getText();
            SunPrintConfigDialog.this.waterMark.setText(text);
            SunPrintConfigDialog.this.waterMark.setStyle(SunPrintConfigDialog.this.model.getWaterMark().getStyle());
            if (text == null) {
                this.cbwarterMark.setSelectedIndex(0);
            } else {
                boolean isFound = false;
                int count = this.cbwarterMark.getItemCount();
                for (int i = 0; i < count; ++i) {
                    Object item = this.cbwarterMark.getItemAt(i);
                    if (!item.equals(text)) continue;
                    this.cbwarterMark.setSelectedIndex(i);
                    isFound = true;
                    break;
                }
                if (!isFound) {
                    this.cbwarterMark.addItem((Object)text);
                    this.cbwarterMark.setSelectedIndex(count);
                }
            }
            SunPrintConfigDialog.this.isWaterMarkOnlyFirstPage = SunPrintConfigDialog.this.model.isWaterMark_onlyFirstPage();
            this.cbOnlyFirstPage.setSelected(SunPrintConfigDialog.this.isWaterMarkOnlyFirstPage);
            SunPrintConfigDialog.this.backGroundColor = SunPrintConfigDialog.this.model.getBackGroundColor();
            this.colorChooser.setColor(SunPrintConfigDialog.this.backGroundColor);
            SunPrintConfigDialog.this.backGroundImage = SunPrintConfigDialog.this.model.getBackGround();
            SunPrintConfigDialog.this.backGroundImageFillMode = SunPrintConfigDialog.this.model.getBackGroundFillMode();
            this.cbFillMode.setSelectedIndex((int)SunPrintConfigDialog.this.model.getBackGroundFillMode());
            if (SunPrintConfigDialog.this.backGroundImage != null) {
                this.cbFillMode.setEnabled(true);
                this.cbDelete.setEnabled(true);
            } else {
                this.cbFillMode.setEnabled(false);
                this.cbDelete.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.cbOnlyFirstPage) {
                if (this.cbOnlyFirstPage.isSelected()) {
                    SunPrintConfigDialog.this.isWaterMarkOnlyFirstPage = true;
                } else {
                    SunPrintConfigDialog.this.isWaterMarkOnlyFirstPage = false;
                }
            } else if (source == this.cbEdit) {
                Frame f = JOptionPane.getFrameForComponent((Component)((Object)this));
                StyleDesigner sd = new StyleDesigner(f, true);
                int showPanel = 3;
                sd.setShowPanel(showPanel);
                sd.getPanAlignment().setTextConrolEnable(false);
                sd.getPanAlignment().setAlignEnable(false);
                sd.setSA(Styles.getSA((ShareStyleAttributes)SunPrintConfigDialog.this.waterMark.getStyle()));
                sd.setTitle(this.waterMarktitle);
                sd.setLocationRelativeTo(null);
                sd.show();
                if (sd.isChanged()) {
                    SunPrintConfigDialog.this.waterMark.setStyle(Styles.getStyle((ShareStyleAttributes)sd.getSA()));
                }
                sd.dispose();
            } else if (source == this.backGround) {
                String[] accepts = staticAccepts;
                File file = KDPrinterUtils.openFileChooser((JComponent)((Object)this), accepts);
                SunPrintConfigDialog.this.backGroundImage = KDPrinterUtils.createImageFromFile((Component)((Object)this), file);
                if (SunPrintConfigDialog.this.backGroundImage != null) {
                    SunPrintConfigDialog.this.backGroundUrl = file.getPath();
                    SunPrintConfigDialog.this.model.setImagePath(SunPrintConfigDialog.this.backGroundUrl);
                    this.cbFillMode.setEnabled(true);
                    this.cbDelete.setEnabled(true);
                } else {
                    SunPrintConfigDialog.this.backGroundUrl = null;
                    SunPrintConfigDialog.this.model.setImagePath(SunPrintConfigDialog.this.backGroundUrl);
                    this.cbFillMode.setEnabled(false);
                    this.cbDelete.setEnabled(false);
                }
            } else if (source == this.cbDelete) {
                SunPrintConfigDialog.this.model.setImagePath(null);
                SunPrintConfigDialog.this.backGroundImage = null;
                SunPrintConfigDialog.this.backGroundUrl = null;
                this.cbFillMode.setEnabled(false);
                this.cbDelete.setEnabled(false);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (source == this.cbwarterMark) {
                if (this.cbwarterMark.getSelectedIndex() != 0) {
                    SunPrintConfigDialog.this.waterMark.setText((String)this.cbwarterMark.getSelectedItem());
                    this.cbOnlyFirstPage.setEnabled(true);
                    this.cbEdit.setEnabled(true);
                } else {
                    SunPrintConfigDialog.this.waterMark.setText(null);
                    this.cbOnlyFirstPage.setEnabled(false);
                    this.cbEdit.setEnabled(false);
                }
            } else if (source == this.cbFillMode) {
                SunPrintConfigDialog.this.backGroundImageFillMode = (byte)this.cbFillMode.getSelectedIndex();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.cbOnlyFirstPage.setEnabled(true);
            this.cbEdit.setEnabled(true);
        }

        public void selected(ComboColorSelectedEvent evt) {
            SunPrintConfigDialog.this.backGroundColor = this.colorChooser.getColor();
        }
    }

    private class OrientationPanel
    extends KDPanel
    implements ActionListener {
        private static final long serialVersionUID = 4009109730838301635L;
        private IconRadioButton rbPortrait;
        private IconRadioButton rbLandscape;
        private IconRadioButton rbRevPortrait;
        private IconRadioButton rbRevLandscape;
        private PageMarginPanel pnlMargins = null;

        public OrientationPanel() {
            this.setOpaque(false);
            this.setLayout(LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(SunPrintConfigDialog.getMsg("border.orientation")));
            ButtonGroup bg = new ButtonGroup();
            this.rbPortrait = new IconRadioButton("radiobutton.portrait", "orientPortrait.gif", true, bg, this);
            this.rbPortrait.addActionListener(this);
            this.add(this.rbPortrait);
            this.rbLandscape = new IconRadioButton("radiobutton.landscape", "orientLandscape.gif", false, bg, this);
            this.rbLandscape.addActionListener(this);
            this.add(this.rbLandscape);
            this.rbRevPortrait = new IconRadioButton("radiobutton.revportrait", "orientRevPortrait.gif", false, bg, this);
            this.rbRevLandscape = new IconRadioButton("radiobutton.revlandscape", "orientRevLandscape.gif", false, bg, this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (this.rbPortrait.isSameAs(source)) {
                SunPrintConfigDialog.this.asCurrent.add(OrientationRequested.PORTRAIT);
            } else if (this.rbLandscape.isSameAs(source)) {
                SunPrintConfigDialog.this.asCurrent.add(OrientationRequested.LANDSCAPE);
            } else if (this.rbRevPortrait.isSameAs(source)) {
                SunPrintConfigDialog.this.asCurrent.add(OrientationRequested.REVERSE_PORTRAIT);
            } else if (this.rbRevLandscape.isSameAs(source)) {
                SunPrintConfigDialog.this.asCurrent.add(OrientationRequested.REVERSE_LANDSCAPE);
            }
            if (this.pnlMargins != null) {
                this.pnlMargins.updateInfo();
            }
        }

        void addOrientationListener(PageMarginPanel pnl) {
            this.pnlMargins = pnl;
        }

        public void updateInfo() {
            Class<OrientationRequested> orCategory = OrientationRequested.class;
            boolean pSupported = false;
            boolean lSupported = false;
            boolean rpSupported = false;
            boolean rlSupported = false;
            boolean isSupport = true;
            if (SunPrintConfigDialog.this.psCurrent != null) {
                isSupport = SunPrintConfigDialog.this.psCurrent.isAttributeCategorySupported(orCategory);
            }
            if (isSupport) {
                OrientationRequested[] ovalues = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE};
                for (int i = 0; i < ovalues.length; ++i) {
                    OrientationRequested value = ovalues[i];
                    if (value == OrientationRequested.PORTRAIT) {
                        pSupported = true;
                        continue;
                    }
                    if (value != OrientationRequested.LANDSCAPE) continue;
                    lSupported = true;
                }
            }
            this.rbPortrait.setEnabled(pSupported);
            this.rbLandscape.setEnabled(lSupported);
            this.rbRevPortrait.setEnabled(rpSupported);
            this.rbRevLandscape.setEnabled(rlSupported);
            OrientationRequested or = (OrientationRequested)SunPrintConfigDialog.this.asCurrent.get(orCategory);
            if (or == null) {
                or = OrientationRequested.PORTRAIT;
            }
            if (or == OrientationRequested.PORTRAIT) {
                this.rbPortrait.setSelected(true);
            } else if (or == OrientationRequested.LANDSCAPE) {
                this.rbLandscape.setSelected(true);
            } else if (or == OrientationRequested.REVERSE_PORTRAIT) {
                this.rbRevPortrait.setSelected(true);
            } else {
                this.rbRevLandscape.setSelected(true);
            }
        }
    }

    private class MediaPanel
    extends KDPanel
    implements ItemListener,
    FocusListener {
        private static final long serialVersionUID = 1799453169831783048L;
        private final String strTitle = SunPrintConfigDialog.access$200("border.media");
        private JLabel lblSize;
        private KDComboBox cbSize;
        private KDComboBox cbSource;
        LinedLabel widthTextField;
        LinedLabel heightTextField;
        private KDNumberTextField ntfWidth;
        private KDNumberTextField ntfHeight;
        private Vector sizes = new Vector();
        private Vector sources = new Vector();
        private MarginsPanel pnlMargins = null;

        public MediaPanel() {
            this.setOpaque(false);
            this.setLayout(LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            this.cbSize = new KDComboBox();
            this.cbSource = new KDComboBox();
            String str = SunPrintConfigDialog.getMsg("label.size");
            FixedPanel pnlTop = new FixedPanel();
            LinedLabel ll = SunPrintConfigDialog.L(str, (JComponent)this.cbSize);
            pnlTop.add((Component)((Object)ll));
            this.lblSize = ll.getBoundLabel();
            DecimalFormat format = new DecimalFormat("###");
            format.setMinimumFractionDigits(0);
            format.setMinimumIntegerDigits(1);
            format.setParseIntegerOnly(false);
            NumberFormatter nf = new NumberFormatter(format);
            nf.setMinimum(new Float(10.0f));
            nf.setMaximum(new Float(999.0f));
            nf.setAllowsInvalid(true);
            nf.setCommitsOnValidEdit(true);
            this.ntfWidth = new KDNumberTextField(4);
            this.ntfWidth.setEditFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.ntfWidth.setDisplayFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.ntfWidth.addFocusListener((FocusListener)this);
            this.ntfWidth.setNumberValue((Number)new Float(210.0f));
            this.ntfWidth.setColumns(3);
            this.widthTextField = SunPrintConfigDialog.L("   " + SunPrintConfigDialog.getMsg("label.width"), (JComponent)this.ntfWidth);
            this.widthTextField.setVisible(false);
            pnlTop.add((Component)((Object)this.widthTextField));
            this.ntfHeight = new KDNumberTextField(4);
            this.ntfHeight.setEditFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.ntfHeight.setDisplayFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.ntfHeight.addFocusListener((FocusListener)this);
            this.ntfHeight.setColumns(3);
            this.ntfHeight.setNumberValue((Number)new Float(297.0f));
            this.heightTextField = SunPrintConfigDialog.L(SunPrintConfigDialog.getMsg("label.height"), (JComponent)this.ntfHeight);
            this.heightTextField.setVisible(false);
            pnlTop.add((Component)((Object)this.heightTextField));
            this.add((Component)((Object)pnlTop));
            str = SunPrintConfigDialog.getMsg("label.source");
            ll = SunPrintConfigDialog.L(" " + str, (JComponent)this.cbSource);
            this.add((Component)((Object)ll));
        }

        private String getMediaName(String key) {
            try {
                String newkey = key.replace(' ', '-');
                newkey = newkey.replace('#', 'n');
                String value = SunPrintConfigDialog.getMsg(newkey);
                if ("".equals(value)) {
                    return key;
                }
                return value;
            }
            catch (MissingResourceException e) {
                return key;
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (e.getStateChange() == 1) {
                if (source == this.cbSize) {
                    int index = this.cbSize.getSelectedIndex();
                    if (index >= 0 && index < this.sizes.size()) {
                        Object obj;
                        MediaSizeName selectMedia;
                        if (this.cbSource.getItemCount() > 1 && this.cbSource.getSelectedIndex() >= 1) {
                            int src = this.cbSource.getSelectedIndex() - 1;
                            MediaTray mt = (MediaTray)this.sources.get(src);
                            SunPrintConfigDialog.this.asCurrent.add(new SunAlternateMedia(mt));
                        }
                        if ((selectMedia = (MediaSizeName)(obj = this.sizes.get(index))) instanceof MediaSizeNameExtend) {
                            MediaSize mediaCustom = MediaSize.getMediaSizeForName(selectMedia);
                            if (selectMedia == MediaSizeNameExtend.CUSTOM) {
                                this.widthTextField.setVisible(true);
                                this.heightTextField.setVisible(true);
                                if (mediaCustom == null) {
                                    BigDecimal w = this.ntfWidth.getBigDecimalValue();
                                    BigDecimal h = this.ntfHeight.getBigDecimalValue();
                                    new FreeMediaSize(w.floatValue(), h.floatValue(), 1000, selectMedia);
                                }
                            } else {
                                this.widthTextField.setVisible(false);
                                this.heightTextField.setVisible(false);
                            }
                            SunPrintConfigDialog.this.asCurrent.add(selectMedia);
                        } else {
                            this.widthTextField.setVisible(false);
                            this.heightTextField.setVisible(false);
                            SunPrintConfigDialog.this.asCurrent.add(selectMedia);
                        }
                    }
                } else if (source == this.cbSource) {
                    int index = this.cbSource.getSelectedIndex();
                    if (index >= 1 && index < this.sources.size() + 1) {
                        SunPrintConfigDialog.this.asCurrent.remove(SunAlternateMedia.class);
                        MediaTray mt = (MediaTray)this.sources.get(index - 1);
                        SunPrintConfigDialog.this.asCurrent.add(new SunAlternateMedia(mt));
                    } else if (index == 0) {
                        SunPrintConfigDialog.this.asCurrent.remove(SunAlternateMedia.class);
                        if (this.cbSize.getItemCount() > 0) {
                            int size = this.cbSize.getSelectedIndex();
                            SunPrintConfigDialog.this.asCurrent.add((MediaSizeName)this.sizes.get(size));
                        }
                    }
                }
                if (this.pnlMargins != null) {
                    this.pnlMargins.updateInfo();
                }
            }
        }

        public void addMediaListener(MarginsPanel pnl) {
            this.pnlMargins = pnl;
        }

        public void updateInfo() {
            Class<Media> mdCategory = Media.class;
            Class<SunAlternateMedia> amCategory = SunAlternateMedia.class;
            boolean mediaSupported = true;
            this.cbSize.removeItemListener((ItemListener)this);
            this.cbSize.removeAllItems();
            this.cbSource.removeItemListener((ItemListener)this);
            this.cbSource.removeAllItems();
            this.cbSource.addItem((Object)this.getMediaName("auto-select"));
            this.sizes.clear();
            this.sources.clear();
            Media[] media = null;
            if (SunPrintConfigDialog.this.psCurrent != null && SunPrintConfigDialog.this.psCurrent.isAttributeCategorySupported(mdCategory)) {
                Media medium;
                int i;
                mediaSupported = true;
                Object values = null;
                Object mediaTrays = null;
                try {
                    values = MediaUtil.getMediaByPrinter(SunPrintConfigDialog.this.psCurrent, SunPrintConfigDialog.this.docFlavor, SunPrintConfigDialog.this.asCurrent);
                    mediaTrays = SunPrintConfigDialog.this.psCurrent.getSupportedAttributeValues(mdCategory, SunPrintConfigDialog.this.docFlavor, SunPrintConfigDialog.this.asCurrent);
                }
                catch (Exception e) {
                    log.error((Object)"err", (Throwable)e);
                }
                if (mediaTrays instanceof Media[]) {
                    Media[] temp = (Media[])mediaTrays;
                    for (i = 0; i < temp.length; ++i) {
                        medium = temp[i];
                        if (!(medium instanceof MediaTray)) continue;
                        this.sources.add(medium);
                        this.cbSource.addItem((Object)this.getMediaName(medium.toString()));
                    }
                }
                if (values instanceof Media[]) {
                    media = (Media[])values;
                    for (int i2 = 0; i2 < media.length; ++i2) {
                        Media medium2 = media[i2];
                        if (medium2 instanceof MediaSizeName) {
                            this.sizes.add(medium2);
                            this.cbSize.addItem((Object)this.getMediaName(medium2.toString()));
                            continue;
                        }
                        if (!(medium2 instanceof MediaTray)) continue;
                        this.sources.add(medium2);
                        this.cbSource.addItem((Object)this.getMediaName(medium2.toString()));
                    }
                } else if (values == null) {
                    Media[] medias = new Media[]{MediaSizeName.ISO_A4, MediaSizeName.ISO_A3, MediaSizeName.ISO_A5, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5};
                    media = medias;
                    for (i = 0; i < media.length; ++i) {
                        medium = media[i];
                        this.sizes.add(medium);
                        this.cbSize.addItem((Object)this.getMediaName(medium.toString()));
                    }
                }
            } else {
                Media[] medias;
                media = medias = new Media[]{MediaSizeName.ISO_A4, MediaSizeName.ISO_A3, MediaSizeName.ISO_A5, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5};
                for (int i = 0; i < media.length; ++i) {
                    Media medium = media[i];
                    this.sizes.add(medium);
                    this.cbSize.addItem((Object)this.getMediaName(medium.toString()));
                }
            }
            MediaSizeNameExtend extend = MediaSizeNameExtend.CUSTOM;
            this.sizes.add(extend);
            this.cbSize.addItem((Object)this.getMediaName(extend.toString()));
            boolean msSupported = mediaSupported && this.sizes.size() > 0;
            this.lblSize.setEnabled(msSupported);
            this.cbSize.setEnabled(msSupported);
            this.cbSource.setEnabled(mediaSupported);
            if (mediaSupported) {
                Media md;
                Media medium = (Media)SunPrintConfigDialog.this.asCurrent.get(mdCategory);
                if (medium == null) {
                    if (SunPrintConfigDialog.this.psCurrent != null) {
                        medium = (Media)SunPrintConfigDialog.this.psCurrent.getDefaultAttributeValue(mdCategory);
                    }
                    if (medium == null && this.sizes.size() > 0) {
                        medium = (Media)this.sizes.get(0);
                    }
                }
                if (medium != null) {
                    if (medium instanceof MediaSizeNameExtend && null != media) {
                        MediaSize mediaCustom = MediaSize.getMediaSizeForName((MediaSizeName)medium);
                        for (int i = 0; i < media.length; ++i) {
                            Media med = media[i];
                            if (!(med instanceof MediaSizeName)) continue;
                            MediaSize win32Media = MediaSize.getMediaSizeForName((MediaSizeName)med);
                            boolean isEquale = false;
                            if (mediaCustom != null && win32Media != null) {
                                isEquale = MediaUtil.isSameSize(mediaCustom.getX(1000), mediaCustom.getY(1000), win32Media.getX(1000), win32Media.getY(1000));
                            }
                            if (!isEquale) continue;
                            this.cbSize.setSelectedIndex(this.sizes.indexOf(med));
                            break;
                        }
                        if (medium == MediaSizeNameExtend.CUSTOM && mediaCustom != null) {
                            this.cbSize.setSelectedIndex(this.sizes.indexOf(medium));
                            this.widthTextField.setVisible(true);
                            this.heightTextField.setVisible(true);
                            this.ntfWidth.setNumberValue((Number)new Float(mediaCustom.getX(1000)));
                            this.ntfHeight.setNumberValue((Number)new Float(mediaCustom.getY(1000)));
                        }
                    } else if (medium instanceof MediaSizeName) {
                        MediaSizeName ms = (MediaSizeName)medium;
                        this.cbSize.setSelectedIndex(this.sizes.indexOf(ms));
                    } else if (medium instanceof MediaTray) {
                        MediaTray mt = (MediaTray)medium;
                        this.cbSource.setSelectedIndex(this.sources.indexOf(mt) + 1);
                    }
                } else {
                    this.cbSize.setSelectedIndex(this.sizes.size() > 0 ? 0 : -1);
                    this.cbSource.setSelectedIndex(0);
                }
                SunAlternateMedia alt = (SunAlternateMedia)SunPrintConfigDialog.this.asCurrent.get(amCategory);
                if (alt != null && (md = alt.getMedia()) instanceof MediaTray) {
                    MediaTray mt = (MediaTray)md;
                    this.cbSource.setSelectedIndex(this.sources.indexOf(mt) + 1);
                }
            }
            this.cbSize.addItemListener((ItemListener)this);
            this.cbSource.addItemListener((ItemListener)this);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            int index;
            MediaSizeName selectMedia;
            Object component = e.getSource();
            if ((component == this.ntfWidth || component == this.ntfHeight) && (selectMedia = (MediaSizeName)this.sizes.get(index = this.cbSize.getSelectedIndex())) instanceof MediaSizeNameExtend) {
                BigDecimal w = this.ntfWidth.getBigDecimalValue();
                BigDecimal h = this.ntfHeight.getBigDecimalValue();
                MediaSize ms = MediaSize.getMediaSizeForName(selectMedia);
                float[] xy = ms.getSize(1000);
                if (!ArrayUtil.isEqual((Float)Float.valueOf(xy[0]), (Float)Float.valueOf(w.floatValue())) || !ArrayUtil.isEqual((Float)Float.valueOf(xy[1]), (Float)Float.valueOf(h.floatValue()))) {
                    if (ms instanceof FreeMediaSize) {
                        ((FreeMediaSize)ms).setXY(w.floatValue(), h.floatValue(), 1000);
                    }
                    SunPrintConfigDialog.this.asCurrent.add(selectMedia);
                    SunPrintConfigDialog.this.mediaSizeChange = true;
                }
            }
        }
    }

    private class ScalePanel
    extends KDPanel
    implements ChangeListener,
    ActionListener {
        private static final long serialVersionUID = -3548925401140237475L;
        private KDSpinner spnScale;
        private KDRadioButton rbScale;
        private KDRadioButton rbFit;
        private KDSpinner spnWidth;
        private KDSpinner spnHeight;
        private KDPanel pnlAutoFit;
        private KDLabel lblHeightFit;

        public ScalePanel() {
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder(SunPrintConfigDialog.getMsg("border.scale")));
            String str = SunPrintConfigDialog.getMsg("label.scalerate");
            Integer value = 100;
            Integer min = 1;
            Integer max = 1000;
            Integer step = 5;
            SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
            this.spnScale = new KDSpinner((SpinnerModel)model);
            LinedLabel ll = SunPrintConfigDialog.L(str, (JComponent)this.spnScale);
            this.rbScale = new KDRadioButton();
            KDPanel pnl = new KDPanel();
            pnl.add((Component)this.rbScale);
            pnl.add((Component)((Object)ll));
            KDPanel pnlTemp = new KDPanel((LayoutManager)new BorderLayout());
            pnlTemp.add((Component)pnl, (Object)"West");
            this.add((Component)pnlTemp, "North");
            value = 1;
            min = 1;
            max = 1000;
            step = 1;
            model = new SpinnerNumberModel(value, min, max, step);
            this.spnWidth = new KDSpinner((SpinnerModel)model);
            value = 1;
            min = 1;
            max = 1000;
            step = 1;
            model = new SpinnerNumberModel(value, min, max, step);
            this.spnHeight = new KDSpinner((SpinnerModel)model);
            LinedLabel ll1 = SunPrintConfigDialog.L(Resources2.getMsg("scale_fit"), (JComponent)this.spnWidth);
            KDLabel lbl1 = new KDLabel(Resources2.getMsg("scale_fit_W"));
            this.lblHeightFit = new KDLabel(Resources2.getMsg("scale_fit_H"));
            this.rbFit = new KDRadioButton();
            KDPanel pnl1 = new KDPanel();
            pnl1.add((Component)this.rbFit);
            pnl1.add((Component)((Object)ll1));
            pnl1.add((Component)lbl1);
            pnl1.add((Component)this.spnHeight);
            pnl1.add((Component)this.lblHeightFit);
            this.pnlAutoFit = new KDPanel((LayoutManager)new BorderLayout());
            this.pnlAutoFit.add((Component)pnl1, (Object)"West");
            this.add((Component)this.pnlAutoFit, "Center");
            ButtonGroup bg = new ButtonGroup();
            bg.add((AbstractButton)this.rbScale);
            bg.add((AbstractButton)this.rbFit);
            this.rbScale.setSelected(true);
            this.spnScale.addChangeListener((ChangeListener)this);
            this.spnWidth.addChangeListener((ChangeListener)this);
            this.spnHeight.addChangeListener((ChangeListener)this);
            this.rbScale.addActionListener((ActionListener)this);
            this.rbFit.addActionListener((ActionListener)this);
        }

        public void enableAutoFit(boolean widthFit, boolean heightFit) {
            if (!widthFit && !heightFit) {
                this.pnlAutoFit.setVisible(false);
            } else if (widthFit && heightFit) {
                this.pnlAutoFit.setVisible(true);
            } else if (!heightFit) {
                this.pnlAutoFit.setVisible(true);
                this.spnHeight.setVisible(false);
                this.lblHeightFit.setVisible(false);
            } else if (heightFit) {
                this.pnlAutoFit.setVisible(true);
                this.spnHeight.setVisible(false);
                this.lblHeightFit.setVisible(false);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            this.updateScale(source);
            if (source == this.spnScale) {
                this.rbScale.removeActionListener((ActionListener)this);
                this.rbScale.setSelected(true);
                this.rbScale.addActionListener((ActionListener)this);
            } else if (source == this.spnWidth || source == this.spnHeight) {
                this.rbFit.removeActionListener((ActionListener)this);
                this.rbFit.setSelected(true);
                this.rbFit.addActionListener((ActionListener)this);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            this.updateScale(source);
            if (source == this.rbScale) {
                this.spnScale.requestFocus();
            } else if (source == this.rbFit) {
                this.spnWidth.requestFocus();
            }
        }

        public void updateScale(Object source) {
            if (source == this.rbScale || source == this.spnScale) {
                Integer i = (Integer)this.spnScale.getValue();
                if (i != null) {
                    double f = (double)i.intValue() / 100.0;
                    ZoomScaleInfo scale = new ZoomScaleInfo(f);
                    SunPrintConfigDialog.this.asCurrent.add(scale);
                }
            } else if (source == this.rbFit || source == this.spnHeight || source == this.spnWidth) {
                int w = 0;
                int h = 0;
                Integer iw = (Integer)this.spnWidth.getValue();
                Integer ih = (Integer)this.spnHeight.getValue();
                if (iw != null) {
                    w = iw;
                }
                if (ih != null) {
                    h = ih;
                }
                ZoomScaleInfo scale = new ZoomScaleInfo(w, h);
                SunPrintConfigDialog.this.asCurrent.add(scale);
            }
        }

        public void updateInfo() {
            Integer newValue;
            Integer oldValue;
            Class<ZoomScaleInfo> c = ZoomScaleInfo.class;
            ZoomScaleInfo factor = (ZoomScaleInfo)SunPrintConfigDialog.this.asCurrent.get(c);
            float f = 1.0f;
            boolean autoFit = false;
            int width = 1;
            int height = 1;
            if (factor != null) {
                f = (float)factor.getScale();
                autoFit = factor.isAutoFit();
                width = factor.getAutoFitWidth();
                height = factor.getAutoFitHeight();
            }
            if (!(oldValue = (Integer)this.spnScale.getValue()).equals(newValue = Integer.valueOf(Math.round(f * 100.0f)))) {
                this.spnScale.removeChangeListener((ChangeListener)this);
                this.spnScale.setValue((Object)newValue);
                this.spnScale.addChangeListener((ChangeListener)this);
            }
            this.rbScale.removeActionListener((ActionListener)this);
            this.rbFit.removeActionListener((ActionListener)this);
            this.rbScale.setSelected(!autoFit);
            this.rbFit.setSelected(autoFit);
            this.rbScale.addActionListener((ActionListener)this);
            this.rbFit.addActionListener((ActionListener)this);
            this.spnWidth.removeChangeListener((ChangeListener)this);
            this.spnWidth.setValue((Object)width);
            this.spnWidth.addChangeListener((ChangeListener)this);
            this.spnHeight.removeChangeListener((ChangeListener)this);
            this.spnHeight.setValue((Object)height);
            this.spnHeight.addChangeListener((ChangeListener)this);
        }
    }

    private class MarginsPanel
    extends KDPanel
    implements ActionListener,
    FocusListener {
        private static final long serialVersionUID = -6865884635849761354L;
        private final String strTitle = SunPrintConfigDialog.access$200("border.margins");
        private KDFormattedTextField leftMargin;
        private KDFormattedTextField rightMargin;
        private KDFormattedTextField topMargin;
        private KDFormattedTextField bottomMargin;
        private int units = 1000;
        private float lmVal = -1.0f;
        private float rmVal = -1.0f;
        private float tmVal = -1.0f;
        private float bmVal = -1.0f;
        private Float lmObj;
        private Float rmObj;
        private Float tmObj;
        private Float bmObj;

        public MarginsPanel() {
            DecimalFormat format;
            this.setOpaque(false);
            this.setLayout(LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            String unitsKey = "label.millimetres";
            String defaultCountry = Locale.getDefault().getCountry();
            if (defaultCountry != null && (defaultCountry.equals("") || defaultCountry.equals(Locale.US.getCountry()) || defaultCountry.equals(Locale.CANADA.getCountry()))) {
                unitsKey = "label.inches";
                this.units = 25400;
            }
            String unitsMsg = SunPrintConfigDialog.getMsg(unitsKey);
            if (this.units == 1000) {
                format = new DecimalFormat("###.##");
                format.setMaximumIntegerDigits(3);
            } else {
                format = new DecimalFormat("##.##");
                format.setMaximumIntegerDigits(2);
            }
            format.setMinimumFractionDigits(1);
            format.setMaximumFractionDigits(2);
            format.setMinimumIntegerDigits(1);
            format.setParseIntegerOnly(false);
            format.setDecimalSeparatorAlwaysShown(true);
            NumberFormatter nf = new NumberFormatter(format);
            nf.setMinimum(new Float(0.0f));
            nf.setMaximum(new Float(999.0f));
            nf.setAllowsInvalid(true);
            nf.setCommitsOnValidEdit(true);
            this.leftMargin = new KDFormattedTextField();
            this.leftMargin.setEditFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.leftMargin.setDisplayFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.leftMargin.addFocusListener((FocusListener)this);
            this.leftMargin.addActionListener((ActionListener)this);
            this.rightMargin = new KDFormattedTextField();
            this.rightMargin.setEditFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.rightMargin.setDisplayFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.rightMargin.addFocusListener((FocusListener)this);
            this.rightMargin.addActionListener((ActionListener)this);
            this.topMargin = new KDFormattedTextField();
            this.topMargin.setEditFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.topMargin.setDisplayFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.topMargin.addFocusListener((FocusListener)this);
            this.topMargin.addActionListener((ActionListener)this);
            this.bottomMargin = new KDFormattedTextField();
            this.bottomMargin.setEditFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.bottomMargin.setDisplayFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.bottomMargin.addFocusListener((FocusListener)this);
            this.bottomMargin.addActionListener((ActionListener)this);
            String str = SunPrintConfigDialog.getMsg("label.leftmargin");
            str = this.addUnit(str, unitsMsg);
            LinedLabel ll = SunPrintConfigDialog.L(str, (JComponent)this.leftMargin);
            this.add((Component)((Object)ll));
            str = SunPrintConfigDialog.getMsg("label.rightmargin");
            str = this.addUnit(str, unitsMsg);
            ll = SunPrintConfigDialog.L(str, (JComponent)this.rightMargin);
            this.add((Component)((Object)ll));
            str = SunPrintConfigDialog.getMsg("label.topmargin");
            str = this.addUnit(str, unitsMsg);
            ll = SunPrintConfigDialog.L(str, (JComponent)this.topMargin);
            this.add((Component)((Object)ll));
            str = SunPrintConfigDialog.getMsg("label.bottommargin");
            str = this.addUnit(str, unitsMsg);
            ll = SunPrintConfigDialog.L(str, (JComponent)this.bottomMargin);
            this.add((Component)((Object)ll));
        }

        String addUnit(String str, String unitsMsg) {
            if (str != null) {
                str = str + unitsMsg;
            }
            return str;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            this.updateMargins(source);
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            this.updateMargins(source);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        public void updateMargins(Object source) {
            if (!(source instanceof KDFormattedTextField)) {
                return;
            }
            KDFormattedTextField tf = (KDFormattedTextField)source;
            Float val = (Float)tf.getValue(Float.class);
            if (val == null) {
                return;
            }
            if (tf == this.leftMargin && ArrayUtil.isEqual((Float)val, (Float)this.lmObj)) {
                return;
            }
            if (tf == this.rightMargin && ArrayUtil.isEqual((Float)val, (Float)this.lmObj)) {
                return;
            }
            if (tf == this.topMargin && ArrayUtil.isEqual((Float)val, (Float)this.lmObj)) {
                return;
            }
            if (tf == this.bottomMargin && ArrayUtil.isEqual((Float)val, (Float)this.lmObj)) {
                return;
            }
            Float lmTmpObj = (Float)this.leftMargin.getValue(Float.class);
            Float rmTmpObj = (Float)this.rightMargin.getValue(Float.class);
            Float tmTmpObj = (Float)this.topMargin.getValue(Float.class);
            Float bmTmpObj = (Float)this.bottomMargin.getValue(Float.class);
            float lm = lmTmpObj.floatValue();
            float rm = rmTmpObj.floatValue();
            float tm = tmTmpObj.floatValue();
            float bm = bmTmpObj.floatValue();
            Class<OrientationRequested> orCategory = OrientationRequested.class;
            OrientationRequested or = (OrientationRequested)SunPrintConfigDialog.this.asCurrent.get(orCategory);
            if (or == null) {
                or = (OrientationRequested)SunPrintConfigDialog.this.psCurrent.getDefaultAttributeValue(orCategory);
            }
            if (or == OrientationRequested.REVERSE_PORTRAIT) {
                float tmp = lm;
                lm = rm;
                rm = tmp;
                tmp = tm;
                tm = bm;
                bm = tmp;
            } else if (or == OrientationRequested.LANDSCAPE) {
                float tmp = lm;
                lm = tm;
                tm = rm;
                rm = bm;
                bm = tmp;
            } else if (or == OrientationRequested.REVERSE_LANDSCAPE) {
                float tmp = lm;
                lm = bm;
                bm = rm;
                rm = tm;
                tm = tmp;
            }
            MediaPrintableArea mpa = this.validateMargins(lm, rm, tm, bm);
            if (mpa != null) {
                SunPrintConfigDialog.this.asCurrent.add(mpa);
                this.lmVal = lm;
                this.rmVal = rm;
                this.tmVal = tm;
                this.bmVal = bm;
                this.lmObj = lmTmpObj;
                this.rmObj = rmTmpObj;
                this.tmObj = tmTmpObj;
                this.bmObj = bmTmpObj;
            } else {
                if (this.lmObj == null || this.bmObj == null || this.tmObj == null || this.rmObj == null) {
                    return;
                }
                this.leftMargin.setValue((Object)this.lmObj);
                this.rightMargin.setValue((Object)this.rmObj);
                this.topMargin.setValue((Object)this.tmObj);
                this.bottomMargin.setValue((Object)this.bmObj);
            }
        }

        private MediaPrintableArea validateMargins(float lm, float rm, float tm, float bm) {
            Class<MediaPrintableArea> mpaCategory = MediaPrintableArea.class;
            MediaPrintableArea mpaMax = null;
            MediaSize mediaSize = null;
            Media media = (Media)SunPrintConfigDialog.this.asCurrent.get(Media.class);
            if (media == null || !(media instanceof MediaSizeName)) {
                media = (Media)SunPrintConfigDialog.this.psCurrent.getDefaultAttributeValue(Media.class);
            }
            if (media instanceof MediaSizeName) {
                MediaSizeName msn = (MediaSizeName)media;
                mediaSize = MediaSize.getMediaSizeForName(msn);
            }
            if (mediaSize == null) {
                mediaSize = new MediaSize(8.5f, 11.0f, 25400);
            }
            if (media != null) {
                HashPrintRequestAttributeSet tmpASet = new HashPrintRequestAttributeSet(SunPrintConfigDialog.this.asCurrent);
                tmpASet.add(media);
                Object values = SunPrintConfigDialog.this.psCurrent.getSupportedAttributeValues(mpaCategory, SunPrintConfigDialog.this.docFlavor, tmpASet);
                if (values instanceof MediaPrintableArea[] && ((MediaPrintableArea[])values).length > 0) {
                    mpaMax = ((MediaPrintableArea[])values)[0];
                }
            }
            if (mpaMax == null) {
                mpaMax = new MediaPrintableArea(0.0f, 0.0f, mediaSize.getX(this.units), mediaSize.getY(this.units), this.units);
            }
            float wid = mediaSize.getX(this.units);
            float hgt = mediaSize.getY(this.units);
            float pax = lm;
            float pay = tm;
            float paw = wid - lm - rm;
            float pah = hgt - tm - bm;
            float xMax = mpaMax.getX(this.units);
            float wMax = mpaMax.getWidth(this.units);
            float yMax = mpaMax.getY(this.units);
            float hMax = mpaMax.getHeight(this.units);
            if (paw <= 0.0f || pah <= 0.0f || pax < 0.0f || pay < 0.0f || Math.round(pax) < Math.round(xMax) || Math.round(paw) > Math.round(wMax) || Math.round(pay) < Math.round(yMax) || Math.round(pah) > Math.round(hMax)) {
                return null;
            }
            return new MediaPrintableArea(lm, tm, paw, pah, this.units);
        }

        public void updateInfo() {
            Class<MediaPrintableArea> mpaCategory = MediaPrintableArea.class;
            MediaPrintableArea mpa = (MediaPrintableArea)SunPrintConfigDialog.this.asCurrent.get(mpaCategory);
            MediaPrintableArea mpaMax = null;
            MediaSize mediaSize = null;
            Media media = (Media)SunPrintConfigDialog.this.asCurrent.get(Media.class);
            if (media == null || !(media instanceof MediaSizeName)) {
                media = (Media)SunPrintConfigDialog.this.psCurrent.getDefaultAttributeValue(Media.class);
            }
            if (media instanceof MediaSizeName) {
                MediaSizeName msn = (MediaSizeName)media;
                mediaSize = MediaSize.getMediaSizeForName(msn);
            }
            if (mediaSize == null) {
                mediaSize = new MediaSize(8.5f, 11.0f, 25400);
            }
            if (media != null) {
                HashPrintRequestAttributeSet tmpASet = new HashPrintRequestAttributeSet(SunPrintConfigDialog.this.asCurrent);
                tmpASet.add(media);
                Object values = SunPrintConfigDialog.this.psCurrent.getSupportedAttributeValues(mpaCategory, SunPrintConfigDialog.this.docFlavor, tmpASet);
                if (values instanceof MediaPrintableArea[] && ((MediaPrintableArea[])values).length > 0) {
                    mpaMax = ((MediaPrintableArea[])values)[0];
                } else if (values instanceof MediaPrintableArea) {
                    mpaMax = (MediaPrintableArea)values;
                }
            }
            if (mpaMax == null) {
                mpaMax = new MediaPrintableArea(0.0f, 0.0f, mediaSize.getX(this.units), mediaSize.getY(this.units), this.units);
            }
            float wid = mediaSize.getX(25400);
            float hgt = mediaSize.getY(25400);
            float maxMarginRatio = 5.0f;
            float xMgn = wid > maxMarginRatio ? 1.0f : wid / maxMarginRatio;
            float yMgn = hgt > maxMarginRatio ? 1.0f : hgt / maxMarginRatio;
            if (mpa == null) {
                mpa = new MediaPrintableArea(xMgn, yMgn, wid - 2.0f * xMgn, hgt - 2.0f * yMgn, 25400);
                SunPrintConfigDialog.this.asCurrent.add(mpa);
            }
            float pax = mpa.getX(this.units);
            float pay = mpa.getY(this.units);
            float paw = mpa.getWidth(this.units);
            float pah = mpa.getHeight(this.units);
            wid = mediaSize.getX(this.units);
            hgt = mediaSize.getY(this.units);
            if (paw > pah) {
                paw = wid - (hgt - paw);
                pah = hgt - (wid - pah);
            }
            float paxMax = mpaMax.getX(this.units);
            float payMax = mpaMax.getY(this.units);
            float pawMax = mpaMax.getWidth(this.units);
            float pahMax = mpaMax.getHeight(this.units);
            Class<OrientationRequested> orCategory = OrientationRequested.class;
            OrientationRequested or = (OrientationRequested)SunPrintConfigDialog.this.asCurrent.get(orCategory);
            boolean invalid = false;
            if (this.lmVal >= 0.0f) {
                invalid = true;
                if (this.lmVal + this.rmVal > wid) {
                    if (paw > pawMax) {
                        paw = pawMax;
                    }
                    pax = (wid - paw) / 2.0f;
                } else {
                    pax = this.lmVal >= paxMax ? this.lmVal : paxMax;
                    paw = wid - pax - this.rmVal;
                }
                if (this.tmVal + this.bmVal > hgt) {
                    if (pah > pahMax) {
                        pah = pahMax;
                    }
                    pay = (hgt - pah) / 2.0f;
                } else {
                    pay = this.tmVal >= payMax ? this.tmVal : payMax;
                    pah = hgt - pay - this.bmVal;
                }
            }
            if (pax < paxMax) {
                invalid = true;
                pax = paxMax;
            }
            if (pay < payMax) {
                invalid = true;
                pay = payMax;
            }
            if (paw > pawMax) {
                invalid = true;
                paw = pawMax;
            }
            if (pah > pahMax) {
                invalid = true;
                pah = pahMax;
            }
            if (pax + paw > paxMax + pawMax || paw <= 0.0f) {
                invalid = true;
                pax = paxMax;
                paw = pawMax;
            }
            if (pay + pah > payMax + pahMax || pah <= 0.0f) {
                invalid = true;
                pay = payMax;
                pah = pahMax;
            }
            if (invalid) {
                mpa = new MediaPrintableArea(pax, pay, paw, pah, this.units);
                SunPrintConfigDialog.this.asCurrent.add(mpa);
            }
            this.lmVal = pax;
            this.tmVal = pay;
            this.rmVal = mediaSize.getX(this.units) - pax - paw;
            this.bmVal = mediaSize.getY(this.units) - pay - pah;
            this.lmObj = new Float(this.lmVal);
            this.rmObj = new Float(this.rmVal);
            this.tmObj = new Float(this.tmVal);
            this.bmObj = new Float(this.bmVal);
            if (or == OrientationRequested.REVERSE_PORTRAIT) {
                Float tmp = this.lmObj;
                this.lmObj = this.rmObj;
                this.rmObj = tmp;
                tmp = this.tmObj;
                this.tmObj = this.bmObj;
                this.bmObj = tmp;
            } else if (or == OrientationRequested.LANDSCAPE) {
                Float tmp = this.lmObj;
                this.lmObj = this.bmObj;
                this.bmObj = this.rmObj;
                this.rmObj = this.tmObj;
                this.tmObj = tmp;
            } else if (or == OrientationRequested.REVERSE_LANDSCAPE) {
                Float tmp = this.lmObj;
                this.lmObj = this.tmObj;
                this.tmObj = this.rmObj;
                this.rmObj = this.bmObj;
                this.bmObj = tmp;
            }
            this.leftMargin.setValue((Object)this.lmObj);
            this.rightMargin.setValue((Object)this.rmObj);
            this.topMargin.setValue((Object)this.tmObj);
            this.bottomMargin.setValue((Object)this.bmObj);
        }
    }

    private class PageMarginPanel
    extends KDPanel
    implements ChangeListener,
    FocusListener,
    MouseListener,
    ActionListener {
        private static final long serialVersionUID = -6716511112382854749L;
        private KDSpinner spTop;
        private KDSpinner spLeft;
        private KDSpinner spBottom;
        private KDSpinner spRight;
        private KDSpinner spHead;
        private KDSpinner spFoot;
        private KDComboBox cbFooterAlign;
        private KDComboBox cbHeaderAlign;
        private ContentHeadFootPreview preview;
        private KDCheckBox halignBox;
        private KDCheckBox valignBox;

        public PageMarginPanel() {
            this.setLayout(null);
            this.spTop = new KDSpinner((SpinnerModel)new SpinnerNumberModel(25.0, 0.0, 150.0, 1.0));
            this.spBottom = new KDSpinner((SpinnerModel)new SpinnerNumberModel(25.0, 0.0, 150.0, 1.0));
            this.spLeft = new KDSpinner((SpinnerModel)new SpinnerNumberModel(19.0, 0.0, 150.0, 1.0));
            this.spRight = new KDSpinner((SpinnerModel)new SpinnerNumberModel(19.0, 0.0, 150.0, 1.0));
            this.spHead = new KDSpinner((SpinnerModel)new SpinnerNumberModel(13.0, 0.0, 150.0, 1.0));
            this.spFoot = new KDSpinner((SpinnerModel)new SpinnerNumberModel(13.0, 0.0, 150.0, 1.0));
            this.cbFooterAlign = new KDComboBox();
            Object[] footerAlignItem = new String[]{Resources.getMsg("combo.header.bottom"), Resources.getMsg("combo.header.top")};
            this.cbFooterAlign.addItems(footerAlignItem);
            this.cbFooterAlign.addActionListener((ActionListener)this);
            this.cbHeaderAlign = new KDComboBox();
            Object[] headerAlignItem = new String[]{Resources2.getMsg("headeralign_1"), Resources2.getMsg("headeralign_2")};
            this.cbHeaderAlign.addItems(headerAlignItem);
            this.cbHeaderAlign.addActionListener((ActionListener)this);
            this.preview = new ContentHeadFootPreview();
            this.preview.setPreferredSize(new Dimension(90, 128));
            int startX = 10;
            int startY = 10;
            int x = startX + 80;
            int y = startY + 0;
            int w = 70;
            int h = 34;
            KDLabelContainer lcTop = new KDLabelContainer(Resources.getMsg("label.topmargin"), (JComponent)this.spTop);
            lcTop.setBoundLabelAlignment(8);
            lcTop.setBounds(x - 5, y, w, h);
            KDLabelContainer lcLeft = new KDLabelContainer(Resources.getMsg("label.leftmargin"), (JComponent)this.spLeft);
            lcLeft.setBoundLabelAlignment(8);
            x = startX + 2;
            y = startY + 80;
            lcLeft.setBounds(x, y, w, h);
            KDLabelContainer lcBm = new KDLabelContainer(Resources.getMsg("label.bottommargin"), (JComponent)this.spBottom);
            lcBm.setBoundLabelAlignment(8);
            x = startX + 90;
            y = startY + 166;
            lcBm.setBounds(x - 15, y, w + 25, h);
            KDLabelContainer lcRight = new KDLabelContainer(Resources.getMsg("label.rightmargin"), (JComponent)this.spRight);
            lcRight.setBoundLabelAlignment(8);
            x = startX + 177;
            y = startY + 80;
            lcRight.setBounds(x, y, w + 20, h);
            x = startX + 77;
            y = startY + 36;
            w = 90;
            h = 128;
            this.preview.setBounds(58 + startX, 36 + startY, h, h);
            KDLabelContainer lcHead = new KDLabelContainer(Resources.getMsg("tab.header"), (JComponent)this.spHead);
            lcHead.setBoundLabelAlignment(8);
            x = startX + 177;
            y = startY + 0;
            w = 55;
            h = 34;
            lcHead.setBounds(x, y, w, h);
            KDLabelContainer lcheaderAlign = new KDLabelContainer(Resources2.getMsg("headeralign"), (JComponent)this.cbHeaderAlign);
            lcheaderAlign.setBoundLabelAlignment(8);
            x = x + w + 5;
            lcheaderAlign.setBounds(x, y, w + 100, h + 3);
            KDLabelContainer lcFoot = new KDLabelContainer(Resources.getMsg("tab.footer"), (JComponent)this.spFoot);
            lcFoot.setBoundLabelAlignment(8);
            x = startX + 177;
            y = startY + 166;
            lcFoot.setBounds(x, y, w, h);
            KDLabelContainer lcfooterAlign = new KDLabelContainer(Resources.getMsg("tab.footeralign"), (JComponent)this.cbFooterAlign);
            lcfooterAlign.setBoundLabelAlignment(8);
            x = x + w + 5;
            lcfooterAlign.setBounds(x, y, w + 63, h + 3);
            this.spTop.addChangeListener((ChangeListener)this);
            ((JSpinner.DefaultEditor)this.spTop.getEditor()).getTextField().addFocusListener(this);
            this.spLeft.addChangeListener((ChangeListener)this);
            ((JSpinner.DefaultEditor)this.spLeft.getEditor()).getTextField().addFocusListener(this);
            this.spBottom.addChangeListener((ChangeListener)this);
            ((JSpinner.DefaultEditor)this.spBottom.getEditor()).getTextField().addFocusListener(this);
            this.spRight.addChangeListener((ChangeListener)this);
            ((JSpinner.DefaultEditor)this.spRight.getEditor()).getTextField().addFocusListener(this);
            this.spHead.addChangeListener((ChangeListener)this);
            ((JSpinner.DefaultEditor)this.spHead.getEditor()).getTextField().addFocusListener(this);
            this.spFoot.addChangeListener((ChangeListener)this);
            ((JSpinner.DefaultEditor)this.spFoot.getEditor()).getTextField().addFocusListener(this);
            this.add((Component)lcTop);
            this.add((Component)lcLeft);
            this.add((Component)lcBm);
            this.add((Component)lcRight);
            this.add((Component)((Object)this.preview));
            this.add((Component)lcHead);
            this.add((Component)lcfooterAlign);
            this.add((Component)lcheaderAlign);
            this.add((Component)lcFoot);
            KDPanel alignPanel = new KDPanel();
            alignPanel.setLayout(null);
            alignPanel.setBorder((Border)BorderFactory.createTitledBorder(SunPrintConfigDialog.getMsg("border.centerAlign")));
            this.add((Component)alignPanel);
            this.halignBox = new KDCheckBox(SunPrintConfigDialog.getMsg("checkbox.horizontal"));
            this.halignBox.addChangeListener((ChangeListener)this);
            this.halignBox.setBounds(10, 18, this.halignBox.getPreferredSize().width, this.halignBox.getPreferredSize().height);
            this.valignBox = new KDCheckBox(SunPrintConfigDialog.getMsg("checkbox.vertical"));
            this.valignBox.addChangeListener((ChangeListener)this);
            this.valignBox.setBounds(110, 18, this.halignBox.getPreferredSize().width, this.halignBox.getPreferredSize().height);
            alignPanel.add((Component)this.halignBox);
            alignPanel.add((Component)this.valignBox);
            alignPanel.setBounds(startX, y + 35, 385, 55);
        }

        public void updateInfo() {
            float foot;
            float head;
            float top;
            HashPrintRequestAttributeSet set = SunPrintConfigDialog.this.asCurrent;
            PageIntervalInfo pageInfo = (PageIntervalInfo)set.get(PageIntervalInfo.class);
            if (pageInfo != null) {
                top = pageInfo.getTop(1000);
                this.spTop.setValue((Object)new Float(top));
                float left = pageInfo.getLeft(1000);
                this.spLeft.setValue((Object)new Float(left));
                float right = pageInfo.getRight(1000);
                this.spRight.setValue((Object)new Float(right));
                float bottom = pageInfo.getBottom(1000);
                this.spBottom.setValue((Object)new Float(bottom));
                this.preview.setPageContentInfo(pageInfo);
            } else {
                top = this.spTop.getFloatVlaue().floatValue();
                float right = this.spRight.getFloatVlaue().floatValue();
                float bottom = this.spBottom.getFloatVlaue().floatValue();
                float left = this.spLeft.getFloatVlaue().floatValue();
                PageIntervalInfo pageContentArea = new PageIntervalInfo(top, left, bottom, right, 1000);
                this.preview.setPageContentInfo(pageContentArea);
            }
            HeadFootIntervalInfo headfootInfo = (HeadFootIntervalInfo)set.get(HeadFootIntervalInfo.class);
            if (headfootInfo != null) {
                head = headfootInfo.getHeadTop(1000);
                this.spHead.setValue((Object)new Float(head));
                foot = headfootInfo.getFootBottom(1000);
                this.spFoot.setValue((Object)new Float(foot));
                this.preview.setHeadFootInfo(headfootInfo);
            } else {
                head = this.spHead.getFloatVlaue().floatValue();
                foot = this.spFoot.getFloatVlaue().floatValue();
                HeadFootIntervalInfo hf = new HeadFootIntervalInfo(head, foot, 1000);
                this.preview.setHeadFootInfo(hf);
            }
            SunPrintConfigDialog.this.footerAlign = SunPrintConfigDialog.this.model.getFooterAlign();
            SunPrintConfigDialog.this.headerAlign = SunPrintConfigDialog.this.model.getHeaderAlign();
            this.cbFooterAlign.setSelectedIndex(SunPrintConfigDialog.this.footerAlign);
            this.cbHeaderAlign.setSelectedIndex(SunPrintConfigDialog.this.headerAlign);
            this.preview.setPrevewScale(0.25f);
            Class<OrientationRequested> orCategory = OrientationRequested.class;
            OrientationRequested or = (OrientationRequested)SunPrintConfigDialog.this.asCurrent.get(orCategory);
            if (or == null || or == OrientationRequested.PORTRAIT) {
                this.preview.setOrientation(1);
            } else {
                this.preview.setOrientation(0);
            }
            SunPrintConfigDialog.this.centerAlign = SunPrintConfigDialog.this.model.getCenterAlign();
            if (SunPrintConfigDialog.this.centerAlign == PageSetupModel.CENTERALIGN_CENTER) {
                this.halignBox.setSelected(true);
                this.valignBox.setSelected(true);
            } else if (SunPrintConfigDialog.this.centerAlign == PageSetupModel.CENTERALIGN_HORIZONTAL) {
                this.halignBox.setSelected(true);
            } else if (SunPrintConfigDialog.this.centerAlign == PageSetupModel.CENTERALIGN_VERTICAL) {
                this.valignBox.setSelected(true);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object src = e.getSource();
            if (src instanceof KDSpinner) {
                this.updateFocus((KDSpinner)src);
            } else if (src == this.halignBox || src == this.valignBox) {
                boolean hSelected = this.halignBox.isSelected();
                boolean vSelected = this.valignBox.isSelected();
                if (hSelected && vSelected) {
                    SunPrintConfigDialog.this.centerAlign = PageSetupModel.CENTERALIGN_CENTER;
                } else if (hSelected) {
                    SunPrintConfigDialog.this.centerAlign = PageSetupModel.CENTERALIGN_HORIZONTAL;
                } else if (vSelected) {
                    SunPrintConfigDialog.this.centerAlign = PageSetupModel.CENTERALIGN_VERTICAL;
                } else {
                    SunPrintConfigDialog.this.centerAlign = PageSetupModel.CENTERALIGN_DEFAULT;
                }
                this.preview.setcenterAling(SunPrintConfigDialog.this.centerAlign);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            JComponent source = (JComponent)e.getSource();
            while (true) {
                if (source instanceof KDSpinner) break;
                source = (JComponent)source.getParent();
            }
            this.updateFocus((KDSpinner)source);
        }

        private void checkScope(KDSpinner spinner) {
            PageIntervalInfo unPrintableArea = KDPrinterUtils.countUnPrintableArea(SunPrintConfigDialog.this.psCurrent, (Media)SunPrintConfigDialog.this.asCurrent.get(Media.class));
            float margin = 0.0f;
            if (spinner == this.spTop || spinner == this.spHead) {
                margin = unPrintableArea.getTop(1000);
            } else if (spinner == this.spBottom || spinner == this.spFoot) {
                margin = unPrintableArea.getBottom(1000);
            } else if (spinner == this.spLeft) {
                margin = unPrintableArea.getLeft(1000);
            } else if (spinner == this.spRight) {
                margin = unPrintableArea.getRight(1000);
            }
            float value = spinner.getFloatVlaue().floatValue();
            if (value < margin) {
                spinner.setValue((Object)new Float(margin));
            }
        }

        private void updateFocus(KDSpinner spinner) {
            this.checkScope(spinner);
            if (spinner == this.spTop || spinner == this.spLeft || spinner == this.spBottom || spinner == this.spRight) {
                Number top = (Number)this.spTop.getValue();
                Number left = (Number)this.spLeft.getValue();
                Number bottom = (Number)this.spBottom.getValue();
                Number right = (Number)this.spRight.getValue();
                PageIntervalInfo pageContentArea = new PageIntervalInfo(top.floatValue(), left.floatValue(), bottom.floatValue(), right.floatValue(), 1000);
                SunPrintConfigDialog.this.asCurrent.add(pageContentArea);
                this.preview.setPageContentInfo(pageContentArea);
            } else if (spinner == this.spHead || spinner == this.spFoot) {
                float head = this.spHead.getFloatVlaue().floatValue();
                float foot = this.spFoot.getFloatVlaue().floatValue();
                HeadFootIntervalInfo hfiInfo = new HeadFootIntervalInfo(head, foot, 1000);
                SunPrintConfigDialog.this.asCurrent.add(hfiInfo);
                this.preview.setHeadFootInfo(hfiInfo);
            }
            if (spinner == this.spLeft) {
                this.preview.setActivedDot((short)1);
            } else if (spinner == this.spTop) {
                this.preview.setActivedDot((short)0);
            } else if (spinner == this.spBottom) {
                this.preview.setActivedDot((short)2);
            } else if (spinner == this.spRight) {
                this.preview.setActivedDot((short)3);
            } else if (spinner == this.spHead) {
                this.preview.setActivedDot((short)4);
            } else if (spinner == this.spFoot) {
                this.preview.setActivedDot((short)5);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.updateFocus((KDSpinner)e.getSource());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cbFooterAlign) {
                SunPrintConfigDialog.this.footerAlign = this.cbFooterAlign.getSelectedIndex();
                if (SunPrintConfigDialog.this.footerAlign == 0) {
                    this.spFoot.setEnabled(true);
                } else {
                    this.spFoot.setEnabled(false);
                }
            } else if (e.getSource() == this.cbHeaderAlign) {
                SunPrintConfigDialog.this.headerAlign = this.cbHeaderAlign.getSelectedIndex();
            }
        }
    }

    private class PageSetupPanel
    extends KDPanel {
        private static final long serialVersionUID = 3468365290933815115L;
        private MediaPanel pnlMedia;
        private OrientationPanel pnlOrientation;
        private ScalePanel pnlScale;

        public PageSetupPanel() {
            int hTemp1;
            this.setLayout(null);
            this.pnlMedia = new MediaPanel();
            this.pnlOrientation = new OrientationPanel();
            this.pnlScale = new ScalePanel();
            this.add((Component)((Object)this.pnlMedia));
            this.add((Component)((Object)this.pnlOrientation));
            this.add((Component)((Object)this.pnlScale));
            this.pnlOrientation.addOrientationListener(SunPrintConfigDialog.this.pnlPageMargin);
            int x = 5;
            int y = 5;
            Dimension size = this.pnlMedia.getPreferredSize();
            int h = size.height;
            this.pnlMedia.setBounds(x, y, 395, h);
            y = y + h + 5;
            h = hTemp1 = this.pnlOrientation.getPreferredSize().height;
            this.pnlOrientation.setBounds(x, y, 395, h);
            y = y + h + 5;
            h = this.pnlScale.getPreferredSize().height;
            this.pnlScale.setBounds(x, y, 395, h);
            h = y + h + 5;
            size.setSize(405, h);
            this.setPreferredSize(size);
        }

        public void updateInfo() {
            this.pnlMedia.updateInfo();
            this.pnlOrientation.updateInfo();
            this.pnlScale.updateInfo();
        }
    }
}

