/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.extend;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePageSetupModel;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePageSetupUI;
import com.kingdee.cosmic.ctrl.print.extend.AbstractSimplePrinter;
import com.kingdee.cosmic.ctrl.print.printjob.IPrintJob;
import com.kingdee.cosmic.ctrl.print.printjob.table.TableImagePrintJob;
import com.kingdee.cosmic.ctrl.print.resource.TableResources;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class KDTableImagePrinter
extends AbstractSimplePrinter {
    private static final Logger logger = LogUtil.getPackageLogger(KDTableImagePrinter.class);
    public static String TABLE_PARSER = "com.kingdee.cosmic.ctrl.kdf.table.print.TableCanvasProvider";
    public static String IMAGE_PARSER = "com.kingdee.cosmic.ctrl.print.extend.ImagePainterProvider";
    private int space = 20;
    protected TablePageSetupModel configmodel;
    protected String pageSetupModeName = TableResources.getMsg("tree.name");
    protected Map providerClassMap = new HashMap();

    public KDTableImagePrinter() {
        this.configmodel = new TablePageSetupModel();
    }

    @Override
    protected void resetKDPrinter() {
        super.resetKDPrinter();
        this.printer.registerConfigUI(this.pageSetupModeName, TablePageSetupUI.class, 4);
    }

    public void setSpace(int space) {
        this.space = space;
    }

    public void addDataParser(Class dataType, String provider_className) {
        this.providerClassMap.put(dataType, provider_className);
    }

    public void setHeader(HeadFootModel header) {
        if (this.printjob == null) {
            this.createPrintJobs();
        }
        this.printjob.getConfig().getHeaderFooterModel().setHeaderModel(header);
    }

    public void setFooter(HeadFootModel footer) {
        if (this.printjob == null) {
            this.createPrintJobs();
        }
        this.printjob.getConfig().getHeaderFooterModel().setFooterModel(footer);
    }

    @Override
    public IPrintJob createPrintJobs() {
        IPrintJob job = super.createPrintJobs();
        job.getConfig().setConfig(this.pageSetupModeName, this.configmodel);
        return job;
    }

    @Override
    public IPrintJob newPrintJob() {
        TableImagePrintJob job = new TableImagePrintJob(this.getPrintData(), this.space, this.configmodel);
        for (Class key : this.providerClassMap.keySet()) {
            try {
                job.addCanvasProvider(key, this.getProvider(key));
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
        return job;
    }

    private String getProvider(Class key) {
        String provider = null;
        Class theKey = key;
        while ((provider = (String)this.providerClassMap.get(theKey)) == null && (theKey = theKey.getSuperclass()) != null) {
        }
        return provider;
    }

    @Override
    public void beforePrint() {
    }
}

