/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.io;

import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.cosmic.ctrl.print.KDPrinter;
import com.kingdee.cosmic.ctrl.print.control.ControlPrint;
import com.kingdee.cosmic.ctrl.print.printjob.BufferPrintJob;
import com.kingdee.cosmic.ctrl.print.printjob.IPrintJob;
import com.kingdee.cosmic.ctrl.print.printjob.MultiBufferPrintJobs;
import com.kingdee.cosmic.ctrl.print.ui.component.HeaderFooter;
import com.kingdee.cosmic.ctrl.print.ui.component.Paper;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractExport {
    private List<String[]> headerRow;
    private List<String[]> footerRow;

    public void begin(String fileNamePre, KDPrinter printer) {
    }

    public void export(String fileNamePre, KDPrinter printer) {
        Paper paper;
        this.begin(fileNamePre, printer);
        ControlPrint cPrint = printer.getControlPrint();
        int index = 0;
        while ((paper = cPrint.getPaper(index)) != null) {
            this.addHeaderFooter(paper);
            this.exportPaper(paper, fileNamePre, index);
            ++index;
        }
        this.deleteTemplateFile(printer);
        this.end();
    }

    private void addHeaderFooter(Paper paper) {
        HeaderFooter footer;
        HeaderFooter header = (HeaderFooter)paper.getHeader();
        if (header != null) {
            HeadFootModel headerModel = new HeadFootModel();
            List<HeadFootRow> headerList = this.wrapperHeaderFooter(this.headerRow);
            headerModel.setRowList(headerList);
            header.setModel(headerModel);
            header.setPainterLocation(header.getX(), header.getLayer());
        }
        if (null != (footer = (HeaderFooter)paper.getFooter())) {
            HeadFootModel footerModel = new HeadFootModel();
            List<HeadFootRow> footerList = this.wrapperHeaderFooter(this.footerRow);
            footerModel.setRowList(footerList);
            footer.setModel(footerModel);
            footer.setPainterLocation(footer.getX(), paper.getHeight() - (float)footer.getLayer());
        }
    }

    private List<HeadFootRow> wrapperHeaderFooter(List<String[]> list) {
        int len = 0;
        String SPLIT = "&|";
        if (list == null || list.size() == 0) {
            return null;
        }
        for (String[] strs : list) {
            len = Math.max(strs.length, len);
        }
        ArrayList<HeadFootRow> lst = new ArrayList<HeadFootRow>(len);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            HeadFootRow row = new HeadFootRow();
            sb.setLength(0);
            for (int j = 0; j < list.size(); ++j) {
                String[] strs = list.get(j);
                if (strs.length > i && !StringUtils.isEmpty((CharSequence)strs[i])) {
                    sb.append(strs[i]);
                } else {
                    sb.append(" ");
                }
                if (j >= list.size() - 1) continue;
                sb.append("&|");
            }
            row.setText(sb.toString());
            lst.add(row);
        }
        return lst;
    }

    public void setPrintSetup(List<String[]> headerRow, List<String[]> footerRow) {
        this.headerRow = headerRow;
        this.footerRow = footerRow;
    }

    private void deleteTemplateFile(KDPrinter printer) {
        MultiBufferPrintJobs jobs = (MultiBufferPrintJobs)printer.getPrintJob();
        int taskCount = jobs.getTaskCount();
        for (int i = 0; i < taskCount; ++i) {
            BufferPrintJob bjob;
            IPrintJob iprintJob = jobs.getPrintJobByPaperIndex(i);
            if (!(iprintJob instanceof BufferPrintJob) || (bjob = (BufferPrintJob)iprintJob).getPrintFileBuffer() == null) continue;
            bjob.getPrintFileBuffer().destroy();
        }
    }

    public void end() {
    }

    protected abstract void exportPaper(Paper var1, String var2, int var3);
}

