/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.io;

import com.kingdee.cosmic.ctrl.print.io.AbstractExport;
import com.kingdee.cosmic.ctrl.print.ui.component.Page;
import com.kingdee.cosmic.ctrl.print.ui.component.Paper;
import com.kingdee.cosmic.ctrl.print.ui.io.Painter2Html;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class HtmlExport
extends AbstractExport {
    String imageDirectionName;
    Map imagesMap = null;

    @Override
    protected void exportPaper(Paper paper, String fileNamePre, int index) {
        this.imagesMap = new HashMap();
        Page page = paper.getBody();
        String des = fileNamePre;
        File tempFile = new File(FilenameUtils.normalize((String)fileNamePre));
        this.imageDirectionName = tempFile.getName() + "_files";
        des = des + index + ".html";
        File destFile = new File(FilenameUtils.normalize((String)des));
        try (FileOutputStream os = new FileOutputStream(destFile);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "UNICODE");){
            this.exportToWriter(page, writer);
            this.saveImages(destFile.getParentFile());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(destFile + " FileNotFoundException error:" + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException("UnsupportedEncodingException error:" + e1.getMessage(), e1);
        }
        catch (IOException e2) {
            throw new RuntimeException("IOException error:" + e2.getMessage(), e2);
        }
    }

    private void saveImages(File direction) {
        int iamgeSize = this.imagesMap.size();
        if (iamgeSize == 0) {
            return;
        }
        File imageDirect = new File(FilenameUtils.normalize((String)(direction.getAbsolutePath() + File.separator + this.imageDirectionName + File.separator)));
        if (!imageDirect.exists()) {
            imageDirect.mkdir();
        }
        for (Map.Entry entry : this.imagesMap.entrySet()) {
            Image image = (Image)entry.getValue();
            try {
                FileOutputStream fos = new FileOutputStream(FilenameUtils.normalize((String)(imageDirect.getAbsolutePath() + "\\" + entry.getKey() + ".jpg")));
                Throwable throwable = null;
                try {
                    BufferedImage bimg = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
                    Graphics gc = bimg.getGraphics();
                    gc.drawImage(image, 0, 0, null);
                    gc.dispose();
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)fos);
                    encoder.encode(bimg);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("FileNotFoundException error:" + e.getMessage(), e);
            }
            catch (ImageFormatException e) {
                throw new RuntimeException("ImageFormatException error:" + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException error:" + e.getMessage(), e);
            }
        }
    }

    private void exportToWriter(Page page, Writer writer) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<html\n");
        sb.append("xmlns=\"http://www.w3.org/TR/REC-html40\">\n");
        sb.append("<head>\n<meta http-equiv=Content-Type content=\"text/html; charset=utf-8\"></head>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        String bodyContent = this.exportToString(page);
        sb.append(bodyContent);
        sb.append("</body>\n");
        sb.append("</html>\n");
        writer.write(sb.toString());
        writer.flush();
    }

    private String exportToString(Page page) {
        if (page != null) {
            Painter2Html p2Html = new Painter2Html();
            return p2Html.makePage(page, this.imagesMap, this.imageDirectionName);
        }
        return null;
    }
}

