/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.io;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleParser;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.print.ConfigManager;
import com.kingdee.cosmic.ctrl.print.KDPrinter;
import com.kingdee.cosmic.ctrl.print.config.AbstractXmlTranslate;
import com.kingdee.cosmic.ctrl.print.config.PrintJobConfigXml;
import com.kingdee.cosmic.ctrl.print.config.xml.PrinterConfigXml;
import com.kingdee.cosmic.ctrl.print.io.BadDataFormatException;
import com.kingdee.cosmic.ctrl.print.io.IndexAccessFile;
import com.kingdee.cosmic.ctrl.print.io.KDPException;
import com.kingdee.cosmic.ctrl.print.io.KDPPrintJob;
import com.kingdee.cosmic.ctrl.print.printjob.IPrintJob;
import com.kingdee.cosmic.ctrl.print.ui.component.Page;
import com.kingdee.cosmic.ctrl.print.ui.io.Painter2Xml;
import com.kingdee.cosmic.ctrl.print.ui.io.Xml2Painter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class KDPFile {
    public static final String VERSION = "1.0";
    public static final String T_KDP = "kdp";
    public static final String A_PAGECOUNT = "pageCount";
    public static final String T_STYLES = "Styles";
    public static final String T_STYLE = "Style";
    private Map styles = new HashMap();
    private Painter2Xml toXml = new Painter2Xml(this.styles);
    private Xml2Painter fromXml = new Xml2Painter(this.styles);
    IndexAccessFile indexFileWriter;

    public KDPFile(String path) throws KDPException {
        try {
            this.indexFileWriter = new IndexAccessFile(path);
        }
        catch (BadDataFormatException e) {
            try {
                this.close();
            }
            catch (IOException e1) {
                throw new KDPException(e);
            }
            throw new KDPException(e);
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException e1) {
                throw new KDPException(e);
            }
            throw new KDPException(e);
        }
    }

    public void createFile() {
    }

    public void addJobBegin(IPrintJob childJob) throws IOException {
        String jobname = PrintJobConfigXml.NAME;
        String key = jobname + childJob.getID();
        this.write(key, "  <" + jobname + " id=\"" + childJob.getID() + "\" " + A_PAGECOUNT + "=\"" + childJob.getPageCount() + "\">");
    }

    public void addJobEnd(IPrintJob childJob) throws IOException {
        this.write("  </" + PrintJobConfigXml.NAME + ">");
    }

    public void addPage(Page page, int index, String jobname) throws IOException {
        IXmlElement pageE = this.toXml.makePage(page);
        String pageStr = KDPFile.xmlToString(pageE);
        this.write(jobname + ".page" + index, pageStr);
    }

    private void write(String key, String content) throws IOException {
        this.indexFileWriter.write(key, content);
        this.indexFileWriter.write(null, "\r\n");
    }

    private void write(String content) throws IOException {
        this.write(null, content);
    }

    public void saveStyles() throws IOException {
        IXmlElement nodeStyles = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)T_STYLES);
        Iterator iter = this.styles.entrySet().iterator();
        StyleParser.writeStyles((IXmlElement)nodeStyles, iter);
        String pageStr = KDPFile.xmlToString(nodeStyles);
        this.write(T_STYLES, pageStr);
    }

    public void addConfig(ConfigManager printConfig) throws IOException {
        IXmlElement e = printConfig.toXmlElement();
        String str = KDPFile.xmlToString(e);
        this.write("printconfig", "  " + str);
    }

    public void closeSave() throws IOException {
        this.indexFileWriter.closeWrite("</kdp>");
    }

    public void save(KDPrinter printer) throws IOException {
        this.indexFileWriter.initWrite("<?xml version=\"1.0\"?>\r\n<kdp version=\"1.0\">\r\n");
        IPrintJob printJob = printer.getPrintJob();
        int taskCount = printJob.getTaskCount();
        for (int i = 0; i < taskCount; ++i) {
            Page page;
            IPrintJob childJob = printJob.getPrintJob(i);
            this.addJobBegin(childJob);
            int index = 0;
            while ((page = childJob.getPage(index)) != null) {
                this.addPage(page, index, childJob.getID());
                ++index;
            }
            this.addJobEnd(childJob);
        }
        this.saveStyles();
        this.addConfig(printer.getPrintConfig());
        this.closeSave();
    }

    public Page getPage(int index, String jobid) {
        IXmlElement e = this.indexFileWriter.read(jobid + ".page" + index);
        if (e != null) {
            Page page = this.fromXml.parsePage(e);
            return page;
        }
        return null;
    }

    public void load(KDPrinter printer) throws KDPException {
        IXmlElement printerConfig = this.indexFileWriter.read(PrinterConfigXml.NAME);
        if (printerConfig == null) {
            throw new KDPException("failed to load element:" + PrinterConfigXml.NAME + ".");
        }
        List joblist = printerConfig.searchChildren(PrintJobConfigXml.NAME);
        printer.clear();
        int length = joblist.size();
        for (int i = 0; i < length; ++i) {
            IXmlElement job = (IXmlElement)joblist.get(i);
            KDPPrintJob printJob = new KDPPrintJob(job.getAttribute(AbstractXmlTranslate.ID));
            printJob.setPrinter(printer);
            printJob.setContent(this);
            printJob.setPageCount(Integer.parseInt(job.getAttribute(A_PAGECOUNT)));
            printer.addPrintJob(printJob);
        }
        this.loadStyles(this.indexFileWriter.read(T_STYLES));
        printer.getPrintConfig().fromXmlElement(printerConfig);
    }

    private void loadStyles(IXmlElement element) {
        if (element == null) {
            return;
        }
        List sList = element.searchChildren(T_STYLE);
        int length = sList.size();
        for (int i = 0; i < length; ++i) {
            IXmlElement s = (IXmlElement)sList.get(i);
            StyleAttributes sa = StyleParser.parseSA((IXmlElement)s);
            Style style = Styles.getStyle((ShareStyleAttributes)sa);
            this.styles.put(s.getAttribute("id"), style);
        }
    }

    public void close() throws IOException {
        this.indexFileWriter.close();
    }

    public static String xmlToString(IXmlElement e) {
        return XmlUtil.outputString((IXmlElement)e);
    }
}

