/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.io;

import com.kingdee.cosmic.ctrl.common.KDToolkit;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.cosmic.ctrl.print.KDPrinter;
import com.kingdee.cosmic.ctrl.print.control.ControlPrint;
import com.kingdee.cosmic.ctrl.print.io.AbstractExport;
import com.kingdee.cosmic.ctrl.print.io.KDFontMapperPlus;
import com.kingdee.cosmic.ctrl.print.ui.component.Paper;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class PdfExport
extends AbstractExport {
    private static final Logger logger = LogUtil.getPackageLogger(PdfExport.class);
    OutputStream os;
    Document document;
    PdfContentByte pdfContentByte;
    public static KDFontMapperPlus DEFAULT_FONTMAPPERPLUS = new KDFontMapperPlus();

    public PdfExport() {
    }

    public PdfExport(OutputStream os) {
        this.os = os;
    }

    @Override
    public void begin(String fileNamePre, KDPrinter printer) {
        String displayDocTitle = null;
        String PDF_SUFFIX = ".pdf";
        Date date = new Date();
        String defaultTitle = "Report-" + String.valueOf(date.getTime()) + PDF_SUFFIX;
        if (this.os == null) {
            String des = fileNamePre;
            if (!des.endsWith(".pdf")) {
                des = des + ".pdf";
            }
            File destFile = new File(FilenameUtils.normalize((String)des));
            displayDocTitle = destFile.getName();
            try {
                this.os = new FileOutputStream(destFile);
            }
            catch (FileNotFoundException e1) {
                throw new RuntimeException(destFile + " FileNotFoundException error:" + e1.getMessage(), e1);
            }
        }
        try {
            ControlPrint cPrint = printer.getControlPrint();
            Paper paper = cPrint.getPaper(0);
            float width = paper.getWidth();
            float height = paper.getHeight();
            Rectangle rc = new Rectangle((float)StyleUtil.pixelToPt((long)((long)width)), (float)StyleUtil.pixelToPt((long)((long)height)));
            float topM = paper.getPainterInfo().getAttributeManager().getBodyTopMargin(1000);
            float bottomM = paper.getPainterInfo().getAttributeManager().getBodyBottomMargin(1000);
            float leftM = paper.getPainterInfo().getAttributeManager().getLeftMargin(1000);
            float rightM = paper.getPainterInfo().getAttributeManager().getRightMargin(1000);
            float topPt = (float)StyleUtil.lomToPt((double)(topM * 10.0f));
            float bottomPt = (float)StyleUtil.lomToPt((double)(bottomM * 10.0f));
            float leftPt = (float)StyleUtil.lomToPt((double)(leftM * 10.0f));
            float rightPt = (float)StyleUtil.lomToPt((double)(rightM * 10.0f));
            this.document = new Document(rc, leftPt, rightPt, topPt, bottomPt);
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)this.os);
            pdfWriter.setViewerPreferences(131072);
            this.document.addTitle(displayDocTitle == null ? defaultTitle : displayDocTitle);
            pdfWriter.createXmpMetadata();
            this.document.open();
            this.pdfContentByte = pdfWriter.getDirectContent();
        }
        catch (DocumentException e) {
            throw new RuntimeException("PDF Document error:" + e.getMessage(), e);
        }
    }

    @Override
    protected void exportPaper(Paper paper, String fileNamePre, int index) {
        long width = (long)paper.getWidth();
        long height = (long)paper.getHeight();
        PdfTemplate pdftemplate = this.pdfContentByte.createTemplate((float)StyleUtil.pixelToPt((long)width), (float)StyleUtil.pixelToPt((long)height));
        Graphics2D graphics2d = pdftemplate.createGraphics((float)StyleUtil.pixelToPt((long)width), (float)StyleUtil.pixelToPt((long)height), (FontMapper)DEFAULT_FONTMAPPERPLUS);
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        graphics2d.scale(72.0 / (double)KDToolkit.getCurrentDpi(), 72.0 / (double)KDToolkit.getCurrentDpi());
        paper.painting(graphics2d, paper.getPainterInfo());
        graphics2d.dispose();
        pdftemplate.setWidth((float)StyleUtil.pixelToPt((long)width));
        pdftemplate.setHeight((float)StyleUtil.pixelToPt((long)height));
        this.pdfContentByte.addTemplate(pdftemplate, 0.0f, 0.0f);
        this.document.newPage();
    }

    @Override
    public void end() {
        try {
            this.document.close();
            this.os.flush();
            this.os.close();
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }

    @Override
    public void export(String fileNamePre, KDPrinter printer) {
        printer.getPrintJob().getPageCount();
        super.export(fileNamePre, printer);
    }

    @Override
    public void setPrintSetup(List<String[]> headerRow, List<String[]> footerRow) {
        super.setPrintSetup(headerRow, footerRow);
    }
}

