/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.preview;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlPrintMessages;
import com.kingdee.cosmic.ctrl.print.preview.PreviewBody;
import com.kingdee.cosmic.ctrl.swing.KDPopupMenu;
import com.kingdee.cosmic.ctrl.swing.KDToolBar;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class EditButtons {
    private PreviewBody body;
    private int x;
    private int y;
    private EditAction newText;
    private EditAction newImage;
    private EditAction style;
    private EditAction delete;
    private EditAction set;
    private String newText_name = CtrlPrintMessages.getMLS("preview.EditButtons.newText", "");
    private String newImage_name = CtrlPrintMessages.getMLS("preview.EditButtons.newImage", "");
    private String style_name = CtrlPrintMessages.getMLS("preview.EditButtons.style", "");
    private String delete_name = CtrlPrintMessages.getMLS("preview.EditButtons.delete", "");
    private String set_name = CtrlPrintMessages.getMLS("preview.EditButtons.set", "");

    public EditButtons(PreviewBody body, KDToolBar parent, int x, int y) {
        this.body = body;
        this.x = x;
        this.y = y;
        this.init();
        parent.add((Action)this.newText);
        parent.add((Action)this.newImage);
        parent.add((Action)this.style);
        parent.add((Action)this.delete);
        parent.add((Action)this.set);
    }

    public EditButtons(PreviewBody body, KDPopupMenu parent, int x, int y) {
        this.body = body;
        this.x = x;
        this.y = y;
        this.init();
        parent.add((Action)this.newText);
        parent.add((Action)this.newImage);
        if (body.getEditManager().isSelectCell()) {
            parent.add((Action)this.style);
            parent.add((Action)this.delete);
            parent.add((Action)this.set);
        }
    }

    private void init() {
        this.newText = new EditAction(this.newText_name);
        this.newImage = new EditAction(this.newImage_name);
        this.style = new EditAction(this.style_name);
        this.delete = new EditAction(this.delete_name);
        this.set = new EditAction(this.set_name);
    }

    public void processAction(String commandName) {
        if (commandName.equals(this.newText_name)) {
            this.body.getEditManager().createNewTextCell(this.x, this.y);
        } else if (commandName.equals(this.newImage_name)) {
            this.body.getEditManager().createImageCell(this.x, this.y);
        } else if (commandName.equals(this.style_name)) {
            this.body.getEditManager().styleSetup(this.style_name);
        } else if (!commandName.equals(this.set_name) && commandName.equals(this.delete_name)) {
            this.body.getEditManager().deleteCell();
        }
    }

    class EditAction
    extends AbstractAction {
        private static final long serialVersionUID = 6287757541693043511L;

        public EditAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditButtons.this.processAction(e.getActionCommand());
        }
    }
}

