/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.ui.component;

import com.kingdee.cosmic.ctrl.print.config.ui.PageSetupModel;
import com.kingdee.cosmic.ctrl.print.printjob.IPrintJob;
import com.kingdee.cosmic.ctrl.print.ui.component.BasicPainter;
import com.kingdee.cosmic.ctrl.print.ui.component.Canvas;
import com.kingdee.cosmic.ctrl.print.ui.component.IPainter;
import com.kingdee.cosmic.ctrl.print.ui.component.MixVariantLabelCell;
import com.kingdee.cosmic.ctrl.print.ui.component.Page;
import com.kingdee.cosmic.ctrl.print.ui.component.PainterInfo;
import com.kingdee.cosmic.ctrl.print.util.ImageFillUtil;
import com.kingdee.cosmic.ctrl.print.util.KDPrinterUtils;
import com.kingdee.cosmic.ctrl.swing.KDFont;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.SwingUtilities;

public class Paper
extends Canvas
implements Cloneable {
    private Canvas header;
    private Page body;
    private Canvas footer;
    private MixVariantLabelCell waterMark;
    private Image backGroundImage;
    private byte backGroundImageFillMode = 0;
    private int paperIndex = -1;
    private short paperType = 1;

    public Paper() {
    }

    public Paper(int index) {
        this.paperIndex = index;
    }

    protected Paper(short newValue) {
        this.paperType = newValue;
    }

    @Override
    public void updateView() {
    }

    @Override
    public void painting(Graphics g, PainterInfo info) {
        this.paintBackGround(g, info);
        this.paintBody(g, info);
        this.paintWaterMark(g, info);
    }

    private void paintBackGround(Graphics g, PainterInfo info) {
        Graphics2D g2d = (Graphics2D)g;
        Color color = this.getBackGround();
        if (color != null) {
            Color oldColor = g.getColor();
            g.setColor(color);
            ((Graphics2D)g).fill(this.getPainterBounds());
            g.setColor(oldColor);
        }
        if (this.backGroundImage != null) {
            Rectangle2D.Float rect = this.getPainterBounds();
            ImageFillUtil.draw(g2d, this.backGroundImage, rect, this.backGroundImageFillMode);
        }
    }

    private void paintBody(Graphics g, PainterInfo info) {
        int centerAlign;
        Graphics2D g2d = (Graphics2D)g;
        info.setPaperIndex(this.getIndex());
        KDPrinterUtils.adjustHeaderFooterBounds(this, g, info);
        Canvas header = this.getHeader();
        this.paintCanavs(g2d, header, info);
        Canvas footer = this.getFooter();
        this.paintCanavs(g2d, footer, info);
        Page bodypage = this.getBody();
        PainterInfo pInfo = null;
        if (bodypage != null) {
            pInfo = bodypage.getPainterInfo();
        }
        if (pInfo == null) {
            pInfo = info;
        }
        if ((centerAlign = info.getAttributeManager().getPageSetupModel().getCenterAlign()) != PageSetupModel.CENTERALIGN_DEFAULT) {
            PainterInfo painterInfo = this.getPainterInfo();
            PrintRequestAttributeSet set = painterInfo.getAttributeManager().getPrintRequestAttributeSet();
            Rectangle pageBounds = KDPrinterUtils.getPageBounds(set, KDPrinterUtils.SCREEN_RESOLUTION);
            float pX = 0.0f;
            float pY = 0.0f;
            float x = pageBounds.x;
            float y = pageBounds.y;
            float width = pageBounds.width;
            float height = pageBounds.height;
            if (bodypage != null) {
                float pWidth = (float)((double)bodypage.getWidth() * info.getScaleX());
                float pHeight = (float)((double)bodypage.getHeight() * info.getScaleY());
                if (centerAlign == PageSetupModel.CENTERALIGN_HORIZONTAL || centerAlign == PageSetupModel.CENTERALIGN_CENTER) {
                    pX = x + (width - pWidth) / 2.0f;
                    bodypage.setX(pX);
                }
                if (centerAlign == PageSetupModel.CENTERALIGN_VERTICAL || centerAlign == PageSetupModel.CENTERALIGN_CENTER) {
                    pY = y + (height - pHeight) / 2.0f;
                    bodypage.setY(pY);
                }
            }
        }
        this.paintCanavs(g2d, bodypage, pInfo);
    }

    private void paintWaterMark(Graphics g, PainterInfo info) {
        if (this.waterMark == null) {
            return;
        }
        Rectangle2D.Float rect = this.getPainterBounds();
        String text = this.waterMark.getParserText(info);
        if (text == null || "".equals(text)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        KDFont font = this.waterMark.getStyle().getKDFont();
        Rectangle2D fontRect = font.getStringBounds(text, g2d.getFontRenderContext());
        int strwidth = (int)(fontRect.getWidth() + 2.5);
        int strHeight = (int)(fontRect.getHeight() + 0.5);
        int rotation = this.waterMark.getStyle().getRotation();
        float width = strwidth;
        float height = strHeight;
        if (Math.abs(rotation) > 0) {
            width = this.widthWhenRotation(strwidth, rotation) + this.heightWhenRotation(strHeight, rotation);
            height = this.heightWhenRotation(strwidth, rotation) + this.widthWhenRotation(strHeight, rotation);
        }
        this.waterMark.setPainterBounds((rect.width - width) / 2.0f, (rect.height - height) / 2.0f, width, height);
        this.paintCanavs((Graphics2D)g, this.waterMark, info);
    }

    private float widthWhenRotation(float width, int rotation) {
        return (float)((double)width * Math.cos(Math.toRadians(Math.abs(rotation))));
    }

    private float heightWhenRotation(float width, int rotation) {
        return (float)((double)width * Math.sin(Math.toRadians(Math.abs(rotation))));
    }

    private void paintCanavs(Graphics2D g2d, IPainter canvas, PainterInfo info) {
        if (canvas == null) {
            return;
        }
        Graphics2D g = (Graphics2D)g2d.create();
        Rectangle2D.Float bounds = canvas.getPainterBounds();
        bounds.width = (float)((double)bounds.width * info.getScaleX());
        bounds.height = (float)((double)bounds.height * info.getScaleY());
        Rectangle clipBounds = g.getClipBounds();
        Rectangle canvasBounds = new Rectangle((int)bounds.x - 3, (int)bounds.y - 3, (int)bounds.width + 4, (int)bounds.height + 4);
        Rectangle resultClip = SwingUtilities.computeIntersection(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height, canvasBounds);
        g.setClip(resultClip);
        Point2D.Float p = canvas.getPainterLocation();
        g.translate(p.x, p.y);
        if (info.getScaleX() != 1.0 || info.getScaleY() != 1.0) {
            g.scale(info.getScaleX(), info.getScaleY());
        }
        canvas.painting(g, info);
        if (info.getScaleX() != 1.0 || info.getScaleY() != 1.0) {
            g.scale(1.0 / info.getScaleX(), 1.0 / info.getScaleY());
        }
        g.translate(-p.x, -p.y);
        g.dispose();
    }

    public void setIndex(int index) {
        this.paperIndex = index;
    }

    public int getIndex() {
        return this.paperIndex;
    }

    public void setBody(Page thePage) {
        this.body = thePage;
    }

    public Page getBody() {
        return this.body;
    }

    public short getPaperType() {
        return this.paperType;
    }

    @Override
    public void setPainterInfo(PainterInfo printPainterInfo) {
        super.setPainterInfo(printPainterInfo);
        printPainterInfo.setPaperIndex(this.getIndex());
    }

    public void setWaterMark(MixVariantLabelCell waterMark) {
        this.waterMark = waterMark;
    }

    public void setBackGroundImage(Image backImage) {
        this.backGroundImage = backImage;
    }

    public void setBackGroundImageFillMode(byte mode) {
        this.backGroundImageFillMode = mode;
    }

    public void setHeader(Canvas head) {
        this.header = head;
    }

    public void setFooter(Canvas foot) {
        this.footer = foot;
    }

    public Canvas getHeader() {
        return this.header;
    }

    public Canvas getFooter() {
        return this.footer;
    }

    @Override
    public float getContentHeight() {
        List children = this.body.getAllPainter();
        float height = 1.0f;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            BasicPainter p = (BasicPainter)children.get(i);
            float theY = p.y + p.height;
            if (!(theY > height)) continue;
            height = theY + 1.0f;
        }
        return height;
    }

    public IPrintJob getPrintJob() {
        return this.getPainterInfo().getAttributeManager().getPrintJob();
    }
}

