/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.xls.output;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlPrintMessages;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.Logger;
import java.awt.Color;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class StyleGuide {
    static PenStyle[] penstyle = new PenStyle[]{PenStyle.PS_SOLID, PenStyle.PS_CONTINUOUS, PenStyle.PS_DOT, PenStyle.PS_DASHDOTDOT, PenStyle.PS_DASHDOT, PenStyle.PS_DASH};
    static int[] linevalue = new int[]{0, 2, 1, 4, 3, 6};
    static LineStyle[] linestyle = new LineStyle[]{LineStyle.TRIGRAM_HOLLOW_LINE, LineStyle.TRIGRAM_SOLID_LINE, LineStyle.DOUBLE_LINE_A, LineStyle.DOUBLE_LINE_B, LineStyle.SINGLE_LINE, LineStyle.NULL_LINE, LineStyle.WIDTH4, LineStyle.WIDTH5, LineStyle.WIDTH6, LineStyle.WIDTH7, LineStyle.WIDTH8, LineStyle.WIDTH9, LineStyle.WIDTH10};
    static int[] lineWidth = new int[]{3, 3, 2, 3, 1, 0, 4, 5, 6, 7, 8, 9, 10};

    public static short translateColor(Color inColor) {
        HSSFColor color = null;
        Map triplets = HSSFColor.getTripletHash();
        Set entrySet = triplets.entrySet();
        if (entrySet.size() > 0) {
            int diff = 0;
            int mindiff = 999;
            short[] rgb = new short[3];
            for (Map.Entry entry : entrySet) {
                HSSFColor ctnColor = (HSSFColor)entry.getValue();
                rgb = ctnColor.getTriplet();
                diff = Math.abs(rgb[0] - inColor.getRed()) + Math.abs(rgb[1] - inColor.getGreen()) + Math.abs(rgb[2] - inColor.getBlue());
                if (diff >= mindiff) continue;
                mindiff = diff;
                color = ctnColor;
            }
        }
        if (color == null) {
            Logger.warn((Object)CtrlPrintMessages.getMLS("colorIsNull", "color\u4e3anull"));
            return 0;
        }
        return color.getIndex();
    }

    public static int[] translateImageBorder(Style style) {
        int i;
        LineStyle lineStyle = style.getBorderLineStyle(Styles.Position.LEFT);
        PenStyle pen = style.getBorderPenStyle(Styles.Position.LEFT);
        int[] obj = new int[3];
        int weight = 0;
        for (i = 0; i < 6; ++i) {
            if (penstyle[i] != pen) continue;
            obj[0] = linevalue[i];
            break;
        }
        for (i = 0; i < linestyle.length; ++i) {
            if (linestyle[i] != lineStyle) continue;
            weight = lineWidth[i];
            break;
        }
        Color borderColor = style.getBorderColor(Styles.Position.LEFT);
        obj[1] = borderColor.getBlue() << 16 | borderColor.getGreen() << 8 | borderColor.getRed();
        obj[2] = weight;
        return obj;
    }

    public static BorderStyle translateBorder(Style style, Styles.Position pos) {
        BorderStyle returnNum = BorderStyle.NONE;
        LineStyle lineStyle = style.getBorderLineStyle(pos);
        PenStyle pen = style.getBorderPenStyle(pos);
        if (lineStyle == LineStyle.TRIGRAM_HOLLOW_LINE) {
            returnNum = BorderStyle.DOUBLE;
        } else if (lineStyle == LineStyle.NULL_LINE) {
            returnNum = BorderStyle.NONE;
        } else if (pen == PenStyle.PS_SOLID) {
            returnNum = lineStyle == LineStyle.SINGLE_LINE ? BorderStyle.THIN : BorderStyle.MEDIUM;
        } else if (pen == PenStyle.PS_CONTINUOUS) {
            returnNum = BorderStyle.HAIR;
        } else if (pen == PenStyle.PS_DASH) {
            returnNum = lineStyle == LineStyle.SINGLE_LINE ? BorderStyle.DASHED : BorderStyle.MEDIUM_DASHED;
        } else if (pen == PenStyle.PS_DASHDOT) {
            returnNum = lineStyle == LineStyle.SINGLE_LINE ? BorderStyle.DASH_DOT : BorderStyle.MEDIUM_DASH_DOT;
        } else if (pen == PenStyle.PS_DASHDOTDOT) {
            returnNum = lineStyle == LineStyle.SINGLE_LINE ? BorderStyle.DASH_DOT_DOT : BorderStyle.MEDIUM_DASH_DOT_DOT;
        } else if (pen == PenStyle.PS_DOT) {
            returnNum = BorderStyle.DOTTED;
        }
        return returnNum;
    }

    public static HorizontalAlignment translateAliment(int align) {
        switch (align) {
            case 0: {
                return HorizontalAlignment.GENERAL;
            }
            case 1: {
                return HorizontalAlignment.LEFT;
            }
            case 2: {
                return HorizontalAlignment.CENTER;
            }
            case 3: {
                return HorizontalAlignment.RIGHT;
            }
        }
        return HorizontalAlignment.GENERAL;
    }

    public static VerticalAlignment translateVerticalAliment(int align) {
        switch (align) {
            case 1: {
                return VerticalAlignment.TOP;
            }
            case 2: {
                return VerticalAlignment.CENTER;
            }
            case 3: {
                return VerticalAlignment.BOTTOM;
            }
        }
        return VerticalAlignment.CENTER;
    }
}

