/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.xls.output;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.util.Base64;
import com.kingdee.cosmic.ctrl.print.xls.widget.IXlsNode;
import com.kingdee.cosmic.ctrl.print.xls.widget.XlsCell;
import com.kingdee.cosmic.ctrl.print.xls.widget.XlsImageCell;
import com.kingdee.cosmic.ctrl.print.xls.widget.XlsLabelCell;
import com.kingdee.cosmic.ctrl.print.xls.widget.XlsPaper;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class XlsNodeContainer {
    private int _limit = 10;
    private List _nodeCache;
    private int _size = 0;
    private RandomAccessFile _file;
    private Logger _log = LogUtil.getLogger(XlsNodeContainer.class);
    private boolean _reachLimit = false;
    private FileInputStream _is = null;

    public XlsNodeContainer(int count) {
        this._limit = count;
        this._nodeCache = new ArrayList(count);
    }

    public void add(XlsPaper node) {
        this._nodeCache.add(node);
        ++this._size;
    }

    public void clear() {
        try {
            if (this._file != null) {
                this._file.close();
                this._file = null;
            }
            if (this._is != null) {
                this._is.close();
            }
            this._size = 0;
            this._nodeCache.clear();
            this._reachLimit = false;
        }
        catch (IOException e) {
            this._log.error((Object)"XlsNodeContainer clear faild");
        }
    }

    public Iterator iterator() {
        return new Iterator(){
            private int _currentIndex = 0;

            @Override
            public boolean hasNext() {
                return XlsNodeContainer.this._size > 0;
            }

            public Object next() {
                Object obj = null;
                obj = XlsNodeContainer.this._nodeCache.get(this._currentIndex);
                return obj;
            }

            @Override
            public void remove() {
                XlsNodeContainer.this._nodeCache.remove(this._currentIndex);
                XlsNodeContainer.this._size--;
            }
        };
    }

    private IXlsNode toNode(IXmlElement element) {
        XlsCell node = null;
        if (element.getName().equals("text")) {
            node = new XlsLabelCell();
            String value = element.getChild("value").getText();
            node.setValue(value);
        } else if (element.getName().equals("image")) {
            String content = element.getText();
            byte[] data = Base64.decode((String)content);
            ImageIcon icon = null;
            try {
                ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(data));
                icon = (ImageIcon)oin.readObject();
            }
            catch (Exception e) {
                this._log.error((Object)"read image cached data faild!", (Throwable)e);
            }
            XlsImageCell cell = new XlsImageCell();
            if (icon != null) {
                cell.setImage(icon.getImage());
            }
            node = cell;
        }
        IXmlElement tempE = element.getChild("common");
        this.parseCommon(tempE, node);
        return node;
    }

    private void parseCommon(IXmlElement element, IXlsNode node) {
        if (element == null) {
            return;
        }
        float width = Float.parseFloat(element.getAttribute("cell.width"));
        float height = Float.parseFloat(element.getAttribute("cell.height"));
        int layer = Integer.parseInt(element.getAttribute("layer"));
        String stylekey = element.getAttribute("stylecode");
        String location = element.getChild("location").getText();
        String[] locations = location.split(",");
        node.setBounds(Float.parseFloat(locations[0]), Float.parseFloat(locations[1]), width + 1.0f, height + 1.0f);
        node.setStyleKey(stylekey);
        node.setLayer(layer);
    }

    public int size() {
        return this._size;
    }
}

