/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print.xls.widget;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlPrintMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.print.ui.component.PainterInfo;
import com.kingdee.cosmic.ctrl.print.xls.exception.OutOfSizeException;
import com.kingdee.cosmic.ctrl.print.xls.output.LinesList;
import com.kingdee.cosmic.ctrl.print.xls.widget.IXlsNode;
import com.kingdee.cosmic.ctrl.print.xls.widget.XlsContainer;
import java.util.List;
import org.apache.log4j.Logger;

public class XlsPaper
extends XlsContainer {
    private PainterInfo _painterInfo;
    private LinesList _horizonLines = new LinesList();
    private LinesList _verticalLines = new LinesList();
    private Logger _log = LogUtil.getLogger(XlsContainer.class);

    @Override
    public void addNode(IXlsNode node) {
        if (node == null) {
            return;
        }
        try {
            this._verticalLines.add(node.getX1());
            this._verticalLines.add(node.getX2());
            this._horizonLines.add(node.getY1());
            this._horizonLines.add(node.getY2());
        }
        catch (OutOfSizeException e) {
            this._log.error((Object)(CtrlPrintMessages.getMLS("columnCountExceeds255", "\u5355\u9875\u5217\u6570\u5927\u4e8e255\uff1f!") + e.getMessage()));
        }
        this.getChildren().add(node);
    }

    public LinesList getHorizonLines() {
        return this._horizonLines;
    }

    public LinesList getVerticalLines() {
        return this._verticalLines;
    }

    public void setPaintInfo(PainterInfo painterInfo) {
        this._painterInfo = painterInfo;
    }

    public PainterInfo getPainterInfo() {
        return this._painterInfo;
    }

    @Override
    public IXmlElement toXml() {
        IXmlElement pageXml = XmlUtil.createNode((String)"paper");
        pageXml.addChild(super.toXml());
        pageXml.addChild(this.child2Xml());
        return pageXml;
    }

    private IXmlElement child2Xml() {
        IXmlElement childrenNode = XmlUtil.createNode((String)"children");
        List children = this.getChildren();
        for (int index = 0; index < children.size(); ++index) {
            IXlsNode node = (IXlsNode)children.get(index);
            childrenNode.addChild(node.toXml());
        }
        return childrenNode;
    }
}

