/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;

public class DateTimeEditor2
extends JTextField {
    private static final long serialVersionUID = 1222459869676695181L;
    public static final int TYPE_DATE = 0;
    public static final int TYPE_TIME = 1;
    private int type;
    private int bitsForSeg1 = 4;
    private int bitsForSeg2 = 2;
    private int bitsForSeg3 = 2;
    private char separator = (char)45;
    DefaultCaret caret = new MyCaret();
    Calendar calendar = Calendar.getInstance();
    private Date minDate;
    private Date maxDate;
    private boolean fireCarentEvent = true;

    public DateTimeEditor2() {
        this.setType(0);
        this.caret.install(this);
        this.setCaret(this.caret);
        this.addCaretListener(new CaretHandle());
        Keymap keyMap = DateTimeEditor2.getKeymap("default");
        keyMap.setDefaultAction(new DefaultKeyTypedAction());
        InputMap im = this.getInputMap();
        ActionMap am = this.getActionMap();
        im.put(KeyStroke.getKeyStroke(37, 0), "left");
        am.put("left", new LeftAction());
        im.put(KeyStroke.getKeyStroke(39, 0), "right");
        am.put("right", new RightAction());
        im.put(KeyStroke.getKeyStroke(38, 0), "up");
        am.put("up", new UpAction());
        im.put(KeyStroke.getKeyStroke(36, 0), "home");
        am.put("home", new HomeAction());
        im.put(KeyStroke.getKeyStroke(35, 0), "end");
        am.put("end", new EndAction());
        im.put(KeyStroke.getKeyStroke(127, 0), "delete");
        im.put(KeyStroke.getKeyStroke('\b'), "delete");
        am.put("delete", new DeleteAction());
    }

    public void setDate(Date d) {
        String s = this.getY(d) + this.separator + this.getM(d) + this.separator + this.getD(d);
        this.setText(s);
        this.setCaretPosotion(0, 1, 0);
    }

    boolean checkValidDate(String s) {
        try {
            Date d = DateFormat.getDateInstance().parse(s);
            if (this.minDate != null && d.compareTo(this.minDate) < 0) {
                return false;
            }
            if (this.maxDate != null && d.compareTo(this.maxDate) > 0) {
                return false;
            }
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    boolean checkValidChar(int bit, char c) {
        if (this.type == 0) {
            if (this.bitsForSeg1 == 2) {
                bit += 2;
            }
            if (bit == 5 ? c < '0' || c > '1' : bit == 8 && (c < '0' || c > '3')) {
                return false;
            }
        }
        return true;
    }

    void replaceText(String content, int caretPos) {
        this.fireCarentEvent = false;
        this.replaceSelection(content);
        this.fireCarentEvent = true;
        this.setCaretPosotion(caretPos, caretPos + 1, 0);
    }

    String getY(Date d) {
        int y = this.calendar.get(1);
        String s = String.valueOf(y);
        return this.fill(s, this.bitsForSeg1, '0');
    }

    String getM(Date d) {
        int m = this.calendar.get(2) + 1;
        String s = String.valueOf(m);
        return this.fill(s, this.bitsForSeg2, '0');
    }

    String getD(Date d) {
        int m = this.calendar.get(5);
        String s = String.valueOf(m);
        return this.fill(s, this.bitsForSeg3, '0');
    }

    String fill(String s, int len, char c) {
        int slen;
        for (int i = slen = s.length(); i < len; ++i) {
            s = c + s;
        }
        return s;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        DateTimeEditor2 edt = new DateTimeEditor2();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(edt);
        frame.pack();
        frame.setVisible(true);
        edt.setDate(new Date());
    }

    void setCaretPosotion(int begin, int end, int direction) {
        int docLength;
        this.fireCarentEvent = false;
        if (direction == 0) {
            if (begin == this.bitsForSeg1 || begin == this.bitsForSeg1 + this.bitsForSeg2 + 1) {
                ++begin;
                ++end;
            }
        } else if (begin == this.bitsForSeg1 || begin == this.bitsForSeg1 + this.bitsForSeg2 + 1) {
            --begin;
            --end;
        }
        if (begin >= (docLength = this.getDocument().getLength())) {
            begin = docLength - 1;
            end = docLength;
        }
        if (begin < 0) {
            begin = 0;
        }
        if (end <= 0) {
            end = 1;
        }
        this.caret.setDot(begin);
        this.caret.moveDot(end);
        this.fireCarentEvent = true;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.bitsForSeg1 = type == 0 ? 4 : 2;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public void setMinDate(Date minDate) {
        this.minDate = minDate;
    }

    static class MyCaret
    extends DefaultCaret {
        private static final long serialVersionUID = -3986169973421662542L;

        MyCaret() {
        }

        @Override
        public void paint(Graphics g) {
        }
    }

    static class DefaultKeyTypedAction
    extends TextAction {
        private static final long serialVersionUID = -8203329096769257734L;

        public DefaultKeyTypedAction() {
            super("default-typed");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DateTimeEditor2 target = (DateTimeEditor2)this.getTextComponent(e);
            if (target != null && e != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    return;
                }
                String content = e.getActionCommand();
                int mod = e.getModifiers();
                if (content != null && content.length() > 0 && (mod & 8) == (mod & 2)) {
                    int begin;
                    char c = content.charAt(0);
                    boolean valid = false;
                    if (c >= '0' && c <= '9' && target.checkValidChar(begin = target.getSelectionStart(), c)) {
                        String s = target.getText();
                        char[] temp = s.toCharArray();
                        temp[begin] = c;
                        s = new String(temp);
                        if (target.checkValidDate(s)) {
                            target.replaceText(content, begin + 1);
                            valid = true;
                        }
                    }
                    if (!valid) {
                        UIManager.getLookAndFeel().provideErrorFeedback(target);
                    }
                }
            }
        }
    }

    class CaretHandle
    implements CaretListener {
        CaretHandle() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            int end;
            if (!DateTimeEditor2.this.fireCarentEvent) {
                return;
            }
            int docLength = DateTimeEditor2.this.getDocument().getLength();
            if (docLength != 10) {
                return;
            }
            int begin = e.getMark();
            if (begin == (end = e.getDot())) {
                ++end;
                if (begin >= docLength) {
                    begin = docLength - 1;
                    end = docLength;
                }
                DateTimeEditor2.this.setCaretPosotion(begin, end, 0);
            }
        }
    }

    static class LeftAction
    extends TextAction {
        private static final long serialVersionUID = 737641854405429957L;

        public LeftAction() {
            super("left");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DateTimeEditor2 target = (DateTimeEditor2)this.getTextComponent(e);
            if (target != null) {
                int begin = target.getSelectionStart();
                int end = target.getSelectionEnd();
                target.setCaretPosotion(--begin, --end, 1);
            }
        }
    }

    static class RightAction
    extends TextAction {
        private static final long serialVersionUID = -6099594407781866015L;

        public RightAction() {
            super("right");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DateTimeEditor2 target = (DateTimeEditor2)this.getTextComponent(e);
            if (target != null) {
                int begin = target.getSelectionStart();
                int end = target.getSelectionEnd();
                target.setCaretPosotion(++begin, ++end, 0);
            }
        }
    }

    static class DeleteAction
    extends TextAction {
        private static final long serialVersionUID = 8704511567365568839L;

        public DeleteAction() {
            super("delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DateTimeEditor2 target = (DateTimeEditor2)this.getTextComponent(e);
            if (target != null) {
                int begin = target.getSelectionStart();
                target.replaceText("0", begin);
            }
        }
    }

    static class EndAction
    extends TextAction {
        private static final long serialVersionUID = 6216269504928872428L;

        public EndAction() {
            super("end");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DateTimeEditor2 target = (DateTimeEditor2)this.getTextComponent(e);
            if (target != null) {
                int docLength = target.getDocument().getLength();
                target.setCaretPosotion(docLength - 1, docLength, 0);
            }
        }
    }

    static class HomeAction
    extends TextAction {
        private static final long serialVersionUID = 6032664786405630433L;

        public HomeAction() {
            super("home");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DateTimeEditor2 target = (DateTimeEditor2)this.getTextComponent(e);
            if (target != null) {
                target.setCaretPosotion(0, 1, 0);
            }
        }
    }

    static class UpAction
    extends TextAction {
        private static final long serialVersionUID = 3048278560529773629L;

        public UpAction() {
            super("up");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DateTimeEditor2 target = (DateTimeEditor2)this.getTextComponent(e);
            if (target != null) {
                // empty if block
            }
        }
    }
}

