/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.BasicFormattedTextField;
import com.kingdee.cosmic.ctrl.swing.CtrlPlainDocument;
import com.kingdee.cosmic.ctrl.swing.model.IDateTimeModel;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;

public class DateTimeTextField2
extends BasicFormattedTextField {
    private static final long serialVersionUID = 1L;
    private CtrlPlainDocument timeDocument = new CtrlPlainDocument();
    public static final int TYPE_DATE = 0;
    public static final int TYPE_TIME = 1;
    private int bitsForSeg1 = 4;
    private int bitsForSeg2 = 2;
    private int bitsForSeg3 = 2;
    Calendar calendar = Calendar.getInstance();
    DefaultCaret caret = new MyCaret();
    private boolean fireCarentEvent = true;
    private Date maxDate;
    private Date minDate;
    private char separator = (char)45;
    private int type;

    public DateTimeTextField2(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
    }

    public CtrlPlainDocument getDateTimeDocument() {
        return this.timeDocument;
    }

    public DateTimeTextField2() {
        this.setType(0);
        this.caret.install(this);
        this.setCaret(this.caret);
        this.addCaretListener(new CaretHandle());
        Keymap keyMap = DateTimeTextField2.getKeymap("default");
        keyMap.setDefaultAction(new DefaultKeyTypedAction());
        InputMap im = this.getInputMap();
        ActionMap am = this.getActionMap();
        im.put(KeyStroke.getKeyStroke(37, 0), "left");
        am.put("left", new LeftAction());
        im.put(KeyStroke.getKeyStroke(39, 0), "right");
        am.put("right", new RightAction());
        im.put(KeyStroke.getKeyStroke(38, 0), "up");
        am.put("up", new UpAction());
        im.put(KeyStroke.getKeyStroke(36, 0), "home");
        am.put("home", new HomeAction());
        im.put(KeyStroke.getKeyStroke(35, 0), "end");
        am.put("end", new EndAction());
        im.put(KeyStroke.getKeyStroke(127, 0), "delete");
        im.put(KeyStroke.getKeyStroke('\b'), "delete");
        am.put("delete", new DeleteAction());
    }

    boolean checkValidChar(int bit, char c) {
        if (this.type == 0) {
            if (this.bitsForSeg1 == 2) {
                bit += 2;
            }
            if (bit == 5 ? c < '0' || c > '1' : bit == 8 && (c < '0' || c > '3')) {
                return false;
            }
        }
        return true;
    }

    boolean checkValidDate(String s) {
        try {
            Date d = DateFormat.getDateInstance().parse(s);
            if (this.minDate != null && d.compareTo(this.minDate) < 0) {
                return false;
            }
            if (this.maxDate != null && d.compareTo(this.maxDate) > 0) {
                return false;
            }
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    String fill(String s, int len, char c) {
        int slen;
        for (int i = slen = s.length(); i < len; ++i) {
            s = c + s;
        }
        return s;
    }

    String getD(Date d) {
        int m = this.calendar.get(5);
        String s = String.valueOf(m);
        return this.fill(s, this.bitsForSeg3, '0');
    }

    String getM(Date d) {
        int m = this.calendar.get(2) + 1;
        String s = String.valueOf(m);
        return this.fill(s, this.bitsForSeg2, '0');
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public IDateTimeModel getDateTimeModel() {
        return null;
    }

    public Date getMaximumDate() {
        return null;
    }

    public Date getMinimumDate() {
        return null;
    }

    public void setDateTimePattern(String dateTimePattern) {
    }

    public String getDateTimePattern() {
        return null;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    public int getType() {
        return this.type;
    }

    String getY(Date d) {
        int y = this.calendar.get(1);
        String s = String.valueOf(y);
        return this.fill(s, this.bitsForSeg1, '0');
    }

    void replaceText(String content, int caretPos) {
        this.fireCarentEvent = false;
        this.replaceSelection(content);
        this.fireCarentEvent = true;
        this.setCaretPosotion(caretPos, caretPos + 1, 0);
    }

    void setCaretPosotion(int begin, int end, int direction) {
        int docLength;
        this.fireCarentEvent = false;
        if (direction == 0) {
            if (begin == this.bitsForSeg1 || begin == this.bitsForSeg1 + this.bitsForSeg2 + 1) {
                ++begin;
                ++end;
            }
        } else if (begin == this.bitsForSeg1 || begin == this.bitsForSeg1 + this.bitsForSeg2 + 1) {
            --begin;
            --end;
        }
        if (begin >= (docLength = this.getDocument().getLength())) {
            begin = docLength - 1;
            end = docLength;
        }
        if (begin < 0) {
            begin = 0;
        }
        if (end <= 0) {
            end = 1;
        }
        this.caret.setDot(begin);
        this.caret.moveDot(end);
        this.fireCarentEvent = true;
    }

    public void setDate(Date d) {
        String s = this.getY(d) + this.separator + this.getM(d) + this.separator + this.getD(d);
        this.setText(s);
        this.setCaretPosotion(0, 1, 0);
    }

    public void setDateTimeModel(IDateTimeModel dateTimeModel) {
    }

    public void setValue(Date d) {
    }

    public void setMinimumDate(Date setMinimumDate) {
    }

    public void setMaximumDate(Date maximumDate) {
    }

    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
    }

    public void setMinDate(Date minDate) {
        this.minDate = minDate;
    }

    public void setType(int type) {
        this.type = type;
        this.bitsForSeg1 = type == 0 ? 4 : 2;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        DateTimeTextField2 edt = new DateTimeTextField2();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(edt);
        frame.pack();
        frame.setVisible(true);
        edt.setDate(new Date());
    }

    static class UpAction
    extends TextAction {
        private static final long serialVersionUID = 9002981187416155510L;

        public UpAction() {
            super("up");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DateTimeTextField2 target = (DateTimeTextField2)this.getTextComponent(e);
            if (target != null) {
                // empty if block
            }
        }
    }

    static class RightAction
    extends TextAction {
        private static final long serialVersionUID = 2070141477638669718L;

        public RightAction() {
            super("right");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DateTimeTextField2 target = (DateTimeTextField2)this.getTextComponent(e);
            if (target != null) {
                int begin = target.getSelectionStart();
                int end = target.getSelectionEnd();
                target.setCaretPosotion(++begin, ++end, 0);
            }
        }
    }

    static class MyCaret
    extends DefaultCaret {
        private static final long serialVersionUID = 4037551716052838353L;

        MyCaret() {
        }

        @Override
        public void paint(Graphics g) {
        }
    }

    static class LeftAction
    extends TextAction {
        private static final long serialVersionUID = -5764398697468037083L;

        public LeftAction() {
            super("left");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DateTimeTextField2 target = (DateTimeTextField2)this.getTextComponent(e);
            if (target != null) {
                int begin = target.getSelectionStart();
                int end = target.getSelectionEnd();
                target.setCaretPosotion(--begin, --end, 1);
            }
        }
    }

    static class HomeAction
    extends TextAction {
        private static final long serialVersionUID = 3064077633893432828L;

        public HomeAction() {
            super("home");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DateTimeTextField2 target = (DateTimeTextField2)this.getTextComponent(e);
            if (target != null) {
                target.setCaretPosotion(0, 1, 0);
            }
        }
    }

    static class EndAction
    extends TextAction {
        private static final long serialVersionUID = -2897547653283965245L;

        public EndAction() {
            super("end");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DateTimeTextField2 target = (DateTimeTextField2)this.getTextComponent(e);
            if (target != null) {
                int docLength = target.getDocument().getLength();
                target.setCaretPosotion(docLength - 1, docLength, 0);
            }
        }
    }

    static class DeleteAction
    extends TextAction {
        private static final long serialVersionUID = -6050511940953130037L;

        public DeleteAction() {
            super("delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DateTimeTextField2 target = (DateTimeTextField2)this.getTextComponent(e);
            if (target != null) {
                int begin = target.getSelectionStart();
                target.replaceText("0", begin);
            }
        }
    }

    static class DefaultKeyTypedAction
    extends TextAction {
        private static final long serialVersionUID = 2679787832235114446L;

        public DefaultKeyTypedAction() {
            super("default-typed");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DateTimeTextField2 target = (DateTimeTextField2)this.getTextComponent(e);
            if (target != null && e != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    return;
                }
                String content = e.getActionCommand();
                int mod = e.getModifiers();
                if (content != null && content.length() > 0 && (mod & 8) == (mod & 2)) {
                    int begin;
                    char c = content.charAt(0);
                    boolean valid = false;
                    if (c >= '0' && c <= '9' && target.checkValidChar(begin = target.getSelectionStart(), c)) {
                        String s = target.getText();
                        char[] temp = s.toCharArray();
                        temp[begin] = c;
                        s = new String(temp);
                        if (target.checkValidDate(s)) {
                            target.replaceText(content, begin + 1);
                            valid = true;
                        }
                    }
                    if (!valid) {
                        UIManager.getLookAndFeel().provideErrorFeedback(target);
                    }
                }
            }
        }
    }

    class CaretHandle
    implements CaretListener {
        CaretHandle() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            int end;
            if (!DateTimeTextField2.this.fireCarentEvent) {
                return;
            }
            int docLength = DateTimeTextField2.this.getDocument().getLength();
            if (docLength != 10) {
                return;
            }
            int begin = e.getMark();
            if (begin == (end = e.getDot())) {
                ++end;
                if (begin >= docLength) {
                    begin = docLength - 1;
                    end = docLength;
                }
                DateTimeTextField2.this.setCaretPosotion(begin, end, 0);
            }
        }
    }
}

