/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.util.CtrlImageUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;

public class KDArrowButton
extends BasicArrowButton {
    private static final long serialVersionUID = -421826626940879404L;
    private Dimension selfPreDim = null;
    private Icon initIcon = null;
    private Icon activeIcon = null;
    private Icon mouseOverIcon = null;
    private boolean isRollover = false;
    private Icon deactiveIcon = null;
    private Color lineCol = null;
    private int iconWidth = 0;
    private int iconHeight = 0;
    public static final int LITTLE_ARROW = 100;
    private Insets customInsets = null;

    public void setInitIcon(Icon icon) {
        this.initIcon = icon;
    }

    public void setActiveIcon(Icon icon) {
        this.activeIcon = icon;
    }

    public void setDeactiveIcon(Icon icon) {
        this.deactiveIcon = icon;
    }

    public void setMouseOverIcon(Icon icon) {
        this.mouseOverIcon = icon;
    }

    private void setRollover(boolean rollover) {
        if (this.isRollover == rollover) {
            return;
        }
        this.isRollover = rollover;
    }

    public KDArrowButton(int direction, Color background, Color shadow, Color darkShadow, Color highlight) {
        super(direction, background, shadow, darkShadow, highlight);
        this.initData();
        this.addRolloverListener();
    }

    public KDArrowButton(int direction) {
        super(direction);
        this.initData();
        this.addRolloverListener();
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public void setDirection(int newValue) {
        if (newValue != this.getDirection()) {
            super.setDirection(newValue);
            this.initIcon = null;
            this.activeIcon = null;
            this.deactiveIcon = null;
            this.mouseOverIcon = null;
            this.initData();
        }
    }

    private void addRolloverListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                KDArrowButton selfArrow = (KDArrowButton)e.getSource();
                selfArrow.setRollover(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                KDArrowButton selfArrow = (KDArrowButton)e.getSource();
                selfArrow.setRollover(false);
            }
        });
    }

    private void initData() {
        this.setFocusable(false);
        switch (this.getDirection()) {
            case 1: {
                if (this.initIcon == null) {
                    this.initIcon = (ImageIcon)UIManager.getIcon("ArrowButton.upInitIcon");
                    this.iconWidth = this.initIcon.getIconWidth();
                    this.iconHeight = this.initIcon.getIconHeight();
                }
                if (this.activeIcon == null) {
                    this.activeIcon = UIManager.getIcon("ArrowButton.upActivieIcon");
                }
                if (this.deactiveIcon == null) {
                    this.deactiveIcon = UIManager.getIcon("ArrowButton.upDeactivieIcon");
                }
                if (this.mouseOverIcon != null) break;
                this.mouseOverIcon = UIManager.getIcon("ArrowButton.upMouseOverIcon");
                break;
            }
            case 100: {
                if (this.initIcon == null) {
                    this.initIcon = (ImageIcon)UIManager.getIcon("ArrowButton.littleInitIcon");
                }
                if (this.activeIcon == null) {
                    this.activeIcon = this.initIcon;
                    this.iconWidth = this.initIcon.getIconWidth();
                    this.iconHeight = this.initIcon.getIconHeight();
                }
                if (this.deactiveIcon == null) {
                    this.deactiveIcon = CtrlImageUtilities.createDisableIcon(this.initIcon);
                }
                if (this.mouseOverIcon != null) break;
                this.mouseOverIcon = UIManager.getIcon("ArrowButton.littleMouseOverIcon");
                break;
            }
            default: {
                if (this.initIcon == null) {
                    this.initIcon = (ImageIcon)UIManager.getIcon("ArrowButton.initIcon");
                    this.iconWidth = this.initIcon.getIconWidth();
                    this.iconHeight = this.initIcon.getIconHeight();
                }
                if (this.activeIcon == null) {
                    this.activeIcon = UIManager.getIcon("ArrowButton.activieIcon");
                }
                if (this.deactiveIcon == null) {
                    this.deactiveIcon = UIManager.getIcon("ArrowButton.deactivieIcon");
                }
                if (this.mouseOverIcon != null) break;
                this.mouseOverIcon = UIManager.getIcon("ArrowButton.mouseOverIcon");
            }
        }
        this.lineCol = Color.decode("#D9D9D0");
    }

    @Override
    public void setPreferredSize(Dimension newVal) {
        this.selfPreDim = newVal;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.selfPreDim != null) {
            return this.selfPreDim;
        }
        if (this.getDirection() == 100) {
            // empty if block
        }
        return new Dimension(18, 18);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    @Override
    public void paint(Graphics g) {
        if (this.activeIcon != null) {
            g.setColor(this.lineCol);
            int w = this.getWidth();
            int h = this.getHeight();
            int x = w > this.iconWidth ? (w - this.iconWidth) / 2 : 0;
            int y = h > this.iconHeight ? (h - this.iconHeight) / 2 : 0;
            boolean isPressed = this.getModel().isPressed();
            if (this.isEnabled()) {
                if (this.getParent() instanceof KDComboBox) {
                    if (this.isRollover) {
                        this.mouseOverIcon.paintIcon(this, g, x, y);
                    } else {
                        this.initIcon.paintIcon(this, g, x, y);
                    }
                } else if (isPressed) {
                    this.activeIcon.paintIcon(this, g, x, y);
                } else if (this.isRollover) {
                    this.mouseOverIcon.paintIcon(this, g, x, y);
                } else {
                    this.initIcon.paintIcon(this, g, x, y);
                }
            } else {
                this.deactiveIcon.paintIcon(this, g, x, y);
            }
        } else {
            super.paint(g);
        }
    }
}

