/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.ButtonActionPropertyListenerEx;
import com.kingdee.cosmic.ctrl.swing.ButtonPropertyConfigurer;
import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.StringUtils;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;

public class KDButton
extends JButton
implements IKDComponent {
    private static final long serialVersionUID = -6658667394732634201L;
    protected Object userObject = null;
    private static final int MAX_WIDTH = 149;
    private static final int MAX_HEIGHT = 21;
    private static final int MIN_WIDTH = 73;
    private static final int MIN_HEIGHT = 21;
    private Dimension selfMaxSize = null;
    private Dimension selfMinSize = null;
    private Dimension selfPreferredSize = null;
    private boolean limitedSize = true;
    private Insets customInsets;
    private boolean autoToolTipText;

    public KDButton() {
        this.init();
    }

    public KDButton(Icon icon) {
        super(icon);
        this.init();
    }

    public KDButton(String text) {
        super(text);
        this.init();
    }

    public KDButton(Action a) {
        super(a);
        this.init();
    }

    @Override
    protected void processMouseEvent(MouseEvent me) {
        if (CtrlSwingUtilities.runCtrlInputVerifier(this)) {
            super.processMouseEvent(me);
        }
    }

    public KDButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    private void init() {
        this.setLimitedSize(true);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 0));
        this.setAutoToolTipText(true);
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void setPreferredSize(Dimension newValue) {
        if (!this.isLimitedSize()) {
            super.setPreferredSize(newValue);
        }
        if (newValue != null) {
            this.selfPreferredSize = newValue;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isLimitedSize()) {
            if (this.selfPreferredSize != null) {
                return this.selfPreferredSize;
            }
            return super.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    @Override
    public void setMaximumSize(Dimension newValue) {
        if (!this.isLimitedSize()) {
            super.setMaximumSize(newValue);
        }
        if (newValue != null) {
            this.selfMaxSize = newValue;
        }
    }

    @Override
    public Dimension getMaximumSize() {
        if (!this.isLimitedSize()) {
            if (this.selfMaxSize != null) {
                return this.selfMaxSize;
            }
            return super.getMaximumSize();
        }
        return new Dimension(149, 21);
    }

    @Override
    public void setMinimumSize(Dimension newValue) {
        if (!this.isLimitedSize()) {
            super.setMinimumSize(newValue);
        }
        if (newValue != null) {
            this.selfMinSize = newValue;
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (!this.isLimitedSize()) {
            if (this.selfMinSize != null) {
                return this.selfMinSize;
            }
            return super.getMinimumSize();
        }
        return new Dimension(73, 21);
    }

    public boolean isLimitedSize() {
        return this.limitedSize;
    }

    public void setLimitedSize(boolean b) {
        this.limitedSize = false;
    }

    @Override
    public void setBounds(Rectangle r) {
        if (!this.isLimitedSize()) {
            super.setBounds(r);
            return;
        }
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (!this.isLimitedSize()) {
            super.setBounds(x, y, width, height);
            return;
        }
        Dimension tempD = this.getSelfSize(new Dimension(width, height));
        super.setBounds(x, y, tempD.width, tempD.height);
    }

    @Override
    public void setSize(int width, int height) {
        if (!this.isLimitedSize()) {
            super.setSize(width, height);
            return;
        }
        Dimension tempD = this.getSelfSize(new Dimension(width, height));
        super.setSize(tempD.width, tempD.height);
    }

    @Override
    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new ButtonActionPropertyListenerEx(this, a);
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        ButtonPropertyConfigurer.configure(this, a);
    }

    private Dimension getSelfPreferredSize() {
        Dimension dim;
        if (this.ui != null && (dim = this.ui.getPreferredSize(this)) != null) {
            return dim;
        }
        return new Dimension(149, 21);
    }

    private Dimension getSelfSize(Dimension newValue) {
        if (newValue != null) {
            int tempW = newValue.width;
            int tempH = newValue.height;
            if (tempW > 149) {
                tempW = 149;
            } else if (tempW < 73) {
                tempW = 73;
            }
            if (tempH > 21) {
                tempH = 21;
            } else if (tempH < 21) {
                tempH = 21;
            }
            return new Dimension(tempW, tempH);
        }
        return this.getSelfPreferredSize();
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public String getToolTipText() {
        if (!this.autoToolTipText) {
            String str = super.getToolTipText();
            if (StringUtils.isEmpty(str)) {
                str = null;
            }
            return str;
        }
        String str = super.getToolTipText();
        if (StringUtils.isEmpty(str)) {
            str = this.getText();
        }
        return str;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.getToolTipText();
    }

    public void setAutoToolTipText(boolean auto) {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (auto) {
            toolTipManager.registerComponent(this);
        } else {
            toolTipManager.unregisterComponent(this);
        }
        this.autoToolTipText = auto;
    }

    public boolean isAutoToolTipText() {
        return this.autoToolTipText;
    }
}

