/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.ButtonActionPropertyListenerEx;
import com.kingdee.cosmic.ctrl.swing.DefaultCtrlComponentSize;
import com.kingdee.cosmic.ctrl.swing.IBoundLabelControl;
import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.IKDTextComponent;
import com.kingdee.cosmic.ctrl.swing.KDComboBoxMultiColumnItem;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.plaf.KDComboBoxMultiColumnRenderer;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeComboBoxUI;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.cosmic.ctrl.swing.util.TextComponentUtilities;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;

public class KDComboBox
extends JComboBox
implements IKDComponent,
IBoundLabelControl,
IKDTextComponent {
    private static final long serialVersionUID = -1327770233611747050L;
    protected Object userObject = null;
    protected KDLabelContainer kdLabelContainer;
    private ActionListener appendButtonHandler;
    private boolean limitedSize = true;
    private Insets customInsets;
    private boolean required = false;
    private boolean readOnly = false;
    private boolean editable = false;
    private boolean isControlKey = false;
    private boolean autoFocusNextComponent = true;
    private boolean appendButtonVisible = false;
    private boolean firelistener = true;

    public KDComboBox() {
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 0));
        TextComponentUtilities.storeOriginalData(this);
        this.adjustDimension();
    }

    public KDComboBox(Object[] items) {
        super(items);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 0));
        TextComponentUtilities.storeOriginalData(this);
        this.adjustDimension();
    }

    public KDComboBox(Vector items) {
        super(items);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 0));
        TextComponentUtilities.storeOriginalData(this);
        this.adjustDimension();
    }

    public KDComboBox(ComboBoxModel aModel) {
        super(aModel);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 0));
        TextComponentUtilities.storeOriginalData(this);
        this.adjustDimension();
    }

    public void adjustDimension() {
        this.setPreferredSize(new Dimension(this.getComboPopupWidth(), 20));
    }

    public ListCellRenderer getRenderer() {
        if (this.getItemCount() == 0) {
            return this.renderer;
        }
        Object item = this.getItemAt(0);
        if (item instanceof KDComboBoxMultiColumnItem && !(this.renderer instanceof KDComboBoxMultiColumnRenderer)) {
            this.renderer = new KDComboBoxMultiColumnRenderer();
        }
        return this.renderer;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (TextComponentUtilities.setEnabled(this, enabled)) {
            super.setEnabled(enabled);
        }
    }

    @Override
    public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
        anEditor.setItem(anItem);
    }

    @Override
    public void setPreferredSize(Dimension newValue) {
        if (newValue != null && this.isLimitedSize()) {
            newValue.height = 19;
        }
        super.setPreferredSize(newValue);
    }

    public void setAppendButtonHandler(ActionListener appendButtonHandler) {
        if (!this.appendButtonVisible) {
            return;
        }
        ActionListener oldAppendButtonHandler = this.appendButtonHandler;
        this.appendButtonHandler = appendButtonHandler;
        this.firePropertyChange("appendButtonHandler", oldAppendButtonHandler, appendButtonHandler);
    }

    public ActionListener getAppendButtonHandler() {
        return this.appendButtonHandler;
    }

    public void setAppendButtonVisible(boolean visible) {
        ((KingdeeComboBoxUI)this.ui).setAppendButtonVisible(visible);
        this.appendButtonVisible = visible;
    }

    public boolean isAppendButtonVisible() {
        return this.appendButtonVisible;
    }

    public void setComboPopupWidth(int pixel) {
        if (this.isLimitedSize()) {
            return;
        }
        ((KingdeeComboBoxUI)this.ui).setComboPopupWidth(pixel);
    }

    public int getComboPopupWidth() {
        if (this.isLimitedSize()) {
            return DefaultCtrlComponentSize.getComboBoxDefaultPreSize().width;
        }
        return ((KingdeeComboBoxUI)this.ui).getComboPopupWidth();
    }

    public boolean isAutoFocusNextComponent() {
        return this.autoFocusNextComponent;
    }

    public void setAutoFocusNextComponent(boolean autoFocusNextComponent) {
        this.autoFocusNextComponent = autoFocusNextComponent;
    }

    public void setLimitedSize(boolean newValue) {
        boolean old = this.limitedSize;
        if (old != newValue) {
            this.limitedSize = newValue;
            this.firePropertyChange("limitedSize", (Object)old, (Object)this.limitedSize);
        }
    }

    public boolean isLimitedSize() {
        return this.limitedSize;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setEditable(boolean editable) {
        if (TextComponentUtilities.setEditable(this, editable)) {
            super.setEditable(editable);
            boolean oldValue = this.editable;
            this.editable = editable;
            this.firePropertyChange("editable", (Object)oldValue, (Object)editable);
        }
    }

    @Override
    public void setRequired(boolean required) {
        boolean oldValue = this.required;
        this.required = required;
        this.firePropertyChange("required", (Object)oldValue, (Object)required);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        boolean oldValue = this.readOnly;
        this.readOnly = readOnly;
        this.firePropertyChange("readOnly", (Object)oldValue, (Object)readOnly);
    }

    public boolean isCanSearch() {
        return ((KingdeeComboBoxUI)this.ui).isCanSearch();
    }

    public void setCanSearch(boolean canSearch) {
        this.setEditable(true);
        ((KingdeeComboBoxUI)this.ui).setCanSearch(canSearch);
    }

    @Override
    public Object getSelectedItem() {
        return super.getSelectedItem();
    }

    public Object getShowSelectedItem() {
        return super.getSelectedItem();
    }

    @Override
    public void setAccessAuthority(int authority) {
        TextComponentUtilities.setAccessAuthority(this, authority);
    }

    @Override
    public int getAccessAuthority() {
        return TextComponentUtilities.getAccessAuthority(this);
    }

    public void addItem(Object obj) {
        if (obj == null) {
            return;
        }
        if (this.getItemCount() > 1 && obj instanceof KDComboBoxMultiColumnItem && !(this.renderer instanceof KDComboBoxMultiColumnRenderer)) {
            this.setRenderer(new KDComboBoxMultiColumnRenderer());
        }
        super.addItem(obj);
    }

    public void addItem(Object obj, boolean firelistener) {
        if (obj == null) {
            return;
        }
        if (this.getItemCount() > 1 && obj instanceof KDComboBoxMultiColumnItem && !(this.renderer instanceof KDComboBoxMultiColumnRenderer)) {
            this.setRenderer(new KDComboBoxMultiColumnRenderer());
        }
        this.firelistener = firelistener;
        super.addItem(obj);
        this.firelistener = true;
    }

    public void addItems(Object[] obj) {
        if (obj == null || obj.length == 0) {
            return;
        }
        int len = obj.length;
        for (int i = 0; i < len; ++i) {
            this.addItem(obj[i]);
        }
    }

    public void addItems(Object[] obj, boolean firelistener) {
        if (obj == null || obj.length == 0) {
            return;
        }
        int len = obj.length;
        this.firelistener = firelistener;
        for (int i = 0; i < len; ++i) {
            this.addItem(obj[i]);
        }
        this.firelistener = true;
    }

    public void addItems(Vector vec) {
        if (vec == null || vec.size() <= 0) {
            return;
        }
        this.addItems(vec.toArray());
    }

    public void insertItemsAt(Object[] obj, int index) {
        if (obj == null || obj.length == 0) {
            return;
        }
        int len = obj.length;
        for (int i = 0; i < len; ++i) {
            this.insertItemAt(obj[i], index);
            ++index;
        }
    }

    public void insertItemsAt(Vector vec, int index) {
        if (vec == null || vec.size() <= 0) {
            return;
        }
        this.insertItemsAt(vec.toArray(), index);
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void setLabelContainer(KDLabelContainer kdLabelContainer) {
        this.kdLabelContainer = kdLabelContainer;
    }

    @Override
    public KDLabelContainer getLabelContainer() {
        return this.kdLabelContainer;
    }

    @Override
    public void setBoundLabel(JLabel label) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabel(label);
        }
    }

    @Override
    public JLabel getBoundLabel() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabel();
        }
        return null;
    }

    @Override
    public void setBoundLabelAlignment(int alignment) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelAlignment(alignment);
        }
    }

    @Override
    public int getBoundLabelAlignment() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelAlignment();
        }
        return 7;
    }

    @Override
    public void setBoundLabelLength(int len) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelLength(len);
        }
    }

    @Override
    public int getBoundLabelLength() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelLength();
        }
        return 0;
    }

    @Override
    public void setBoundLabelText(String labelText) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelText(labelText);
        }
    }

    @Override
    public String getBoundLabelText() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelText();
        }
        return "";
    }

    @Override
    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new ButtonActionPropertyListenerEx(this, a){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Boolean visibleState;
                String propertyName = e.getPropertyName();
                JComboBox comboBox = (JComboBox)this.getTarget();
                if (comboBox == null) {
                    Action action = (Action)e.getSource();
                    action.removePropertyChangeListener(this);
                } else if (e.getPropertyName().equals("ShortDescription")) {
                    String text = (String)e.getNewValue();
                    comboBox.setToolTipText(text);
                } else if (propertyName.equals("enabled")) {
                    Boolean enabledState = (Boolean)e.getNewValue();
                    comboBox.setEnabled(enabledState);
                    comboBox.repaint();
                } else if (propertyName.equals("visible") && (visibleState = (Boolean)e.getNewValue()) != null) {
                    comboBox.setVisible(visibleState);
                }
            }
        };
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        Boolean objValue;
        this.setEnabled(a != null ? a.isEnabled() : true);
        this.setToolTipText(a != null ? (String)a.getValue("ShortDescription") : null);
        boolean value = true;
        if (a != null && (objValue = (Boolean)a.getValue("visible")) != null) {
            value = objValue;
        }
        this.setVisible(value);
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    public boolean isControlKey() {
        return this.isControlKey;
    }

    public void setControlKey(boolean isControlKey) {
        this.isControlKey = isControlKey;
    }

    @Override
    protected void selectedItemChanged() {
        if (!this.firelistener) {
            return;
        }
        super.selectedItemChanged();
    }

    @Override
    protected void fireActionEvent() {
        if (!this.firelistener) {
            return;
        }
        super.fireActionEvent();
    }

    public void setSelectedItem(Object anObject, boolean fireListener) {
        if (!fireListener) {
            this.firelistener = false;
            this.setSelectedItem(anObject);
            this.firelistener = true;
        } else {
            this.setSelectedItem(anObject);
        }
    }

    public void setSelectedIndex(int anIndex, boolean fireListener) {
        int size = this.dataModel.getSize();
        if (anIndex == -1) {
            this.setSelectedItem(null, fireListener);
        } else {
            if (anIndex < -1 || anIndex >= size) {
                throw new IllegalArgumentException("setSelectedIndex: " + anIndex + " out of bounds");
            }
            this.setSelectedItem(this.dataModel.getElementAt(anIndex), fireListener);
        }
    }

    public ComboBoxModel getDataModel() {
        return this.dataModel;
    }

    public void validateInputValue() {
        if (this.ui != null && this.ui instanceof KingdeeComboBoxUI) {
            ((KingdeeComboBoxUI)this.ui).validateInputValue();
        }
    }
}

