/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import com.kingdee.cosmic.ctrl.swing.resource.KDResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

public class KDComponentDialog
extends KDDialog {
    public static final int OK_CANCEL_STYLE = 0;
    public static final int CANCEL_CUSTOM_STYLE = 1;
    public static final int CUSTOM_STYLE = 2;
    private static final long serialVersionUID = 4935401178359267835L;
    private static final int OK_RET = 0;
    private static final int CANCEL_RET = 1;
    private static final Insets insets = new Insets(10, 10, 10, 10);
    private KDSeparator separator;
    private KDPanel btnPanel;
    private KDButton okBtn;
    private KDButton cancelBtn;
    private List buttons;
    private Component dialogComponent;
    private int LFStyle = 0;
    private ActionListener actionListener;
    private int result;

    public KDComponentDialog() {
        this.init();
    }

    public KDComponentDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public KDComponentDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public KDComponentDialog(Frame owner, String title) {
        super(owner, title);
        this.init();
    }

    public KDComponentDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    public KDComponentDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    public KDComponentDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public KDComponentDialog(Dialog owner, String title) {
        super(owner, title);
        this.init();
    }

    public KDComponentDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    public KDComponentDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init();
    }

    public KDComponentDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init();
    }

    public int getLFStyle() {
        return this.LFStyle;
    }

    public void setLFStyle(int style) {
        this.LFStyle = style;
    }

    public Component getDialogComponent() {
        return this.dialogComponent;
    }

    public void setDialogComponent(Component comp) {
        if (comp != this.dialogComponent) {
            if (this.dialogComponent != null) {
                this.getContentPane().remove(this.dialogComponent);
            }
            this.dialogComponent = comp;
            if (comp != null) {
                this.getContentPane().add(comp);
            }
        }
    }

    public void addButton(KDButton btn) {
        if (this.buttons != null) {
            this.buttons.add(btn);
            this.btnPanel.add(btn);
        }
    }

    public List getButtons() {
        return this.buttons;
    }

    public KDButton getButton(int index) {
        if (this.buttons != null && index > 0 && index < this.buttons.size()) {
            return (KDButton)this.buttons.get(index);
        }
        return null;
    }

    public void removeButton(KDButton btn) {
        if (this.buttons != null) {
            this.buttons.remove(btn);
        }
    }

    public void removeButton(int index) {
        if (this.buttons != null) {
            this.buttons.remove(index);
        }
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    private void init() {
        this.buttons = new ArrayList();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new ComponentDialogLayout());
        this.separator = new KDSeparator();
        this.separator.setOrientation(0);
        this.btnPanel = new KDPanel();
        this.btnPanel.setLayout(new ButtonPanelLayout());
        this.okBtn = new KDButton(KDResourceManager.getMLS("ok", "\u786e\u5b9a"));
        this.okBtn.setActionCommand("ok");
        this.cancelBtn = new KDButton(KDResourceManager.getMLS("cancel", "\u53d6\u6d88"));
        this.cancelBtn.setActionCommand("cancel");
        this.btnPanel.add("okBtn", this.okBtn);
        this.btnPanel.add("cancelBtn", this.cancelBtn);
        this.getContentPane().add("separator", this.separator);
        this.getContentPane().add("btnPanel", this.btnPanel);
        this.actionListener = new DefaultActionListener();
        this.okBtn.addActionListener(this.actionListener);
        this.cancelBtn.addActionListener(this.actionListener);
    }

    private class DefaultActionListener
    implements ActionListener {
        private DefaultActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("ok")) {
                KDComponentDialog.this.setResult(0);
                KDComponentDialog.this.dispose();
            } else if (e.getActionCommand().equals("cancel")) {
                KDComponentDialog.this.setResult(1);
                KDComponentDialog.this.dispose();
            }
        }
    }

    private class ButtonPanelLayout
    implements LayoutManager {
        private Component okBtn;
        private Component cancelBtn;

        private ButtonPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if ("okBtn".equals(name)) {
                this.okBtn = comp;
            }
            if ("cancelBtn".equals(name)) {
                this.cancelBtn = comp;
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            block3: {
                block4: {
                    block2: {
                        if (KDComponentDialog.this.getLFStyle() != 0) break block2;
                        int x = parent.getWidth() - 10 - this.cancelBtn.getPreferredSize().width;
                        int y = 10;
                        this.cancelBtn.setBounds(x, y, this.cancelBtn.getPreferredSize().width, 21);
                        x = x - 3 - this.okBtn.getPreferredSize().width;
                        this.okBtn.setBounds(x, y, this.okBtn.getPreferredSize().width, 21);
                        break block3;
                    }
                    if (KDComponentDialog.this.getLFStyle() != 1) break block4;
                    int x = parent.getWidth() - insets.right - this.cancelBtn.getPreferredSize().width;
                    int y = insets.top;
                    this.cancelBtn.setBounds(x, y, this.cancelBtn.getPreferredSize().width, 21);
                    List buttons = KDComponentDialog.this.getButtons();
                    for (int i = 0; i < buttons.size(); ++i) {
                        Component comp = (Component)buttons.get(i);
                        if (!comp.isVisible()) continue;
                        x = x - 3 - comp.getPreferredSize().width;
                        comp.setBounds(x, y, comp.getPreferredSize().width, 21);
                    }
                    break block3;
                }
                if (KDComponentDialog.this.getLFStyle() != 2) break block3;
                int x = parent.getWidth() - 7;
                int y = 10;
                List buttons = KDComponentDialog.this.getButtons();
                for (int i = 0; i < buttons.size(); ++i) {
                    Component comp = (Component)buttons.get(i);
                    if (!comp.isVisible()) continue;
                    x = x - 3 - comp.getPreferredSize().width;
                    comp.setBounds(x, y, comp.getPreferredSize().width, 21);
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    private class ComponentDialogLayout
    implements LayoutManager {
        Component separator;
        Component btnPanel;

        private ComponentDialogLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if ("dialogComponent".equals(name)) {
                // empty if block
            }
            if ("separator".equals(name)) {
                this.separator = comp;
            }
            if ("btnPanel".equals(name)) {
                this.btnPanel = comp;
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            this.btnPanel.setBounds(0, parent.getHeight() - 41, parent.getWidth(), 41);
            this.separator.setBounds(0, parent.getHeight() - 43, parent.getWidth(), 2);
            Component comp = KDComponentDialog.this.getDialogComponent();
            if (comp != null && comp.isVisible()) {
                Dimension preSize = comp.getPreferredSize();
                int temp = parent.getWidth() - insets.left - insets.right;
                int width = preSize.width >= temp ? temp : preSize.width;
                temp = parent.getHeight() - insets.top - insets.bottom - 43;
                int height = preSize.height >= temp ? temp : preSize.height;
                comp.setBounds(10, 10, width, height);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

