/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.common.variant.Util;
import com.kingdee.cosmic.ctrl.swing.IKDEditor;
import com.kingdee.cosmic.ctrl.swing.event.DataChangeEvent;
import com.kingdee.cosmic.ctrl.swing.event.DataChangeListener;
import com.kingdee.cosmic.ctrl.swing.model.CurrencyEditorModel;
import com.kingdee.cosmic.ctrl.swing.model.ICurrencyEditorModel;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeCurrencyEditorUI;
import java.awt.Dimension;
import java.awt.Insets;
import java.math.BigDecimal;
import javax.swing.JComponent;

public class KDCurrencyEditor
extends JComponent
implements IKDEditor {
    public static final int MIN_INTEGER_DIGIT = 9;
    public static final int MAX_INTEGER_DIGIT = 15;
    public static final int MIN_DECIMAL_DIGIT = 2;
    public static final int MAX_DECIMAL_DIGIT = 4;
    private KingdeeCurrencyEditorUI ui = new KingdeeCurrencyEditorUI();
    private ICurrencyEditorModel model;
    private ModelDataChangeListener mdcl = new ModelDataChangeListener();
    private int integerDigitCount = 15;
    private int decimalDigitCount = 2;
    private boolean allowMinus = true;

    public KDCurrencyEditor() {
        this(15, 2);
    }

    public KDCurrencyEditor(int integerDigitCount, int decimalDigitCount) {
        this.integerDigitCount = integerDigitCount;
        this.decimalDigitCount = decimalDigitCount;
        this.createModel();
        this.model.addModelChangeListener(this.mdcl);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI(this.ui);
    }

    @Override
    public KingdeeCurrencyEditorUI getUI() {
        return this.ui;
    }

    public void resetTrianglePosition() {
        if (this.ui != null) {
            this.ui.resetTrianglePosition();
        }
    }

    protected void createModel() {
        this.model = new CurrencyEditorModel();
    }

    public ICurrencyEditorModel getModel() {
        return this.model;
    }

    public void setIntegerDigitCount(int integerDigitCount) {
        this.integerDigitCount = integerDigitCount;
        this.repaint();
    }

    public void setDecimalDigitCount(int decimalDigitCount) {
        this.decimalDigitCount = decimalDigitCount;
        this.repaint();
    }

    public int getIntegerDigitCount() {
        return this.integerDigitCount;
    }

    public int getDecimalDigitCount() {
        return this.decimalDigitCount;
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(150, 40);
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof String) {
            this.model.setValue(new BigDecimal(this.getFormattedString((String)value)));
        } else if (value instanceof BigDecimal) {
            this.model.setValue(new BigDecimal(this.getFormattedString(Util.bigDecimalToPlainString((BigDecimal)((BigDecimal)value)))));
        } else if (value == null) {
            this.model.setValue(null);
        }
    }

    @Override
    public Object getValue() {
        return this.model.getValue();
    }

    @Override
    public void setDisplay(boolean isDisplay) {
        this.setVisible(isDisplay);
    }

    @Override
    public boolean isDisplay() {
        return this.isVisible();
    }

    public void setAllowMinus(boolean allowMinus) {
        this.allowMinus = allowMinus;
        BigDecimal value = (BigDecimal)this.getValue();
        if (value != null && value.signum() < 0) {
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isAllowMinus() {
        return this.allowMinus;
    }

    @Override
    public void addDataChangeListener(DataChangeListener listener) {
        this.model.addModelChangeListener(listener);
    }

    @Override
    public void removeDataChangeListener(DataChangeListener listener) {
        this.model.removeModelChangeListener(listener);
    }

    private String getFormattedString(String origin) {
        if ("".equals(origin)) {
            return "0";
        }
        String[] splittedStrings = origin.split("\\.");
        int sign = 1;
        String integerDigits = splittedStrings[0];
        if (integerDigits.charAt(0) == '-') {
            sign = -1;
            integerDigits = integerDigits.substring(1);
        }
        String decimalDigits = "";
        if (splittedStrings.length > 1) {
            decimalDigits = splittedStrings[1];
        }
        if (integerDigits.length() > this.integerDigitCount) {
            integerDigits = integerDigits.substring(integerDigits.length() - this.integerDigitCount);
        }
        if (decimalDigits.length() > this.decimalDigitCount) {
            decimalDigits = decimalDigits.substring(0, this.decimalDigitCount);
        }
        StringBuilder sb = new StringBuilder();
        if (sign < 0) {
            sb.append('-');
        }
        sb.append(integerDigits);
        sb.append('.');
        sb.append(decimalDigits);
        return sb.toString();
    }

    public boolean isNegative() {
        return this.model.isNegative();
    }

    public void setNegative(boolean negative) {
        this.model.setNegative(negative);
    }

    private class ModelDataChangeListener
    implements DataChangeListener {
        private ModelDataChangeListener() {
        }

        @Override
        public void dataChanged(DataChangeEvent eventObj) {
            KDCurrencyEditor.this.revalidate();
            KDCurrencyEditor.this.repaint();
        }
    }
}

