/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.DefaultKingdeeListCellRenderer;
import com.kingdee.cosmic.ctrl.swing.IBoundLabelControl;
import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.StringUtils;
import com.kingdee.cosmic.ctrl.swing.model.KingdeeListModel;
import com.kingdee.cosmic.ctrl.swing.model.KingdeeListSelectionModel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;

public class KDList
extends JList
implements IKDComponent,
IBoundLabelControl {
    private static final long serialVersionUID = 3902200182187298568L;
    protected Object userObject = null;
    protected KDLabelContainer kdLabelContainer;
    public static final int MAINTAIN_FOCUSCOL = 0;
    public static final int LOSING_FOCUSCOL = 1;
    private int focusOperateMode = 0;
    public static final int COMMON_BORDER = 3;
    public static final int MAINUI_BORDER = 4;
    private int cellBorderModal = 3;
    private Insets customInsets;
    private boolean allowAutoToolTipText = false;

    public KDList(ListModel dataModel) {
        super(dataModel);
        this.setCellRenderer(new DefaultKingdeeListCellRenderer());
    }

    public KDList(Object[] listData) {
        this.init(listData);
    }

    public KDList(Vector listData) {
        super(listData);
        this.init(listData.toArray());
    }

    public KDList() {
        this.init(null);
    }

    private void init(Object[] listData) {
        KingdeeListModel model = new KingdeeListModel();
        this.setModel(model);
        if (listData != null) {
            for (int i = 0; i < listData.length; ++i) {
                this.addElement(listData[i]);
            }
            model.trimToSize();
        }
        this.setCellRenderer(new DefaultKingdeeListCellRenderer());
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void setLabelContainer(KDLabelContainer kdLabelContainer) {
        this.kdLabelContainer = kdLabelContainer;
    }

    @Override
    public KDLabelContainer getLabelContainer() {
        return this.kdLabelContainer;
    }

    @Override
    public void setBoundLabel(JLabel label) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabel(label);
        }
    }

    @Override
    public JLabel getBoundLabel() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabel();
        }
        return null;
    }

    @Override
    public void setBoundLabelAlignment(int alignment) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelAlignment(alignment);
        }
    }

    @Override
    public int getBoundLabelAlignment() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelAlignment();
        }
        return 7;
    }

    @Override
    public void setBoundLabelLength(int len) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelLength(len);
        }
    }

    @Override
    public int getBoundLabelLength() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelLength();
        }
        return 0;
    }

    @Override
    public void setBoundLabelText(String labelText) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelText(labelText);
        }
    }

    @Override
    public String getBoundLabelText() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelText();
        }
        return "";
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    public void addElement(Object elem) {
        if (this.getModel() instanceof DefaultListModel) {
            ((DefaultListModel)this.getModel()).addElement(elem);
        }
    }

    public void insertElement(Object elem, int index) {
        if (this.getModel() instanceof DefaultListModel) {
            ((DefaultListModel)this.getModel()).insertElementAt(elem, index);
        }
    }

    public Object setElement(Object elem, int index) {
        if (this.getModel() instanceof DefaultListModel) {
            return ((DefaultListModel)this.getModel()).set(index, elem);
        }
        return null;
    }

    public boolean removeElement(Object elem) {
        if (this.getModel() instanceof DefaultListModel) {
            return ((DefaultListModel)this.getModel()).removeElement(elem);
        }
        return false;
    }

    public void removeElementAt(int index) {
        if (this.getModel() instanceof DefaultListModel) {
            ((DefaultListModel)this.getModel()).removeElementAt(index);
        }
    }

    public void removeAllElements() {
        if (this.getModel() instanceof DefaultListModel) {
            ((DefaultListModel)this.getModel()).removeAllElements();
        }
    }

    public Object getElement(int index) {
        if (this.getModel() instanceof DefaultListModel) {
            return ((DefaultListModel)this.getModel()).getElementAt(index);
        }
        return null;
    }

    public void setFocusOperateMode(int newMode) {
        int old = this.focusOperateMode;
        if (old != newMode) {
            if (newMode != 0 && newMode != 1) {
                newMode = 0;
            }
            this.focusOperateMode = newMode;
            this.firePropertyChange("focusOperateMode", (Object)old, (Object)newMode);
        }
    }

    public int getFocusOperateMode() {
        return this.focusOperateMode;
    }

    public int getIndexOfElement(Object elem) {
        if (this.getModel() instanceof DefaultListModel) {
            return ((DefaultListModel)this.getModel()).indexOf(elem);
        }
        return -1;
    }

    public boolean isContainsElement(Object elem) {
        if (this.getModel() instanceof DefaultListModel) {
            return ((DefaultListModel)this.getModel()).contains(elem);
        }
        return false;
    }

    public int getElementCount() {
        return this.getModel().getSize();
    }

    public void setElementIcon(Icon icon, int index) {
        if (this.getModel() instanceof KingdeeListModel) {
            ((KingdeeListModel)this.getModel()).setIcon(icon, index);
        }
    }

    public void setElementIcon(Icon icon, Object elem) {
        if (this.getModel() instanceof KingdeeListModel) {
            ((KingdeeListModel)this.getModel()).setIcon(icon, elem);
        }
    }

    public Icon getElementIcon(int index) {
        if (this.getModel() instanceof KingdeeListModel) {
            return ((KingdeeListModel)this.getModel()).getIcon(index);
        }
        return null;
    }

    public Icon getElementIcon(Object elem) {
        if (this.getModel() instanceof KingdeeListModel) {
            return ((KingdeeListModel)this.getModel()).getIcon(elem);
        }
        return null;
    }

    public void setHorizontalAlignment(int alignment) {
        if (this.getCellRenderer() instanceof JLabel) {
            ((JLabel)((Object)this.getCellRenderer())).setHorizontalAlignment(alignment);
        }
    }

    public void setHorizontalTextPosition(int textPosition) {
        if (this.getCellRenderer() instanceof JLabel) {
            ((JLabel)((Object)this.getCellRenderer())).setHorizontalTextPosition(textPosition);
        }
    }

    @Override
    protected ListSelectionModel createSelectionModel() {
        return new KingdeeListSelectionModel();
    }

    public int getCellBorderModal() {
        return this.cellBorderModal;
    }

    public void setCellBorderModal(int cellBorderModal) {
        this.cellBorderModal = cellBorderModal;
    }

    public void setAllowAutoToolTipText(boolean b) {
        this.allowAutoToolTipText = b;
    }

    public boolean isAllowAutoToolTipText() {
        return this.allowAutoToolTipText;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (!this.isAllowAutoToolTipText()) {
            return super.getToolTipText();
        }
        String tooltip = null;
        int index = this.locationToIndex(event.getPoint());
        if (index != -1) {
            Object value = this.getModel().getElementAt(index);
            ListCellRenderer renderer = this.getCellRenderer();
            Component rendererComp = renderer.getListCellRendererComponent(this, value, index, true, false);
            if (rendererComp.getPreferredSize().width > this.getVisibleRect().width) {
                String string = tooltip = value == null ? null : value.toString();
                if (StringUtils.isEmpty(tooltip)) {
                    tooltip = null;
                }
                return tooltip;
            }
            return null;
        }
        return null;
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        if (!this.isAllowAutoToolTipText()) {
            return super.getToolTipLocation(event);
        }
        int index = this.locationToIndex(event.getPoint());
        if (index != -1) {
            Rectangle cellBounds = this.getCellBounds(index, index);
            return new Point(cellBounds.x, cellBounds.y);
        }
        return null;
    }
}

