/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.swing.DefaultTextField;
import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.IKDEditor;
import com.kingdee.cosmic.ctrl.swing.IKDTextComponent;
import com.kingdee.cosmic.ctrl.swing.ITextLengthLimit;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPromptPopup;
import com.kingdee.cosmic.ctrl.swing.KDPromptSelector;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.StringUtils;
import com.kingdee.cosmic.ctrl.swing.event.CommitEvent;
import com.kingdee.cosmic.ctrl.swing.event.CommitListener;
import com.kingdee.cosmic.ctrl.swing.event.DataChangeEvent;
import com.kingdee.cosmic.ctrl.swing.event.DataChangeListener;
import com.kingdee.cosmic.ctrl.swing.event.DataErrorEvent;
import com.kingdee.cosmic.ctrl.swing.event.DataErrorListener;
import com.kingdee.cosmic.ctrl.swing.event.PreChangeEvent;
import com.kingdee.cosmic.ctrl.swing.event.PreChangeListener;
import com.kingdee.cosmic.ctrl.swing.event.SelectorEvent;
import com.kingdee.cosmic.ctrl.swing.event.SelectorListener;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeePromptBoxUI;
import com.kingdee.cosmic.ctrl.swing.resource.KDResourceManager;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.cosmic.ctrl.swing.util.SwingLogUtil;
import com.kingdee.cosmic.ctrl.swing.util.TextComponentUtilities;
import java.awt.Color;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class KDPromptBox
extends JComponent
implements IKDComponent,
IKDEditor,
IKDTextComponent,
ITextLengthLimit {
    private static final Logger logger = LogUtil.getPackageLogger(KDPromptBox.class);
    private static final long serialVersionUID = -6406059646655137205L;
    private static final String UICLASSID = "PromptBoxUI";
    public static final Object DEFAULTVALUE = new Object();
    public static final Object BADVALUE = new Object();
    public static final int PRECHANGED = 0;
    public static final int PARSED = 1;
    public static final int SELECTORCLOSED = 3;
    protected JTextComponent edt = this.createEditor();
    protected KDLabel label = new KDLabel();
    protected int labelLength = 0;
    protected int editorLength = 100;
    protected boolean labelVisible = false;
    protected boolean required = false;
    protected boolean readOnly = false;
    protected boolean dirty = false;
    protected Object data;
    protected KDPromptSelector selector;
    protected KDPromptPopup downPanel = null;
    private boolean hasDownPanel = false;
    private boolean hasDownPanelSelected = false;
    private boolean hasQuickQueryPanel = false;
    private boolean isQuickQuery = false;
    protected Object userObject = null;
    private String lastInput = "";
    private Insets customInsets;
    private final String DEFAULT_EDITOR_TOOLTIPS = "F7";
    private String editorTooltipsText = null;
    private String buttonTooltipsText = null;
    private boolean autoFocusNextComponent = true;
    private boolean autoAddRow = true;
    private boolean edittedStop = true;
    PopupDownPanelThread popupDownPanelThread = null;
    private boolean hasCommitEdit = false;
    public static final int TOP = 1;
    public static final int CENTER = 2;
    public static final int BOTTOM = 3;
    private int alignment = 1;

    public boolean isAutoAddRow() {
        return this.autoAddRow;
    }

    public void setAutoAddRow(boolean autoAddRow) {
        this.autoAddRow = autoAddRow;
    }

    public boolean isAutoFocusNextComponent() {
        return this.autoFocusNextComponent;
    }

    public void setAutoFocusNextComponent(boolean autoFocusNextComponent) {
        this.autoFocusNextComponent = autoFocusNextComponent;
    }

    public void setHistoryRecordEnabled(boolean b) {
        if (!(this.getEditor() instanceof DefaultEditor)) {
            return;
        }
        DefaultEditor editor = (DefaultEditor)this.getEditor();
        if (b) {
            editor.setAssistorEnabled(true);
            editor.setAssistorMaximumRowCount(100);
        } else {
            editor.setAssistorEnabled(false);
        }
    }

    public void setHistoryRecordName(String name) {
        if (!(this.getEditor() instanceof DefaultEditor)) {
            return;
        }
        DefaultEditor editor = (DefaultEditor)this.getEditor();
        editor.setRecordName(name);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.getEditor() instanceof DefaultEditor) {
            this.getEditor().setName(name);
        }
    }

    public boolean isHistoryRecordEnabled() {
        KDTextField editor = (KDTextField)this.getEditor();
        return editor.isAssistorEnabled();
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public boolean hasDownPanel() {
        return this.hasDownPanel;
    }

    public boolean hasDownPanelSelected() {
        return this.hasDownPanelSelected;
    }

    public boolean isHasQuickQueryPanel() {
        return this.hasQuickQueryPanel;
    }

    public void setHasQuickQueryPanel(boolean hasQuickQueryPanel) {
        this.hasQuickQueryPanel = hasQuickQueryPanel;
    }

    public boolean isQuickQuery() {
        return this.isQuickQuery;
    }

    public void setQuickQuery(boolean isQuickQuery) {
        this.isQuickQuery = isQuickQuery;
    }

    public void setHasDownPanelSelected(boolean hasDownPanelSelected) {
        this.hasDownPanelSelected = hasDownPanelSelected;
    }

    public KDPromptBox() {
        this.label.setForeground(Color.decode("#666666"));
        this.setEditorTooltipsText("F7");
        this.setButtonTooltipsText(null);
        this.setHistoryRecordEnabled(true);
        this.updateUI();
        TextComponentUtilities.storeOriginalData(this);
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    public String getEditorTooltipsText() {
        return this.editorTooltipsText;
    }

    public void setEditorTooltipsText(String editorTooltipsText) {
        this.editorTooltipsText = editorTooltipsText;
        this.setToolTipText(editorTooltipsText);
    }

    public String getButtonTooltipsText() {
        return this.buttonTooltipsText;
    }

    public void setButtonTooltipsText(String buttonTooltipsText) {
        this.buttonTooltipsText = buttonTooltipsText;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (TextComponentUtilities.setEnabled(this, enabled)) {
            super.setEnabled(enabled);
            this.getLabel().setEnabled(true);
        }
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        boolean oldValue = this.required;
        this.required = required;
        if (this.edt instanceof IKDTextComponent) {
            ((IKDTextComponent)((Object)this.edt)).setRequired(required);
            if (required) {
                this.edt.putClientProperty("promptbox", Boolean.TRUE);
            } else {
                this.edt.putClientProperty("promptbox", null);
            }
        }
        this.firePropertyChange("required", (Object)oldValue, (Object)required);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        boolean oldValue = this.readOnly;
        if (this.readOnly != readOnly) {
            if (readOnly) {
                this.putClientProperty("originalEnabled", this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
                this.setEnabled(true);
            } else if (this.getClientProperty("originalEnabled") != null) {
                boolean enabled = (Boolean)this.getClientProperty("originalEnabled");
                this.setEnabled(enabled);
            }
            this.getUI().getButton().setEnabled((Boolean)this.getClientProperty("originalEnabled"));
        }
        this.readOnly = readOnly;
        this.firePropertyChange("readOnly", (Object)oldValue, (Object)readOnly);
    }

    @Override
    public void setAccessAuthority(int authority) {
        if (this.getAccessAuthority() != authority) {
            TextComponentUtilities.setAccessAuthority(this, authority);
        }
    }

    @Override
    public int getAccessAuthority() {
        return TextComponentUtilities.getAccessAuthority(this);
    }

    public boolean isSelectAllOnFocus() {
        return this.edt instanceof KDTextField ? ((DefaultEditor)this.getEditor()).isSelectAllOnFocus() : false;
    }

    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        if (this.edt instanceof KDTextField) {
            ((DefaultEditor)this.getEditor()).setSelectAllOnFocus(selectAllOnFocus);
        }
    }

    protected DefaultEditor createEditor() {
        DefaultEditor tf = new DefaultEditor();
        return tf;
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireActionEvent() {
        ActionEvent actionEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, 1001, this.getText());
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(actionEvent);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        ChangeEvent changeEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
    }

    public void addPreChangeListener(PreChangeListener listener) {
        this.listenerList.add(PreChangeListener.class, listener);
    }

    public void removePreChangeListener(PreChangeListener listener) {
        this.listenerList.remove(PreChangeListener.class, listener);
    }

    public PreChangeListener[] getPreChangeListeners() {
        return (PreChangeListener[])this.listenerList.getListeners(PreChangeListener.class);
    }

    protected void firePreChange(PreChangeEvent e) {
        boolean ret = true;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] == PreChangeListener.class) {
                ((PreChangeListener)listeners[i + 1]).preChange(e);
                ret &= e.succeeded();
            }
            if (!ret) break;
        }
    }

    public void addSelectorListener(SelectorListener listener) {
        this.listenerList.add(SelectorListener.class, listener);
    }

    public void removeSelectorListener(SelectorListener listener) {
        this.listenerList.remove(SelectorListener.class, listener);
    }

    public SelectorListener[] getSelectorListeners() {
        return (SelectorListener[])this.listenerList.getListeners(SelectorListener.class);
    }

    protected boolean doFireSelectorEvent() {
        SelectorEvent selectorEvent = new SelectorEvent(this);
        this.fireSelectorWillShow(selectorEvent);
        return !selectorEvent.isCanceled();
    }

    protected void fireSelectorWillShow(SelectorEvent selectorEvent) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SelectorListener.class) continue;
            ((SelectorListener)listeners[i + 1]).willShow(selectorEvent);
        }
    }

    public void addDataErrorListener(DataErrorListener listener) {
        this.listenerList.add(DataErrorListener.class, listener);
    }

    public void removeCommitListener(DataErrorListener listener) {
        this.listenerList.remove(DataErrorListener.class, listener);
    }

    protected void fireDataErrorDialog(DataErrorEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataErrorListener.class) continue;
            ((DataErrorListener)listeners[i + 1]).showErrorDialog(event);
        }
    }

    public void addCommitListener(CommitListener listener) {
        this.listenerList.add(CommitListener.class, listener);
    }

    public void removeCommitListener(CommitListener listener) {
        this.listenerList.remove(CommitListener.class, listener);
    }

    public CommitListener[] getCommitListeners() {
        return (CommitListener[])this.listenerList.getListeners(CommitListener.class);
    }

    public boolean doFireCommitEvent(String text) {
        CommitEvent commitEvent = new CommitEvent(this, text);
        this.fireCommitEdit(commitEvent);
        return !commitEvent.isCanceled();
    }

    protected void fireCommitEdit(CommitEvent commitEvent) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CommitListener.class) continue;
            ((CommitListener)listeners[i + 1]).willCommit(commitEvent);
        }
    }

    protected KDPromptSelector createSelector(Object param) {
        return new DefaultSelector();
    }

    protected void configSelector(Object param) {
    }

    public void setHasDownPanel(boolean b) {
        this.hasDownPanel = b;
    }

    protected KDPromptPopup createDownPanel() {
        if (this.downPanel == null) {
            this.downPanel = new KDPromptPopup(this);
        }
        return this.downPanel;
    }

    protected void configDownPanel(Object param) {
    }

    public void addDataErrorListener() {
    }

    public void setEdittedStop(boolean b) {
        this.edittedStop = b;
    }

    public boolean isEdittedStop() {
        return this.edittedStop;
    }

    protected Object popupSelector(Object param) {
        if (this.selector == null) {
            this.selector = this.createSelector(param);
        }
        if (!this.doFireSelectorEvent()) {
            return DEFAULTVALUE;
        }
        this.configSelector(param);
        this.selector.show();
        if (this.selector.isCanceled()) {
            return DEFAULTVALUE;
        }
        return this.selector.getData();
    }

    public void setDataBySelector() {
        this.setEdittedStop(false);
        Object newData = this.popupSelector(null);
        if (this.isReadOnly()) {
            this.setEdittedStop(true);
            return;
        }
        String str = this.getText();
        if (newData == BADVALUE) {
            this.setData(BADVALUE);
            this.handleBadValue(3, str);
        } else if (newData != DEFAULTVALUE) {
            this.setData(newData, true);
        }
        this.setEdittedStop(true);
    }

    public void popupDownPanel(Object param) {
        String text = ((JTextComponent)this.getEditor()).getText();
        if (text == null || text.equals("")) {
            return;
        }
        if (this.popupDownPanelThread != null) {
            this.closeDownPanel();
        }
        this.popupDownPanelThread = new PopupDownPanelThread(text);
        this.popupDownPanelThread.start();
    }

    public void closeDownPanel() {
        this.getUI().closeDownPanel();
        if (this.popupDownPanelThread != null) {
            this.lastInput = "";
            this.popupDownPanelThread.interrupt();
            this.popupDownPanelThread.setIsInterrupt(true);
            this.popupDownPanelThread = null;
        }
    }

    public void commitEdit() throws ParseException {
        if (this.isDirty()) {
            this.setHasCommitEdit(true);
            this.commitEditImmediately();
            if (((KDTextField)this.getEditor()).isAssistorShowing() && this.isDirty()) {
                DataErrorEvent event = new DataErrorEvent(this);
                this.fireDataErrorDialog(event);
                throw new ParseException("KDPromptBox commit error!", 0);
            }
        }
    }

    public boolean isHasCommitEdit() {
        return this.hasCommitEdit;
    }

    public void setHasCommitEdit(boolean hasCommitEdit) {
        this.hasCommitEdit = hasCommitEdit;
    }

    private void commitEditImmediately() {
        Object newData = null;
        String newText = this.edt.getText();
        if (newText != null && newText.length() > 0) {
            if (!this.doFireCommitEvent(newText)) {
                return;
            }
            newData = this.stringToValue(newText);
        }
        if (newData == BADVALUE) {
            this.setData(BADVALUE);
            this.handleBadValue(1, newText);
        } else if (newData != DEFAULTVALUE) {
            if (this.edt instanceof KDTextField && ((KDTextField)this.edt).isAssistorEnabled()) {
                ((KDTextField)this.edt).memorizeAssistorInfo();
            }
            this.setData(newData, true);
        }
    }

    protected Object stringToValue(String t) {
        return t;
    }

    public Object parseToSingleValue(String src) {
        this.putClientProperty("poppable", Boolean.FALSE);
        Object result = this.stringToValue(src);
        this.putClientProperty("poppable", null);
        if (result == DEFAULTVALUE || result == BADVALUE) {
            return null;
        }
        return result;
    }

    protected String valueToString(Object o) {
        String ret = "";
        if (o != null) {
            ret = o.toString();
        }
        return ret;
    }

    public void setData(Object newdata) {
        this.setData(newdata, false);
    }

    public void setDataNoNotify(Object newdata) {
        this.setData(newdata, false, false);
    }

    public void setDataForCtrlDown(Object newdata) {
        this.setData(newdata, true);
        if (this.popupDownPanelThread != null) {
            this.closeDownPanel();
        }
    }

    protected void setData(Object newdata, boolean postEvent) {
        this.setData(newdata, postEvent, true);
    }

    protected void setData(Object newdata, boolean postEvent, boolean notify) {
        this.setHasDownPanel(false);
        if (TextComponentUtilities.setData(this, newdata)) {
            Object olddata = this.data;
            if (newdata == BADVALUE) {
                if (this.data != null) {
                    this.data = null;
                    if (notify) {
                        this.fireStateChanged();
                        this.fireDataChanged(this.data, olddata);
                    }
                }
                return;
            }
            if (newdata == DEFAULTVALUE) {
                return;
            }
            if (this.data != newdata) {
                boolean isDataOk = true;
                PreChangeEvent e = new PreChangeEvent(this, newdata, this.data);
                if (postEvent) {
                    if (notify) {
                        this.firePreChange(e);
                    }
                    isDataOk = e.succeeded();
                }
                if (isDataOk) {
                    if (e.getResult() == 0) {
                        return;
                    }
                    this.data = newdata = e.getData();
                    this.updateData();
                    if (notify) {
                        this.fireStateChanged();
                        this.fireDataChanged(this.data, olddata);
                    }
                } else {
                    this.data = null;
                    if (notify) {
                        this.fireStateChanged();
                        this.fireDataChanged(this.data, olddata);
                    }
                    this.handleBadValue(0, this.getText());
                }
            } else {
                this.updateData();
            }
        }
    }

    public Object getData() {
        if (this.getAccessAuthority() == 2) {
            return TextComponentUtilities.getData(this);
        }
        return this.data;
    }

    public JComponent getEditor() {
        return this.edt;
    }

    public void setEditorWrapped(boolean wrapped) {
        if (wrapped && this.edt instanceof KDTextField) {
            this.remove(this.edt);
            boolean editable = this.isEditable();
            this.edt = new KDTextArea();
            if (editable) {
                this.edt.putClientProperty("promptbox", Boolean.TRUE);
                this.edt.setEditable(true);
            } else {
                this.edt.putClientProperty("promptbox", null);
                this.edt.setEditable(false);
            }
            InputMap inputMap = this.edt.getInputMap(0);
            KeyStroke ks = KeyStroke.getKeyStroke(10, 0);
            Object actionName = inputMap.get(ks);
            inputMap.put(ks, "no-action");
            inputMap.put(KeyStroke.getKeyStroke(10, 512), actionName);
            this.add("Editor", new KDScrollPane(this.edt));
            this.setAlignment(1);
            this.updateUI();
        } else if (!wrapped && this.edt instanceof KDTextArea) {
            this.remove(this.edt);
            boolean editable = this.isEditable();
            this.edt = new DefaultEditor();
            if (editable) {
                this.edt.putClientProperty("promptbox", Boolean.TRUE);
                this.edt.setEditable(true);
            } else {
                this.edt.putClientProperty("promptbox", null);
                this.edt.setEditable(false);
            }
            this.add("Editor", this.edt);
            this.setAlignment(2);
            this.updateUI();
        }
        if (this.required) {
            this.edt.putClientProperty("promptbox", Boolean.TRUE);
            ((IKDTextComponent)((Object)this.edt)).setRequired(true);
        } else {
            this.edt.putClientProperty("promptbox", null);
            ((IKDTextComponent)((Object)this.edt)).setRequired(false);
        }
    }

    public JLabel getLabel() {
        return this.label;
    }

    public int getLabelLength() {
        return this.labelLength;
    }

    public void setLabelLength(int labelLength) {
    }

    public int getEditorLength() {
        return this.editorLength;
    }

    public void setEditorLength(int editorLength) {
        int oldEditorLength = this.editorLength;
        this.editorLength = editorLength;
        this.firePropertyChange("editorLength", (Object)oldEditorLength, (Object)editorLength);
    }

    public String getLabelText() {
        return this.label.getText();
    }

    private static final String getReadForbitItem() {
        return KDResourceManager.getMLS("noPerm", "\u65e0\u6743\u9650");
    }

    public void setLabelText(String text) {
        if (this.getClientProperty("accessAuthority") != null && this.getClientProperty("accessAuthority") instanceof Integer && (Integer)this.getClientProperty("accessAuthority") == 2) {
            this.label.setText(KDPromptBox.getReadForbitItem());
        } else {
            this.label.setText(text);
        }
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean labelVisible) {
        this.labelVisible = labelVisible;
    }

    public void setSelector(KDPromptSelector s) {
        this.selector = s;
    }

    public KDPromptSelector getSelector() {
        return this.selector;
    }

    public void setDownPanel(KDPromptPopup p) {
        this.downPanel = p;
    }

    public KDPromptPopup getDownPanel() {
        return this.downPanel;
    }

    @Override
    public boolean requestFocus(boolean b) {
        return this.getEditor().requestFocus(b);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.getEditor().requestFocusInWindow();
    }

    @Override
    public void requestFocus() {
        if (this.edt == null) {
            return;
        }
        this.edt.requestFocus();
    }

    @Override
    public void setEditable(boolean aFlag) {
        if (TextComponentUtilities.setEditable(this, aFlag)) {
            boolean oldEnabled = this.isEditable();
            if (aFlag) {
                this.edt.putClientProperty("promptbox", null);
            } else {
                this.edt.putClientProperty("promptbox", Boolean.TRUE);
            }
            this.edt.setEditable(aFlag);
            this.firePropertyChange("editable", oldEnabled, aFlag);
        }
    }

    @Override
    public boolean isEditable() {
        return this.edt.isEditable();
    }

    @Override
    public boolean hasFocus() {
        boolean br = super.hasFocus();
        if (!br && this.edt != null) {
            br = this.edt.hasFocus();
        }
        return br;
    }

    public void setTextSelected() {
        if (this.edt == null) {
            return;
        }
        this.edt.selectAll();
    }

    public void updateData() {
        if (this.getClientProperty("accessAuthority") != null && this.getClientProperty("accessAuthority") instanceof Integer && (Integer)this.getClientProperty("accessAuthority") == 2) {
            this.setText(KDPromptBox.getReadForbitItem());
        } else {
            this.setText(this.valueToString(this.data));
        }
        this.setDirty(false);
    }

    public void setText(String t) {
        this.edt.setText(t);
    }

    public void setEditingText(String t) {
        if (TextComponentUtilities.setData(this, t)) {
            this.edt.setText(t);
            if (!StringUtil.isEmptyString((String)t)) {
                this.edt.setCaretPosition(t.length());
            }
        }
    }

    public String getText() {
        if (this.getAccessAuthority() == 2) {
            return (String)TextComponentUtilities.getData(this);
        }
        JTextComponent e = (JTextComponent)this.getEditor();
        if (e != null) {
            return e.getText();
        }
        return "";
    }

    @Override
    public void addDataChangeListener(DataChangeListener listener) {
        this.listenerList.add(DataChangeListener.class, listener);
    }

    protected void fireDataChanged(DataChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataChangeListener.class) continue;
            ((DataChangeListener)listeners[i + 1]).dataChanged(event);
        }
    }

    protected void fireDataChanged(Object newData, Object oldData) {
        DataChangeEvent evt = new DataChangeEvent(this, newData, oldData);
        this.fireDataChanged(evt);
    }

    @Override
    public Object getValue() {
        return this.getData();
    }

    @Override
    public boolean isDisplay() {
        return true;
    }

    @Override
    public void removeDataChangeListener(DataChangeListener listener) {
        this.listenerList.remove(DataChangeListener.class, listener);
    }

    @Override
    public void setDisplay(boolean isDisplay) {
        this.setVisible(isDisplay);
    }

    @Override
    public void setValue(Object value) {
        this.setData(value);
    }

    protected void handleBadValue(int when, Object value) {
        switch (when) {
            case 0: {
                SwingLogUtil.info((String)"PRECHANGED");
                break;
            }
            case 1: {
                SwingLogUtil.info((String)"PARSED");
                break;
            }
            case 3: {
                SwingLogUtil.info((String)"SELECTOR CLOSED");
                break;
            }
            default: {
                SwingLogUtil.info((String)"UNKNOWN WHEN");
            }
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean b) {
        this.dirty = b;
    }

    public void setIcon(Image icon) {
        this.getUI().setIconOff(icon);
    }

    public void setDisabledIcon(Image icon) {
        this.getUI().setDisabledIcon(icon);
    }

    public void setClearIcon(Image icon) {
        this.getUI().setIconClear(icon);
    }

    @Override
    public void setToolTipText(String text) {
        this.getEditor().setToolTipText(text);
        this.setButtonTooltipsText(text);
    }

    @Override
    public void updateUI() {
        this.setUI(KingdeePromptBoxUI.createUI(this));
    }

    @Override
    public KingdeePromptBoxUI getUI() {
        return (KingdeePromptBoxUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return UICLASSID;
    }

    public void setAlignment(int align) {
        if (align == 1 || align == 2 || align == 3) {
            this.alignment = align;
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    protected void popModalDialog() {
        this.setDataBySelector();
    }

    public void setDialog(KDPromptSelector s) {
        this.setSelector(s);
    }

    public KDPromptSelector getDialog() {
        return this.getSelector();
    }

    public final void NotifyAction() {
        this.fireActionEvent();
    }

    @Override
    public void setFocusTraversalKeysEnabled(boolean b) {
        super.setFocusTraversalKeysEnabled(b);
        this.getEditor().setFocusTraversalKeysEnabled(b);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.getUI().setCtrlDown(false);
    }

    @Override
    public int getMaxLength() {
        return ((ITextLengthLimit)((Object)this.edt)).getMaxLength();
    }

    @Override
    public int getMinLength() {
        return ((ITextLengthLimit)((Object)this.edt)).getMinLength();
    }

    @Override
    public void setMaxLength(int len) {
        ((ITextLengthLimit)((Object)this.edt)).setMaxLength(len);
    }

    @Override
    public void setMinLength(int len) {
        ((ITextLengthLimit)((Object)this.edt)).setMinLength(len);
    }

    public static class DefaultEditor
    extends DefaultTextField {
        private static final long serialVersionUID = -6592404262363541282L;
        private String customTooltip;

        public DefaultEditor() {
            CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 0));
        }

        public DefaultEditor(String text) {
            super(text);
            CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 0));
        }

        public DefaultEditor(int columns) {
            super(columns);
            CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 0));
        }

        public DefaultEditor(String text, int columns) {
            super(text, columns);
            CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 0));
        }

        public DefaultEditor(Document doc, String text, int columns) {
            super(doc, text, columns);
            CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 0));
        }

        @Override
        public void setToolTipText(String text) {
            super.setToolTipText(text);
            if (!StringUtils.isEmpty(text) && !"F7".equals(text)) {
                this.customTooltip = text;
            }
        }

        @Override
        public String getToolTipText() {
            if (this.customTooltip != null) {
                return this.customTooltip;
            }
            if (this.isEnabled()) {
                double ew;
                String text = this.getText();
                double tw = this.getFontMetrics(this.getFont()).stringWidth(text);
                if (tw > (ew = (double)this.getVisibleRect().width)) {
                    return text;
                }
            }
            return super.getToolTipText();
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return this.getToolTipText();
        }
    }

    public static class DefaultSelector
    implements KDPromptSelector {
        @Override
        public void show() {
        }

        @Override
        public boolean isCanceled() {
            return true;
        }

        @Override
        public Object getData() {
            return null;
        }
    }

    class PopupDownPanelThread
    extends Thread {
        boolean isInterrupt = false;
        String currentInput = null;

        public PopupDownPanelThread(String currentInput) {
            this.currentInput = currentInput;
        }

        public void setIsInterrupt(boolean isInterrupt) {
            this.isInterrupt = isInterrupt;
        }

        public boolean isInterrupt() {
            return this.isInterrupt;
        }

        @Override
        public void run() {
            if (!this.currentInput.equals(KDPromptBox.this.lastInput)) {
                KDPromptBox.this.lastInput = this.currentInput;
                try {
                    PopupDownPanelThread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.isInterrupt) {
                    return;
                }
                KDPromptBox.this.createDownPanel();
                KDPromptBox.this.configDownPanel(this.currentInput);
                KDPromptBox.this.getUI().popDownPanel();
            } else {
                KDPromptBox.this.getUI().popDownPanel();
            }
        }
    }
}

