/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.swing.ButtonActionPropertyListenerEx;
import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeIconFactory;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeRadioButtonUI;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeListener;

public class KDRadioButton
extends JRadioButton
implements IKDComponent {
    private static final long serialVersionUID = -5982654839660753384L;
    protected Object userObject = null;
    private Insets customInsets;
    private static final String[] staticTypes = new String[]{"MnemonicKey", "Name", "ShortDescription", "ActionCommandKey", "enabled"};

    public KDRadioButton() {
    }

    public KDRadioButton(Icon icon) {
        super(icon);
    }

    public KDRadioButton(Action a) {
        super(a);
        this.registerTooltipText();
    }

    public KDRadioButton(Icon icon, boolean selected) {
        super(icon, selected);
    }

    public KDRadioButton(String text) {
        super(text);
        this.registerTooltipText();
    }

    public KDRadioButton(String text, boolean selected) {
        super(text, selected);
        this.registerTooltipText();
    }

    public KDRadioButton(String text, Icon icon) {
        super(text, icon);
        this.registerTooltipText();
    }

    public KDRadioButton(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.registerTooltipText();
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (!StringUtil.isEmptyString((String)text)) {
            this.registerTooltipText();
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    private void registerTooltipText() {
        String text = this.getText();
        if (!StringUtil.isEmptyString((String)text)) {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.setToolTipText(text);
        }
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void updateUI() {
        super.setUI(KingdeeRadioButtonUI.createUI(this));
    }

    @Override
    public Icon getIcon() {
        return KingdeeIconFactory.getRadioButtonIcon();
    }

    public void setAccessAuthority(int authority) {
    }

    public int getAccessAuthority() {
        return 0;
    }

    public void setSelected(boolean selected, boolean fireListener) {
        if (fireListener) {
            this.setSelected(selected);
        } else if (this.getModel() instanceof JToggleButton.ToggleButtonModel) {
            int i;
            ChangeListener[] savedChangeListeners = ((JToggleButton.ToggleButtonModel)this.getModel()).getChangeListeners();
            ItemListener[] savedItemListeners = ((JToggleButton.ToggleButtonModel)this.getModel()).getItemListeners();
            if (savedChangeListeners != null) {
                for (i = 0; i < savedChangeListeners.length; ++i) {
                    this.getModel().removeChangeListener(savedChangeListeners[i]);
                }
            }
            if (savedItemListeners != null) {
                for (i = 0; i < savedItemListeners.length; ++i) {
                    this.getModel().removeItemListener(savedItemListeners[i]);
                }
            }
            this.setSelected(selected);
            if (savedChangeListeners != null) {
                for (i = 0; i < savedChangeListeners.length; ++i) {
                    this.getModel().addChangeListener(savedChangeListeners[i]);
                }
            }
            if (savedItemListeners != null) {
                for (i = 0; i < savedItemListeners.length; ++i) {
                    this.getModel().addItemListener(savedItemListeners[i]);
                }
            }
            this.repaint();
        } else {
            this.setSelected(selected);
        }
    }

    @Override
    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new ButtonActionPropertyListenerEx(this, a){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                AbstractButton button = (AbstractButton)this.getTarget();
                if (button == null) {
                    Action action = (Action)e.getSource();
                    action.removePropertyChangeListener(this);
                } else if (propertyName.equals("Name")) {
                    String text = (String)e.getNewValue();
                    button.setText(text);
                    button.repaint();
                } else if (propertyName.equals("ShortDescription")) {
                    String text = (String)e.getNewValue();
                    button.setToolTipText(text);
                } else if (propertyName.equals("enabled")) {
                    Boolean enabledState = (Boolean)e.getNewValue();
                    button.setEnabled(enabledState);
                    button.repaint();
                } else if (propertyName.equals("ActionCommandKey")) {
                    button.setActionCommand((String)e.getNewValue());
                } else if (propertyName.equals("visible")) {
                    Boolean visibleState = (Boolean)e.getNewValue();
                    button.setVisible(visibleState);
                }
            }
        };
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        String[] types = staticTypes;
        for (int i = 0; i < types.length; ++i) {
            Boolean objValue;
            String type = types[i];
            if (type == null) continue;
            if (type.equals("MnemonicKey")) {
                Integer n = a == null ? null : (Integer)a.getValue(type);
                this.setMnemonic(n == null ? 0 : n);
                continue;
            }
            if (type.equals("Name")) {
                this.setText(a != null ? (String)a.getValue(type) : null);
                continue;
            }
            if (type.equals("ShortDescription")) {
                this.setToolTipText(a != null ? (String)a.getValue(type) : null);
                continue;
            }
            if (type.equals("SmallIcon")) {
                this.setIcon(a != null ? (Icon)a.getValue(type) : null);
                continue;
            }
            if (type.equals("ActionCommandKey")) {
                this.setActionCommand(a != null ? (String)a.getValue(type) : null);
                continue;
            }
            if (type.equals("enabled")) {
                this.setEnabled(a != null ? a.isEnabled() : true);
                continue;
            }
            if (!type.equals("visible")) continue;
            boolean value = true;
            if (a != null && (objValue = (Boolean)a.getValue("visible")) != null) {
                value = objValue;
            }
            this.setVisible(value);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent me) {
        if (CtrlSwingUtilities.runCtrlInputVerifier(this)) {
            super.processMouseEvent(me);
        }
    }
}

