/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.DateTimeEditor;
import com.kingdee.cosmic.ctrl.swing.IDateTimePicker;
import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.IKDEditor;
import com.kingdee.cosmic.ctrl.swing.IKDTextComponent;
import com.kingdee.cosmic.ctrl.swing.KDSpinner;
import com.kingdee.cosmic.ctrl.swing.event.DataChangeListener;
import com.kingdee.cosmic.ctrl.swing.model.AbstractDateTimeModel;
import com.kingdee.cosmic.ctrl.swing.model.DateTimeModel;
import com.kingdee.cosmic.ctrl.swing.model.IDateTimeModel;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeTimePickerUI;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Insets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;

public class KDTimePicker
extends JComponent
implements IKDComponent,
IKDEditor,
IDateTimePicker,
IKDTextComponent {
    private static final long serialVersionUID = -4423568388428998107L;
    protected Object userObject = null;
    private DateTimeEditor editor = null;
    private JComponent renderer = null;
    private IDateTimeModel model = null;
    private java.util.Date minSelfDate = null;
    private java.util.Date maxSelfDate = null;
    private boolean isNullValue = false;
    private boolean supportEmptyValue = false;
    private boolean required = false;
    private static final String uiClassID = "KingdeeTimePickerUI";
    private int labelAlignment = 7;
    private JLabel compositeLable = null;
    private int labelLength = -1;
    private Insets customInsets;
    private boolean nullAble;

    public KDTimePicker() {
        this.createModel();
        this.createEditor();
        this.createRenderer();
        this.updateUI();
        this.setValue(new java.util.Date());
    }

    public void commitEdit() throws ParseException {
        try {
            JComponent editor = this.getEditor().getEditorComponent();
            if (editor instanceof KDSpinner) {
                ((KDSpinner)editor).commitEdit();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public boolean isSupportEmptyValue() {
        return this.supportEmptyValue;
    }

    public void setSupportEmptyValue(boolean supportEmptyValue) {
        this.supportEmptyValue = supportEmptyValue;
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void addDataChangeListener(DataChangeListener listener) {
        this.editor.addDataChangeListener(listener);
    }

    @Override
    public Object getValue() {
        if (this.getModel().isEmptyValue()) {
            return null;
        }
        return this.getModel().getValue();
    }

    public Timestamp getTimestamp() {
        Object obj = this.getValue();
        if (obj != null) {
            Timestamp timestamp = new Timestamp(((java.util.Date)obj).getTime());
            return timestamp;
        }
        return null;
    }

    public Date getSqlDate() {
        Object obj = this.getValue();
        if (obj != null) {
            Date sqlDate = new Date(((java.util.Date)obj).getTime());
            return sqlDate;
        }
        return null;
    }

    public Object getValue(Class c) {
        if (c != null) {
            String cName = c.getName();
            if (cName.equals("java.sql.Timestamp")) {
                return this.getTimestamp();
            }
            if (cName.equals("java.sql.Date")) {
                return this.getSqlDate();
            }
            if (cName.equals("java.util.Date")) {
                return this.getValue();
            }
            if (cName.equals("java.sql.Time")) {
                return this.getSqlTime();
            }
            throw new IllegalArgumentException("c type is not supported");
        }
        return this.getValue();
    }

    public Time getSqlTime() {
        Object obj = this.getValue();
        if (obj != null) {
            Time time = new Time(((java.util.Date)obj).getTime());
            return time;
        }
        return null;
    }

    @Override
    public boolean isDisplay() {
        return this.isVisible();
    }

    @Override
    public void removeDataChangeListener(DataChangeListener listener) {
        this.editor.removeDataChangeListener(listener);
    }

    @Override
    public void setDisplay(boolean isDisplay) {
        this.setVisible(isDisplay);
    }

    @Override
    public void setValue(Object value) {
        this.isNullValue = false;
        Object newValue = this.getValue();
        if (value instanceof java.util.Date && newValue != null && CtrlSwingUtilities.judgeEquals(value, (Object)((java.util.Date)newValue))) {
            return;
        }
        if (value == null && (this.maxSelfDate != null || this.minSelfDate != null)) {
            return;
        }
        if (value != null) {
            if (this.maxSelfDate != null && CtrlSwingUtilities.judgeDate((java.util.Date)value, this.maxSelfDate) > 0) {
                return;
            }
            if (this.minSelfDate != null && CtrlSwingUtilities.judgeDate((java.util.Date)value, this.minSelfDate) < 0) {
                return;
            }
        }
        if (value == null || value instanceof java.util.Date) {
            if (value == null && !this.isSupportEmptyValue()) {
                JComponent c;
                if (this.nullAble && (c = this.getEditor().getEditorComponent()) instanceof KDSpinner) {
                    ((KDSpinner)c).getModel().setValue(null);
                }
            } else {
                this.getModel().setValue((java.util.Date)value);
                this.getModel().setEmptyValue(this.isNullValue);
                this.editor.setValue((java.util.Date)value);
            }
        } else {
            throw new IllegalArgumentException("value is illegal.");
        }
    }

    public void setValue(Object value, boolean fireListener) {
        if (!fireListener) {
            ((AbstractDateTimeModel)this.getModel()).setDataChangeListenerFired(false);
            this.getEditor().setDataChangeListenerFired(false);
            this.setValue(value);
            ((AbstractDateTimeModel)this.getModel()).setDataChangeListenerFired(true);
            this.getEditor().setDataChangeListenerFired(true);
        } else {
            this.setValue(value);
        }
    }

    protected void createEditor() {
        this.editor = new DateTimeEditor(this);
    }

    protected JComponent createRenderer() {
        return null;
    }

    public DateTimeEditor getEdtor() {
        return this.editor;
    }

    public DateTimeEditor getEditor() {
        return this.editor;
    }

    public JComponent getRenderer() {
        return this.renderer;
    }

    public DateFormat getFormat() {
        if (this.editor != null) {
            return this.editor.getFormat();
        }
        return null;
    }

    public void setTimePattern(String pattern) {
        this.editor.setDateTimePattern(pattern);
    }

    public String getTimePattern() {
        return this.editor.getDateTimePattern();
    }

    public String getText() {
        return this.editor.getText();
    }

    protected void createModel() {
        this.model = new DateTimeModel();
        this.model.setDateEnable(false);
        this.model.setTimeEnable(true);
        this.model.setMilliSecondEnable(false);
    }

    @Override
    public IDateTimeModel getModel() {
        return this.model;
    }

    @Override
    public boolean isDateEnabled() {
        return this.getModel().isDateEnable();
    }

    @Override
    public boolean isTimeEnabled() {
        return this.getModel().isTimeEnable();
    }

    @Override
    public final void setDateEnabled(boolean b) {
        this.getModel().setDateEnable(false);
    }

    @Override
    public final void setTimeEnabled(boolean b) {
        this.getModel().setTimeEnable(true);
    }

    public void setMilliSecondEnable(boolean b) {
        boolean oldB = this.getModel().isMillisecondEnable();
        if (oldB != b) {
            this.getModel().setMilliSecondEnable(b);
            this.firePropertyChange("milliSecondEnable", oldB, b);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.getEditor() != null) {
            this.getEditor().setEnabled(enabled);
        } else {
            super.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.getEditor() != null) {
            return this.getEditor().isEnabled();
        }
        return super.isEnabled();
    }

    @Override
    public void setEditable(boolean b) {
        if (this.getEdtor() != null) {
            this.getEdtor().setEditable(b);
        }
    }

    @Override
    public boolean isEditable() {
        if (this.getEdtor() != null) {
            return this.getEdtor().isEditable();
        }
        return false;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
        this.editor.setRequired(required);
    }

    public void setMaximumDate(java.util.Date newMaxDate) {
        this.maxSelfDate = newMaxDate != null ? new java.util.Date(newMaxDate.getTime()) : null;
        this.editor.setMaximumDate(this.maxSelfDate);
    }

    public java.util.Date getMaximumDate() {
        return this.editor.getMaximumDate();
    }

    public void setMinimumDate(java.util.Date newMinDate) {
        this.minSelfDate = newMinDate != null ? new java.util.Date(newMinDate.getTime()) : null;
        this.editor.setMinimumDate(this.minSelfDate);
    }

    public java.util.Date getMinimumDate() {
        return this.editor.getMinimumDate();
    }

    public boolean isMilliSecondEnable() {
        return this.getModel().isMillisecondEnable();
    }

    @Override
    public void updateUI() {
        this.setUI((KingdeeTimePickerUI)UIManager.getUI(this));
    }

    public void setUI(KingdeeTimePickerUI ui) {
        super.setUI(ui);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public KingdeeTimePickerUI getUI() {
        return (KingdeeTimePickerUI)this.ui;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
        Map additionalValues = (Map)s.readObject();
        this.model = (IDateTimeModel)additionalValues.get("model");
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        HashMap<String, IDateTimeModel> additionalValues = new HashMap<String, IDateTimeModel>(1);
        IDateTimeModel model = this.getModel();
        if (model instanceof Serializable) {
            additionalValues.put("model", model);
        }
        s.writeObject(additionalValues);
        s.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    public void setLabelAlignment(int newLabelAlignment) {
        if (this.validateLabelAlignment(newLabelAlignment)) {
            int old = this.getLabelAlignment();
            if (old != newLabelAlignment) {
                this.labelAlignment = newLabelAlignment;
                this.firePropertyChange("labelAlignment", (Object)old, (Object)this.labelAlignment);
            }
        } else {
            throw new IllegalArgumentException("labelAlignment is invalidate.please see javax.swing.SwingConstants");
        }
    }

    public int getLabelAlignment() {
        return this.labelAlignment;
    }

    public void setLabelText(String newLabelText) {
        String old = this.getLabelText();
        if (newLabelText != null && !Objects.equals(old, newLabelText)) {
            if (this.getCompositeLabel() == null) {
                this.setCompositeLabel(new JLabel());
            }
            this.getCompositeLabel().setText(newLabelText);
        }
    }

    public String getLabelText() {
        if (this.getCompositeLabel() != null) {
            return this.getCompositeLabel().getText();
        }
        return null;
    }

    public void setCompositeLabel(JLabel newLabel) {
        JLabel old;
        if (newLabel != null && (old = this.getCompositeLabel()) != newLabel) {
            this.compositeLable = newLabel;
            this.firePropertyChange("compositeLabel", old, newLabel);
        }
    }

    public JLabel getCompositeLabel() {
        return this.compositeLable;
    }

    public void setLabelLength(int len) {
        int old = this.getLabelLength();
        if (old != len) {
            this.labelLength = len;
            this.firePropertyChange("labelLength", (Object)old, (Object)len);
        }
    }

    public int getLabelLength() {
        return this.labelLength;
    }

    private boolean validateLabelAlignment(int labelAli) {
        switch (labelAli) {
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setAccessAuthority(int authority) {
    }

    @Override
    public int getAccessAuthority() {
        return 0;
    }

    public void setNullable(boolean nullAble) {
        this.nullAble = nullAble;
        if (nullAble) {
            this.instalNullableModel();
        } else {
            this.uninstallNullableModel();
        }
    }

    public boolean isNullable() {
        return this.nullAble;
    }

    private void instalNullableModel() {
        JComponent comp = this.editor.getEditorComponent();
        if (comp instanceof KDSpinner) {
            KDSpinner spinner = (KDSpinner)comp;
            spinner.setNullable(true);
            SpinnerDateModel model = (SpinnerDateModel)spinner.getModel();
            spinner.setModel(new SpinnerDateModel(){
                private Object value = null;

                @Override
                public Object getValue() {
                    if (this.value == null || this.value instanceof String && ((String)this.value).trim().equals("")) {
                        KDTimePicker.this.model.setValue(null);
                    }
                    return this.value;
                }

                @Override
                public void setValue(Object value) {
                    if (value == null || value instanceof String && ((String)value).trim().equals("")) {
                        if (this.value == value) {
                            return;
                        }
                        this.value = null;
                        this.fireStateChanged();
                        return;
                    }
                    this.value = value;
                    super.setValue(value);
                    this.fireStateChanged();
                }
            });
            ((SpinnerDateModel)spinner.getModel()).setValue(model.getValue());
            ((SpinnerDateModel)spinner.getModel()).setCalendarField(model.getCalendarField());
            ((SpinnerDateModel)spinner.getModel()).setStart(model.getStart());
            ((SpinnerDateModel)spinner.getModel()).setEnd(model.getEnd());
        }
    }

    private void uninstallNullableModel() {
        JComponent comp = this.editor.getEditorComponent();
        if (comp instanceof KDSpinner) {
            KDSpinner spinner = (KDSpinner)comp;
            spinner.setNullable(false);
        }
    }

    static {
        UIManager.getDefaults().put(uiClassID, "com.kingdee.cosmic.ctrl.swing.plaf.KingdeeTimePickerUI");
    }
}

