/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.KDArrowButton;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.plaf.SpecialBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Timer;

public class KDUpDownContainer
extends KDPanel {
    private static final long serialVersionUID = 2459927866251558977L;
    public static final String UP_BUTTON = "upButton";
    public static final String DOWN_BUTTON = "downButton";
    private KDPanel arrowButtonPane = null;
    private KDArrowButton upButton = null;
    private KDArrowButton downButton = null;
    private Insets customInsets = new Insets(8, 0, 0, 0);
    private KDScrollPane scrollPane = null;
    private MouseListener arrowButtonMouseHandler = null;
    private int delay = 250;
    private Timer runTimer = null;
    public static final int UP_RUN = 0;
    public static final int DOWN_RUN = 1;
    private int direction = 0;

    public KDUpDownContainer() {
        this((JComponent)null);
    }

    public KDUpDownContainer(JComponent comp) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.getArrowButtonPane(), "South");
        this.add((Component)this.getScrollPane(), "Center");
        if (comp != null) {
            this.getScrollPane().getViewport().setView(comp);
            comp.putClientProperty("inUpDownContainer", "true");
        }
        this.installListeners();
    }

    public void setCustomEditor(JComponent comp) {
        if (comp != null) {
            this.getScrollPane().getViewport().setView(comp);
        }
    }

    protected void installListeners() {
        if (this.arrowButtonMouseHandler != null) {
            this.unInstallListeners();
        }
        this.getUpButton().addMouseListener(this.getArrowButtonMouseListener());
        this.getDownButton().addMouseListener(this.getArrowButtonMouseListener());
    }

    protected void unInstallListeners() {
        if (this.arrowButtonMouseHandler != null) {
            this.getUpButton().removeMouseListener(this.arrowButtonMouseHandler);
            this.getDownButton().removeMouseListener(this.arrowButtonMouseHandler);
            this.arrowButtonMouseHandler = null;
        }
    }

    public MouseListener getArrowButtonMouseListener() {
        if (this.arrowButtonMouseHandler == null) {
            this.arrowButtonMouseHandler = new ArrowMouseHandler();
        }
        return this.arrowButtonMouseHandler;
    }

    public void removeCustomEditor() {
        JViewport viewport = this.getScrollPane().getViewport();
        int n = viewport.getComponentCount();
        for (int i = n - 1; i >= 0; --i) {
            viewport.remove(this.getComponent(i));
        }
        viewport.revalidate();
        viewport.repaint();
    }

    public KDPanel getArrowButtonPane() {
        if (this.arrowButtonPane == null) {
            this.arrowButtonPane = new KDPanel(new FlowLayout(2, 2, 3));
            SpecialBorder.RemainderLineBorder border = new SpecialBorder.RemainderLineBorder();
            border.setLineColor(Color.decode("#B4B4AB"));
            this.arrowButtonPane.setBorder(border);
            this.arrowButtonPane.add(this.getUpButton());
            this.arrowButtonPane.add(this.getDownButton());
            this.arrowButtonPane.setPreferredSize(new Dimension(120, 32));
        }
        return this.arrowButtonPane;
    }

    public KDArrowButton getUpButton() {
        if (this.upButton == null) {
            this.upButton = new KDArrowButton(1);
            this.upButton.setActionCommand(UP_BUTTON);
        }
        return this.upButton;
    }

    @Override
    public void setCustomInsets(Insets newValue) {
        if (newValue != null) {
            this.customInsets = newValue;
        }
    }

    @Override
    public Insets getInsets() {
        return this.customInsets != null ? this.customInsets : new Insets(0, 0, 0, 0);
    }

    public KDArrowButton getDownButton() {
        if (this.downButton == null) {
            this.downButton = new KDArrowButton(5);
            this.downButton.setActionCommand(DOWN_BUTTON);
        }
        return this.downButton;
    }

    public KDScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new KDScrollPane();
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.scrollPane.getHorizontalScrollBar().setPreferredSize(new Dimension(0, 0));
            this.scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
        }
        return this.scrollPane;
    }

    private boolean hasViewPort() {
        JViewport viewPort = this.getScrollPane().getViewport();
        return viewPort != null;
    }

    public void downUpPressOprt(int di) {
        this.setArrowDirection(di);
        if (!this.hasViewPort()) {
            return;
        }
        if (this.runTimer == null) {
            this.createRunTimer();
        }
        this.runTimer.stop();
        this.runTimer.start();
    }

    public void downUpReleaseOprt(int di) {
        this.setArrowDirection(0);
        if (!this.hasViewPort()) {
            return;
        }
        if (this.runTimer != null) {
            this.runTimer.stop();
        }
    }

    private void setArrowDirection(int newValue) {
        this.direction = newValue;
    }

    public void setDelay(int newValue) {
        this.delay = newValue;
        if (this.runTimer != null) {
            this.runTimer.setDelay(this.delay);
        }
    }

    public int getDelay() {
        return this.delay;
    }

    private Timer createRunTimer() {
        if (this.runTimer == null) {
            this.runTimer = new Timer(this.getDelay(), new RunTimerHandler());
        }
        return this.runTimer;
    }

    private void runTimerOprt() {
        if (this.direction == 0) {
            this.scrollByUnits(0, 26);
        } else {
            this.scrollByUnits(1, 26);
        }
    }

    public void scrollByUnits(int di, int units) {
        int delta = 1;
        delta = di == 0 ? (delta += -units) : (delta += units);
        JViewport viewPort = this.getScrollPane().getViewport();
        Point oldViewPosition = viewPort.getViewPosition();
        Point newViewPosition = new Point(oldViewPosition.x, oldViewPosition.y + delta);
        Dimension realRect = viewPort.getViewSize();
        if (delta > 0) {
            if (newViewPosition.y > realRect.height) {
                newViewPosition.y = realRect.height;
            }
        } else if (delta < 0 && newViewPosition.y < 0) {
            newViewPosition.y = 0;
        }
        this.getScrollPane().getViewport().setViewPosition(newViewPosition);
        this.getScrollPane().revalidate();
        this.getScrollPane().repaint();
    }

    private class RunTimerHandler
    implements ActionListener {
        private RunTimerHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            KDUpDownContainer.this.runTimerOprt();
        }
    }

    private class ArrowMouseHandler
    extends MouseAdapter {
        private long tempTime = 0L;

        private ArrowMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.tempTime = System.currentTimeMillis();
            Component comp = e.getComponent();
            String commandAction = ((AbstractButton)comp).getActionCommand();
            if (KDUpDownContainer.DOWN_BUTTON.equals(commandAction)) {
                KDUpDownContainer.this.downUpPressOprt(1);
            } else if (KDUpDownContainer.UP_BUTTON.equals(commandAction)) {
                KDUpDownContainer.this.downUpPressOprt(0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.tempTime = System.currentTimeMillis() - this.tempTime;
            Component comp = e.getComponent();
            String commandAction = ((AbstractButton)comp).getActionCommand();
            if (KDUpDownContainer.DOWN_BUTTON.equals(commandAction)) {
                KDUpDownContainer.this.downUpReleaseOprt(1);
            } else if (KDUpDownContainer.UP_BUTTON.equals(commandAction)) {
                KDUpDownContainer.this.downUpReleaseOprt(0);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.tempTime <= 400L) {
                Component comp = e.getComponent();
                String commandAction = ((AbstractButton)comp).getActionCommand();
                if (KDUpDownContainer.DOWN_BUTTON.equals(commandAction)) {
                    KDUpDownContainer.this.setArrowDirection(1);
                } else if (KDUpDownContainer.UP_BUTTON.equals(commandAction)) {
                    KDUpDownContainer.this.setArrowDirection(0);
                }
                KDUpDownContainer.this.runTimerOprt();
            }
        }
    }
}

