/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.calculator.plaf;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDFormattedTextField;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDSpinner;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.calculator.ICalculatorModelListener;
import com.kingdee.cosmic.ctrl.swing.calculator.KDCalculatorModel;
import com.kingdee.cosmic.ctrl.swing.calculator.KDCalculatorPopup;
import com.kingdee.cosmic.ctrl.swing.resource.KDResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import org.apache.log4j.Logger;

public class KingdeeCalculatorPopupUI
extends ComponentUI {
    private static final Logger logger = LogUtil.getPackageLogger(KingdeeCalculatorPopupUI.class);
    private KDCalculatorPopup calculatorPopup;
    private KDLabelContainer labelContainer;
    private KDSpinner spinner;
    private String[] buttonStrings;
    private List buttonList;
    private KDWorkButton mrBtn;
    private KDFormattedTextField display;
    private KDCalculatorModel cm;
    private KeyListener keyListener;
    private MouseListener mouseListener;
    private ChangeListener changeListener;
    private ICalculatorModelListener modelListener;
    private LayoutManager layout;
    private int narrowInterval = 3;
    private int wideInterval = 8;
    private Dimension labelContainerSize = new Dimension(119, 19);
    private Dimension buttonSize = new Dimension(36, 27);
    private static Insets insets = new Insets(10, 10, 10, 10);
    private static Dimension compPreferredSize = new Dimension(256, 172);
    private static Dimension zeroDim = new Dimension(0, 0);

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeCalculatorPopupUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Color oldColor = g.getColor();
        g.setColor(UIManager.getColor("Calculator.bgColor1"));
        g.drawLine(0, 0, KingdeeCalculatorPopupUI.compPreferredSize.width - 2, 0);
        g.drawLine(0, 1, 0, KingdeeCalculatorPopupUI.compPreferredSize.height - 2);
        g.drawLine(KingdeeCalculatorPopupUI.compPreferredSize.width - 1, 0, KingdeeCalculatorPopupUI.compPreferredSize.width - 1, KingdeeCalculatorPopupUI.compPreferredSize.height - 1);
        g.drawLine(0, KingdeeCalculatorPopupUI.compPreferredSize.height - 1, KingdeeCalculatorPopupUI.compPreferredSize.width - 2, KingdeeCalculatorPopupUI.compPreferredSize.height - 1);
        g.setColor(UIManager.getColor("Calculator.bgColor2"));
        g.drawLine(1, 1, KingdeeCalculatorPopupUI.compPreferredSize.width - 3, 1);
        g.drawLine(1, 2, 1, KingdeeCalculatorPopupUI.compPreferredSize.height - 3);
        g.setColor(UIManager.getColor("Calculator.bgColor3"));
        g.drawLine(KingdeeCalculatorPopupUI.compPreferredSize.width - 2, 1, KingdeeCalculatorPopupUI.compPreferredSize.width - 2, KingdeeCalculatorPopupUI.compPreferredSize.height - 2);
        g.drawLine(1, KingdeeCalculatorPopupUI.compPreferredSize.height - 2, KingdeeCalculatorPopupUI.compPreferredSize.width - 3, KingdeeCalculatorPopupUI.compPreferredSize.height - 2);
        g.setColor(UIManager.getColor("Calculator.bgColor4"));
        g.drawLine(2, 2, KingdeeCalculatorPopupUI.compPreferredSize.width - 4, 2);
        g.drawLine(2, 3, 2, KingdeeCalculatorPopupUI.compPreferredSize.height - 4);
        g.setColor(UIManager.getColor("Calculator.bgColor5"));
        g.drawLine(KingdeeCalculatorPopupUI.compPreferredSize.width - 3, 2, KingdeeCalculatorPopupUI.compPreferredSize.width - 3, KingdeeCalculatorPopupUI.compPreferredSize.height - 3);
        g.drawLine(2, KingdeeCalculatorPopupUI.compPreferredSize.height - 3, KingdeeCalculatorPopupUI.compPreferredSize.width - 4, KingdeeCalculatorPopupUI.compPreferredSize.height - 3);
        g.setColor(UIManager.getColor("Calculator.bgColor6"));
        g.drawLine(3, 3, KingdeeCalculatorPopupUI.compPreferredSize.width - 5, 3);
        g.drawLine(3, 4, 3, KingdeeCalculatorPopupUI.compPreferredSize.height - 5);
        g.setColor(UIManager.getColor("Calculator.bgColor7"));
        g.drawLine(KingdeeCalculatorPopupUI.compPreferredSize.width - 4, 3, KingdeeCalculatorPopupUI.compPreferredSize.width - 4, KingdeeCalculatorPopupUI.compPreferredSize.height - 4);
        g.drawLine(3, KingdeeCalculatorPopupUI.compPreferredSize.height - 4, KingdeeCalculatorPopupUI.compPreferredSize.width - 5, KingdeeCalculatorPopupUI.compPreferredSize.height - 4);
        g.setColor(UIManager.getColor("Calculator.bgColor8"));
        g.fillRect(4, 4, KingdeeCalculatorPopupUI.compPreferredSize.width - 7, KingdeeCalculatorPopupUI.compPreferredSize.height - 7);
        g.setColor(oldColor);
        this.calculatorPopup.requestFocusInWindow();
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return super.contains(c, x, y);
    }

    @Override
    public Accessible getAccessibleChild(JComponent c, int i) {
        return super.getAccessibleChild(c, i);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent c) {
        return super.getAccessibleChildrenCount(c);
    }

    public void dispatchUserEvent(UserEvent e) {
        this.cm.dispatch(e.getCommand());
    }

    public void sendCommand(String command) {
        this.cm.dispatch(command);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension dim = this.getPreferredSize(c);
        dim.width += dim.width + c.getInsets().left + c.getInsets().right + 20;
        dim.height += dim.height + c.getInsets().top + c.getInsets().right + 20;
        return dim;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getMaximumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return compPreferredSize;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.calculatorPopup = (KDCalculatorPopup)c;
        this.cm = this.calculatorPopup.getModel();
        this.createLayout();
        c.setLayout(this.layout);
        this.installComponents(this.calculatorPopup);
        this.installDefaults(this.calculatorPopup);
        this.installListeners(this.calculatorPopup);
        this.installKeyboardActions(this.calculatorPopup);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.unInstallKeyboardActions((KDCalculatorPopup)c);
        this.unInstallListeners((KDCalculatorPopup)c);
        this.unInstallDefaults((KDCalculatorPopup)c);
        this.unInstallComponents((KDCalculatorPopup)c);
        this.cm = null;
        super.uninstallUI(c);
    }

    public void setPrecision(int precision, boolean enableChange) {
        if (precision < 0 || precision > 15) {
            throw new ArithmeticException("Precision out of range [0,15]");
        }
        this.spinner.setValue(precision);
        this.spinner.setEnabled(true);
        this.adjustScaleByStep(0);
        this.spinner.setEnabled(enableChange);
    }

    protected void installComponents(KDCalculatorPopup c) {
        this.display = this.calculatorPopup.getDisplay();
        this.buttonStrings = KDCalculatorModel.commandButtonlabels;
        this.buttonList = new ArrayList(this.buttonStrings.length);
        this.spinner = this.createSpinner();
        if (this.labelContainer == null) {
            this.labelContainer = new KDLabelContainer();
            this.labelContainer.setBoundEditor(this.spinner);
            this.labelContainer.setBoundLabelText(KDResourceManager.getMLS("exactDecimal", "\u7cbe\u786e\u5c0f\u6570\u4f4d"));
            this.labelContainer.getBoundLabel().setForeground(UIManager.getColor("Calculator.LabelTextColor"));
            this.labelContainer.setBoundLabelUnderline(true);
            this.labelContainer.setPreferredSize(this.labelContainerSize);
            this.labelContainer.getBoundEditor().setFocusable(false);
            this.labelContainer.setFocusable(false);
            this.labelContainer.setVisible(false);
            c.add((Component)this.labelContainer, "labelContainer");
        }
        for (int i = 0; i < this.buttonStrings.length; ++i) {
            KDWorkButton workButton = this.createButton(this.buttonStrings[i]);
            this.buttonList.add(workButton);
            c.add((Component)workButton, this.buttonStrings[i]);
        }
    }

    protected void unInstallComponents(KDCalculatorPopup c) {
        c.setLayout(null);
        c.removeAll();
        this.labelContainer = null;
        this.display = null;
        this.spinner = null;
        this.buttonList = null;
        this.buttonStrings = null;
    }

    protected void installDefaults(KDCalculatorPopup c) {
    }

    protected void unInstallDefaults(KDCalculatorPopup c) {
    }

    protected void installListeners(KDCalculatorPopup c) {
        if (this.keyListener == null) {
            this.keyListener = new CalculatorKeyListener();
        }
        if (this.mouseListener == null) {
            this.mouseListener = new CalculatorMouseListener();
        }
        if (this.changeListener == null) {
            this.changeListener = new CalculatorChangeListener();
        }
        if (this.modelListener == null) {
            this.modelListener = new CalculatorModelListener();
        }
        this.spinner.addChangeListener(this.changeListener);
        this.addButtonKeyListener(this.buttonList, this.keyListener);
        this.addButtonMouseListener(this.buttonList, this.mouseListener);
        this.calculatorPopup.addKeyListener(this.keyListener);
        this.cm.addCalculateListener(this.modelListener);
    }

    protected void unInstallListeners(KDCalculatorPopup c) {
        if (this.keyListener != null) {
            this.removeButtonKeyListener(this.buttonList, this.keyListener);
            this.calculatorPopup.removeKeyListener(this.keyListener);
            this.keyListener = null;
        }
        if (this.changeListener != null) {
            this.spinner.removeChangeListener(this.changeListener);
            this.changeListener = null;
        }
        if (this.modelListener != null) {
            this.cm.removeCalculateListener(this.modelListener);
            this.modelListener = null;
        }
        if (this.mouseListener != null) {
            this.removeButtonMouseListener(this.buttonList, this.mouseListener);
            this.mouseListener = null;
        }
    }

    protected void installKeyboardActions(KDCalculatorPopup c) {
    }

    protected void unInstallKeyboardActions(KDCalculatorPopup c) {
    }

    protected KDSpinner createSpinner() {
        KDSpinner spinner = new KDSpinner();
        spinner.setEditable(false);
        spinner.setValue(2);
        spinner.setFocusable(false);
        spinner.getEditor().setFocusable(false);
        return spinner;
    }

    protected void createLayout() {
        if (this.layout == null) {
            this.layout = new CalculatorLayout();
        }
    }

    protected KDWorkButton createButton(String text) {
        KDWorkButton button = new KDWorkButton(text);
        if (text.equals("1") || text.equals("2") || text.equals("3") || text.equals("4") || text.equals("5") || text.equals("6") || text.equals("7") || text.equals("8") || text.equals("9") || text.equals("0") || text.equals("+/-") || text.equals(".")) {
            button.setForeground(UIManager.getColor("Calculator.buttonTextColor2"));
        } else {
            button.setForeground(UIManager.getColor("Calculator.buttonTextColor1"));
        }
        button.setActionCommand(text);
        button.setPreferredSize(this.buttonSize);
        button.setFocusable(false);
        if ("MR".equals(text)) {
            this.mrBtn = button;
        }
        return button;
    }

    private int getLabelIndex(String label) {
        for (int i = 0; i < this.buttonStrings.length; ++i) {
            if (!this.buttonStrings[i].equals(label)) continue;
            return i;
        }
        return -1;
    }

    private void addButtonKeyListener(List list, KeyListener keyListener) {
        for (int i = 0; i < list.size(); ++i) {
            ((KDWorkButton)list.get(i)).addKeyListener(keyListener);
        }
    }

    private void removeButtonKeyListener(List list, KeyListener keyListener) {
        for (int i = 0; i < list.size(); ++i) {
            ((KDWorkButton)list.get(i)).removeKeyListener(keyListener);
        }
    }

    private void addButtonMouseListener(List list, MouseListener mouseListener) {
        for (int i = 0; i < list.size(); ++i) {
            ((KDWorkButton)list.get(i)).addMouseListener(mouseListener);
        }
    }

    private void removeButtonMouseListener(List list, MouseListener mouseListener) {
        for (int i = 0; i < list.size(); ++i) {
            ((KDWorkButton)list.get(i)).removeMouseListener(mouseListener);
        }
    }

    private void adjustScaleByStep(int step) {
        if (!this.spinner.isEnabled()) {
            return;
        }
        int value = (Integer)this.spinner.getValue() + step;
        if (value < 0) {
            value = 0;
        } else if (value > 15) {
            value = 15;
        }
        this.cm.setScale(value);
        this.spinner.setValue(value);
        ((KDWorkButton)this.buttonList.get(this.getLabelIndex("="))).requestFocus();
        this.calculatorPopup.requestFocusInWindow();
    }

    private void tranceKeyEventToButtonClick(KeyEvent e) {
        Window w;
        String keyChar = String.valueOf(e.getKeyChar());
        switch (e.getKeyCode()) {
            default: {
                break;
            }
            case 8: {
                keyChar = "Back";
                break;
            }
            case 127: {
                keyChar = "CE";
                break;
            }
            case 76: {
                if (!e.isControlDown()) break;
                keyChar = "MC";
                break;
            }
            case 82: {
                if (e.isControlDown()) {
                    keyChar = "MR";
                    break;
                }
                keyChar = "1/x";
                break;
            }
            case 77: {
                if (!e.isControlDown()) break;
                keyChar = "MS";
                break;
            }
            case 80: {
                if (!e.isControlDown()) break;
                keyChar = "M+";
                break;
            }
            case 50: {
                if (!e.isShiftDown()) break;
                keyChar = "sqrt";
                break;
            }
            case 53: {
                if (!e.isShiftDown()) break;
                keyChar = "%";
                break;
            }
            case 10: {
                keyChar = "=";
                break;
            }
            case 47: 
            case 111: {
                keyChar = "/";
                break;
            }
            case 106: {
                keyChar = "*";
                break;
            }
            case 56: {
                if (!e.isShiftDown()) break;
                keyChar = "*";
                break;
            }
            case 45: {
                if (e.isShiftDown()) break;
                keyChar = "-";
                break;
            }
            case 109: {
                keyChar = "-";
                break;
            }
            case 61: {
                if (!e.isShiftDown()) break;
                keyChar = "+";
                break;
            }
            case 107: {
                keyChar = "+";
                break;
            }
            case 120: {
                keyChar = "+/-";
                break;
            }
            case 110: {
                keyChar = ".";
                break;
            }
            case 67: {
                if (e.isControlDown()) {
                    this.copyToClipboard();
                    break;
                }
                keyChar = "NIL";
                break;
            }
            case 86: {
                if (e.isControlDown()) {
                    this.pasteFromClipboard();
                    break;
                }
                keyChar = "NIL";
                break;
            }
            case 38: {
                this.adjustScaleByStep(1);
                break;
            }
            case 40: {
                this.adjustScaleByStep(-1);
            }
        }
        int i = this.getLabelIndex(keyChar);
        if (i != -1) {
            ((JButton)this.buttonList.get(i)).doClick();
        }
        this.dispatchUserEvent(new UserEvent(e.getSource(), keyChar));
        if (keyChar.equals("=") && (w = SwingUtilities.getWindowAncestor(this.calculatorPopup)) instanceof KDDialog) {
            w.dispose();
        }
    }

    private void copyToClipboard() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkSystemClipboardAccess();
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        StringSelection st = new StringSelection(this.cm.getExpressValue());
        Clipboard cp = tk.getSystemClipboard();
        cp.setContents(st, this.calculatorPopup);
    }

    private void pasteFromClipboard() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkSystemClipboardAccess();
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Clipboard cp = tk.getSystemClipboard();
        try {
            String express = (String)cp.getContents(this).getTransferData(DataFlavor.stringFlavor);
            for (int i = 0; i < express.length(); ++i) {
                char ch = express.charAt(i);
                String cmd = String.valueOf(ch);
                if (ch == 'r' || ch == 'R') {
                    cmd = "1/x";
                } else if (ch == '@') {
                    cmd = "sqrt";
                } else if (ch == '\n') {
                    cmd = "=";
                }
                int j = this.getLabelIndex(cmd);
                if (j != -1) {
                    ((JButton)this.buttonList.get(j)).doClick();
                }
                this.dispatchUserEvent(new UserEvent(this.display, cmd));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class UserEvent
    extends EventObject {
        private static final long serialVersionUID = -3757481230067475783L;
        private String command = null;

        public String getCommand() {
            return this.command;
        }

        @Override
        public String toString() {
            return this.command;
        }

        public UserEvent(Object source, String command) {
            super(source);
            this.command = command;
        }
    }

    private class CalculatorModelListener
    implements ICalculatorModelListener {
        private CalculatorModelListener() {
        }

        @Override
        public void displayChanged(String value) {
            KingdeeCalculatorPopupUI.this.display.setText(value);
            KingdeeCalculatorPopupUI.this.calculatorPopup.setResult(new BigDecimal(value));
        }

        @Override
        public void memoryStatusChanged(boolean flag) {
            String tag = flag ? "*" : "";
            KingdeeCalculatorPopupUI.this.mrBtn.setText(KingdeeCalculatorPopupUI.this.mrBtn.getActionCommand() + tag);
            KingdeeCalculatorPopupUI.this.mrBtn.setToolTipText(KingdeeCalculatorPopupUI.this.cm.getStatus().getMemory());
        }

        @Override
        public void messageAccepted(String msg) {
            KingdeeCalculatorPopupUI.this.display.setText(msg);
        }
    }

    private class CalculatorChangeListener
    implements ChangeListener {
        private CalculatorChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            KingdeeCalculatorPopupUI.this.adjustScaleByStep(0);
        }
    }

    private class CalculatorMouseListener
    implements MouseListener {
        private CalculatorMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getModifiers() == 16 && e.getSource() instanceof JButton) {
                KingdeeCalculatorPopupUI.this.dispatchUserEvent(new UserEvent(e.getSource(), ((JButton)e.getSource()).getActionCommand()));
            }
            KingdeeCalculatorPopupUI.this.calculatorPopup.requestFocusInWindow();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class CalculatorKeyListener
    implements KeyListener {
        private CalculatorKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            KingdeeCalculatorPopupUI.this.tranceKeyEventToButtonClick(e);
            KingdeeCalculatorPopupUI.this.calculatorPopup.requestFocusInWindow();
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    private class CalculatorLayout
    implements LayoutManager {
        private Component labelContainer;
        private Component backBtn;
        private Component ceBtn;
        private Component cBtn;
        private Component mcBtn;
        private Component mrBtn;
        private Component msBtn;
        private Component mpBtn;
        private Component zeroBtn;
        private Component oneBtn;
        private Component twoBtn;
        private Component threeBtn;
        private Component fourBtn;
        private Component fiveBtn;
        private Component sixBtn;
        private Component sevenBtn;
        private Component eightBtn;
        private Component nineBtn;
        private Component signBtn;
        private Component dotBtn;
        private Component divideBtn;
        private Component multiplyBtn;
        private Component subtractBtn;
        private Component plusBtn;
        private Component sqrtBtn;
        private Component percentBtn;
        private Component denominatorBtn;
        private Component resultBtn;

        private CalculatorLayout() {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp == this.labelContainer) {
                this.labelContainer = null;
                return;
            }
            if (comp == this.backBtn) {
                this.backBtn = null;
                return;
            }
            if (comp == this.ceBtn) {
                this.ceBtn = null;
                return;
            }
            if (comp == this.cBtn) {
                this.cBtn = null;
                return;
            }
            if (comp == this.mcBtn) {
                this.mcBtn = null;
                return;
            }
            if (comp == this.mrBtn) {
                this.mrBtn = null;
                return;
            }
            if (comp == this.msBtn) {
                this.msBtn = null;
                return;
            }
            if (comp == this.mpBtn) {
                this.mpBtn = null;
                return;
            }
            if (comp == this.zeroBtn) {
                this.zeroBtn = null;
                return;
            }
            if (comp == this.oneBtn) {
                this.oneBtn = null;
                return;
            }
            if (comp == this.twoBtn) {
                this.twoBtn = null;
                return;
            }
            if (comp == this.threeBtn) {
                this.threeBtn = null;
                return;
            }
            if (comp == this.fourBtn) {
                this.fourBtn = null;
                return;
            }
            if (comp == this.fiveBtn) {
                this.fiveBtn = null;
                return;
            }
            if (comp == this.sixBtn) {
                this.sixBtn = null;
                return;
            }
            if (comp == this.sevenBtn) {
                this.sevenBtn = null;
                return;
            }
            if (comp == this.eightBtn) {
                this.eightBtn = null;
                return;
            }
            if (comp == this.nineBtn) {
                this.nineBtn = null;
                return;
            }
            if (comp == this.signBtn) {
                this.signBtn = null;
                return;
            }
            if (comp == this.dotBtn) {
                this.dotBtn = null;
                return;
            }
            if (comp == this.divideBtn) {
                this.divideBtn = null;
                return;
            }
            if (comp == this.multiplyBtn) {
                this.multiplyBtn = null;
                return;
            }
            if (comp == this.subtractBtn) {
                this.subtractBtn = null;
                return;
            }
            if (comp == this.plusBtn) {
                this.plusBtn = null;
                return;
            }
            if (comp == this.sqrtBtn) {
                this.sqrtBtn = null;
                return;
            }
            if (comp == this.percentBtn) {
                this.percentBtn = null;
                return;
            }
            if (comp == this.denominatorBtn) {
                this.denominatorBtn = null;
                return;
            }
            if (comp == this.resultBtn) {
                this.resultBtn = null;
                return;
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            int count = parent.getComponentCount();
            if (count <= 0) {
                return;
            }
            Dimension labelContainerDim = this.preferredSize(this.labelContainer);
            Point labelContainerPoint = new Point();
            labelContainerPoint.x = insets.left;
            labelContainerPoint.y = insets.top;
            Point backBtnPoint = new Point();
            backBtnPoint.x = labelContainerPoint.x + labelContainerDim.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            backBtnPoint.y = insets.top;
            Point ceBtnPoint = new Point();
            ceBtnPoint.x = backBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            ceBtnPoint.y = insets.top;
            Point cBtnPoint = new Point();
            cBtnPoint.x = ceBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            cBtnPoint.y = insets.top;
            Point mcBtnPoint = new Point();
            mcBtnPoint.x = insets.left;
            mcBtnPoint.y = cBtnPoint.y + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height + KingdeeCalculatorPopupUI.this.wideInterval;
            Point sevenBtnPoint = new Point();
            sevenBtnPoint.x = mcBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.wideInterval;
            sevenBtnPoint.y = mcBtnPoint.y;
            Point eightBtnPoint = new Point();
            eightBtnPoint.x = sevenBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            eightBtnPoint.y = mcBtnPoint.y;
            Point nineBtnPoint = new Point();
            nineBtnPoint.x = eightBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            nineBtnPoint.y = mcBtnPoint.y;
            Point divideBtnPoint = new Point();
            divideBtnPoint.x = nineBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            divideBtnPoint.y = mcBtnPoint.y;
            Point sqrtBtnPoint = new Point();
            sqrtBtnPoint.x = divideBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            sqrtBtnPoint.y = mcBtnPoint.y;
            Point mrBtnPoint = new Point();
            mrBtnPoint.x = insets.left;
            mrBtnPoint.y = mcBtnPoint.y + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height + KingdeeCalculatorPopupUI.this.narrowInterval;
            Point fourBtnPoint = new Point();
            fourBtnPoint.x = mrBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.wideInterval;
            fourBtnPoint.y = mrBtnPoint.y;
            Point fiveBtnPoint = new Point();
            fiveBtnPoint.x = fourBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            fiveBtnPoint.y = mrBtnPoint.y;
            Point sixBtnPoint = new Point();
            sixBtnPoint.x = fiveBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            sixBtnPoint.y = mrBtnPoint.y;
            Point multiplyBtnPoint = new Point();
            multiplyBtnPoint.x = sixBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            multiplyBtnPoint.y = mrBtnPoint.y;
            Point percentBtnPoint = new Point();
            percentBtnPoint.x = multiplyBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            percentBtnPoint.y = mrBtnPoint.y;
            Point msBtnPoint = new Point();
            msBtnPoint.x = insets.left;
            msBtnPoint.y = mrBtnPoint.y + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height + KingdeeCalculatorPopupUI.this.narrowInterval;
            Point oneBtnPoint = new Point();
            oneBtnPoint.x = msBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.wideInterval;
            oneBtnPoint.y = msBtnPoint.y;
            Point twoBtnPoint = new Point();
            twoBtnPoint.x = oneBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            twoBtnPoint.y = msBtnPoint.y;
            Point threeBtnPoint = new Point();
            threeBtnPoint.x = twoBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            threeBtnPoint.y = msBtnPoint.y;
            Point subtractBtnPoint = new Point();
            subtractBtnPoint.x = threeBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            subtractBtnPoint.y = msBtnPoint.y;
            Point denominatorBtnPoint = new Point();
            denominatorBtnPoint.x = subtractBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            denominatorBtnPoint.y = msBtnPoint.y;
            Point mpBtnPoint = new Point();
            mpBtnPoint.x = insets.left;
            mpBtnPoint.y = msBtnPoint.y + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height + KingdeeCalculatorPopupUI.this.narrowInterval;
            Point zeroBtnPoint = new Point();
            zeroBtnPoint.x = mpBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.wideInterval;
            zeroBtnPoint.y = mpBtnPoint.y;
            Point signBtnPoint = new Point();
            signBtnPoint.x = zeroBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            signBtnPoint.y = mpBtnPoint.y;
            Point dotBtnPoint = new Point();
            dotBtnPoint.x = signBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            dotBtnPoint.y = mpBtnPoint.y;
            Point plusBtnPoint = new Point();
            plusBtnPoint.x = dotBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            plusBtnPoint.y = mpBtnPoint.y;
            Point resultBtnPoint = new Point();
            resultBtnPoint.x = plusBtnPoint.x + ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width + KingdeeCalculatorPopupUI.this.narrowInterval;
            resultBtnPoint.y = mpBtnPoint.y;
            Rectangle labelContainerRect = new Rectangle(labelContainerPoint.x, labelContainerPoint.y, labelContainerDim.width, labelContainerDim.height);
            Rectangle backBtnRect = new Rectangle(backBtnPoint.x, backBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle ceBtnRect = new Rectangle(ceBtnPoint.x, ceBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle cBtnRect = new Rectangle(cBtnPoint.x, cBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle mcBtnRect = new Rectangle(mcBtnPoint.x, mcBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle msBtnRect = new Rectangle(msBtnPoint.x, msBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle mrBtnRect = new Rectangle(mrBtnPoint.x, mrBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle mpBtnRect = new Rectangle(mpBtnPoint.x, mpBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle zeroBtnRect = new Rectangle(zeroBtnPoint.x, zeroBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle oneBtnRect = new Rectangle(oneBtnPoint.x, oneBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle twoBtnRect = new Rectangle(twoBtnPoint.x, twoBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle threeBtnRect = new Rectangle(threeBtnPoint.x, threeBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle fourBtnRect = new Rectangle(fourBtnPoint.x, fourBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle fiveBtnRect = new Rectangle(fiveBtnPoint.x, fiveBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle sixBtnRect = new Rectangle(sixBtnPoint.x, sixBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle sevenBtnRect = new Rectangle(sevenBtnPoint.x, sevenBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle eightBtnRect = new Rectangle(eightBtnPoint.x, eightBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle nineBtnRect = new Rectangle(nineBtnPoint.x, nineBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle signBtnRect = new Rectangle(signBtnPoint.x, signBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle dotBtnRect = new Rectangle(dotBtnPoint.x, dotBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle divideBtnRect = new Rectangle(divideBtnPoint.x, divideBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle multiplyBtnRect = new Rectangle(multiplyBtnPoint.x, multiplyBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle subtractBtnRect = new Rectangle(subtractBtnPoint.x, subtractBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle plusBtnRect = new Rectangle(plusBtnPoint.x, plusBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle sqrtBtnRect = new Rectangle(sqrtBtnPoint.x, sqrtBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle percentBtnRect = new Rectangle(percentBtnPoint.x, percentBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle denominatorBtnRect = new Rectangle(denominatorBtnPoint.x, denominatorBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            Rectangle resultBtnRect = new Rectangle(resultBtnPoint.x, resultBtnPoint.y, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.width, ((KingdeeCalculatorPopupUI)KingdeeCalculatorPopupUI.this).buttonSize.height);
            this.labelContainer.setBounds(labelContainerRect.x, labelContainerRect.y, labelContainerRect.width, labelContainerRect.height);
            this.backBtn.setBounds(backBtnRect.x, backBtnRect.y, backBtnRect.width, backBtnRect.height);
            this.ceBtn.setBounds(ceBtnRect.x, ceBtnRect.y, ceBtnRect.width, ceBtnRect.height);
            this.cBtn.setBounds(cBtnRect.x, cBtnRect.y, cBtnRect.width, cBtnRect.height);
            this.mcBtn.setBounds(mcBtnRect.x, mcBtnRect.y, mcBtnRect.width, mcBtnRect.height);
            this.mrBtn.setBounds(mrBtnRect.x, mrBtnRect.y, mrBtnRect.width, mrBtnRect.height);
            this.msBtn.setBounds(msBtnRect.x, msBtnRect.y, msBtnRect.width, msBtnRect.height);
            this.mpBtn.setBounds(mpBtnRect.x, mpBtnRect.y, mpBtnRect.width, mpBtnRect.height);
            this.zeroBtn.setBounds(zeroBtnRect.x, zeroBtnRect.y, zeroBtnRect.width, zeroBtnRect.height);
            this.oneBtn.setBounds(oneBtnRect.x, oneBtnRect.y, oneBtnRect.width, oneBtnRect.height);
            this.twoBtn.setBounds(twoBtnRect.x, twoBtnRect.y, twoBtnRect.width, twoBtnRect.height);
            this.threeBtn.setBounds(threeBtnRect.x, threeBtnRect.y, threeBtnRect.width, threeBtnRect.height);
            this.fourBtn.setBounds(fourBtnRect.x, fourBtnRect.y, fourBtnRect.width, fourBtnRect.height);
            this.fiveBtn.setBounds(fiveBtnRect.x, fiveBtnRect.y, fiveBtnRect.width, fiveBtnRect.height);
            this.sixBtn.setBounds(sixBtnRect.x, sixBtnRect.y, sixBtnRect.width, sixBtnRect.height);
            this.sevenBtn.setBounds(sevenBtnRect.x, sevenBtnRect.y, sevenBtnRect.width, sevenBtnRect.height);
            this.eightBtn.setBounds(eightBtnRect.x, eightBtnRect.y, eightBtnRect.width, eightBtnRect.height);
            this.nineBtn.setBounds(nineBtnRect.x, nineBtnRect.y, nineBtnRect.width, nineBtnRect.height);
            this.signBtn.setBounds(signBtnRect.x, signBtnRect.y, signBtnRect.width, signBtnRect.height);
            this.dotBtn.setBounds(dotBtnRect.x, dotBtnRect.y, dotBtnRect.width, dotBtnRect.height);
            this.divideBtn.setBounds(divideBtnRect.x, divideBtnRect.y, divideBtnRect.width, divideBtnRect.height);
            this.multiplyBtn.setBounds(multiplyBtnRect.x, multiplyBtnRect.y, multiplyBtnRect.width, multiplyBtnRect.height);
            this.subtractBtn.setBounds(subtractBtnRect.x, subtractBtnRect.y, subtractBtnRect.width, subtractBtnRect.height);
            this.plusBtn.setBounds(plusBtnRect.x, plusBtnRect.y, plusBtnRect.width, plusBtnRect.height);
            this.sqrtBtn.setBounds(sqrtBtnRect.x, sqrtBtnRect.y, sqrtBtnRect.width, sqrtBtnRect.height);
            this.percentBtn.setBounds(percentBtnRect.x, percentBtnRect.y, percentBtnRect.width, percentBtnRect.height);
            this.denominatorBtn.setBounds(denominatorBtnRect.x, denominatorBtnRect.y, denominatorBtnRect.width, denominatorBtnRect.height);
            this.resultBtn.setBounds(resultBtnRect.x, resultBtnRect.y, resultBtnRect.width, resultBtnRect.height);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (name.equals("labelContainer")) {
                this.labelContainer = comp;
            }
            if (name.equals("Back")) {
                this.backBtn = comp;
            }
            if (name.equals("CE")) {
                this.ceBtn = comp;
            }
            if (name.equals("C")) {
                this.cBtn = comp;
            }
            if (name.equals("MC")) {
                this.mcBtn = comp;
            }
            if (name.equals("MR")) {
                this.mrBtn = comp;
            }
            if (name.equals("MS")) {
                this.msBtn = comp;
            }
            if (name.equals("M+")) {
                this.mpBtn = comp;
            }
            if (name.equals("0")) {
                this.zeroBtn = comp;
            }
            if (name.equals("1")) {
                this.oneBtn = comp;
            }
            if (name.equals("2")) {
                this.twoBtn = comp;
            }
            if (name.equals("3")) {
                this.threeBtn = comp;
            }
            if (name.equals("4")) {
                this.fourBtn = comp;
            }
            if (name.equals("5")) {
                this.fiveBtn = comp;
            }
            if (name.equals("6")) {
                this.sixBtn = comp;
            }
            if (name.equals("7")) {
                this.sevenBtn = comp;
            }
            if (name.equals("8")) {
                this.eightBtn = comp;
            }
            if (name.equals("9")) {
                this.nineBtn = comp;
            }
            if (name.equals("+/-")) {
                this.signBtn = comp;
            }
            if (name.equals(".")) {
                this.dotBtn = comp;
            }
            if (name.equals("/")) {
                this.divideBtn = comp;
            }
            if (name.equals("*")) {
                this.multiplyBtn = comp;
            }
            if (name.equals("-")) {
                this.subtractBtn = comp;
            }
            if (name.equals("+")) {
                this.plusBtn = comp;
            }
            if (name.equals("sqrt")) {
                this.sqrtBtn = comp;
            }
            if (name.equals("%")) {
                this.percentBtn = comp;
            }
            if (name.equals("1/x")) {
                this.denominatorBtn = comp;
            }
            if (name.equals("=")) {
                this.resultBtn = comp;
            }
        }

        private Dimension preferredSize(Component c) {
            return c == null ? zeroDim : c.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }
    }
}

