/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.dial;

import com.kingdee.cosmic.ctrl.swing.dial.DialIndicator;
import com.kingdee.cosmic.ctrl.swing.dial.DialNeedle;
import com.kingdee.cosmic.ctrl.swing.dial.DialPan;
import com.kingdee.cosmic.ctrl.swing.dial.DialScale;
import com.kingdee.cosmic.ctrl.swing.dial.DialTitle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BasicDial
extends JComponent {
    private static final long serialVersionUID = 519488716969085737L;
    protected static final int DEFAULTSIZE = 1;
    public static final double MIN = 0.8;
    protected List needles;
    protected List scales;
    protected DialPan pan;
    protected List indicators;
    protected DialTitle title;
    protected DialTitle unitTitle = new DialTitle("");
    protected transient ChangeEvent changeEvent = null;

    public BasicDial() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(133, 90));
    }

    public void setValue(int index, Object value) {
        DialNeedle ndl = this.getNeedle(index);
        if (ndl != null) {
            ndl.setValue(value);
            this.fireStateChanged();
            this.repaint();
        }
    }

    public Object getValue(int index) {
        Object ret = null;
        DialNeedle ndl = this.getNeedle(index);
        if (ndl != null) {
            ret = ndl.getValue();
        }
        return ret;
    }

    public void setValue(Object key, Object value) {
        DialNeedle ndl = this.getNeedle(key);
        if (ndl != null) {
            ndl.setValue(value);
            this.fireStateChanged();
            this.repaint();
        }
    }

    public Object getValue(Object key) {
        Object ret = null;
        DialNeedle ndl = this.getNeedle(key);
        if (ndl != null) {
            ret = ndl.getValue();
        }
        return ret;
    }

    public void setValue(Object value) {
        this.setValue(0, value);
    }

    public Object getValue() {
        return this.getValue(0);
    }

    public void addNeedle(DialNeedle needle, Object key) {
        NeedleItem item = new NeedleItem(key, needle);
        if (this.needles == null) {
            this.needles = new ArrayList(1);
        }
        this.needles.add(item);
    }

    public void removeNeedle(Object key) {
        this.removeElement(key, this.needles);
    }

    public void removeNeedle(int index) {
        this.removeElement(index, this.needles);
    }

    public DialNeedle getNeedle(Object key) {
        NeedleItem item = (NeedleItem)this.getElement(key, this.needles);
        if (item != null) {
            return item.needle;
        }
        return null;
    }

    public DialNeedle getNeedle(int index) {
        NeedleItem item = (NeedleItem)this.getElement(index, this.needles);
        if (item != null) {
            return item.needle;
        }
        return null;
    }

    public int getNeedlesCount() {
        return this.getElementsCount(this.needles);
    }

    public void addScale(DialScale scale, Object key) {
        ScaleItem item = new ScaleItem(key, scale);
        if (this.scales == null) {
            this.scales = new ArrayList(1);
        }
        this.scales.add(item);
    }

    public void removeScale(Object key) {
        this.removeElement(key, this.scales);
    }

    public void removeScale(int index) {
        this.removeElement(index, this.scales);
    }

    public DialScale getScale(Object key) {
        ScaleItem item = (ScaleItem)this.getElement(key, this.scales);
        if (item != null) {
            return item.scale;
        }
        return null;
    }

    public DialScale getScale(int index) {
        ScaleItem item = (ScaleItem)this.getElement(index, this.scales);
        if (item != null) {
            return item.scale;
        }
        return null;
    }

    public int getScalesCount() {
        return this.getElementsCount(this.scales);
    }

    public void addIndicator(DialIndicator indicator, Object key) {
        indicator.install(this);
        IndicatorItem item = new IndicatorItem(key, indicator);
        if (this.indicators == null) {
            this.indicators = new ArrayList(1);
        }
        this.indicators.add(item);
    }

    public void removeIndicator(Object key) {
        DialIndicator indr = this.getIndicator(key);
        if (indr != null) {
            indr.dismiss();
            this.removeElement(key, this.indicators);
        }
    }

    public void removeIndicator(int index) {
        DialIndicator indr = this.getIndicator(index);
        if (indr != null) {
            indr.dismiss();
            this.removeElement(index, this.indicators);
        }
    }

    public DialIndicator getIndicator(Object key) {
        IndicatorItem item = (IndicatorItem)this.getElement(key, this.indicators);
        if (item != null) {
            return item.indicator;
        }
        return null;
    }

    public DialIndicator getIndicator(int index) {
        IndicatorItem item = (IndicatorItem)this.getElement(index, this.indicators);
        if (item != null) {
            return item.indicator;
        }
        return null;
    }

    public int getIndicatorsCount() {
        return this.getElementsCount(this.indicators);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int i;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, width, height);
        }
        Insets ins = this.getInsets();
        Rectangle area = new Rectangle(ins.top, ins.left, width -= ins.left + ins.right, height -= ins.top + ins.bottom);
        if (this.pan != null) {
            this.pan.draw(g, area, this);
        }
        ScaleItem si = null;
        IndicatorItem ii = null;
        NeedleItem ni = null;
        if (this.scales != null) {
            for (i = 0; i < this.scales.size(); ++i) {
                si = (ScaleItem)this.scales.get(i);
                si.scale.draw(g, area, this);
            }
        }
        if (this.indicators != null) {
            for (i = 0; i < this.indicators.size(); ++i) {
                ii = (IndicatorItem)this.indicators.get(i);
                ii.indicator.draw(g, area, this);
            }
        }
        if (this.needles != null) {
            for (i = 0; i < this.needles.size(); ++i) {
                ni = (NeedleItem)this.needles.get(i);
                ni.needle.draw(g, area, this);
            }
        }
        this.drawTitle(g2);
    }

    protected void drawTitle(Graphics2D g2) {
        this.setToolTipText(this.generateToolTip());
        AffineTransform oldTrans = g2.getTransform();
        DialTitle ttl = this.getTitle();
        if (ttl != null) {
            Point pt = this.getTitle().getLocation();
            g2.translate(pt.x, pt.y);
            ttl.paint(g2);
            g2.setTransform(oldTrans);
        }
    }

    protected String generateToolTip() {
        StringBuilder tip = new StringBuilder();
        Format ft = null;
        Object val = null;
        int count = this.getNeedlesCount();
        for (int i = 0; i < count; ++i) {
            DialNeedle ndl = this.getNeedle(i);
            DialScale scl = ndl.getScale();
            if (scl == null) continue;
            tip.append(scl.getCaption());
            tip.append(':');
            val = ndl.getValue();
            ft = scl.getTickLabelFormat();
            if (ft != null) {
                tip.append(ft.format(val));
            } else {
                tip.append(val);
            }
            tip.append(' ');
        }
        return tip.toString();
    }

    private int indexOf(Object key, List list) {
        int index = -1;
        QueuedItem item = null;
        for (int i = 0; i < list.size(); ++i) {
            item = (QueuedItem)list.get(i);
            if (!item.key.equals(key)) continue;
            index = i;
            break;
        }
        return index;
    }

    protected void removeElement(Object key, List list) {
        if (list == null) {
            return;
        }
        int i = this.indexOf(key, list);
        if (i < 0) {
            return;
        }
        list.remove(i);
    }

    protected void removeElement(int index, List list) {
        if (list == null) {
            return;
        }
        list.remove(index);
    }

    protected Object getElement(Object key, List list) {
        if (list == null) {
            return null;
        }
        int i = this.indexOf(key, list);
        if (i < 0) {
            return null;
        }
        return list.get(i);
    }

    protected Object getElement(int index, List list) {
        if (list == null) {
            return null;
        }
        return list.get(index);
    }

    protected int getElementsCount(List elems) {
        if (elems != null) {
            return elems.size();
        }
        return 0;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public DialPan getPan() {
        return this.pan;
    }

    public void setPan(DialPan p) {
        this.pan = p;
    }

    public DialTitle getTitle() {
        return this.title;
    }

    public void setTitle(DialTitle t) {
        if (this.title != null) {
            this.remove(this.title);
        }
        if (t != null) {
            t.setVerticalAlignment(0);
            t.setForeground(new Color(0));
            this.title = t;
            this.add(t);
        }
    }

    public DialTitle getUnitTitle() {
        return this.unitTitle;
    }

    private void setUnitTitle(DialTitle unit) {
        if (this.unitTitle != null) {
            this.remove(this.unitTitle);
        }
        if (unit != null) {
            unit.setHorizontalAlignment(4);
            unit.setVerticalAlignment(0);
            unit.setForeground(new Color(0x676767));
            this.unitTitle = unit;
            this.add(unit);
        }
    }

    public void setUnitTitle(String unit) {
        this.setUnitTitle(new DialTitle(unit));
    }

    public BufferedImage createBufferedImage() {
        int width = this.getSize().width;
        int height = this.getSize().height;
        BufferedImage image = null;
        if (width > 0 && height > 0) {
            image = new BufferedImage(width, height, 2);
            Graphics2D g2 = image.createGraphics();
            if (!this.isOpaque()) {
                Color old = g2.getColor();
                g2.setColor(new Color(255, 255, 255, 0));
                g2.fillRect(0, 0, width, height);
                g2.setColor(old);
            }
            this.paint(g2);
            g2.dispose();
        }
        return image;
    }

    protected class IndicatorItem
    extends QueuedItem {
        public DialIndicator indicator;

        public IndicatorItem(Object k, DialIndicator indic) {
            this.key = k;
            this.indicator = indic;
        }
    }

    protected class ScaleItem
    extends QueuedItem {
        public DialScale scale;

        public ScaleItem(Object k, DialScale s) {
            this.key = k;
            this.scale = s;
        }
    }

    protected class NeedleItem
    extends QueuedItem {
        public DialNeedle needle;

        public NeedleItem(Object k, DialNeedle n) {
            this.key = k;
            this.needle = n;
        }
    }

    protected abstract class QueuedItem {
        public Object key;

        protected QueuedItem() {
        }

        public String toString() {
            String str = this.key + "(" + this.getClass() + ")";
            return str;
        }
    }
}

