/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.dial;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.swing.dial.CustomDialRange;
import com.kingdee.cosmic.ctrl.swing.dial.DialGraduator;
import com.kingdee.cosmic.ctrl.swing.dial.DialScale;
import com.kingdee.cosmic.ctrl.swing.dial.DialTickValueGenerator;
import com.kingdee.cosmic.ctrl.swing.dial.KpiRange;
import com.kingdee.cosmic.ctrl.swing.resource.KDResourceManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JComponent;

public class CustomDialScale
extends DialScale {
    private List rangeList = new ArrayList();
    protected boolean drawLabel = true;
    protected Font labelFont = new Font(CtrlCommonMessages.getMLS((String)"yahei", (String)"\u5fae\u8f6f\u96c5\u9ed1"), 1, 11);
    protected static final Color DEFAULTCOLOR = new Color(0x414142);
    protected static final Paint DEFAULTPAINT = DEFAULTCOLOR;
    protected Paint defaultPaint;
    protected Paint labelShadowPaint = this.defaultPaint = DEFAULTPAINT;
    protected static final double SCALEPOS = 0.8615384615384615;
    protected static final double TICKSWIDTH = 0.12307692307692308;
    protected static final int RADIUSMEDIUM = 60;

    protected static final String getDefaultTitle() {
        return KDResourceManager.getMLS("range", "\u8303\u56f4");
    }

    public CustomDialScale() {
    }

    public CustomDialScale(Point pt, int r) {
        super(pt, r);
    }

    public CustomDialScale(Point pt, int r, int minAngle, int arcAngle) {
        super(pt, r, minAngle, arcAngle);
    }

    public CustomDialScale(Point pt, int r, int minAngle, int arcAngle, boolean cw) {
        super(pt, r, minAngle, arcAngle, cw);
    }

    @Override
    public void setMaximumValue(Object maxValue) {
        if (maxValue instanceof Number) {
            this.maximumValue = new Double(((Number)maxValue).doubleValue());
            this.setDirty(true);
        }
    }

    @Override
    public void setMinimumValue(Object minValue) {
        if (minValue instanceof Number) {
            this.minimumValue = new Double(((Number)minValue).doubleValue());
            this.setDirty(true);
        }
    }

    public void setTotalRange(CustomDialRange range) {
        if (range == null) {
            range = new CustomDialRange(KDResourceManager.getMLS("totalRange", "\u603b\u8303\u56f4"), DEFAULTCOLOR, 0.0, 0.0);
        }
        this.setMinimumValue(new Double(range.getLowerBound()));
        this.setMaximumValue(new Double(range.getUpperBound()));
    }

    public CustomDialRange getTotalRange() {
        Double min = (Double)this.getMinimumValue();
        Double max = (Double)this.getMaximumValue();
        if (min == null || max == null) {
            return null;
        }
        return new CustomDialRange(KDResourceManager.getMLS("totalRange", "\u603b\u8303\u56f4"), DEFAULTCOLOR, min, max);
    }

    public List getRangeList() {
        return this.rangeList;
    }

    public void setRangesList(List rangesList) {
        this.rangeList = rangesList;
    }

    public CustomDialRange getRange(int index) {
        if (this.rangeList != null) {
            return (CustomDialRange)this.rangeList.get(index);
        }
        return null;
    }

    public void addRange(CustomDialRange range) {
        if (this.rangeList != null) {
            this.rangeList.add(range);
        }
    }

    public void addRanges(CustomDialRange[] ranges) {
        if (this.rangeList != null) {
            for (int i = 0; i < ranges.length; ++i) {
                this.addRange(ranges[i]);
            }
        }
    }

    public void removeRange(int index) {
        if (this.rangeList != null) {
            this.rangeList.remove(index);
        }
    }

    public void removeRange(CustomDialRange range) {
        if (this.rangeList != null && this.rangeList.contains(range)) {
            this.rangeList.remove(range);
        }
    }

    public void clearRanges() {
        if (this.rangeList != null) {
            this.rangeList.clear();
        }
    }

    protected Paint getBackgroundPaint() {
        return Color.DARK_GRAY;
    }

    public Paint getLabelShadowPaint() {
        return this.labelShadowPaint;
    }

    public void setLabelShadowPaint(Paint paint) {
        this.labelShadowPaint = paint;
    }

    @Override
    protected DialTickValueGenerator createGenerator() {
        return new CustomDialTicker();
    }

    @Override
    protected void drawTicks(Graphics2D g2, double amin, double as, JComponent c) {
        Paint oldPaint = g2.getPaint();
        Font oldFont = g2.getFont();
        g2.setFont(this.labelFont);
        int LOWANGLE = 20;
        int UPANGLE = 160;
        int GAP = 2;
        int tickLen = this.getTickLength();
        Format ft = this.getTickLabelFormat();
        String label = "";
        FontMetrics fm = g2.getFontMetrics();
        int w = 0;
        int h = fm.getAscent() - fm.getLeading();
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double x3 = 0.0;
        double y3 = 0.0;
        double rcos = 0.0;
        double rsin = 0.0;
        int r = this.getRadius();
        double angle = 0.0;
        double temp = 0.0;
        Object val = null;
        while (this.generator.hasNext()) {
            val = this.generator.next();
            angle = this.getAngle(val);
            rcos = Math.cos(Math.toRadians(angle));
            rsin = Math.sin(Math.toRadians(angle));
            x1 = (double)this.getAxle().x - rcos * (double)r;
            y1 = (double)this.getAxle().y - rsin * (double)r;
            x2 = (double)this.getAxle().x - rcos * (double)(r - tickLen);
            y2 = (double)this.getAxle().y - rsin * (double)(r - tickLen);
            g2.setPaint(this.getTicksPaint());
            g2.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
            if (!this.isTickLabelVisible() || !this.isDrawLabel()) continue;
            label = ft != null ? ft.format(val) : val.toString();
            w = fm.stringWidth(label);
            angle = Math.abs(angle % 180.0);
            temp = angle > 20.0 && angle < 160.0 ? (double)h / (2.0 * rsin) : (double)w / (2.0 * rcos);
            temp = Math.abs(temp) + 2.0;
            x3 = x2 + temp * rcos;
            y3 = y2 + temp * rsin;
            x3 -= (double)(w / 2);
            if ((y3 += (double)(h / 2)) >= (double)this.getAxle().y && y3 <= (double)(this.getAxle().y + h / 2)) {
                y3 = this.getAxle().y;
            }
            g2.setPaint(this.getLabelShadowPaint());
            g2.drawString(label, (float)x3, (float)y3);
            g2.setPaint(this.getTickLabelPaint());
            g2.drawString(label, (float)x3 - 1.0f, (float)y3 - 1.0f);
        }
        g2.setPaint(oldPaint);
        g2.setFont(oldFont);
    }

    @Override
    protected void drawArcs(Graphics2D g2, double start, double arc, JComponent c) {
        int r = this.getRadius();
        int x = this.getAxle().x;
        int y = this.getAxle().y;
        int w = this.getTickLength();
        r -= w / 2;
        Stroke old = g2.getStroke();
        BasicStroke stk = new BasicStroke(w, 0, 2);
        g2.setStroke(stk);
        Paint paint = null;
        paint = this.defaultPaint;
        start = 0.0;
        arc = 180.0;
        this.drawArc(g2, x, y, r, start, arc, paint);
        paint = this.defaultPaint;
        start = this.graduator.getAngle(this.getMinimumValue());
        arc = this.graduator.getAngle(this.getMaximumValue()) - start;
        this.drawArc(g2, x, y, r, start, arc, paint);
        if (--w < 1) {
            w = 1;
        }
        stk = new BasicStroke(w, 0, 2);
        g2.setStroke(stk);
        this.drawArc(g2, x, y, r);
        g2.setStroke(old);
    }

    private void drawArc(Graphics2D g2, int x, int y, int r) {
        CustomDialRange range2 = null;
        Color paint = null;
        double start = 0.0;
        double arc = 0.0;
        if (this.rangeList != null) {
            for (CustomDialRange range2 : this.rangeList) {
                if (range2 == null) continue;
                paint = range2.getColor();
                start = this.graduator.getAngle(new Double(range2.getLowerBound()));
                arc = this.graduator.getAngle(new Double(range2.getUpperBound())) - start;
                this.drawArc(g2, x, y, r, start, arc, paint);
            }
        }
    }

    private void drawArc(Graphics2D g2, int x, int y, int r, double start, double arc, Paint paint) {
        g2.setPaint(paint);
        Arc2D.Double arcShape = null;
        arcShape = this.isClockWise() ? new Arc2D.Double(x - r, y - r, 2 * r, 2 * r, DialScale.DialUtils.cwToGeom(start, arc), arc, 0) : new Arc2D.Double(x - r, y - r, 2 * r, 2 * r, start, arc, 0);
        g2.draw(arcShape);
    }

    @Override
    public void draw(Graphics g, Rectangle area, JComponent c) {
        int panRadius = area.width / 2;
        int sclRadius = (int)(0.8615384615384615 * (double)panRadius);
        int tickWidth = (int)(0.12307692307692308 * (double)panRadius) + 1;
        int x = area.x + panRadius;
        int y = area.y + panRadius;
        if (panRadius < 60) {
            this.setDrawLabel(false);
        } else {
            this.setDrawLabel(true);
        }
        this.setRadius(sclRadius);
        this.setAxle(new Point(x, y));
        this.setTickLength(tickWidth);
        if (this.isDirty()) {
            this.normalizeRange();
        }
        super.draw(g, area, c);
    }

    private void normalizeRange() {
        ArrayList<Double> values = new ArrayList<Double>();
        Double value = null;
        CustomDialRange range2 = null;
        CustomDialGraduator graduator = (CustomDialGraduator)this.getGraduator();
        CustomDialTicker generator = (CustomDialTicker)this.getGenerator();
        if (this.getRangeList() != null) {
            for (CustomDialRange range2 : this.getRangeList()) {
                if (range2 == null) continue;
                value = new Double(range2.getLowerBound());
                if (!values.contains(value)) {
                    values.add(value);
                }
                if (values.contains(value = new Double(range2.getUpperBound()))) continue;
                values.add(value);
            }
        }
        double vmin = 0.0;
        double vmax = 0.0;
        if (values.size() <= 0) {
            vmin = Double.POSITIVE_INFINITY;
            vmax = Double.NEGATIVE_INFINITY;
        } else {
            Collections.sort(values);
            vmin = (Double)values.get(0);
            vmax = (Double)values.get(values.size() - 1);
        }
        boolean changed = false;
        CustomDialRange r = (CustomDialRange)this.getRangeList().get(0);
        if (r == null) {
            r = new CustomDialRange(CustomDialScale.getDefaultTitle(), DEFAULTCOLOR, 0.0, 0.0);
            changed = true;
        }
        double rmin = r.getLowerBound();
        double rmax = r.getUpperBound();
        if (rmin > vmin) {
            rmin = vmin;
            changed = true;
        }
        if (rmax < vmax) {
            rmax = vmax;
            changed = true;
        }
        if (changed) {
            this.setMinimumValue(new Double(rmin));
            this.setMaximumValue(new Double(rmax));
        }
        value = new Double(rmin);
        if (values.isEmpty() || !values.get(0).equals(value)) {
            values.add(0, value);
        }
        value = new Double(rmax);
        if (values.isEmpty() || !values.get(values.size() - 1).equals(value)) {
            values.add(value);
        }
        double SCALE = 0.15;
        if (graduator != null || generator != null) {
            short temp = this.trimInfinity(values);
            Double fmin = null;
            Double fmax = null;
            if (temp != 0) {
                int size = values.size();
                double delta = 0.0;
                double left = 0.0;
                double right = 0.0;
                if (temp == 3) {
                    left = 1.0;
                    right = 1.0;
                } else if (temp == 1) {
                    left = 1.0;
                } else if (temp == 2) {
                    right = 1.0;
                }
                double DEFAULTMIN = 0.0;
                double DEFAULTMAX = 100.0;
                double DEFAULTDELTA = 100.0;
                if (size > 1) {
                    vmin = (Double)values.get(0);
                    vmax = (Double)values.get(values.size() - 1);
                } else if (size == 1) {
                    vmax = vmin = ((Double)values.get(0)).doubleValue();
                } else {
                    vmin = 0.0;
                    vmax = 100.0;
                }
                delta = (vmax - vmin) * 0.15;
                if (ArrayUtil.isEqual((Double)delta, (Double)0.0)) {
                    delta = 100.0;
                }
                fmin = new Double(vmin - delta * left);
                fmax = new Double(vmax + delta * right);
            } else {
                fmin = null;
                fmax = null;
            }
            if (graduator != null) {
                graduator.setFinite(fmin, fmax);
            }
            if (generator != null) {
                generator.setFinite(fmin, fmax);
            }
        }
    }

    private short trimInfinity(List values) {
        short ret = 0;
        if (values.remove(KpiRange.INFINITESIMAL)) {
            ret = 1;
        }
        if (values.remove(KpiRange.INFINITY)) {
            ret = (short)(ret | 2);
        }
        return ret;
    }

    protected boolean isDrawLabel() {
        return this.drawLabel;
    }

    protected void setDrawLabel(boolean b) {
        this.drawLabel = b;
    }

    @Override
    public double getAngle(Object value) {
        double angle = super.getAngle(value);
        if (angle > 180.0) {
            return 180.0;
        }
        if (angle < 0.0) {
            return 0.0;
        }
        return angle;
    }

    @Override
    protected DialGraduator createGraduator() {
        return new CustomDialGraduator();
    }

    private static interface DomainType {
        public static final short CLOSE = 0;
        public static final short INFINITESIMAL = 1;
        public static final short INFINITY = 2;
        public static final short BOTHOPEN = 3;
    }

    public class CustomDialTicker
    implements DialTickValueGenerator {
        private Double finiteMin = null;
        private Double finiteMax = null;
        private int index = 0;
        private List values = new ArrayList();
        private static final int TICKSCOUNT = 10;

        @Override
        public boolean hasNext() {
            if (this.index > 0) {
                return true;
            }
            this.reverse();
            return false;
        }

        @Override
        public Object next() {
            --this.index;
            if (this.index < 0) {
                throw new NoSuchElementException();
            }
            return this.values.get(this.index);
        }

        @Override
        public void setParameters(Object min, Object max) {
            this.values.clear();
            this.index = 0;
            this.addValue(CustomDialScale.this.rangeList);
            if (this.values.isEmpty()) {
                int mini = ((Number)min).intValue();
                int maxi = ((Number)max).intValue();
                if (this.finiteMin != null) {
                    mini = this.finiteMin.intValue();
                }
                if (this.finiteMax != null) {
                    maxi = this.finiteMax.intValue();
                }
                long step = ((long)maxi - (long)mini) / 10L;
                long temp = (long)mini - (long)mini % (step = this.getStdStep(step));
                if (temp <= (long)mini) {
                    temp += step;
                }
                while (temp < (long)maxi) {
                    this.values.add(new Double(temp));
                    temp += step;
                }
            }
            this.addValue(new CustomDialRange(CustomDialScale.getDefaultTitle(), DEFAULTCOLOR, (Double)min, (Double)max));
            this.reverse();
        }

        private long getStdStep(long step) {
            if (step == 0L) {
                return 1L;
            }
            int STD_STEP2 = 2;
            int STD_STEP5 = 5;
            int STD_STEP10 = 10;
            int n = 0;
            while (step > 14L) {
                step /= 10L;
                ++n;
            }
            step = step <= 3L ? 2L : (step <= 7L ? 5L : 10L);
            for (int i = 0; i < n; ++i) {
                step *= 10L;
            }
            return step;
        }

        private void addValue(List rangeList) {
            if (rangeList != null) {
                CustomDialRange range2 = null;
                for (CustomDialRange range2 : rangeList) {
                    if (range2 == null) continue;
                    this.addValue(range2);
                }
            }
        }

        private void addValue(CustomDialRange range) {
            Double val = null;
            if (range != null) {
                val = new Double(range.getLowerBound());
                if (this.values.indexOf(val) == -1) {
                    this.values.add(val);
                }
                if (this.values.indexOf(val = new Double(range.getUpperBound())) == -1) {
                    this.values.add(val);
                }
            }
        }

        private void reverse() {
            this.index = this.values.size();
        }

        public void setFinite(Double vmin, Double vmax) {
            this.finiteMin = vmin;
            this.finiteMax = vmax;
        }
    }

    public static class CustomDialGraduator
    extends DialGraduator {
        private Double finiteMin = null;
        private Double finiteMax = null;

        @Override
        public double getAngle(Object value) {
            double v = 0.0;
            if (value instanceof Number) {
                v = ((Number)value).doubleValue();
                if (this.finiteMin != null && v < this.finiteMin) {
                    return 0.0;
                }
                if (this.finiteMax != null && v > this.finiteMax) {
                    return 180.0;
                }
            }
            return super.getAngle(value);
        }

        @Override
        public void setParameters(Object vmin, Object vmax, double as) {
            if (this.finiteMin != null) {
                vmin = this.finiteMin;
            }
            if (this.finiteMax != null) {
                vmax = this.finiteMax;
            }
            super.setParameters(vmin, vmax, as);
        }

        public void setFinite(Double vmin, Double vmax) {
            this.finiteMin = vmin;
            this.finiteMax = vmax;
        }
    }
}

