/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.model;

import com.kingdee.cosmic.ctrl.swing.common.i18n.CtrlSwingMessages;
import com.kingdee.cosmic.ctrl.swing.event.ComboFunctionChooserModelChangeEvent;
import com.kingdee.cosmic.ctrl.swing.model.AbstractComboFunctionChooserModel;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.Icon;

public class ComboFunctionChooserModel
extends AbstractComboFunctionChooserModel {
    private int actionCellPanelInsets = 4;
    private int actionCellBorder = 3;
    private int moreCellPanelInsets = 4;
    private int actionCellColumnCount = 3;
    private int actionCellRowCount;
    private Icon[] actionIcons;
    private Icon defaultActionIcon;
    private Icon moreActionIcon;
    private boolean moreCellEnabled;
    private Rectangle[] actionCellRectanglesWithBorder;
    private Rectangle[] actionCellRectanglesWithoutBorder;
    private Dimension actionCellPanelDimension;
    private Dimension moreCellPanelDimension;

    @Override
    public int getActionCellColumnCount() {
        return this.actionCellColumnCount;
    }

    @Override
    public Icon[] getActionIcons() {
        return this.actionIcons;
    }

    @Override
    public Icon getDefaultActionIcon() {
        return this.defaultActionIcon;
    }

    @Override
    public boolean isMoreCellEnabled() {
        return this.moreCellEnabled;
    }

    @Override
    public void setActionCellColumnCount(int actionCellColumnCount) {
        if (actionCellColumnCount < 1) {
            throw new IllegalArgumentException(CtrlSwingMessages.getMLS("functionButtonColumnParamError", "\u529f\u80fd\u6309\u94ae\u7684\u5217\u6570\u53c2\u6570\u9519\u8bef"));
        }
        int oldActionCellColumnCount = this.actionCellColumnCount;
        if (oldActionCellColumnCount != actionCellColumnCount) {
            this.actionCellColumnCount = actionCellColumnCount;
            this.actionCellRowCount = this.actionIcons.length % actionCellColumnCount == 0 ? this.actionIcons.length / actionCellColumnCount : this.actionIcons.length / actionCellColumnCount + 1;
            this.createActionCellPanelDimension();
            this.createActionCellRectanglesWithBorder();
            this.createActionCellRectanglesWithoutBorder();
            this.fireModelChanged(new ComboFunctionChooserModelChangeEvent("columnCountChanged", this.actionCellColumnCount, actionCellColumnCount));
        }
    }

    @Override
    public void setActionIcons(Icon[] actionIcons) {
        if (actionIcons == null) {
            throw new IllegalArgumentException(CtrlSwingMessages.getMLS("functionItemImageCannotBeNull", "\u529f\u80fd\u9879\u56fe\u7247\u4e0d\u80fd\u4e3anull"));
        }
        Icon[] oldActionsIcon = this.actionIcons;
        if (oldActionsIcon != actionIcons) {
            this.actionIcons = actionIcons;
            this.actionCellRectanglesWithBorder = new Rectangle[this.actionIcons.length];
            this.actionCellRectanglesWithoutBorder = new Rectangle[this.actionIcons.length];
            this.actionCellRowCount = actionIcons.length % this.actionCellColumnCount == 0 ? actionIcons.length / this.actionCellColumnCount : actionIcons.length / this.actionCellColumnCount + 1;
            this.createActionCellPanelDimension();
            this.createActionCellRectanglesWithBorder();
            this.createActionCellRectanglesWithoutBorder();
            this.defaultActionIcon = actionIcons[0];
            this.fireModelChanged(new ComboFunctionChooserModelChangeEvent("actionsChanged", this.actionIcons, oldActionsIcon));
        }
    }

    @Override
    public void setDefaultActionIcon(Icon di) {
        if (this.defaultActionIcon == di) {
            return;
        }
        if (di == null) {
            throw new IllegalArgumentException(CtrlSwingMessages.getMLS("defaultImageCannotBeNull", "\u9ed8\u8ba4\u56fe\u7247\u8bbe\u7f6e\u4e0d\u80fd\u4e3anull"));
        }
        if (this.getDefaultIconIndexInActionIcons(di) == -1) {
            throw new IllegalArgumentException(CtrlSwingMessages.getMLS("defaultImageSettingInvalid", "\u9ed8\u8ba4\u56fe\u7247\u8bbe\u7f6e\u975e\u6cd5"));
        }
        Icon oldDefaultActionIcon = this.defaultActionIcon;
        this.defaultActionIcon = di;
        this.fireModelChanged(new ComboFunctionChooserModelChangeEvent("defaultActionChanged", this.defaultActionIcon, oldDefaultActionIcon));
    }

    @Override
    public void setMoreCellActionIcon(Icon moreActionIcon) {
        Icon oldMoreActionIcon = this.moreActionIcon;
        if (oldMoreActionIcon != moreActionIcon) {
            if (oldMoreActionIcon == null) {
                this.moreActionIcon = moreActionIcon;
                this.moreCellEnabled = true;
                this.createMoreCellPanelDimension();
                this.fireModelChanged(new ComboFunctionChooserModelChangeEvent("moreCellAdded", moreActionIcon, oldMoreActionIcon));
            } else {
                this.moreActionIcon = moreActionIcon;
                this.moreCellEnabled = false;
                this.moreCellPanelDimension = null;
                this.fireModelChanged(new ComboFunctionChooserModelChangeEvent("moreCellRemoved", moreActionIcon, oldMoreActionIcon));
            }
        }
    }

    @Override
    public Icon getMoreCellActionIcon() {
        return this.moreActionIcon;
    }

    @Override
    public int getDefaultIconIndexInActionIcons(Icon di) {
        int index = -1;
        for (int i = 0; i < this.actionIcons.length; ++i) {
            if (di != this.actionIcons[i]) continue;
            index = i;
            break;
        }
        return index;
    }

    private void createActionCellRectanglesWithoutBorder() {
        int iconWidth = this.actionIcons[0].getIconWidth();
        int iconHeight = this.actionIcons[0].getIconHeight();
        for (int i = 0; i < this.actionCellRowCount; ++i) {
            for (int j = 0; j < this.actionCellColumnCount; ++j) {
                if (i * this.actionCellColumnCount + j >= this.actionIcons.length) continue;
                this.actionCellRectanglesWithoutBorder[i * this.actionCellColumnCount + j] = new Rectangle(this.actionCellPanelInsets + this.actionCellBorder * (2 * j + 1) + iconWidth * j, this.actionCellPanelInsets + this.actionCellBorder * (2 * i + 1) + iconHeight * i, iconWidth, iconHeight);
            }
        }
    }

    private void createActionCellRectanglesWithBorder() {
        int iconWidth = this.actionIcons[0].getIconWidth();
        int iconHeight = this.actionIcons[0].getIconHeight();
        for (int i = 0; i < this.actionCellRowCount; ++i) {
            for (int j = 0; j < this.actionCellColumnCount; ++j) {
                if (i * this.actionCellColumnCount + j >= this.actionIcons.length) continue;
                this.actionCellRectanglesWithBorder[i * this.actionCellColumnCount + j] = new Rectangle(this.actionCellPanelInsets + this.actionCellBorder * 2 * j + iconWidth * j, this.actionCellPanelInsets + this.actionCellBorder * 2 * i + iconHeight * i, iconWidth + 2 * this.actionCellBorder, iconHeight + 2 * this.actionCellBorder);
            }
        }
    }

    private void createActionCellPanelDimension() {
        int width = this.actionCellPanelInsets * 2 + this.actionCellColumnCount * (this.actionCellBorder * 2 + this.actionIcons[0].getIconWidth());
        int height = this.actionCellPanelInsets * 2 + this.actionCellRowCount * (this.actionCellBorder * 2 + this.actionIcons[0].getIconHeight());
        this.actionCellPanelDimension = new Dimension(width, height);
    }

    private void createMoreCellPanelDimension() {
        int width = this.actionCellPanelDimension.width;
        int height = this.moreCellPanelInsets + 4 + this.moreActionIcon.getIconHeight();
        this.moreCellPanelDimension = new Dimension(width, height);
    }

    @Override
    public Dimension getActionCellPanelDimension() {
        return this.actionCellPanelDimension;
    }

    @Override
    public Rectangle getActionCellRectangleWithBorder(int index) {
        if (index >= this.actionCellRectanglesWithBorder.length) {
            return null;
        }
        return this.actionCellRectanglesWithBorder[index];
    }

    @Override
    public Rectangle getActionCellRectangleWithoutBorder(int index) {
        if (index >= this.actionCellRectanglesWithoutBorder.length) {
            return null;
        }
        return this.actionCellRectanglesWithoutBorder[index];
    }

    @Override
    public Rectangle getMoreCellRectangle() {
        if (!this.moreCellEnabled) {
            return null;
        }
        return new Rectangle(this.moreCellPanelInsets, this.actionCellPanelDimension.height, this.actionCellPanelDimension.width - this.moreCellPanelInsets * 2, this.moreActionIcon.getIconHeight() + 4);
    }

    @Override
    public Dimension getMoreCellPanelDimension() {
        return this.moreCellPanelDimension;
    }

    @Override
    public Dimension getActionCellDimension() {
        return new Dimension(this.actionCellRectanglesWithBorder[0].width, this.actionCellRectanglesWithBorder[0].height);
    }

    @Override
    public int getActionCellPanelInsets() {
        return this.actionCellPanelInsets;
    }

    @Override
    public void setActionCellPanelInsets(int actionCellPanelInsets) {
        this.actionCellPanelInsets = actionCellPanelInsets;
    }

    @Override
    public int getActionCellBorder() {
        return this.actionCellBorder;
    }

    @Override
    public void setActionCellBorder(int actionCellBorder) {
        this.actionCellBorder = actionCellBorder;
    }

    @Override
    public int getMoreCellPanelInsets() {
        return this.moreCellPanelInsets;
    }

    @Override
    public void setMoreCellPanelInsets(int moreCellPanelInsets) {
        this.moreCellPanelInsets = moreCellPanelInsets;
    }
}

