/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.model;

import com.kingdee.cosmic.ctrl.swing.KDFont;
import com.kingdee.cosmic.ctrl.swing.common.i18n.CtrlSwingMessages;
import com.kingdee.cosmic.ctrl.swing.event.FontChangeEvent;
import com.kingdee.cosmic.ctrl.swing.event.FontChangeListener;
import com.kingdee.cosmic.ctrl.swing.model.IFontSelectionModel;
import java.awt.Font;
import javax.swing.event.EventListenerList;

public class FontSelectionModel
implements IFontSelectionModel {
    protected FontChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    private Font selectedFont;

    public FontSelectionModel(Font font) {
        this.selectedFont = font;
    }

    public FontSelectionModel() {
        this.selectedFont = new KDFont(CtrlSwingMessages.getMLS("defaultFontFamily", "\u5b8b\u4f53"), 0, 9);
    }

    @Override
    public Font getSelectedFont() {
        return this.selectedFont;
    }

    @Override
    public void setSelectedFont(Font font) {
        if (font != null && !this.selectedFont.equals(font)) {
            Font oldFont = this.selectedFont;
            this.selectedFont = font;
            this.fireStateChanged(oldFont, font);
        }
    }

    @Override
    public void setSelectedFont(Font font, int changeBit) {
        if (font != null) {
            Font oldFont = this.selectedFont;
            this.selectedFont = font;
            this.fireStateChanged(oldFont, font, changeBit);
        }
    }

    @Override
    public void addChangeListener(FontChangeListener listener) {
        this.listenerList.add(FontChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(FontChangeListener listener) {
        this.listenerList.remove(FontChangeListener.class, listener);
    }

    public FontChangeListener[] getChangeListeners() {
        return (FontChangeListener[])this.listenerList.getListeners(FontChangeListener.class);
    }

    protected void fireStateChanged(Font oldFont, Font newFont) {
        Object[] listeners = this.listenerList.getListenerList();
        this.changeEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FontChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new FontChangeEvent(this, oldFont, newFont);
            }
            ((FontChangeListener)listeners[i + 1]).fontChanged(this.changeEvent);
        }
    }

    protected void fireStateChanged(Font oldFont, Font newFont, int changeBit) {
        Object[] listeners = this.listenerList.getListenerList();
        this.changeEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FontChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new FontChangeEvent(this, oldFont, newFont, changeBit);
            }
            ((FontChangeListener)listeners[i + 1]).fontChanged(this.changeEvent);
        }
    }
}

