/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.swing.KDComboBoxMultiColumnItem;
import com.kingdee.cosmic.ctrl.swing.plaf.KDComboPopup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class KDComboBoxMultiColumnRenderer
extends JPanel
implements ListCellRenderer {
    protected static Border noFocusBorder = new EmptyBorder(0, 0, 0, 0);
    private JLabel[] labels;
    private int width = 70;

    public KDComboBoxMultiColumnRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
        this.setLayout(new KingdeeComboBoxMultiColumnRendererLayout());
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        int i;
        Container o;
        if (!(value instanceof KDComboBoxMultiColumnItem)) {
            return null;
        }
        if (list.getParent() != null && (o = list.getParent().getParent().getParent()) instanceof KDComboPopup) {
            this.width = ((KDComboPopup)o).getComboPopupWidth() == -1 ? ((KDComboPopup)o).getComboBoxWidth() : ((KDComboPopup)o).getComboPopupWidth();
        }
        KDComboBoxMultiColumnItem dci = (KDComboBoxMultiColumnItem)value;
        String[] values = dci.getVlaues();
        Color c = dci.getColor();
        if (this.labels == null) {
            this.labels = new JLabel[values.length];
            for (i = 0; i < values.length; ++i) {
                this.labels[i] = new JLabel();
                this.add(this.labels[i]);
            }
        }
        if (isSelected) {
            for (i = 0; i < values.length; ++i) {
                this.labels[i].setForeground(Color.WHITE);
                if (i == 0) {
                    int inset = dci.getInset();
                    StringBuilder tempValue = new StringBuilder();
                    int tempInset = inset * 4;
                    for (int j = 0; j < tempInset; ++j) {
                        tempValue.append(" ");
                    }
                    this.labels[i].setText(tempValue.append(values[i]).toString());
                    continue;
                }
                this.labels[i].setText(values[i]);
            }
            this.setBackground(list.getSelectionBackground());
        } else {
            for (i = 0; i < values.length; ++i) {
                this.labels[i].setForeground(c);
                if (i == 0) {
                    int inset = dci.getInset();
                    StringBuilder tempValue = new StringBuilder();
                    int tempInset = inset * 4;
                    for (int j = 0; j < tempInset; ++j) {
                        tempValue.append(" ");
                    }
                    this.labels[i].setText(tempValue.append(values[i]).toString());
                    continue;
                }
                this.labels[i].setText(values[i]);
            }
            this.setBackground(list.getBackground());
        }
        this.setToolTipText(dci.toString());
        return this;
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.labels != null) {
            for (int i = 0; i < this.labels.length; ++i) {
                this.labels[i].setForeground(fg);
            }
        }
    }

    private class KingdeeComboBoxMultiColumnRendererLayout
    implements LayoutManager {
        private int columnHeight = 20;

        private KingdeeComboBoxMultiColumnRendererLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(KDComboBoxMultiColumnRenderer.this.width, this.columnHeight);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(KDComboBoxMultiColumnRenderer.this.width, this.columnHeight);
        }

        @Override
        public void layoutContainer(Container parent) {
            int labelsCount = KDComboBoxMultiColumnRenderer.this.labels.length;
            int labelsWidth = KDComboBoxMultiColumnRenderer.this.width / labelsCount;
            for (int i = 0; i < labelsCount; ++i) {
                KDComboBoxMultiColumnRenderer.this.labels[i].setBounds(labelsWidth * i, 0, labelsWidth - 20, this.columnHeight);
            }
        }
    }
}

