/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBoxMultiColumnItem;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.common.i18n.CtrlSwingMessages;
import com.kingdee.cosmic.ctrl.swing.resource.KDResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicComboPopup;

public class KDComboPopup
extends BasicComboPopup {
    private static final long serialVersionUID = -2400923134029021679L;
    private KDWorkButton appendButton;
    private int popupWidth = -1;

    public KDComboPopup(JComboBox combo) {
        super(combo);
        if (combo instanceof KDComboBox) {
            this.setLayout(new KingdeeComboPopupLayout());
            combo.getModel().addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                    ComboBoxModel cmbModel = KDComboPopup.this.comboBox.getModel();
                    int itemCount = cmbModel.getSize();
                    Vector vListData = new Vector();
                    for (int i = 0; i < itemCount; ++i) {
                        Object o = cmbModel.getElementAt(i);
                        if (o instanceof KDComboBoxMultiColumnItem) {
                            ToolTipManager.sharedInstance().setEnabled(false);
                            ToolTipManager.sharedInstance().setEnabled(true);
                        }
                        vListData.addElement(o);
                    }
                    KDComboPopup.this.list.setListData(vListData);
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    ComboBoxModel cmbModel = KDComboPopup.this.comboBox.getModel();
                    int itemCount = cmbModel.getSize();
                    Vector vListData = new Vector();
                    for (int i = 0; i < itemCount; ++i) {
                        Object o = cmbModel.getElementAt(i);
                        if (o instanceof KDComboBoxMultiColumnItem) {
                            ToolTipManager.sharedInstance().setEnabled(false);
                            ToolTipManager.sharedInstance().setEnabled(true);
                        }
                        vListData.addElement(o);
                    }
                    KDComboPopup.this.list.setListData(vListData);
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                }
            });
        }
    }

    public int getComboBoxWidth() {
        return this.comboBox.getWidth();
    }

    @Override
    protected MouseListener createListMouseListener() {
        return new ListMouseHandler();
    }

    public void setAppendButtonVisible(boolean visible) {
        if (visible && this.appendButton == null) {
            this.appendButton = new KDWorkButton(CtrlSwingMessages.getMLS("New", "New"));
            this.appendButton.setIcon(new ImageIcon(KDResourceManager.getImage("combobox_appendbutton.gif")));
            this.appendButton.setFocusable(false);
            this.validate();
        } else if (!visible && this.appendButton != null) {
            this.validate();
            this.appendButton = null;
        }
    }

    public void setAppendButtonHandler(ActionListener newHandler, ActionListener oldHandler) {
        this.appendButton.removeActionListener(oldHandler);
        this.appendButton.addActionListener(newHandler);
    }

    public void setComboPopupWidth(int pixel) {
        this.popupWidth = pixel;
    }

    public int getComboPopupWidth() {
        return this.popupWidth;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        ToolTipManager.sharedInstance().setEnabled(false);
        ToolTipManager.sharedInstance().setEnabled(true);
        if (this.comboBox instanceof KDComboBox && !b && ((KDComboBox)this.comboBox).isCanSearch()) {
            ComboBoxModel cmbModel = this.comboBox.getModel();
            int itemCount = cmbModel.getSize();
            Vector vListData = new Vector();
            for (int i = 0; i < itemCount; ++i) {
                Object o = cmbModel.getElementAt(i);
                vListData.addElement(o);
            }
            this.list.setListData(vListData);
        }
    }

    public void setKDListSelection(int selectedIndex) {
        int selectIndex = -1;
        Object oSelected = null;
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            oSelected = this.comboBox.getItemAt(selectedIndex);
            if (oSelected == null || !oSelected.equals(this.list.getModel().getElementAt(i))) continue;
            selectIndex = i;
            break;
        }
        if (selectIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectIndex);
            this.list.ensureIndexIsVisible(selectIndex);
        }
    }

    @Override
    protected void configureList() {
        this.list.setFont(this.comboBox.getFont());
        this.list.setForeground(this.comboBox.getForeground());
        this.list.setBackground(this.comboBox.getBackground());
        this.list.setSelectionForeground(UIManager.getColor("TextField.selectionForeground"));
        this.list.setSelectionBackground(UIManager.getColor("TextField.selectionBackground"));
        this.list.setBorder(BorderFactory.createLineBorder(UIManager.getColor("ComboBox.popupBorderLineColor")));
        this.list.setCellRenderer(this.comboBox.getRenderer());
        this.list.setFocusable(false);
        this.list.setSelectionMode(0);
        this.setKDListSelection(this.comboBox.getSelectedIndex());
        this.installListListeners();
    }

    @Override
    protected void updateListBoxSelectionForEvent(MouseEvent anEvent, boolean shouldScroll) {
        String selectedItemStr;
        super.updateListBoxSelectionForEvent(anEvent, shouldScroll);
        if (this.list.getModel().getSize() <= 0) {
            return;
        }
        Object selectedValue = this.list.getSelectedValue();
        if (selectedValue != null && (selectedItemStr = selectedValue.toString()) != null) {
            int selectedItemStrWidth = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), selectedItemStr);
            JScrollBar sb = this.scroller.getVerticalScrollBar();
            int avalibleWidth = this.getWidth();
            if (sb != null && sb.isVisible()) {
                avalibleWidth = avalibleWidth - sb.getWidth() - 2;
            }
            if (selectedItemStrWidth > avalibleWidth) {
                this.list.setToolTipText(selectedItemStr);
            } else {
                this.list.setToolTipText(null);
            }
        }
    }

    @Override
    public void show() {
        this.setKDListSelection(this.comboBox.getSelectedIndex());
        Point location = this.getKDPopupLocation();
        this.show(this.comboBox, location.x, location.y);
    }

    public Point getKDPopupLocation() {
        Dimension popupSize = this.comboBox.getSize();
        Insets insets = this.getInsets();
        popupSize.setSize(popupSize.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
        Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
        Dimension scrollSize = popupBounds.getSize();
        Point popupLocation = popupBounds.getLocation();
        this.scroller.setMaximumSize(scrollSize);
        this.scroller.setPreferredSize(scrollSize);
        this.scroller.setMinimumSize(scrollSize);
        this.list.revalidate();
        return popupLocation;
    }

    @Override
    protected int getPopupHeightForRowCount(int maxRowCount) {
        int listSize;
        int minRowCount = 0;
        minRowCount = this.comboBox instanceof KDComboBox && ((KDComboBox)this.comboBox).isCanSearch() ? ((listSize = this.list.getModel().getSize()) > 7 ? 7 : listSize) : Math.min(maxRowCount, this.list.getModel().getSize());
        int height = 0;
        ListCellRenderer<Object> renderer = this.list.getCellRenderer();
        Object value = null;
        for (int i = 0; i < minRowCount; ++i) {
            value = this.list.getModel().getElementAt(i);
            Component c = renderer.getListCellRendererComponent(this.list, value, i, false, false);
            height += c.getPreferredSize().height;
        }
        return height == 0 ? 100 : height;
    }

    private class KingdeeComboPopupLayout
    implements LayoutManager {
        private int columnHeight = 20;
        private int inset = 3;

        private KingdeeComboPopupLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            this.columnHeight = (int)((JComponent)((Object)KDComboPopup.this.list.getCellRenderer())).getPreferredSize().getHeight();
            int maxRowCount = KDComboPopup.this.comboBox.getMaximumRowCount();
            int rowCount = KDComboPopup.this.comboBox.getItemCount();
            if (rowCount == 0) {
                rowCount = 5;
            }
            int pageRowCount = maxRowCount >= rowCount ? rowCount : maxRowCount;
            int width = KDComboPopup.this.popupWidth != -1 ? KDComboPopup.this.popupWidth : ((KDComboBox)KDComboPopup.this.comboBox).getWidth();
            int height = (((KDComboBox)KDComboPopup.this.comboBox).isAppendButtonVisible() ? pageRowCount * this.columnHeight + 19 + this.inset * 2 : pageRowCount * this.columnHeight) + 4;
            return new Dimension(width, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            int maxRowCount = KDComboPopup.this.comboBox.getMaximumRowCount();
            int rowCount = KDComboPopup.this.comboBox.getItemCount();
            if (rowCount == 0) {
                rowCount = 5;
            }
            int pageRowCount = maxRowCount >= rowCount ? rowCount : maxRowCount;
            int width = KDComboPopup.this.popupWidth != -1 ? KDComboPopup.this.popupWidth - 2 : ((KDComboBox)KDComboPopup.this.comboBox).getWidth() - 2;
            int height = pageRowCount * this.columnHeight;
            KDComboPopup.this.scroller.setBounds(1, 1, width, height + 2);
            KDComboPopup.this.add(KDComboPopup.this.scroller);
            if (((KDComboBox)KDComboPopup.this.comboBox).isAppendButtonVisible()) {
                KDComboPopup.this.add(KDComboPopup.this.appendButton);
                KDComboPopup.this.appendButton.setBounds(this.inset, height + this.inset + 3, width - this.inset * 2, 19);
            } else if (KDComboPopup.this.appendButton != null) {
                KDComboPopup.this.remove(KDComboPopup.this.appendButton);
            }
        }
    }

    protected class ItemHandler
    implements ItemListener {
        protected ItemHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                JComboBox comboBox = (JComboBox)e.getSource();
                KDComboPopup.this.setKDListSelection(comboBox.getSelectedIndex());
            }
        }
    }

    protected class ListMouseHandler
    extends MouseAdapter {
        protected ListMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent anEvent) {
            if (KDComboPopup.this.list.getModel().getSize() <= 0) {
                return;
            }
            int selectedIndex = -1;
            int itemCount = KDComboPopup.this.comboBox.getItemCount();
            if (KDComboPopup.this.comboBox instanceof KDComboBox) {
                Object oItem = null;
                Object oList = null;
                if (((KDComboBox)KDComboPopup.this.comboBox).getAccessAuthority() == 1) {
                    KDComboPopup.this.comboBox.setPopupVisible(false);
                    return;
                }
                oList = KDComboPopup.this.list.getSelectedValue();
                for (int i = 0; i < itemCount; ++i) {
                    oItem = KDComboPopup.this.comboBox.getItemAt(i);
                    if (oItem == null || !oItem.equals(oList)) continue;
                    selectedIndex = i;
                    break;
                }
                KDComboPopup.this.comboBox.setSelectedIndex(selectedIndex);
                KDComboPopup.this.comboBox.setPopupVisible(false);
                if (KDComboPopup.this.comboBox.isEditable() && KDComboPopup.this.comboBox.getEditor() != null) {
                    KDComboPopup.this.comboBox.configureEditor(KDComboPopup.this.comboBox.getEditor(), KDComboPopup.this.comboBox.getSelectedItem());
                }
            } else {
                KDComboPopup.this.comboBox.setSelectedIndex(KDComboPopup.this.list.getSelectedIndex());
                KDComboPopup.this.comboBox.setPopupVisible(false);
                if (KDComboPopup.this.comboBox.isEditable() && KDComboPopup.this.comboBox.getEditor() != null) {
                    KDComboPopup.this.comboBox.configureEditor(KDComboPopup.this.comboBox.getEditor(), KDComboPopup.this.comboBox.getSelectedItem());
                }
            }
        }
    }
}

