/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.swing.ComboFunctionChooserDownList;
import com.kingdee.cosmic.ctrl.swing.KDArrowButton;
import com.kingdee.cosmic.ctrl.swing.KDComboFunctionChooser;
import com.kingdee.cosmic.ctrl.swing.KDPopupMenu;
import com.kingdee.cosmic.ctrl.swing.util.CtrlImageUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class KingdeeComboFunctionChooserUI
extends ComponentUI {
    private KDPopupMenu popup;
    private boolean isPopping = false;
    private KDComboFunctionChooser c;
    private ComboFunctionChooserDownList functionChooserDownList;
    private EnabledPropertyChangeListener enabledPropertyChangeListener = new EnabledPropertyChangeListener();
    private KDArrowButton arrowButton = new KDArrowButton(100);
    private ArrowButtonListener arrowBtnListener = new ArrowButtonListener();
    private ShadowEffectMouseListener shadowEffectMouseListener = new ShadowEffectMouseListener();
    private boolean shadowTrigger;
    private boolean mousePressed;
    private int location = DOWN_THE_OWNER;
    public static int DOWN_THE_OWNER = 0;
    public static int OVER_THE_OWNER = 1;

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.c = (KDComboFunctionChooser)c;
        this.c.setLayout(new FunctionChooserLayout());
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallListeners();
        this.uninstallComponents();
    }

    protected void installComponents() {
        this.arrowButton.setPreferredSize(new Dimension(13, this.c.getModel().getActionCellDimension().height));
        this.c.add(this.arrowButton);
    }

    protected void uninstallComponents() {
        this.c.remove(this.arrowButton);
        this.arrowButton = null;
    }

    protected void installListeners() {
        this.c.addPropertyChangeListener(this.enabledPropertyChangeListener);
        this.arrowButton.addActionListener(this.arrowBtnListener);
        this.c.addMouseListener(this.shadowEffectMouseListener);
        this.arrowButton.addMouseListener(this.shadowEffectMouseListener);
    }

    protected void uninstallListeners() {
        this.arrowButton.removeMouseListener(this.shadowEffectMouseListener);
        this.c.removeMouseListener(this.shadowEffectMouseListener);
        this.arrowButton.removeActionListener(this.arrowBtnListener);
        this.c.removePropertyChangeListener(this.enabledPropertyChangeListener);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Color oldcolor;
        super.paint(g, c);
        Color shadowColor = UIManager.getColor("ComboFunctionChooser.look.shadowColor");
        if (c.isEnabled()) {
            this.c.getModel().getDefaultActionIcon().paintIcon(c, g, this.c.getModel().getActionCellBorder(), this.c.getModel().getActionCellBorder());
        } else {
            CtrlImageUtilities.createDisableIcon(this.c.getModel().getDefaultActionIcon()).paintIcon(c, g, this.c.getModel().getActionCellBorder(), this.c.getModel().getActionCellBorder());
        }
        if (this.shadowTrigger) {
            oldcolor = g.getColor();
            g.setColor(shadowColor);
            g.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
            g.drawLine(c.getWidth() - this.arrowButton.getWidth(), 0, c.getWidth() - this.arrowButton.getWidth(), c.getHeight());
            if (this.mousePressed) {
                g.setColor(new Color(shadowColor.getRed(), shadowColor.getGreen(), shadowColor.getBlue(), 160));
            } else {
                g.setColor(new Color(shadowColor.getRed(), shadowColor.getGreen(), shadowColor.getBlue(), 80));
            }
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            g.setColor(oldcolor);
        }
        if (this.popup != null) {
            oldcolor = g.getColor();
            g.setColor(shadowColor);
            if (this.getDownListLocation() == OVER_THE_OWNER) {
                g.drawRect(0, -1, c.getWidth() - 1, c.getHeight());
            } else {
                g.drawRect(0, 0, c.getWidth() - 1, c.getHeight());
            }
            g.setColor(oldcolor);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int w = this.c.getModel().getActionCellDimension().width + this.arrowButton.getPreferredSize().width;
        int h = this.c.getModel().getActionCellDimension().height;
        return new Dimension(w, h);
    }

    protected void popDownList() {
        this.initDownList();
        boolean bl = this.isPopping = !this.isPopping;
        if (this.isPopping) {
            Point lp = this.c.getLocation();
            try {
                lp = this.c.getLocationOnScreen();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int screenWidth = screenSize.width;
            int screenHeight = screenSize.height;
            int downListWidth = this.functionChooserDownList.getPreferredSize().width;
            int downListHeight = this.functionChooserDownList.getPreferredSize().height;
            int x = lp.x;
            int rightX = x + downListWidth;
            x = rightX > screenWidth ? x + this.c.getWidth() - downListWidth : x;
            int y = lp.y + this.c.getPreferredSize().height - 1;
            int bottomY = y + downListHeight;
            if (bottomY > screenHeight) {
                y = lp.y - downListHeight;
                this.location = OVER_THE_OWNER;
            } else {
                this.location = DOWN_THE_OWNER;
            }
            this.popup = new KDPopupMenu(){

                @Override
                public void setVisible(boolean b) {
                    if (!b) {
                        KingdeeComboFunctionChooserUI.this.isPopping = false;
                        KingdeeComboFunctionChooserUI.this.shadowTrigger = false;
                        KingdeeComboFunctionChooserUI.this.c.repaint();
                        KingdeeComboFunctionChooserUI.this.popup = null;
                    }
                    super.setVisible(b);
                }
            };
            this.popup.add(this.functionChooserDownList);
            this.popup.setBorder(BorderFactory.createEmptyBorder());
            Point p = new Point(x, y);
            SwingUtilities.convertPointFromScreen(p, this.c);
            this.popup.show(this.c, p.x, p.y);
            this.functionChooserDownList.requestFocusInWindow();
        } else {
            this.shadowTrigger = false;
            this.c.repaint();
            this.popup.setVisible(false);
            this.popup = null;
        }
    }

    protected void initDownList() {
        if (this.functionChooserDownList == null) {
            this.functionChooserDownList = new ComboFunctionChooserDownList(this.c.getModel(), this.c);
            this.c.getModel().addModelChangeListener(this.functionChooserDownList);
            this.functionChooserDownList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 77) {
                        KingdeeComboFunctionChooserUI.this.c.actionPerformed(-1);
                        KingdeeComboFunctionChooserUI.this.setPopupVisible(false);
                    }
                }
            });
        }
    }

    public void setPopupVisible(boolean v) {
        if (!this.isPopping && v) {
            this.popDownList();
        } else if (this.isPopping && !v) {
            this.popDownList();
        }
    }

    public int getDownListLocation() {
        return this.location;
    }

    protected class FunctionChooserLayout
    implements LayoutManager {
        protected FunctionChooserLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            KingdeeComboFunctionChooserUI.this.arrowButton.setBounds(((KingdeeComboFunctionChooserUI)KingdeeComboFunctionChooserUI.this).c.getModel().getActionCellDimension().width, 0, ((KingdeeComboFunctionChooserUI)KingdeeComboFunctionChooserUI.this).arrowButton.getPreferredSize().width, ((KingdeeComboFunctionChooserUI)KingdeeComboFunctionChooserUI.this).arrowButton.getPreferredSize().height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = 0;
            int h = 0;
            w = ((KingdeeComboFunctionChooserUI)KingdeeComboFunctionChooserUI.this).c.getModel().getActionCellDimension().width + ((KingdeeComboFunctionChooserUI)KingdeeComboFunctionChooserUI.this).arrowButton.getPreferredSize().width;
            h = ((KingdeeComboFunctionChooserUI)KingdeeComboFunctionChooserUI.this).c.getModel().getActionCellDimension().height > ((KingdeeComboFunctionChooserUI)KingdeeComboFunctionChooserUI.this).arrowButton.getPreferredSize().height ? ((KingdeeComboFunctionChooserUI)KingdeeComboFunctionChooserUI.this).c.getModel().getActionCellDimension().height : ((KingdeeComboFunctionChooserUI)KingdeeComboFunctionChooserUI.this).arrowButton.getPreferredSize().height;
            return new Dimension(w, h);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    private class EnabledPropertyChangeListener
    implements PropertyChangeListener {
        private EnabledPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("enabled".equals(evt.getPropertyName())) {
                if (evt.getNewValue().equals(Boolean.FALSE)) {
                    KingdeeComboFunctionChooserUI.this.arrowButton.setEnabled(false);
                    KingdeeComboFunctionChooserUI.this.arrowButton.removeMouseListener(KingdeeComboFunctionChooserUI.this.shadowEffectMouseListener);
                    KingdeeComboFunctionChooserUI.this.c.removeMouseListener(KingdeeComboFunctionChooserUI.this.shadowEffectMouseListener);
                    KingdeeComboFunctionChooserUI.this.arrowButton.removeActionListener(KingdeeComboFunctionChooserUI.this.arrowBtnListener);
                    KingdeeComboFunctionChooserUI.this.shadowTrigger = false;
                    KingdeeComboFunctionChooserUI.this.c.repaint();
                } else {
                    KingdeeComboFunctionChooserUI.this.arrowButton.addActionListener(KingdeeComboFunctionChooserUI.this.arrowBtnListener);
                    KingdeeComboFunctionChooserUI.this.c.addMouseListener(KingdeeComboFunctionChooserUI.this.shadowEffectMouseListener);
                    KingdeeComboFunctionChooserUI.this.arrowButton.addMouseListener(KingdeeComboFunctionChooserUI.this.shadowEffectMouseListener);
                    KingdeeComboFunctionChooserUI.this.arrowButton.setEnabled(true);
                }
            }
        }
    }

    private class ArrowButtonListener
    implements ActionListener {
        private ArrowButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KingdeeComboFunctionChooserUI.this.shadowTrigger = false;
            KingdeeComboFunctionChooserUI.this.popDownList();
            KingdeeComboFunctionChooserUI.this.c.repaint();
        }
    }

    private class ShadowEffectMouseListener
    implements MouseListener {
        private ShadowEffectMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == KingdeeComboFunctionChooserUI.this.c) {
                KingdeeComboFunctionChooserUI.this.c.actionPerformed(KingdeeComboFunctionChooserUI.this.c.getModel().getDefaultIconIndexInActionIcons(KingdeeComboFunctionChooserUI.this.c.getModel().getDefaultActionIcon()));
                KingdeeComboFunctionChooserUI.this.shadowTrigger = true;
                KingdeeComboFunctionChooserUI.this.mousePressed = false;
            } else {
                KingdeeComboFunctionChooserUI.this.shadowTrigger = false;
            }
            KingdeeComboFunctionChooserUI.this.c.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (KingdeeComboFunctionChooserUI.this.popup == null) {
                KingdeeComboFunctionChooserUI.this.shadowTrigger = true;
                KingdeeComboFunctionChooserUI.this.c.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            KingdeeComboFunctionChooserUI.this.shadowTrigger = false;
            KingdeeComboFunctionChooserUI.this.c.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == KingdeeComboFunctionChooserUI.this.c) {
                KingdeeComboFunctionChooserUI.this.mousePressed = true;
                KingdeeComboFunctionChooserUI.this.c.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getSource() == KingdeeComboFunctionChooserUI.this.c) {
                KingdeeComboFunctionChooserUI.this.mousePressed = false;
                KingdeeComboFunctionChooserUI.this.c.repaint();
            }
        }
    }
}

