/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.swing.IKDTextComponent;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDFileChooser;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.KDToggleButton;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.common.i18n.CtrlSwingMessages;
import com.kingdee.cosmic.ctrl.swing.util.JVM;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Position;
import sun.awt.shell.ShellFolder;

public class KingdeeFileChooserUI
extends BasicFileChooserUI
implements IKDTextComponent {
    private JPanel centerPanel;
    private JLabel lookInLabel;
    private KDComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private JPanel listViewPanel;
    private JPanel detailsViewPanel;
    private JPanel currentViewPanel;
    private Icon homeFolderIcon;
    private FocusListener editorFocusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                KingdeeFileChooserUI.this.applyEdit();
            }
        }
    };
    private boolean useShellFolder;
    private ListSelectionModel listSelectionModel;
    private JList list;
    private JTable detailsTable;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private KDComboBox filterComboBox;
    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension vstrut4 = new Dimension(1, 4);
    private static final Dimension vstrut6 = new Dimension(1, 6);
    private static final Dimension vstrut8 = new Dimension(1, 8);
    private static final Dimension hstrut5 = new Dimension(5, 1);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 500;
    private static int MIN_HEIGHT = 326;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_PREF_WIDTH = 405;
    private static int LIST_PREF_HEIGHT = 135;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private static final Dimension FOLDER_BUTTON_SIZE = new Dimension(25, 19);
    private static final int COLUMN_FILENAME = 0;
    private static final int COLUMN_FILESIZE = 1;
    private static final int COLUMN_FILETYPE = 2;
    private static final int COLUMN_FILEDATE = 3;
    private static final int COLUMN_FILEATTR = 4;
    private static final int COLUMN_COLCOUNT = 5;
    private int[] COLUMN_WIDTHS = new int[]{150, 75, 130, 130, 40};
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private String fileNameHeaderText = null;
    private String fileSizeHeaderText = null;
    private String fileTypeHeaderText = null;
    private String fileDateHeaderText = null;
    private String fileAttrHeaderText = null;
    private String allFilefilterText = null;
    int lastIndex = -1;
    File editFile = null;
    int editX = 20;
    JTextField editCell = null;
    static final int space = 10;

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeFileChooserUI((JFileChooser)c);
    }

    public KingdeeFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        this.bottomPanel = null;
        this.buttonPanel = null;
    }

    @Override
    public void installComponents(JFileChooser fc) {
        File[] cbFolders;
        FileSystemView fsv = fc.getFileSystemView();
        fc.setBorder(new EmptyBorder(10, 10, 10, 10));
        fc.setLayout(new BorderLayout(0, 11));
        JPanel topPanel = new JPanel(new BorderLayout(11, 0));
        JPanel topButtonPanel = new JPanel();
        topButtonPanel.setLayout(new BoxLayout(topButtonPanel, 2));
        topPanel.add((Component)topButtonPanel, "After");
        fc.add((Component)topPanel, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        topPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new KDComboBox();
        this.directoryComboBox.getAccessibleContext().setAccessibleDescription(this.lookInLabelText);
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.0f);
        this.directoryComboBox.setMaximumRowCount(8);
        topPanel.add((Component)this.directoryComboBox, "Center");
        KDWorkButton upFolderButton = new KDWorkButton(this.getChangeToParentDirectoryAction());
        ((AbstractButton)upFolderButton).setText(null);
        upFolderButton.setPreferredSize(FOLDER_BUTTON_SIZE);
        upFolderButton.setMinimumSize(FOLDER_BUTTON_SIZE);
        upFolderButton.setMaximumSize(FOLDER_BUTTON_SIZE);
        upFolderButton.setIcon(this.upFolderIcon);
        upFolderButton.setToolTipText(this.upFolderToolTipText);
        upFolderButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        upFolderButton.setAlignmentX(0.0f);
        upFolderButton.setAlignmentY(0.5f);
        upFolderButton.setMargin(shrinkwrap);
        topButtonPanel.add(upFolderButton);
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        File homeDir = fsv.getHomeDirectory();
        String toolTipText = this.homeFolderToolTipText;
        if (fsv.isRoot(homeDir)) {
            toolTipText = this.getFileView(fc).getName(homeDir);
        }
        this.homeFolderIcon = UIManager.getIcon("FileChooser.homeFolderIcon");
        KDWorkButton b = new KDWorkButton(this.homeFolderIcon);
        b.setPreferredSize(FOLDER_BUTTON_SIZE);
        b.setMinimumSize(FOLDER_BUTTON_SIZE);
        b.setMaximumSize(FOLDER_BUTTON_SIZE);
        b.setToolTipText(toolTipText);
        b.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(shrinkwrap);
        b.addActionListener(this.getGoHomeAction());
        topButtonPanel.add(b);
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        b = new KDWorkButton(this.getNewFolderAction());
        b.setPreferredSize(FOLDER_BUTTON_SIZE);
        b.setMinimumSize(FOLDER_BUTTON_SIZE);
        b.setMaximumSize(FOLDER_BUTTON_SIZE);
        ((AbstractButton)b).setText(null);
        b.setIcon(this.newFolderIcon);
        b.setToolTipText(this.newFolderToolTipText);
        b.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(shrinkwrap);
        topButtonPanel.add(b);
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        ButtonGroup viewButtonGroup = new ButtonGroup();
        class ViewButtonListener
        implements ActionListener {
            JFileChooser fc;

            ViewButtonListener(JFileChooser fc) {
                this.fc = fc;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JToggleButton b = (JToggleButton)e.getSource();
                JPanel oldViewPanel = KingdeeFileChooserUI.this.currentViewPanel;
                if (b == KingdeeFileChooserUI.this.detailsViewButton) {
                    if (KingdeeFileChooserUI.this.detailsViewPanel == null) {
                        KingdeeFileChooserUI.this.detailsViewPanel = KingdeeFileChooserUI.this.createDetailsView(this.fc);
                        KingdeeFileChooserUI.this.detailsViewPanel.setPreferredSize(LIST_PREF_SIZE);
                    }
                    KingdeeFileChooserUI.this.currentViewPanel = KingdeeFileChooserUI.this.detailsViewPanel;
                } else {
                    KingdeeFileChooserUI.this.currentViewPanel = KingdeeFileChooserUI.this.listViewPanel;
                }
                if (KingdeeFileChooserUI.this.currentViewPanel != oldViewPanel) {
                    KingdeeFileChooserUI.this.centerPanel.remove(oldViewPanel);
                    KingdeeFileChooserUI.this.centerPanel.add((Component)KingdeeFileChooserUI.this.currentViewPanel, "Center");
                    KingdeeFileChooserUI.this.centerPanel.revalidate();
                    KingdeeFileChooserUI.this.centerPanel.repaint();
                }
            }
        }
        ViewButtonListener viewButtonListener = new ViewButtonListener(fc);
        this.listViewButton = new KDToggleButton(this.listViewIcon);
        this.listViewButton.setPreferredSize(FOLDER_BUTTON_SIZE);
        this.listViewButton.setMinimumSize(FOLDER_BUTTON_SIZE);
        this.listViewButton.setMaximumSize(FOLDER_BUTTON_SIZE);
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.getAccessibleContext().setAccessibleName(this.listViewButtonAccessibleName);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkwrap);
        this.listViewButton.addActionListener(viewButtonListener);
        topButtonPanel.add(this.listViewButton);
        viewButtonGroup.add(this.listViewButton);
        this.detailsViewButton = new KDToggleButton(this.detailsViewIcon);
        this.detailsViewButton.setPreferredSize(FOLDER_BUTTON_SIZE);
        this.detailsViewButton.setMinimumSize(FOLDER_BUTTON_SIZE);
        this.detailsViewButton.setMaximumSize(FOLDER_BUTTON_SIZE);
        this.detailsViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailsViewButton.getAccessibleContext().setAccessibleName(this.detailsViewButtonAccessibleName);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(shrinkwrap);
        this.detailsViewButton.addActionListener(viewButtonListener);
        topButtonPanel.add(this.detailsViewButton);
        viewButtonGroup.add(this.detailsViewButton);
        this.useShellFolder = false;
        File[] roots = fsv.getRoots();
        if (roots != null && roots.length == 1 && (cbFolders = (File[])ShellFolder.get("fileChooserComboBoxFolders")) != null && cbFolders.length > 0 && roots[0] == cbFolders[0]) {
            this.useShellFolder = true;
        }
        this.centerPanel = new JPanel(new BorderLayout());
        this.listViewPanel = this.createList(fc);
        this.listSelectionModel = this.list.getSelectionModel();
        this.listViewPanel.setPreferredSize(LIST_PREF_SIZE);
        this.centerPanel.add((Component)this.listViewPanel, "Center");
        this.currentViewPanel = this.listViewPanel;
        this.centerPanel.add((Component)this.getAccessoryPanel(), "After");
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        fc.add((Component)this.centerPanel, "Center");
        JPanel bottomPanel = this.getBottomPanel();
        bottomPanel.setLayout(new BoxLayout(this.getBottomPanel(), 2));
        fc.add((Component)bottomPanel, "South");
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 3));
        labelPanel.add(Box.createRigidArea(vstrut4));
        JLabel fnl = new JLabel(this.fileNameLabelText);
        fnl.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        fnl.setAlignmentY(0.0f);
        labelPanel.add(fnl);
        labelPanel.add(Box.createRigidArea(new Dimension(1, 12)));
        JLabel ftl = new JLabel(this.filesOfTypeLabelText);
        ftl.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        labelPanel.add(ftl);
        this.getBottomPanel().add(labelPanel);
        this.getBottomPanel().add(Box.createRigidArea(new Dimension(15, 0)));
        JPanel fileAndFilterPanel = new JPanel();
        fileAndFilterPanel.add(Box.createRigidArea(vstrut8));
        fileAndFilterPanel.setLayout(new BoxLayout(fileAndFilterPanel, 1));
        this.fileNameTextField = new KDTextField(35){
            private static final long serialVersionUID = -8459988790363234676L;

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        fnl.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!KingdeeFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    KingdeeFileChooserUI.this.listSelectionModel.clearSelection();
                }
            }
        });
        if (fc.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(fc.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(fc.getSelectedFile()));
        }
        fileAndFilterPanel.add(this.fileNameTextField);
        fileAndFilterPanel.add(Box.createRigidArea(vstrut8));
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new KDComboBox((ComboBoxModel)this.filterComboBoxModel);
        this.filterComboBox.setEditable(false);
        ftl.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        fileAndFilterPanel.add(this.filterComboBox);
        this.getBottomPanel().add(fileAndFilterPanel);
        this.getBottomPanel().add(Box.createRigidArea(hstrut10));
        this.getButtonPanel().setLayout(new BoxLayout(this.getButtonPanel(), 1));
        this.approveButton = new KDButton(this.getApproveButtonText(fc)){
            private static final long serialVersionUID = -7707744056676727540L;

            @Override
            public Dimension getMaximumSize() {
                return ((KingdeeFileChooserUI)KingdeeFileChooserUI.this).approveButton.getPreferredSize().width > ((KingdeeFileChooserUI)KingdeeFileChooserUI.this).cancelButton.getPreferredSize().width ? KingdeeFileChooserUI.this.approveButton.getPreferredSize() : KingdeeFileChooserUI.this.cancelButton.getPreferredSize();
            }
        };
        this.approveButton.setMargin(new Insets(0, 0, 0, 0));
        this.approveButton.setPreferredSize(new Dimension(72, 21));
        this.approveButton.setMinimumSize(new Dimension(72, 21));
        this.approveButton.setMaximumSize(new Dimension(72, 21));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(fc));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.getButtonPanel().add(Box.createRigidArea(vstrut4));
        this.getButtonPanel().add(this.approveButton);
        this.getButtonPanel().add(Box.createRigidArea(vstrut6));
        this.cancelButton = new KDButton(this.cancelButtonText){
            private static final long serialVersionUID = -8625465232625905563L;

            @Override
            public Dimension getMaximumSize() {
                return ((KingdeeFileChooserUI)KingdeeFileChooserUI.this).approveButton.getPreferredSize().width > ((KingdeeFileChooserUI)KingdeeFileChooserUI.this).cancelButton.getPreferredSize().width ? KingdeeFileChooserUI.this.approveButton.getPreferredSize() : KingdeeFileChooserUI.this.cancelButton.getPreferredSize();
            }
        };
        this.cancelButton.setMargin(new Insets(0, 0, 0, 0));
        this.cancelButton.setPreferredSize(new Dimension(72, 21));
        this.cancelButton.setMinimumSize(new Dimension(72, 21));
        this.cancelButton.setMaximumSize(new Dimension(72, 21));
        this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (fc.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setPreferredSize(new Dimension(72, 54));
        }
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    @Override
    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = CtrlSwingMessages.getMLS("FileChooser.lookInLabelText", "Look:");
        this.saveInLabelText = CtrlSwingMessages.getMLS("FileChooser.saveInLabelText", "Save:");
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", l);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", l);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", l);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", l);
        this.homeFolderToolTipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", l);
        this.homeFolderAccessibleName = UIManager.getString((Object)"FileChooser.homeFolderAccessibleName", l);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", l);
        this.newFolderAccessibleName = UIManager.getString((Object)"FileChooser.newFolderAccessibleName", l);
        this.listViewButtonToolTipText = UIManager.getString((Object)"FileChooser.listViewButtonToolTipText", l);
        this.listViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.listViewButtonAccessibleName", l);
        this.detailsViewButtonToolTipText = UIManager.getString((Object)"FileChooser.detailsViewButtonToolTipText", l);
        this.detailsViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.detailsViewButtonAccessibleName", l);
        this.fileNameHeaderText = UIManager.getString((Object)"FileChooser.fileNameHeaderText", l);
        this.fileSizeHeaderText = UIManager.getString((Object)"FileChooser.fileSizeHeaderText", l);
        this.fileTypeHeaderText = UIManager.getString((Object)"FileChooser.fileTypeHeaderText", l);
        this.fileDateHeaderText = UIManager.getString((Object)"FileChooser.fileDateHeaderText", l);
        this.fileAttrHeaderText = UIManager.getString((Object)"FileChooser.fileAttrHeaderText", l);
        this.cancelButtonText = CtrlSwingMessages.getMLS("FileChooser.cancelButtonText", "cancel");
        this.cancelButtonToolTipText = CtrlSwingMessages.getMLS("FileChooser.cancelButtonText", "cancel");
        this.allFilefilterText = CtrlSwingMessages.getMLS("FileChooser.allFilefilterText", "all file");
    }

    @Override
    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        ActionMap actionMap = this.getActionMap2();
        SwingUtilities.replaceUIActionMap(fc, actionMap);
    }

    protected ActionMap getActionMap2() {
        return this.createActionMap2();
    }

    protected ActionMap createActionMap2() {
        AbstractAction escAction = new AbstractAction(){
            private static final long serialVersionUID = -2020275791888285012L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (KingdeeFileChooserUI.this.editFile != null) {
                    KingdeeFileChooserUI.this.cancelEdit();
                } else {
                    KingdeeFileChooserUI.this.getFileChooser().cancelSelection();
                }
            }

            @Override
            public boolean isEnabled() {
                return KingdeeFileChooserUI.this.getFileChooser().isEnabled();
            }
        };
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("approveSelection", this.getApproveSelectionAction());
        map.put("cancelSelection", escAction);
        map.put("Go Up", this.getChangeToParentDirectoryAction());
        return map;
    }

    protected JPanel createList(JFileChooser fc) {
        JPanel p = new JPanel(new BorderLayout());
        final JFileChooser fileChooser = fc;
        this.list = new JList(){
            private static final long serialVersionUID = 3139297471691613902L;

            @Override
            public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
                ListModel model = this.getModel();
                int max = model.getSize();
                if (prefix == null || startIndex < 0 || startIndex >= max) {
                    throw new IllegalArgumentException();
                }
                boolean backwards = bias == Position.Bias.Backward;
                int i = startIndex;
                while (backwards ? i >= 0 : i < max) {
                    String filename = fileChooser.getName((File)model.getElementAt(i));
                    if (filename.regionMatches(true, 0, prefix, 0, prefix.length())) {
                        return i;
                    }
                    i += backwards ? -1 : 1;
                }
                return -1;
            }
        };
        this.list.setCellRenderer(new FileRenderer());
        this.list.setLayoutOrientation(1);
        this.list.setVisibleRowCount(-1);
        if (fc.isMultiSelectionEnabled()) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
        }
        this.list.setModel(this.getModel());
        this.list.addListSelectionListener(this.createListSelectionListener(fc));
        this.list.addMouseListener(this.createDoubleClickListener(fc, this.list));
        this.list.addMouseListener(this.createSingleClickListener(fc, this.list));
        this.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                new DelayedSelectionUpdater();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                new DelayedSelectionUpdater();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.list);
        p.add((Component)scrollpane, "Center");
        return p;
    }

    protected JPanel createDetailsView(JFileChooser fc) {
        final JFileChooser chooser = fc;
        JPanel p = new JPanel(new BorderLayout());
        DetailsTableModel detailsTableModel = new DetailsTableModel(chooser);
        this.detailsTable = new JTable(detailsTableModel){
            private static final long serialVersionUID = 4978515340391698726L;

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getKeyCode() == 27 && this.getCellEditor() == null) {
                    chooser.dispatchEvent(e);
                    return true;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        };
        this.detailsTable.setComponentOrientation(chooser.getComponentOrientation());
        this.detailsTable.setAutoResizeMode(0);
        this.detailsTable.setShowGrid(false);
        this.detailsTable.setSelectionModel(this.listSelectionModel);
        this.detailsTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        Font font = this.detailsTable.getFont();
        this.detailsTable.setRowHeight(Math.max(font.getSize(), 19) + 3);
        TableColumnModel columnModel = this.detailsTable.getColumnModel();
        TableColumn[] columns = new TableColumn[5];
        for (int i = 0; i < 5; ++i) {
            columns[i] = columnModel.getColumn(i);
            columns[i].setPreferredWidth(this.COLUMN_WIDTHS[i]);
        }
        if (!System.getProperty("os.name").startsWith("Windows")) {
            columnModel.removeColumn(columns[2]);
            columnModel.removeColumn(columns[4]);
        }
        DetailsTableCellRenderer cellRenderer = new DetailsTableCellRenderer(chooser);
        this.detailsTable.setDefaultRenderer(File.class, cellRenderer);
        this.detailsTable.setDefaultRenderer(Date.class, cellRenderer);
        this.detailsTable.setDefaultRenderer(Object.class, cellRenderer);
        final JTextField tf = new JTextField();
        tf.addFocusListener(this.editorFocusListener);
        columns[0].setCellEditor(new DefaultCellEditor(tf){
            private static final long serialVersionUID = 8330713291441545378L;

            @Override
            public boolean isCellEditable(EventObject e) {
                if (e instanceof MouseEvent) {
                    MouseEvent me = (MouseEvent)e;
                    int index = KingdeeFileChooserUI.this.detailsTable.rowAtPoint(me.getPoint());
                    return me.getClickCount() == 1 && KingdeeFileChooserUI.this.detailsTable.isRowSelected(index);
                }
                return super.isCellEditable(e);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                if (value instanceof File) {
                    tf.setText(chooser.getName((File)value));
                    tf.requestFocus();
                    tf.selectAll();
                }
                return comp;
            }
        });
        JList fakeList = new JList(detailsTableModel.listModel){
            private static final long serialVersionUID = 6376747089937244091L;
            JTable table;
            {
                this.table = KingdeeFileChooserUI.this.detailsTable;
            }

            @Override
            public int locationToIndex(Point location) {
                return this.table.rowAtPoint(location);
            }

            @Override
            public Rectangle getCellBounds(int index0, int index1) {
                Rectangle r0 = this.table.getCellRect(index0, 0, false);
                Rectangle r1 = this.table.getCellRect(index1, 0, false);
                return r0.union(r1);
            }

            public Object getSelectedValue() {
                return this.table.getValueAt(this.table.getSelectedRow(), 0);
            }

            @Override
            public Component add(Component comp) {
                if (comp instanceof JTextField) {
                    return this.table.add(comp);
                }
                return super.add(comp);
            }

            @Override
            public void repaint() {
                if (this.table != null) {
                    this.table.repaint();
                }
            }

            @Override
            public TransferHandler getTransferHandler() {
                if (this.table != null) {
                    return this.table.getTransferHandler();
                }
                return super.getTransferHandler();
            }

            @Override
            public void setTransferHandler(TransferHandler newHandler) {
                if (this.table != null) {
                    this.table.setTransferHandler(newHandler);
                } else {
                    super.setTransferHandler(newHandler);
                }
            }

            @Override
            public boolean getDragEnabled() {
                if (this.table != null) {
                    return this.table.getDragEnabled();
                }
                return super.getDragEnabled();
            }

            @Override
            public void setDragEnabled(boolean b) {
                if (this.table != null) {
                    this.table.setDragEnabled(b);
                } else {
                    super.setDragEnabled(b);
                }
            }
        };
        fakeList.setSelectionModel(this.listSelectionModel);
        this.detailsTable.addMouseListener(this.createDoubleClickListener(chooser, fakeList));
        JScrollPane scrollpane = new JScrollPane(this.detailsTable);
        scrollpane.setComponentOrientation(chooser.getComponentOrientation());
        LookAndFeel.installColors(scrollpane.getViewport(), "Table.background", "Table.foreground");
        scrollpane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JScrollPane sp = (JScrollPane)e.getComponent();
                KingdeeFileChooserUI.this.fixNameColumnWidth(sp.getViewport().getSize().width);
                sp.removeComponentListener(this);
            }
        });
        p.add((Component)scrollpane, "Center");
        return p;
    }

    private void fixNameColumnWidth(int viewWidth) {
        TableColumn nameCol = this.detailsTable.getColumnModel().getColumn(0);
        int tableWidth = this.detailsTable.getPreferredSize().width;
        if (tableWidth < viewWidth) {
            nameCol.setPreferredWidth(nameCol.getPreferredWidth() + viewWidth - tableWidth);
        }
    }

    private static boolean disableFileChooserSpeedFix() {
        return false;
    }

    @Override
    public ListSelectionListener createListSelectionListener(JFileChooser fc) {
        return new BasicFileChooserUI.SelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JFileChooser chooser = KingdeeFileChooserUI.this.getFileChooser();
                    FileSystemView fsv = chooser.getFileSystemView();
                    JList list = (JList)e.getSource();
                    if (chooser.isMultiSelectionEnabled()) {
                        File[] files = null;
                        Object[] objects = list.getSelectedValues();
                        if (objects != null) {
                            if (objects.length == 1 && ((File)objects[0]).isDirectory() && chooser.isTraversable((File)objects[0]) && (chooser.getFileSelectionMode() == 0 || !fsv.isFileSystem((File)objects[0]))) {
                                KingdeeFileChooserUI.this.setDirectorySelected(true);
                                KingdeeFileChooserUI.this.setDirectory((File)objects[0]);
                            } else {
                                files = new File[objects.length];
                                int j = 0;
                                for (int i = 0; i < objects.length; ++i) {
                                    boolean isFile;
                                    File f = (File)objects[i];
                                    boolean isDir = f.isDirectory();
                                    boolean bl = KingdeeFileChooserUI.disableFileChooserSpeedFix() ? f.isFile() : (isFile = !isDir);
                                    if ((!chooser.isFileSelectionEnabled() || !isFile) && (!chooser.isDirectorySelectionEnabled() || !fsv.isFileSystem(f) || !isDir)) continue;
                                    files[j++] = f;
                                }
                                if (j == 0) {
                                    files = null;
                                } else if (j < objects.length) {
                                    File[] tmpFiles = new File[j];
                                    System.arraycopy(files, 0, tmpFiles, 0, j);
                                    files = tmpFiles;
                                }
                                KingdeeFileChooserUI.this.setDirectorySelected(false);
                            }
                        }
                        chooser.setSelectedFiles(files);
                    } else {
                        File file = (File)list.getSelectedValue();
                        if (file != null && file.isDirectory() && chooser.isTraversable(file) && (chooser.getFileSelectionMode() == 0 || !fsv.isFileSystem(file))) {
                            KingdeeFileChooserUI.this.setDirectorySelected(true);
                            KingdeeFileChooserUI.this.setDirectory(file);
                            chooser.setSelectedFile(null);
                        } else {
                            KingdeeFileChooserUI.this.setDirectorySelected(false);
                            if (file != null) {
                                chooser.setSelectedFile(file);
                            }
                        }
                    }
                }
            }
        };
    }

    private MouseListener createSingleClickListener(JFileChooser fc, JList list) {
        return new SingleClickListener(list);
    }

    private int getEditIndex() {
        return this.lastIndex;
    }

    private void setEditIndex(int i) {
        this.lastIndex = i;
    }

    private void resetEditIndex() {
        this.lastIndex = -1;
    }

    private void cancelEdit() {
        if (this.editFile != null) {
            this.editFile = null;
            this.list.remove(this.editCell);
            this.centerPanel.repaint();
        } else if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().cancelCellEditing();
        }
    }

    private void editFileName(int index) {
        this.ensureIndexIsVisible(index);
        if (this.listViewPanel.isVisible()) {
            this.editFile = (File)this.getModel().getElementAt(index);
            Rectangle r = this.list.getCellBounds(index, index);
            if (this.editCell == null) {
                this.editCell = new JTextField();
                this.editCell.addActionListener(new EditActionListener());
                this.editCell.addFocusListener(this.editorFocusListener);
                this.editCell.setNextFocusableComponent(this.list);
            }
            this.list.add(this.editCell);
            this.editCell.setText(this.getFileChooser().getName(this.editFile));
            if (this.list.getComponentOrientation().isLeftToRight()) {
                this.editCell.setBounds(this.editX + r.x, r.y, r.width - this.editX, r.height);
            } else {
                this.editCell.setBounds(r.x, r.y, r.width - this.editX, r.height);
            }
            this.editCell.requestFocus();
            this.editCell.selectAll();
        } else if (this.detailsViewPanel.isVisible()) {
            this.detailsTable.editCellAt(index, 0);
        }
    }

    private void applyEdit() {
        if (this.editFile != null && this.editFile.exists()) {
            JFileChooser chooser = this.getFileChooser();
            String oldDisplayName = chooser.getName(this.editFile);
            String oldFileName = this.editFile.getName();
            String newDisplayName = this.editCell.getText().trim();
            if (!newDisplayName.equals(oldDisplayName)) {
                FileSystemView fsv;
                File f2;
                int i2;
                String newFileName = newDisplayName;
                int i1 = oldFileName.length();
                if (i1 > (i2 = oldDisplayName.length()) && oldFileName.charAt(i2) == '.') {
                    newFileName = newDisplayName + oldFileName.substring(i2);
                }
                if (!(f2 = (fsv = chooser.getFileSystemView()).createFileObject(this.editFile.getParentFile(), newFileName)).exists() && this.getModel().renameFile(this.editFile, f2) && fsv.isParent(chooser.getCurrentDirectory(), f2)) {
                    if (chooser.isMultiSelectionEnabled()) {
                        chooser.setSelectedFiles(new File[]{f2});
                    } else {
                        chooser.setSelectedFile(f2);
                    }
                }
            }
        }
        if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().stopCellEditing();
        }
        this.cancelEdit();
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int prefWidth = KingdeeFileChooserUI.PREF_SIZE.width;
        Dimension d = c.getLayout().preferredLayoutSize(c);
        if (d != null) {
            return new Dimension(d.width < prefWidth ? prefWidth : d.width, d.height < KingdeeFileChooserUI.PREF_SIZE.height ? KingdeeFileChooserUI.PREF_SIZE.height : d.height);
        }
        return new Dimension(prefWidth, KingdeeFileChooserUI.PREF_SIZE.height);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileSelected() {
        if (this.getFileChooser().isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            Object[] files = this.getFileChooser().getSelectedFiles();
            Object[] selectedObjects = this.list.getSelectedValues();
            this.listSelectionModel.setValueIsAdjusting(true);
            try {
                int index;
                Arrays.sort(files);
                Arrays.sort(selectedObjects);
                int shouldIndex = 0;
                int actuallyIndex = 0;
                while (shouldIndex < files.length && actuallyIndex < selectedObjects.length) {
                    int index2;
                    int comparison = ((File)files[shouldIndex]).compareTo((File)selectedObjects[actuallyIndex]);
                    if (comparison < 0) {
                        index2 = this.getModel().indexOf(files[shouldIndex]);
                        this.listSelectionModel.addSelectionInterval(index2, index2);
                        ++shouldIndex;
                        continue;
                    }
                    if (comparison > 0) {
                        index2 = this.getModel().indexOf(selectedObjects[actuallyIndex]);
                        this.listSelectionModel.removeSelectionInterval(index2, index2);
                        ++actuallyIndex;
                        continue;
                    }
                    ++shouldIndex;
                    ++actuallyIndex;
                }
                while (shouldIndex < files.length) {
                    index = this.getModel().indexOf(files[shouldIndex]);
                    this.listSelectionModel.addSelectionInterval(index, index);
                    ++shouldIndex;
                }
                while (actuallyIndex < selectedObjects.length) {
                    index = this.getModel().indexOf(selectedObjects[actuallyIndex]);
                    this.listSelectionModel.removeSelectionInterval(index, index);
                    ++actuallyIndex;
                }
            }
            finally {
                this.listSelectionModel.setValueIsAdjusting(false);
            }
        } else {
            int i;
            JFileChooser chooser = this.getFileChooser();
            File f = null;
            f = this.isDirectorySelected() ? this.getDirectory() : chooser.getSelectedFile();
            if (f != null && (i = this.getModel().indexOf(f)) >= 0) {
                this.listSelectionModel.setSelectionInterval(i, i);
                this.ensureIndexIsVisible(i);
            } else {
                this.listSelectionModel.clearSelection();
            }
        }
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] files) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (i > 0) {
                buf.append(' ');
            }
            if (files.length > 1) {
                buf.append('\"');
            }
            buf.append(this.fileNameString(files[i]));
            if (files.length <= 1) continue;
            buf.append('\"');
        }
        return buf.toString();
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        this.applyEdit();
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(f));
            this.setFileSelected();
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        this.applyEdit();
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
            this.setFileName(this.fileNameString(files));
            this.setFileSelected();
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        this.listSelectionModel.setAnchorSelectionIndex(-1);
        this.listSelectionModel.setLeadSelectionIndex(-1);
        this.ensureIndexIsVisible(0);
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null) {
            this.directoryComboBoxModel.addItem(currentDirectory);
            this.getNewFolderAction().setEnabled(currentDirectory.canWrite());
            this.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(currentDirectory));
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
                if (fsv.isFileSystem(currentDirectory)) {
                    this.setFileName(currentDirectory.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent e) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent e) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            this.setFileName(currentDirectory.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doMultiSelectionChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.listSelectionModel.setSelectionMode(2);
        } else {
            this.listSelectionModel.setSelectionMode(0);
            this.listSelectionModel.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        if (chooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent e) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    KingdeeFileChooserUI.this.doSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    KingdeeFileChooserUI.this.doSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged")) {
                    KingdeeFileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("fileFilterChanged")) {
                    KingdeeFileChooserUI.this.doFilterChanged(e);
                } else if (s.equals("fileSelectionChanged")) {
                    KingdeeFileChooserUI.this.doFileSelectionModeChanged(e);
                } else if (s.equals("MultiSelectionEnabledChangedProperty")) {
                    KingdeeFileChooserUI.this.doMultiSelectionChanged(e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    KingdeeFileChooserUI.this.doAccessoryChanged(e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    KingdeeFileChooserUI.this.doApproveButtonTextChanged(e);
                } else if (s.equals("DialogTypeChangedProperty")) {
                    KingdeeFileChooserUI.this.doDialogTypeChanged(e);
                } else if (s.equals("ApproveButtonMnemonicChangedProperty")) {
                    KingdeeFileChooserUI.this.doApproveButtonMnemonicChanged(e);
                } else if (s.equals("ControlButtonsAreShownChangedProperty")) {
                    KingdeeFileChooserUI.this.doControlButtonsChanged(e);
                } else if (s.equals("CancelSelection")) {
                    KingdeeFileChooserUI.this.applyEdit();
                } else if (s.equals("componentOrientation")) {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JFileChooser cc = (JFileChooser)e.getSource();
                    if (o != (ComponentOrientation)e.getOldValue()) {
                        cc.applyComponentOrientation(o);
                    }
                    if (KingdeeFileChooserUI.this.detailsTable != null) {
                        KingdeeFileChooserUI.this.detailsTable.setComponentOrientation(o);
                        KingdeeFileChooserUI.this.detailsTable.getParent().getParent().setComponentOrientation(o);
                    }
                } else if (s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                    KingdeeFileChooserUI.this.fileNameTextField.selectAll();
                    KingdeeFileChooserUI.this.fileNameTextField.requestFocus();
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    private void ensureIndexIsVisible(int i) {
        if (i >= 0) {
            this.list.ensureIndexIsVisible(i);
            if (this.detailsTable != null) {
                this.detailsTable.scrollRectToVisible(this.detailsTable.getCellRect(i, 0, true));
            }
        }
    }

    @Override
    public void ensureFileIsVisible(JFileChooser fc, File f) {
        this.ensureIndexIsVisible(this.getModel().indexOf(f));
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        this.getModel().validateFileCache();
    }

    @Override
    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    @Override
    public void setFileName(String filename) {
        if (JVM.current().isOneDotSix() && this.getFileChooser().getClientProperty(KDFileChooser.NO_PATH_MESS_ON_JVM6) != null && !StringUtil.isEmptyString((String)filename) && filename.indexOf(File.separatorChar) != -1) {
            filename = null;
        }
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(filename);
        }
    }

    @Override
    protected void setDirectorySelected(boolean directorySelected) {
        super.setDirectorySelected(directorySelected);
        JFileChooser chooser = this.getFileChooser();
        if (directorySelected) {
            this.approveButton.setText(this.directoryOpenButtonText);
            this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
        } else {
            this.approveButton.setText(this.getApproveButtonText(chooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        }
    }

    @Override
    public String getDirectoryName() {
        return null;
    }

    @Override
    public void setDirectoryName(String dirname) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent e) {
        JFileChooser fc = this.getFileChooser();
        File f = fc.getSelectedFile();
        if (!e.getValueIsAdjusting() && f != null && !this.getFileChooser().isTraversable(f)) {
            this.setFileName(this.fileNameString(f));
        }
    }

    @Override
    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public void setEditable(boolean editable) {
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public void setRequired(boolean required) {
    }

    @Override
    public void setAccessAuthority(int authority) {
    }

    @Override
    public int getAccessAuthority() {
        return 0;
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        private static final long serialVersionUID = -7993617474466394767L;

        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f = (File)KingdeeFileChooserUI.this.directoryComboBox.getSelectedItem();
            KingdeeFileChooserUI.this.getFileChooser().setCurrentDirectory(f);
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private static final long serialVersionUID = -8559071599903343876L;
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = KingdeeFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if ("ChoosableFileFilterChangedProperty".equals(prop)) {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if ("fileFilterChanged".equals(prop)) {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void setSelectedItem(Object filter) {
            if (filter != null) {
                KingdeeFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter currentFilter = KingdeeFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (int i = 0; i < this.filters.length; ++i) {
                    if (this.filters[i] != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    KingdeeFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return KingdeeFileChooserUI.this.getFileChooser().getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return KingdeeFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -6616493624720900437L;

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof FileFilter) {
                if (value instanceof BasicFileChooserUI.AcceptAllFileFilter) {
                    this.setText(KingdeeFileChooserUI.this.allFilefilterText);
                } else {
                    this.setText(((FileFilter)value).getDescription());
                }
            }
            return this;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = -2865876496603299625L;
        Vector directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = KingdeeFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File dir = KingdeeFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        private void addItem(File directory) {
            if (directory == null) {
                return;
            }
            this.directories.clear();
            File[] baseFolders = KingdeeFileChooserUI.this.useShellFolder ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(baseFolders));
            File canonical = null;
            try {
                canonical = directory.getCanonicalFile();
            }
            catch (IOException e) {
                canonical = directory;
            }
            try {
                ShellFolder sf;
                File f = sf = ShellFolder.getShellFolder(canonical);
                ArrayList<ShellFolder> path = new ArrayList<ShellFolder>(10);
                do {
                    path.add((ShellFolder)f);
                } while ((f = ((File)f).getParentFile()) != null);
                int pathCount = path.size();
                for (int i = 0; i < pathCount; ++i) {
                    f = (File)path.get(i);
                    if (!this.directories.contains(f)) continue;
                    int topIndex = this.directories.indexOf(f);
                    for (int j = i - 1; j >= 0; --j) {
                        this.directories.insertElementAt(path.get(j), topIndex + i - j);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(sf);
            }
            catch (FileNotFoundException ex) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i = 0; i < this.depths.length; ++i) {
                File dir = (File)this.directories.get(i);
                File parent = dir.getParentFile();
                this.depths[i] = 0;
                if (parent == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!parent.equals((File)this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int i) {
            return this.depths != null && i >= 0 && i < this.depths.length ? this.depths[i] : 0;
        }

        @Override
        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        @Override
        public int getSize() {
            return this.directories.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    static class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(c, g, x + this.depth * 10, y);
            } else {
                this.icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1988638182747303382L;
        IndentIcon ii = new IndentIcon();

        DirectoryComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
                return this;
            }
            File directory = (File)value;
            this.setText(KingdeeFileChooserUI.this.getFileChooser().getName(directory));
            this.ii.icon = icon = KingdeeFileChooserUI.this.getFileChooser().getIcon(directory);
            this.ii.depth = KingdeeFileChooserUI.this.directoryComboBoxModel.getDepth(index);
            this.setIcon(this.ii);
            return this;
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 2783986154451363611L;

        protected FileRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File file = (File)value;
            String fileName = KingdeeFileChooserUI.this.getFileChooser().getName(file);
            this.setText(fileName);
            Icon icon = KingdeeFileChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            if (isSelected) {
                KingdeeFileChooserUI.this.editX = icon.getIconWidth() + 4;
            }
            return this;
        }
    }

    class EditActionListener
    implements ActionListener {
        EditActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KingdeeFileChooserUI.this.applyEdit();
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        JList list;

        public SingleClickListener(JList list) {
            this.list = list;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (e.getClickCount() == 1) {
                    JFileChooser fc = KingdeeFileChooserUI.this.getFileChooser();
                    int index = this.list.locationToIndex(e.getPoint());
                    if ((!fc.isMultiSelectionEnabled() || fc.getSelectedFiles().length <= 1) && index >= 0 && this.list.isSelectedIndex(index) && KingdeeFileChooserUI.this.getEditIndex() == index && KingdeeFileChooserUI.this.editFile == null) {
                        KingdeeFileChooserUI.this.editFileName(index);
                    } else if (index >= 0) {
                        KingdeeFileChooserUI.this.setEditIndex(index);
                    } else {
                        KingdeeFileChooserUI.this.resetEditIndex();
                    }
                } else {
                    KingdeeFileChooserUI.this.resetEditIndex();
                }
            }
        }
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        DelayedSelectionUpdater() {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            KingdeeFileChooserUI.this.setFileSelected();
        }
    }

    static class DetailsTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -8196349778348646285L;
        JFileChooser chooser;
        DateFormat df;

        DetailsTableCellRenderer(JFileChooser chooser) {
            this.chooser = chooser;
            this.df = DateFormat.getDateTimeInstance(3, 3, chooser.getLocale());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 1 || column == 4) {
                this.setHorizontalAlignment(11);
            } else {
                this.setHorizontalAlignment(10);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        @Override
        public void setValue(Object value) {
            this.setIcon(null);
            if (value instanceof File) {
                File file = (File)value;
                String fileName = this.chooser.getName(file);
                this.setText(fileName);
                Icon icon = this.chooser.getIcon(file);
                this.setIcon(icon);
            } else if (value instanceof Date) {
                this.setText(this.df.format((Date)value));
            } else {
                super.setValue(value);
            }
        }
    }

    class DetailsTableModel
    extends AbstractTableModel
    implements ListDataListener {
        private static final long serialVersionUID = -9004733544918764269L;
        String[] columnNames;
        JFileChooser chooser;
        ListModel listModel;

        DetailsTableModel(JFileChooser fc) {
            this.columnNames = new String[]{KingdeeFileChooserUI.this.fileNameHeaderText, KingdeeFileChooserUI.this.fileSizeHeaderText, KingdeeFileChooserUI.this.fileTypeHeaderText, KingdeeFileChooserUI.this.fileDateHeaderText, KingdeeFileChooserUI.this.fileAttrHeaderText};
            this.chooser = fc;
            this.listModel = KingdeeFileChooserUI.this.getModel();
            this.listModel.addListDataListener(this);
        }

        @Override
        public int getRowCount() {
            return this.listModel.getSize();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return File.class;
                }
                case 3: {
                    return Date.class;
                }
            }
            return super.getColumnClass(column);
        }

        @Override
        public Object getValueAt(int row, int col) {
            File f = (File)this.listModel.getElementAt(row);
            switch (col) {
                case 0: {
                    return f;
                }
                case 1: {
                    if (!f.exists() || f.isDirectory()) {
                        return null;
                    }
                    long len = f.length() / 1024L;
                    if (len < 1024L) {
                        return (len == 0L ? 1L : len) + " KB";
                    }
                    if ((len /= 1024L) < 1024L) {
                        return len + " MB";
                    }
                    return (len /= 1024L) + " GB";
                }
                case 2: {
                    if (!f.exists()) {
                        return null;
                    }
                    return this.chooser.getFileSystemView().getSystemTypeDescription(f);
                }
                case 3: {
                    if (!f.exists() || this.chooser.getFileSystemView().isFileSystemRoot(f)) {
                        return null;
                    }
                    long time = f.lastModified();
                    return time == 0L ? null : new Date(time);
                }
                case 4: {
                    if (!f.exists() || this.chooser.getFileSystemView().isFileSystemRoot(f)) {
                        return null;
                    }
                    String attributes = "";
                    if (!f.canWrite()) {
                        attributes = attributes + "R";
                    }
                    if (f.isHidden()) {
                        attributes = attributes + "H";
                    }
                    return attributes;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                JFileChooser chooser = KingdeeFileChooserUI.this.getFileChooser();
                File f = (File)this.getValueAt(row, col);
                if (f != null) {
                    String oldDisplayName = chooser.getName(f);
                    String oldFileName = f.getName();
                    String newDisplayName = ((String)value).trim();
                    if (!newDisplayName.equals(oldDisplayName)) {
                        FileSystemView fsv;
                        File f2;
                        int i2;
                        String newFileName = newDisplayName;
                        int i1 = oldFileName.length();
                        if (i1 > (i2 = oldDisplayName.length()) && oldFileName.charAt(i2) == '.') {
                            newFileName = newDisplayName + oldFileName.substring(i2);
                        }
                        if (!(f2 = (fsv = chooser.getFileSystemView()).createFileObject(f.getParentFile(), newFileName)).exists() && KingdeeFileChooserUI.this.getModel().renameFile(f, f2) && fsv.isParent(chooser.getCurrentDirectory(), f2)) {
                            if (chooser.isMultiSelectionEnabled()) {
                                chooser.setSelectedFiles(new File[]{f2});
                            } else {
                                chooser.setSelectedFile(f2);
                            }
                        }
                    }
                }
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.fireTableDataChanged();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.fireTableDataChanged();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.fireTableDataChanged();
        }
    }
}

