/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.swing.KDMenuBar;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeUtils;
import com.kingdee.cosmic.ctrl.swing.plaf.PaintUtil;
import com.kingdee.cosmic.ctrl.swing.util.CtrlImageUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicMenuUI;
import javax.swing.text.View;

public class KingdeeMenuUI
extends BasicMenuUI {
    private static Color mebuBarForeground = null;
    private static final int BG_INIT = 0;
    private static final int BG_ROLLVER = 1;
    private int leftAreaWidth = 22;
    private static Color leftBgShadow = null;
    private static Color leftBgDarkShadow = null;
    private static Color leftRollBgShadow = null;
    private static Color leftRollBgDarkShadow = null;
    private static Color separatorShadow = null;
    private static Color separatorDarkShadow = null;
    private static Color separatorRollShadow = null;
    private static Color separatorRollDarkShadow = null;
    private static int minWidth = UIManager.getInt("Menu.minWidth");
    static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();
    private String acceleratorDelimiter;
    static final String MAX_ACC_WIDTH = "maxAccWidth";
    private Color rollverForeground = null;
    private Color rollverBgBegin = null;
    private Color rollverBgEnd = null;
    private Color pressBgBegin = null;
    private Color pressBgEnd = null;

    public static ComponentUI createUI(JComponent x) {
        return new KingdeeMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        this.menuItem.setRequestFocusEnabled(false);
        this.leftAreaWidth = (Integer)UIManager.get("MenuItem.leftAreaWidth") + 3;
        leftBgShadow = UIManager.getColor("MenuItem.leftBgShadow");
        leftBgDarkShadow = UIManager.getColor("MenuItem.leftBgDarkShadow");
        leftRollBgShadow = UIManager.getColor("MenuItem.leftRollBgShadow");
        leftRollBgDarkShadow = UIManager.getColor("MenuItem.leftRollBgDarkShadow");
        separatorShadow = UIManager.getColor("MenuItem.separatorShadow");
        separatorDarkShadow = UIManager.getColor("MenuItem.separatorDarkShadow");
        separatorRollShadow = UIManager.getColor("MenuItem.separatorRollShadow");
        separatorRollDarkShadow = UIManager.getColor("MenuItem.separatorRollDarkShadow");
        this.rollverForeground = UIManager.getColor("Menu.rollverForeground");
        mebuBarForeground = UIManager.getColor("MenuBar.foreground");
        this.rollverBgBegin = UIManager.getColor("Menu.rollverBgBegin");
        this.rollverBgEnd = UIManager.getColor("Menu.rollverBgEnd");
        this.pressBgBegin = UIManager.getColor("Menu.pressBgBegin");
        this.pressBgEnd = UIManager.getColor("Menu.pressBgEnd");
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            ((JMenu)this.menuItem).setOpaque(false);
            ((JMenu)this.menuItem).setRolloverEnabled(true);
        }
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new InnerMouseInputHandler();
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension dim = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            return dim;
        }
        JMenuItem b = (JMenuItem)c;
        Icon icon = b.getIcon();
        if (icon == null) {
            dim.width += this.leftAreaWidth;
        }
        if (dim.width < minWidth) {
            dim.width = minWidth;
        }
        return dim;
    }

    @Override
    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        Color oldselectionForeground = this.selectionForeground;
        if (!((JMenu)menuItem).isTopLevelMenu()) {
            textRect.x = this.leftAreaWidth + 5;
        }
        ButtonModel m = menuItem.getModel();
        if (((JMenu)menuItem).getParent() instanceof KDMenuBar) {
            if (m.isRollover() && !m.isArmed() && this.rollverForeground != null) {
                g.setColor(this.rollverForeground);
            } else {
                g.setColor(mebuBarForeground);
            }
        } else if (!((JMenu)menuItem).isTopLevelMenu()) {
            g.setColor(this.selectionForeground);
            if (m.isRollover() || m.isArmed() || m.isSelected()) {
                this.selectionForeground = Color.white;
            }
        } else if (m.isRollover() && !m.isArmed() && this.rollverForeground != null) {
            g.setColor(this.rollverForeground);
        } else {
            g.setColor(this.selectionForeground);
        }
        super.paintText(g, menuItem, textRect, text);
        this.selectionForeground = oldselectionForeground;
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        if (((JMenu)menuItem).isTopLevelMenu()) {
            this.paintTopMenuBackground(g, menuItem, bgColor);
        } else {
            this.paintChildMenuBackground(g, menuItem, bgColor);
        }
    }

    protected void paintTopMenuBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        MenuElement[] mes = this.getMenuElements(menuItem);
        if (mes != null && mes.length > 2) {
            if (mes[1] == menuItem) {
                this.fillBackground(g, menuWidth, menuHeight, 1, this.pressBgBegin, this.pressBgEnd);
            } else if (menuItem.isOpaque()) {
                g.setColor(menuItem.getBackground());
                this.fillSelfRect(g, menuWidth, menuHeight, 0);
            }
        } else if (model.isRollover() && !model.isArmed()) {
            this.fillBackground(g, menuWidth, menuHeight, 1, this.rollverBgBegin, this.rollverBgEnd);
        } else if (model.isArmed() && model.isPressed()) {
            this.fillBackground(g, menuWidth, menuHeight, 1, this.pressBgBegin, this.pressBgEnd);
        } else if (menuItem.isOpaque()) {
            g.setColor(menuItem.getBackground());
            this.fillSelfRect(g, menuWidth, menuHeight, 0);
        }
        g.setColor(oldColor);
    }

    protected void fillSelfRect(Graphics g, int w, int h, int type) {
        g.drawLine(2, 1, w - 3, 1);
        g.drawLine(2, h - 2, w - 3, h - 2);
        g.drawLine(1, 2, 1, h - 2);
        g.drawLine(w - 2, 2, w - 2, h - 2);
        g.fillRect(2, 2, w - 4, h - 4);
        if (type == 1) {
            g.fillRect(1, h - 3, w - 2, 4);
        }
    }

    protected void fillBackground(Graphics g, int w, int h, int type, Color beginColor, Color endColor) {
        Graphics2D g2d = (Graphics2D)g;
        GradientPaint gradient = null;
        gradient = new GradientPaint(1.0f, 1.0f, beginColor, 1.0f, h - 2, endColor);
        g2d.setPaint(gradient);
        g2d.fillRect(1, 1, w - 2, h - 2);
    }

    private MenuElement[] getMenuElements(Component c) {
        if (c instanceof JMenu) {
            MenuSelectionManager mag = MenuSelectionManager.defaultManager();
            MenuElement[] me = mag.getSelectedPath();
            if (me != null && me.length > 0) {
                return me;
            }
            return null;
        }
        return null;
    }

    protected void paintChildMenuBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuItem.isOpaque()) {
            if (model.isRollover() || model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(UIManager.getColor("MenuItem.selectionBackground"));
                g.fillRect(0, 0, menuWidth, menuHeight);
                this.paintLeftBackground(g, 1);
                this.paintMiddleSeparator(g, 1);
            } else {
                g.setColor(UIManager.getColor("Menu.background"));
                g.fillRect(0, 0, menuWidth, menuHeight);
                this.paintLeftBackground(g, 0);
                this.paintMiddleSeparator(g, 0);
            }
        }
        g.setColor(oldColor);
    }

    protected void paintLeftBackground(Graphics g, int state) {
        Rectangle rect = new Rectangle(0, 0, this.leftAreaWidth, this.menuItem.getHeight());
        switch (state) {
            case 1: {
                PaintUtil.drawShadow(g, 1.0f, 1.0f, leftRollBgShadow, this.leftAreaWidth, 1.0f, leftRollBgDarkShadow, rect, 0);
                break;
            }
            default: {
                PaintUtil.drawShadow(g, 1.0f, 1.0f, leftBgShadow, this.leftAreaWidth, 1.0f, leftBgDarkShadow, rect, 0);
            }
        }
    }

    protected void paintMiddleSeparator(Graphics g, int state) {
        int h = this.menuItem.getHeight();
        switch (state) {
            case 1: {
                g.setColor(separatorRollShadow);
                g.drawLine(this.leftAreaWidth, 0, this.leftAreaWidth, h);
                g.setColor(separatorRollDarkShadow);
                g.drawLine(this.leftAreaWidth + 1, 0, this.leftAreaWidth + 1, h);
                break;
            }
            default: {
                g.setColor(separatorShadow);
                g.drawLine(this.leftAreaWidth, 0, this.leftAreaWidth, h);
                g.setColor(separatorDarkShadow);
                g.drawLine(this.leftAreaWidth + 1, 0, this.leftAreaWidth + 1, h);
            }
        }
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        int menuWidth = b.getWidth();
        int menuHeight = b.getHeight();
        Insets i = c.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, menuWidth, menuHeight);
        KingdeeMenuUI.viewRect.x += i.left;
        KingdeeMenuUI.viewRect.y += i.top;
        KingdeeMenuUI.viewRect.width -= i.right + KingdeeMenuUI.viewRect.x;
        KingdeeMenuUI.viewRect.height -= i.bottom + KingdeeMenuUI.viewRect.y;
        Font holdf = g.getFont();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(this.acceleratorFont);
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        String text = this.layoutMenuItem(fm, b.getText(), fmAccel, acceleratorText, b.getIcon(), checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        this.paintBackground(g, b, background);
        Color holdc = g.getColor();
        if (checkIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            } else {
                g.setColor(holdc);
            }
            if (this.useCheckAndArrow()) {
                checkIcon.paintIcon(c, g, KingdeeMenuUI.checkIconRect.x, KingdeeMenuUI.checkIconRect.y);
            }
            g.setColor(holdc);
        }
        if (b.getIcon() != null) {
            Icon icon;
            if (!model.isEnabled()) {
                icon = CtrlImageUtilities.createDisableIcon(b.getIcon());
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
            } else {
                icon = b.getIcon();
            }
            if (icon != null) {
                KingdeeMenuUI.iconRect.x = (this.leftAreaWidth - KingdeeMenuUI.iconRect.width) / 2 + KingdeeMenuUI.viewRect.x - 1;
                icon.paintIcon(c, g, KingdeeMenuUI.iconRect.x, KingdeeMenuUI.iconRect.y);
            }
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            int accOffset = 0;
            Container parent = this.menuItem.getParent();
            if (parent instanceof JComponent) {
                JComponent p = (JComponent)parent;
                Integer maxValueInt = (Integer)p.getClientProperty(MAX_ACC_WIDTH);
                int maxValue = maxValueInt != null ? maxValueInt : KingdeeMenuUI.acceleratorRect.width;
                accOffset = maxValue - KingdeeMenuUI.acceleratorRect.width;
            }
            g.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                if (this.disabledForeground != null) {
                    g.setColor(this.disabledForeground);
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, KingdeeMenuUI.acceleratorRect.x - accOffset, KingdeeMenuUI.acceleratorRect.y + fmAccel.getAscent());
                } else {
                    g.setColor(b.getBackground().brighter());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, KingdeeMenuUI.acceleratorRect.x - accOffset, KingdeeMenuUI.acceleratorRect.y + fmAccel.getAscent());
                    g.setColor(b.getBackground().darker());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, KingdeeMenuUI.acceleratorRect.x - accOffset - 1, KingdeeMenuUI.acceleratorRect.y + fmAccel.getAscent() - 1);
                }
            } else {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(this.acceleratorSelectionForeground);
                } else {
                    g.setColor(this.acceleratorForeground);
                }
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, KingdeeMenuUI.acceleratorRect.x - accOffset, KingdeeMenuUI.acceleratorRect.y + fmAccel.getAscent());
            }
        }
        if (arrowIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            }
            if (this.useCheckAndArrow()) {
                arrowIcon.paintIcon(c, g, KingdeeMenuUI.arrowIconRect.x, KingdeeMenuUI.arrowIconRect.y);
            }
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    private String layoutMenuItem(FontMetrics fm, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, textIconGap);
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorText = "";
        } else {
            acceleratorRect.width = SwingUtilities.computeStringWidth(fmAccel, acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        if (this.useCheckAndArrow()) {
            if (checkIcon != null) {
                checkIconRect.width = checkIcon.getIconWidth();
                checkIconRect.height = checkIcon.getIconHeight();
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = arrowIcon.getIconWidth();
                arrowIconRect.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
        }
        Rectangle labelRect = iconRect.union(textRect);
        if (KingdeeUtils.isLeftToRight(this.menuItem)) {
            textRect.x += menuItemGap;
            iconRect.x += menuItemGap;
            acceleratorRect.x = viewRect.x + viewRect.width - arrowIconRect.width - menuItemGap - acceleratorRect.width;
            if (this.useCheckAndArrow()) {
                checkIconRect.x = viewRect.x + menuItemGap;
                textRect.x += menuItemGap + checkIconRect.width;
                iconRect.x += menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + viewRect.width - menuItemGap - arrowIconRect.width;
            }
        } else {
            textRect.x -= menuItemGap;
            iconRect.x -= menuItemGap;
            acceleratorRect.x = viewRect.x + arrowIconRect.width + menuItemGap;
            if (this.useCheckAndArrow()) {
                checkIconRect.x = viewRect.x + viewRect.width - menuItemGap - checkIconRect.width;
                textRect.x -= menuItemGap + checkIconRect.width;
                iconRect.x -= menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + menuItemGap;
            }
        }
        acceleratorRect.y = labelRect.y + labelRect.height / 2 - acceleratorRect.height / 2;
        if (this.useCheckAndArrow()) {
            arrowIconRect.y = labelRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            checkIconRect.y = labelRect.y + labelRect.height / 2 - checkIconRect.height / 2;
        }
        return text;
    }

    private boolean useCheckAndArrow() {
        boolean b = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            b = false;
        }
        return b;
    }

    protected class InnerMouseInputHandler
    extends BasicMenuUI.MouseInputHandler {
        transient long lastPressedTimestamp;
        transient boolean shouldDiscardRelease;

        protected InnerMouseInputHandler() {
            super(KingdeeMenuUI.this);
            this.lastPressedTimestamp = -1L;
            this.shouldDiscardRelease = false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            super.mouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            super.mousePressed(e);
            AbstractButton b = (AbstractButton)e.getSource();
            if (b.contains(e.getX(), e.getY())) {
                long multiClickThreshhold = b.getMultiClickThreshhold();
                long lastTime = this.lastPressedTimestamp;
                long currentTime = this.lastPressedTimestamp = e.getWhen();
                if (lastTime != -1L && currentTime - lastTime < multiClickThreshhold) {
                    this.shouldDiscardRelease = true;
                    return;
                }
                ButtonModel model = b.getModel();
                if (!model.isEnabled()) {
                    return;
                }
                if (!model.isArmed()) {
                    model.setArmed(true);
                }
                model.setPressed(true);
                if (!b.hasFocus() && b.isRequestFocusEnabled()) {
                    b.requestFocus();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            super.mouseReleased(e);
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (this.shouldDiscardRelease) {
                    this.shouldDiscardRelease = false;
                    return;
                }
                AbstractButton b = (AbstractButton)e.getSource();
                ButtonModel model = b.getModel();
                model.setPressed(false);
                model.setArmed(false);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            AbstractButton b = (AbstractButton)e.getSource();
            ButtonModel model = b.getModel();
            if (b.isRolloverEnabled()) {
                model.setRollover(true);
            }
            if (model.isPressed()) {
                model.setArmed(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            AbstractButton b = (AbstractButton)e.getSource();
            ButtonModel model = b.getModel();
            if (b.isRolloverEnabled()) {
                model.setRollover(false);
            }
            model.setArmed(false);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
        }
    }
}

