/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import com.kingdee.cosmic.ctrl.swing.KDTextAreaCtrl;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.common.i18n.CtrlSwingMessages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import org.apache.log4j.Logger;

public class KingdeeTextFieldUI
extends BasicTextFieldUI {
    private static final Logger logger = LogUtil.getPackageLogger(KingdeeTextFieldUI.class);
    protected transient KDTextField tf;
    protected TextFieldListener listener;
    private PropertyChangeListener propertyChangeListener = new AddtionalPropertyChangeListener();

    public static ComponentUI createUI(JComponent comp) {
        return new KingdeeTextFieldUI(comp);
    }

    public KingdeeTextFieldUI(JComponent comp) {
        this.tf = (KDTextField)comp;
    }

    @Override
    public void installUI(JComponent comp) {
        this.tf = (KDTextField)comp;
        super.installUI(comp);
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.tf.setSelectionColor(UIManager.getColor("TextField.selectionBackground"));
        this.tf.setSelectedTextColor(UIManager.getColor("TextField.selectionForeground"));
        this.tf.setDisabledTextColor(UIManager.getColor("TextField.disableForeground"));
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.listener == null) {
            this.listener = new TextFieldListener(this.tf);
        }
        this.tf.addKeyListener(this.listener);
        this.tf.addFocusListener(this.listener);
        this.tf.addPropertyChangeListener(this.propertyChangeListener);
        InputMap inputMap = this.tf.getInputMap();
        ActionMap actionMap = this.tf.getActionMap();
        KeyStroke newKeyStroke = KeyStroke.getKeyStroke(90, 2, false);
        inputMap.put(newKeyStroke, "undo-textfield");
        newKeyStroke = KeyStroke.getKeyStroke(89, 2, false);
        inputMap.put(newKeyStroke, "redo-textfield");
        actionMap.put("undo-textfield", new UndoAction());
        actionMap.put("redo-textfield", new RedoAction());
    }

    @Override
    protected void uninstallListeners() {
        this.tf.removePropertyChangeListener(this.propertyChangeListener);
        this.tf.removeFocusListener(this.listener);
        this.tf.removeKeyListener(this.listener);
        super.uninstallListeners();
        InputMap inputMap = this.tf.getInputMap();
        ActionMap actionMap = this.tf.getActionMap();
        inputMap.remove(KeyStroke.getKeyStroke(90, 2, false));
        inputMap.remove(KeyStroke.getKeyStroke(89, 2, false));
        actionMap.remove("undo-textfield");
        actionMap.remove("redo-textfield");
    }

    @Override
    protected void paintBackground(Graphics g) {
        Color customForegroundColor = this.tf.getCustomForegroundColor();
        Color customBackgroundColor = this.tf.getCustomBackgroundColor();
        if (this.tf.getAccessAuthority() == 1) {
            if (customForegroundColor != null) {
                this.tf.setForeground(customForegroundColor);
            } else {
                this.tf.setForeground(UIManager.getColor("TextField.readonlyForeground"));
            }
            if (customBackgroundColor != null) {
                g.setColor(customBackgroundColor);
            } else {
                g.setColor(UIManager.getColor("TextField.readonlyBackground"));
            }
        } else if (this.tf.isEnabled()) {
            super.paintBackground(g);
            if (this.tf.isEditable()) {
                if (this.tf.isRequired()) {
                    if (customForegroundColor != null) {
                        this.tf.setForeground(customForegroundColor);
                    } else {
                        this.tf.setForeground(UIManager.getColor("TextField.requiredForeground"));
                    }
                    if (customBackgroundColor != null) {
                        g.setColor(customBackgroundColor);
                    } else {
                        g.setColor(UIManager.getColor("TextField.requiredBackground"));
                    }
                } else {
                    if (customForegroundColor != null) {
                        this.tf.setForeground(customForegroundColor);
                    } else {
                        this.tf.setForeground(UIManager.getColor("TextField.foreground"));
                    }
                    if (customBackgroundColor != null) {
                        g.setColor(customBackgroundColor);
                    } else {
                        g.setColor(UIManager.getColor("TextField.background"));
                    }
                }
            } else if (this.tf.isRequired()) {
                if (this.tf.getClientProperty("promptbox") != null) {
                    if (this.tf.isRequired()) {
                        if (customForegroundColor != null) {
                            this.tf.setForeground(customForegroundColor);
                        } else {
                            this.tf.setForeground(UIManager.getColor("TextField.requiredForeground"));
                        }
                        if (customBackgroundColor != null) {
                            g.setColor(customBackgroundColor);
                        } else {
                            g.setColor(UIManager.getColor("TextField.requiredBackground"));
                        }
                    }
                } else {
                    if (customForegroundColor != null) {
                        this.tf.setForeground(customForegroundColor);
                    } else {
                        this.tf.setForeground(UIManager.getColor("TextField.disableForeground"));
                    }
                    if (customBackgroundColor != null) {
                        g.setColor(customBackgroundColor);
                    } else {
                        g.setColor(UIManager.getColor("TextField.disableBackground"));
                    }
                }
            } else if (this.tf.getClientProperty("promptbox") != null) {
                if (customForegroundColor != null) {
                    this.tf.setForeground(customForegroundColor);
                } else {
                    this.tf.setForeground(UIManager.getColor("TextField.foreground"));
                }
                if (customBackgroundColor != null) {
                    g.setColor(customBackgroundColor);
                } else {
                    g.setColor(UIManager.getColor("TextField.background"));
                }
            } else {
                if (customForegroundColor != null) {
                    this.tf.setForeground(customForegroundColor);
                } else {
                    this.tf.setForeground(UIManager.getColor("TextField.disableForeground"));
                }
                if (customBackgroundColor != null) {
                    g.setColor(customBackgroundColor);
                } else {
                    g.setColor(UIManager.getColor("TextField.disableBackground"));
                }
            }
        } else {
            if (customForegroundColor != null) {
                this.tf.setDisabledTextColor(customForegroundColor);
            } else {
                this.tf.setDisabledTextColor(UIManager.getColor("TextField.disableForeground"));
            }
            if (customBackgroundColor != null) {
                g.setColor(customBackgroundColor);
            } else {
                g.setColor(UIManager.getColor("TextField.disableBackground"));
            }
        }
        g.fillRect(0, 0, this.tf.getWidth(), this.tf.getHeight());
    }

    private int getHorAlignValue() {
        return this.tf.getHorizontalAlignment();
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle rect = super.getVisibleEditorRect();
        int tempHori = this.getHorAlignValue();
        if (rect != null) {
            if (tempHori == 4) {
                if (rect.x < 3) {
                    rect.x = 3;
                }
            } else if (tempHori == 10 && rect.x < 3) {
                rect.x = 3;
            }
        }
        return rect;
    }

    private class AddtionalPropertyChangeListener
    implements PropertyChangeListener {
        private AddtionalPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("customForegroundColorChanged")) {
                KingdeeTextFieldUI.this.tf.repaint();
            } else if (evt.getPropertyName().equals("customBackgroundColorChanged")) {
                KingdeeTextFieldUI.this.tf.repaint();
            }
        }
    }

    public class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -8864464253679348472L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (KingdeeTextFieldUI.this.tf.manager.canRedo()) {
                    KingdeeTextFieldUI.this.tf.manager.redo();
                }
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -2277974741261471723L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (KingdeeTextFieldUI.this.tf.manager.canUndo()) {
                    KingdeeTextFieldUI.this.tf.manager.undo();
                }
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
    }

    public static class PopupInputDialog
    extends JDialog {
        private static final long serialVersionUID = -1055018527099237803L;
        protected static final Color BGCOLOR = new Color(239, 235, 239);
        protected static final int PANEHEIGHT = 150;
        protected static final int PANEWIDTH = 400;
        static Dimension screen;
        protected KDTextAreaCtrl ta;
        protected KDSeparator separator;
        protected KDButton okButton;
        protected KDButton cancelButton;
        protected boolean isOk;

        public PopupInputDialog(Dialog owner, String str) {
            super(owner, true);
            this.init(str);
        }

        public PopupInputDialog(Frame owner, String str) {
            super(owner, true);
            this.init(str);
        }

        private void init(String str) {
            this.initComponent();
            if (this.ta != null) {
                this.ta.setText(str);
            }
            if (screen == null) {
                screen = Toolkit.getDefaultToolkit().getScreenSize();
            }
            this.setLocation((PopupInputDialog.screen.width - 400) / 2, (PopupInputDialog.screen.height - 150) / 2);
            this.pack();
            this.isOk = false;
        }

        public void initComponent() {
            this.ta = new KDTextAreaCtrl(4);
            this.separator = new KDSeparator();
            this.okButton = new KDButton(CtrlSwingMessages.getMLS("ok", "\u786e\u5b9a"));
            this.cancelButton = new KDButton(CtrlSwingMessages.getMLS("cancel", "\u53d6\u6d88"));
            this.okButton.addActionListener(new OkAction());
            this.cancelButton.addActionListener(new CancelAction());
            Container cp = this.getContentPane();
            cp.add(this.ta);
            cp.add(this.separator);
            cp.add(this.okButton);
            cp.add(this.cancelButton);
            cp.setLayout(new PopupInputDialogLayout());
            cp.setBackground(BGCOLOR);
            ((JPanel)cp).setPreferredSize(new Dimension(400, 150));
            this.setModal(true);
            this.setResizable(false);
            this.setTitle(CtrlSwingMessages.getMLS("edit", "\u7f16\u8f91"));
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    this.dispose();
                }
            });
        }

        public String getInputText() {
            return this.ta.getText();
        }

        public boolean isCancel() {
            return !this.isOk;
        }

        protected class CancelAction
        implements ActionListener {
            protected CancelAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupInputDialog.this.dispose();
            }
        }

        protected class OkAction
        implements ActionListener {
            protected OkAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupInputDialog.this.isOk = true;
                PopupInputDialog.this.dispose();
            }
        }

        protected class PopupInputDialogLayout
        implements LayoutManager {
            protected PopupInputDialogLayout() {
            }

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public void layoutContainer(Container parent) {
                int x = 8;
                int y = 8;
                int w = 385;
                int h = 82;
                PopupInputDialog.this.ta.setBounds(x, y, w, h);
                PopupInputDialog.this.separator.setBounds(0, y + h + 12, 400, 4);
                x = x + w - 80;
                y = 116;
                PopupInputDialog.this.cancelButton.setBounds(x, y, 80, 21);
                x -= 4;
                PopupInputDialog.this.okButton.setBounds(x -= 80, y, 80, 21);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return new Dimension(420, 160);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return this.minimumLayoutSize(parent);
            }
        }
    }

    protected static class TextFieldListener
    implements FocusListener,
    KeyListener {
        protected KDTextField tf;

        public TextFieldListener(KDTextField t) {
            this.tf = t;
        }

        @Override
        public void focusGained(FocusEvent e) {
            Component c = (Component)e.getSource();
            c.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            Component c = (Component)e.getSource();
            c.repaint();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Window win;
            if (!(this.tf.isEnabled() && this.tf.isEditable() && this.tf.isEnabledPopup())) {
                return;
            }
            int code = e.getKeyCode();
            if (code == 40 && (win = SwingUtilities.getWindowAncestor(this.tf)) != null) {
                Dialog dlg = null;
                if (win instanceof Dialog) {
                    dlg = new PopupInputDialog((Dialog)win, this.tf.getText());
                } else if (win instanceof Frame) {
                    dlg = new PopupInputDialog((Frame)win, this.tf.getText());
                }
                if (dlg != null) {
                    dlg.setVisible(true);
                    if (!((PopupInputDialog)dlg).isCancel()) {
                        this.tf.setText(((PopupInputDialog)dlg).getInputText());
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

