/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.swing.KDMultiLangBox;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTextAreaCtrl;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeMultiLangAreaUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;

class MultiLangPopup
extends BasicComboPopup {
    private static final long serialVersionUID = -1655640310086420645L;
    protected static Color popupBorderColor;

    public MultiLangPopup(JComboBox cBox) {
        super(cBox);
    }

    @Override
    protected JScrollPane createScroller() {
        return new KDScrollPane(this.list, 20, 31);
    }

    @Override
    public void show() {
        this.setMultListSelection(this.comboBox.getSelectedIndex());
        Point location = this.getMultPopupLocation();
        this.show(this.comboBox, location.x, location.y);
    }

    private void setMultListSelection(int selectedIndex) {
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
            this.list.ensureIndexIsVisible(selectedIndex);
        }
    }

    @Override
    protected void configurePopup() {
        popupBorderColor = UIManager.getColor("PopupMenu.borderLineColor");
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(popupBorderColor));
        this.setOpaque(false);
        this.add(this.scroller);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
    }

    private Point getMultPopupLocation() {
        Component comp;
        Dimension popupSize = this.comboBox.getSize();
        Insets insets = this.getInsets();
        popupSize.setSize(popupSize.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
        int h = 0;
        ComboBoxUI ui = this.comboBox.getUI();
        if (ui instanceof KingdeeMultiLangAreaUI && (comp = ((KingdeeMultiLangAreaUI)ui).getEditor()) instanceof KDTextAreaCtrl && (comp = ((KDTextAreaCtrl)comp).getCorner("UPPER_RIGHT_CORNER")) != null) {
            h = comp.getHeight() + 1;
        }
        if (h == 0) {
            h = this.comboBox.getBounds().height;
        }
        Rectangle popupBounds = this.computePopupBounds(0, h, popupSize.width, popupSize.height);
        Dimension scrollSize = popupBounds.getSize();
        Point popupLocation = popupBounds.getLocation();
        this.scroller.setMaximumSize(scrollSize);
        this.scroller.setPreferredSize(scrollSize);
        this.scroller.setMinimumSize(scrollSize);
        this.list.revalidate();
        return popupLocation;
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MultiLangBoxMouseHandler();
    }

    protected KDMultiLangBox getComboBox() {
        return (KDMultiLangBox)this.comboBox;
    }

    @Override
    protected void togglePopup() {
        super.togglePopup();
    }

    protected class MultiLangBoxMouseHandler
    extends BasicComboPopup.InvocationMouseHandler {
        protected MultiLangBoxMouseHandler() {
            super(MultiLangPopup.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e) || !MultiLangPopup.this.getComboBox().isEnabled()) {
                return;
            }
            if (MultiLangPopup.this.getComboBox().isEditable()) {
                Component comp = MultiLangPopup.this.getComboBox().getEditor().getEditorComponent();
                if (!(comp instanceof JComponent) || ((JComponent)comp).isRequestFocusEnabled()) {
                    comp.requestFocus();
                }
                Object newItem = MultiLangPopup.this.getComboBox().getEditor().getItem();
                MultiLangPopup.this.getComboBox().getModel().setSelectedItem(newItem);
            } else if (MultiLangPopup.this.getComboBox().isRequestFocusEnabled()) {
                MultiLangPopup.this.getComboBox().requestFocus();
            }
            MultiLangPopup.this.togglePopup();
        }
    }
}

