/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

public class PaintUtil {
    public static void drawShadow(Graphics g, JComponent comp, float x0, float y0, Color shadow, float x1, float y1, Color darkShadow, int hv) {
        if (shadow != null && darkShadow != null) {
            if (hv == 0) {
                PaintUtil.drawHoriShadow(g, comp, x0, y0, shadow, x1, y1, darkShadow);
            } else {
                PaintUtil.drawVertShadow(g, comp, y0, x0, shadow, y1, x1, darkShadow);
            }
        }
    }

    public static void drawHoriShadow(Graphics g, JComponent comp, float x0, float y0, Color shadow, float x1, float y1, Color darkShadow) {
        if (shadow != null && darkShadow != null) {
            Graphics2D g2D = (Graphics2D)g;
            GradientPaint gradient = new GradientPaint(x0, y0, shadow, x1, y1, darkShadow);
            g2D.setPaint(gradient);
            Rectangle rect = comp.getBounds();
            g2D.fillRect(0, 0, rect.width, rect.height - 1);
        }
    }

    public static void drawVertShadow(Graphics g, JComponent comp, float x0, float y0, Color shadow, float x1, float y1, Color darkShadow) {
        if (shadow != null && darkShadow != null) {
            Graphics2D g2D = (Graphics2D)g;
            GradientPaint gradient = new GradientPaint(x0, y0, shadow, x1, y1, darkShadow);
            g2D.setPaint(gradient);
            Rectangle rect = comp.getBounds();
            g2D.fillRect(0, 0, rect.width - 1, rect.height - 1);
        }
    }

    public static void drawShadow(Graphics g, float x1, float y1, Color color1, float x2, float y2, Color color2, Shape s, int hv) {
        if (color1 != null && color2 != null) {
            if (hv == 1) {
                Graphics2D g2D = (Graphics2D)g;
                GradientPaint gradient = new GradientPaint(0.0f, y1, color1, 0.0f, y2, color2);
                g2D.setPaint(gradient);
                g2D.fill(s);
            } else {
                Graphics2D g2D = (Graphics2D)g;
                GradientPaint gradient = new GradientPaint(x1, 0.0f, color1, x2, 0.0f, color2);
                g2D.setPaint(gradient);
                g2D.fill(s);
            }
        }
    }

    public static void drawShadow(Graphics g, Color color1, Color color2, Rectangle rect, int hv) {
        if (color1 != null && color2 != null) {
            if (hv == 1) {
                Graphics2D g2D = (Graphics2D)g;
                GradientPaint gradient = new GradientPaint(0.0f, (float)rect.getY(), color1, 0.0f, (float)(rect.getHeight() + rect.getY()), color2);
                g2D.setPaint(gradient);
                g2D.fill(rect);
            } else {
                Graphics2D g2D = (Graphics2D)g;
                GradientPaint gradient = new GradientPaint((float)rect.getX(), 0.0f, color1, (float)(rect.getWidth() + rect.getX()), 0.0f, color2);
                g2D.setPaint(gradient);
                g2D.fill(rect);
            }
        }
    }

    public static void drawRectangle(Graphics g, int w, int h, Color[] topCol, Color[] botCol) {
        Color old = g.getColor();
        g.setColor(topCol[0]);
        g.drawLine(1, 1, w - 2, 1);
        g.drawLine(1, 2, 1, h - 2);
        g.setColor(topCol[1]);
        g.drawLine(2, 2, w - 3, 2);
        g.drawLine(2, 3, 2, h - 3);
        g.setColor(topCol[2]);
        g.drawLine(3, 3, w - 4, 3);
        g.drawLine(3, 4, 3, h - 4);
        g.setColor(botCol[0]);
        g.drawLine(3, h - 3, w - 3, h - 3);
        g.drawLine(w - 3, 3, w - 3, h - 4);
        g.setColor(botCol[1]);
        g.drawLine(2, h - 2, w - 2, h - 2);
        g.drawLine(w - 2, 2, w - 2, h - 3);
        g.setColor(botCol[2]);
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 1, w - 1, h - 2);
        g.setColor(old);
    }

    public static void drawRectangle(Graphics g, int w, int h, Color topColA, Color topColB, Color topColC, Color botColA, Color botColB, Color botColC) {
        Color old = g.getColor();
        g.setColor(topColA);
        g.drawLine(1, 1, w - 2, 1);
        g.drawLine(1, 2, 1, h - 2);
        g.setColor(topColB);
        g.drawLine(2, 2, w - 3, 2);
        g.drawLine(2, 3, 2, h - 3);
        g.setColor(topColC);
        g.drawLine(3, 3, w - 4, 3);
        g.drawLine(3, 4, 3, h - 4);
        g.setColor(botColA);
        g.drawLine(3, h - 3, w - 3, h - 3);
        g.drawLine(w - 3, 3, w - 3, h - 4);
        g.setColor(botColB);
        g.drawLine(2, h - 2, w - 2, h - 2);
        g.drawLine(w - 2, 2, w - 2, h - 3);
        g.setColor(botColC);
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 1, w - 1, h - 2);
        g.setColor(old);
    }
}

